# Подключение сегментной анимации к колонке Мини-2

## Введение

Станция Мини-2 имеет сегментный индикатор, который позволяет отображать текущее время и другие символы.
Схематично сегментный индикатор имеет следующий вид

```
     ****     ****         ****     ****     *
    *    *   *    *       *    *   *    *
    *    *   *    *   *   *    *   *    *
     ****     ****   ***   ****     ****
    *    *   *    *   *   *    *   *    *
    *    *   *    *       *    *   *    *
     ****     ****         ****     ****
```

Здесь:
* четыре 7-сегментных блока, которые поволяют отображать цифры от 0 до 9 и некоторые символы
* 4 индикатора между блоками, которые позволяют отобразить знаки "тире", "двоеточие", "плюс" (также можно зажигать только верхнюю или нижнюю часть плюса)
* дополнительный индикатор в правом верхнем углу, обычно используется для отображения градусов.

Для работы с сегментными индикаторами используется библиотека alice/library/scled_animations, которая позволяет как использовать стандартные анимации сегментов, так и создавать свои собственные "на лету".

## Основные способы задания анимации

### Использование предопределенных анимаций

Файл scled_animations_directive.h позволяет задать для колонки одну из типовых директив: 
* Like
* Dislike
* Next
* Previous
* Pause

Пример добавления директивы анимации:

```cpp
#include <alice/library/scled_animations/scled_animations_directive.h>
...
if (request.Interfaces().GetHasScledDisplay()) {
    NScledAnimation::AddStandardScled(bodyBuilder, NScledAnimation::EScledAnimations::SCLED_ANIMATION_LIKE);
    bodyBuilder.AddTtsPlayPlaceholderDirective();
}
```

__Используйте метод GetHasScledDisplay() чтобы убедиться, что колонка поддерживает сегментный LED дисплей__

__Добавление TTS PLAY PLACEHOLDER необходимо чтобы анимация на сегментом LED-дисплее проигрывалась одновременно с TTS!__


### Конструирование анимаций при помощи билдера

Если вы ходите добавить кастомную анимацию (например, отобразить значение погоды или будильника), вам надо воспользоваться интерфейсами scled_animations_builder.h или scled_animations_builder_hw.h.
Они позволяют на лету создать нужную анимацию на LEDах и затем преобразовать ее в код директивы. Простейший вариант билдера выглядит так:

```cpp
#include <alice/library/scled_animations/scled_animations_builder.h>
#include <alice/library/scled_animations/scled_animations_directive_hw.h>
...
if (request.Interfaces().GetHasScledDisplay()) {
    TScledAnimationBuilder scled;

    scled.AddDraw("12-56*", /* brighness= */ 255, /* durationMs= */ 1000);
    NScledAnimation::AddDrawScled(bodyBuilder, scled);
    bodyBuilder.AddTtsPlayPlaceholderDirective();
}
```
В указанном примере на колонке на полную яркость (brightness = 255) на 1 секунду (dirationMs = 1000) загорится паттерн вида "12-56*" (звездочка в конце определяет, что также будет зажжен LED в правом верхнем углу).

Билдер позволяет добавлять не только простые анимации, но и строить красивые плавные изображения с буквами и цифрами.

* scled_animations_builder.h работает напрямую с протобафами Response
* scled_animations_builder_hw.h работает с TResponseBodyBuilder для Hollywood


## Профессиональное использование билдера

Билдер анимаций для сегментного дисплея определяет следующие основные методы для задания анимаций:
* AddDraw()
* AddAnim()
* SetDraw()
* SetAnim()

Методы AddXxx() добавляют новую анимацию в конец очереди уже существующих. Удобно использоваться в том случае, если вы "рисуете" последовательную анимацию с разными эффектами в билдере.

Методы SetXxx() позволяют добавить деталей в уже существующую анимацию. Эти методы рассмотрены ниже.

Методы XxxDraw (AddDraw() или SetDraw()) рисует паттерн на экране как есть, с указанной яркостью, в течение указанного времени.

Методы XxxAnim (AddAnim() или SetAnim()) позволяют рисовать на экране сложные анимации с изменением яркости, плавным разворачиванием картинки и т.п.

Кроме указанных методов есть ряд дополнительных параметров, которые могут потребоваться для кастомизации работы билдера.

### Понятие паттерна

Каждая цифра имеет 7 сегментов, которые могут быть включены или выключены. Стандартная нумерация сегментов следующая:

```
     AAAA
    F    B
    F    B
     GGGG
    E    C
    E    C
     DDDD
```
Таким образом цифре 1 соответствуют сегменты B и C, а букве L - сегменты D, E, F. Если вы хотите создать свой паттерн, то можно воспользоваться одним из следующих вариантов:

* воспользоваться методом `TScledAnimationBuilder::Char2Pattern`, который превращает стандартные буквы и цифры в сегменты
* воспользоваться одной из функций вида `TScledAnimationBuilder::Digit0()`, `TScledAnimationBuilder::LetterH()` и т.п.
* построить нужный паттерн вручную `TScledAnimationBuilder::MakeDigit(bool a, bool b, bool c, bool d, bool e, bool f, bool g)`

__Внимание! Билдер поддерживает только те знаки, которые могут быть нарисованы при помощи 7-сегментного паттерна. Например, буквы T или K не могут быть нарисованы.__

4 паттерна и дополнительные LED (SpecialLeds) собираются в общий TFullPattern

```cpp
TFullPattern TScledAnimationBuilder::MakeFullPattern(TPattern p1, TPattern p2, SpecialLeds special, TPattern p3, TPattern p4);
// или (если ваш паттерн представим из символов 0123456789ABCDEFGHIJLOPSUZ-_[])
TFullPattern static TFullPattern String2Pattern(const TString& pattern);
```
паттерны передаются первым аргументом во все функции рисования.

Примеры строковых паттернов для String2Pattern():

| Паттерн    | Описание                                                                  |
| ---------- |:------------------------------------------------------------------------- |
| `"12:56 "` | Все ок, рисуется 12 56 и символ двоеточия                                 |
| `"  -21*"` | Первые 2 цифры не горят, затем рисуется минус, цифры 21 и символ градусов |
| `" U:U  "` | Рисуются 2 буквы U и двоеточие между ними                                 |
| `"118   "` | Ошибка ( на месте восьмерки может быть `:` `-` или `+` )                  |
| `"AB TY "` | Ошибка (буквы `T` и `Y` не могут быть нарисованы при помощи 7 сегментов ) |
| `"56-12@"` | Ошибка (в последнем символе может быть или `пробел`, или `*` )            |

У функции String2Pattern() есть дополнительная возможность генерации символов, которые непредставимы при помощи стандартных цифр и букв. Если вместо соответствующего символа указать знак `#`, то за ним должно быть указано 7 нулей и единиц, которые кодируют сегменты от A до F. Пример:

String2Pattern("#1111110#0000001:#1101101#0000000*") эквивалентно String2Pattern("0-:2*")

В одной записи можно комбинировать и простые символы и спецсимволы с `#` одновременно (см пример ниже)

### Варианты анимаций

Билдер поддерживает следующие варианты анимаций

| Анимация               | Описание                                                                                    |
| ---------------------- |:------------------------------------------------------------------------------------------- |
| AnimModeSolid          | Без анимации, паттерн горит с одинаковой яркостью (это поведение AddDraw()                  |
| AnimModeFade           | Анимация плавно изменяется от яркости brightness1 до brightness2                            |
| AnimModeFromLeft       | Паттерн плавно проявляется или гаснет слева направо                                         |
| AnimModeFromRight      | Паттерн плавно проявляется или гаснет справа налево                                         |
| AnimModeFromTop        | Паттерн плавно проявляется или гаснет сверху вниз                                           |
| AnimModeFromBottom     | Паттерн плавно проявляется или гаснет снизу вверх                                           |
| AnimModeFromBottomLeft | Паттерн движется слева направо, но при приближении к концу дополнительно уходит снизу вверх |

Дополнительно могут быть применены модификаторы скорости

| Модификатор           | Описание                                                                                    |
| --------------------- |:------------------------------------------------------------------------------------------- |
| AnimModeSpeedNormal   | Скорость проигрывания анимации равномерная                                                  |
| AnimModeSpeedSlowFast | Скорость проигрывания анимации сначала медленная, потом возрастает                          |
| AnimModeSpeedFastSlow | Скорость проигрывания анимации сначала быстрая, потом замедляется                           |
| AnimModeSpeedSmooth   | Скорость проигрывания анимации быстрая в середине, замедленная по краям                     |


## Примеры использования билдера

Допустим, мы хотим поддержать сценарий random_number - чтобы на экране рисовалось выпавшее число.

```cpp
TScledAnimationBuilder scled;

// Добавить появление числа от 0 до 255 (полная яркость) за 500 мс
scled.AddAnim("   23", 0, 255, 500, TScledAnimationBuilder::AnimModeFade);
// Задержать число на экране на одну секунду
scled.AddDraw("   23", 255, 1000);
// Плавно погасить число за 500 мс
scled.AddAnim("   23", 255, 0, 500, TScledAnimationBuilder::AnimModeFade);
```

Анимация достаточно простая, ее можно сделать более эфффектной. Давайте добавим в крайнем левом сегменте, чтобы по кругу бегала черточка. Так как отдельная черточка не представляется при помощи стандартных символов, придется воспользоваться конструированием паттернов

```cpp
TScledAnimationBuilder::TFullPattern pat1 = TScledAnimationBuilder::MakeFullPattern(TScledAnimationBuilder::MakeDigit(true, false, false, false, false, false, false), 0, TScledAnimationBuilder::SpecialNothing, 0, 0);
TScledAnimationBuilder::TFullPattern pat2 = TScledAnimationBuilder::MakeFullPattern(TScledAnimationBuilder::MakeDigit(false, true, false, false, false, false, false), 0, TScledAnimationBuilder::SpecialNothing, 0, 0);
TScledAnimationBuilder::TFullPattern pat3 = TScledAnimationBuilder::MakeFullPattern(TScledAnimationBuilder::MakeDigit(false, false, true, false, false, false, false), 0, TScledAnimationBuilder::SpecialNothing, 0, 0);

// Также можно воспользоваться функционалом String2Pattern:
TScledAnimationBuilder::TFullPattern pat1 = TScledAnimationBuilder::String2Pattern("#1000000     "); // пробелы после #1000000 нужны - они кодируют вторую цифру, разделитель, еще две цифры и знаг градуса!
TScledAnimationBuilder::TFullPattern pat2 = TScledAnimationBuilder::String2Pattern("#0100000     ");
TScledAnimationBuilder::TFullPattern pat3 = TScledAnimationBuilder::String2Pattern("#0010000     ");
...
```

И затем одновременно с рисованием цифры 23 рисуем бегущую черту. Так как анимация числа "23" уже сделана (и ее общая длительность 500+1000+500 = 2 секунды), мы будем пользоваться функциями SetAnim, чтобы точечно вклиниться в существущий рисунок.

```cpp
scled.SetDraw(pat1, 255, 0, 200);
scled.SetDraw(pat2, 255, 200, 400);
scled.SetDraw(pat3, 255, 400, 600); // Последовательно зажигаем черточки по кругу на 200 мс
...
scled.SetDraw(pat8, 255, 1800, 2000); // Заканчиваем рисовать черточки одновременно с окончанием основной анимации
// P.S. Да, все это можно завернуть в цикл :)
```

## Пример сложной анимации

Пример анимации выключения экрана мини2, как показано на рисунке ниже:

[Посмотреть видео](https://wiki.yandex-team.ru/users/d-dima/supported-features/.files/video2021-11-1611-12-47.mp4)

Так как билдер не поддерживает сворачивание в центр, нам придется воспользоваться несколькими анимациями, которые накладываются друг на друга:

* свернуть слева направо первые две цифры (12)
* свернуть справа налево последние две цифры (14)
* нарисовать двоеточие, которое не должно пропадать
* плавно высветить знак минуса, когда сворачивание цифр подойдет к середине
* подержать знак "+" на экране и затем плавно погасить его

Итоговая анимация приведена ниже

```cpp
// Внимание! Цифры "12" и "14" надо сконструировать из текущего времени колонки!!!
// Сворачиваем число 12 слева направо в течение 1 секунды (от 0 мс до 1000 мс)
scled.SetAnim("12    ", 255, 0, 0, 1000, TScledAnimationBuilder::AnimModeFromLeft);
// Одновременно с этим сворачиваем число 14 справа налево в течение 1 секунды
scled.SetAnim("   14 ", 255, 0, 0, 1000, TScledAnimationBuilder::AnimModeFromRight);
// Рисуем двоеточие на экране 
//   (тоже в течение одной секунды, но это непринципиально,
//    так как чуть ниже мы будем управлять двоеточием уже в составе плюса)
scled.SetDraw("  :   ", 255, 0, 1000);
// Добавляем высвечивание минуса в течение 100 мс
//   Обратите внимание - исходные анимации для "12" и "14" делались на одну секунду,
//   но так как это сворачивание в центр - до центральной точки цифры дойдут в два раза быстрее,
//   поэтому минус показывается с 500 мс до 600 мс
scled.SetAnim("  -   ", 0, 255, 500, 600, TScledAnimationBuilder::AnimModeFade);
// Начиная с 600 мс и до 1500 мс плавно гасим итоговый плюс (состоящий из '-' и ':') с 255 до нуля.
scled.SetAnim("  +   ", 255, 0, 600, 1500, TScledAnimationBuilder::AnimModeFade);
```

## Рекомендованные параметры для сегметной анимации

Если ваш сценарий отрисовывает на LED-экране мини-2 длинное изображение вида 88:88 (установка будильников, таймеров и т.п.), то рекомендовано использовать следующие параметры и настройки:

* Появление избражения
  * Яркость с 0 до 255
  * Длительность появления - 1000 мс
  * Анимация: `TScledAnimationBuilder::AnimModeFromRight | TScledAnimationBuilder::AnimModeSpeedSmooth`
* Изображение на экране:
  * Яркость 255
  * Длительность - 1000 мс
* Угасание изображения: 
  * Яркость с 255 до 0
  * Длительность пропадания - 1000 мс
  * Анимация: `TScledAnimationBuilder::AnimModeFromLeft | TScledAnimationBuilder::AnimModeSpeedSmooth`

Для использования рекомендованных параметров можно воспользоваться следующей функцией:
```
void NAlice::NScledAnimation::AddAnimatedScled(TResponseBodyBuilder& builder, const TString& pattern)
```
Эта функция создает анимацию длительностью 3 секунды с рекомендованными параметрами.
  
По другим вопросам, связанным с параметрами сегментной анимации, обращайтесь к [Алексею Белицкому](https://staff.yandex-team.ru/abelitsky).
