# Система парсинга слотов стандартных сущностей NLU

https://a.yandex-team.ru/arc/trunk/arcadia/alice/library/sys_datetime умеет парсить сущности со следующими типами:
* `sys.date`
* `sys.time`
* `sys.datetime`

Может быть использован для сценариев получения даты и времени, запроса погоды, установки напоминаний и будильников, а также во всех других сценариях, где требуется обработка даты и времени (афиша, доставка, и т.п.)

### Инициализация:

#### Конструирование с предопределенными данными

Методы `TSlotSysDatetimeParser::Today()`, `TSlotSysDatetimeParser::Yesterday()`, `TSlotSysDatetimeParser::Tomorrow()` возвращают `TMaybe<TSlotSysDatetimeParser>`, заполненный правильным образом (релативная дата).

#### Конструирование на основании Semantic Frame

* Объявите переменную `TMaybe<TSlotSysDatetimeParser>`
* Вызовите метод `TSlotSysDatetimeParser::Parse()`, передав туда или соответствующий слот в JSON формате, или один из протобафов: 
  * TSysDatetimeSlotValue
  * TSysDateSlotValue
  * TSysTimeSlotValue
* Метод вернет Nothing(), если параметров, относящихся к `sys.date`, `sys.time` или `sys.datetime` не найдено.

### Использование ("сырые" данные):

#### Анализ полученных результатов

Метод `GetParseInfo()` может вернуть один из следующих результатов:

* `EDatetimeParser::Unknown` - данные не распознаны 
* `EDatetimeParser::Fixed` - парсер содержит указание фиксированной даты или времени
* `EDatetimeParser::DayOfWeek` - парсер содержит указание дня недели
* `EDatetimeParser::RelativeFuture` - парсер содержит относительную дату или время в будущем
* `EDatetimeParser::RelativePast` - парсер содержит относительную дату или время в прошлом
* `EDatetimeParser::RelativeMix` - парсер содержит относительную дату или время, но есть как положительные, так и отрицательные данные
* `EDatetimeParser::Mix` - парсер содержит различные инструкции

Метод `GetParseContent()` позволяет узнать, какие именно данные были получены после парсинга:

* `Unknown` - данных не было;
* `DateOnly` - только поля, относящиеся к дате;
* `TimeOnly` - только поля, относящиеся ко времени;
* `DateTime` - все поля (как дата, так и время).

#### Работа с сырыми данными

Метод `GetRawDatetime()` возвращает указатель на "сырые" данные, полученые из слота как есть. При необходимости (если например у вас есть альтернативные значения для слота) вы можете дополнить сырые данные для получения финального результата (см ниже)

#### Слияние результатов

Иногда бывает так, что исходные данные поступают не в вие одинарного sys.date, а разбитыми на несколько частей. Например:

* А какой день недели будет `15 марта`, в, ээээээ, ну допустим, `2022 году`?
* Какая дата будет `завтра`, но `через 5 лет`?

В этом случае для парсинга исходного фрейма может потребоваться несколько структур TSlotSysDatetimeParser, причем данные в них не пересекаются.

Метод bool TSlotSysDatetimeParser::Merge(const TSlotSysDatetimeParser& date2) позволяет скомпоновать поля в одной структуре и работать дальше только с ней. Метод возвращает true, если данные успешно собраны вместе и false, если данные конфликтуют и собрать воедино их не удалось (пример: "скажи, сегодня `4 марта` или `5 марта`?").

Если метод Merge() вернул false, то данные в обоих структурах остаются без измений!

Merge() может скомпоновать данные, даже если их тип отличается (`15 марта` и `через год`). При этом все финальные рассчеты пройдут корректно!


### Использование (финальный результат):

Метод `GetTargetDateTime()` принимает 2 параметра:
* `dateCurrent` (NDatetime::TCivilSecond) - текущее время системы для формирования ответа. Изменять `dtCurrent`может быть полезно в продолжительных сценариях, в зависимости от других слотов запроса или в тестах.
* `tense` - время, в котором надо вычислить дату (подробнее про tense см ниже)

| Параметр времени  | Описание                                                                        |
| ----------------- |:------------------------------------------------------------------------------- |
| `TenseDefault`    | Система будет строить финальную дату и время, опираясь на гипотезы внутри слота |
| `TenseFuture`     | Система будет строить финальную дату и время, выбирая будущее время             |
| `TensePast`       | Система будет строить финальную дату и время, выбирая прошедшее время           |

Метод возвращает NDatetime::TCivilSecond - дату и время, которое было вычислено исходя из запроса

Логика работы функции следующая:

* провести корректировки параметров, исходя из логики AM/PM (если она была) и указания абсолютных годов вида "21".
* при наличии абсолютного указания даты и времени параметры данные в dt будут заменены нужными из слота ("15 июня", "17:00" и так далее). Если указано `TensePast` или `TenseFuture`, то недозаполненные поля будут скорректированы автоматически:
  * `TenseFuture`, 13:00 при текущем времени 12/09/2021 17:00 вернет 13/09/2021 13:00 (т.е. следующий день)
  * `TensePast`, 1 февраля при текущей дате 8 февраля вернет 1 февраля того же года
  * `TensePast`, 1 февраля при текущей дате 20 января вернет 1 февраля предыдущего года!!!
  * `TenseDefault` не делает никаких проверок и автоматических смещений в прошлое или будущее
* при наличии относительных смещений даты и времени произойдет корректировка итоговой даты на нужную величину
  * `TenseDefault` трактует относительные смещения как они были заведены в слоте
  * `TenseFuture` трактует относительные смещения всегда в будущее
  * `TensePast` трактует относительные смещения всегда в прошлое
* при наличии смещения дня недели итоговая дата корректируется до указанного дня недели. Это происходит или вперед (`TenseDefault`, `TenseFuture`) или назад (`TensePast`).

### Примеры:
| Запрос            | Текущая дата / время | Tense     | Итоговый ответ                          |
| ----------------- |:-------------------- |:--------- |:--------------------------------------- |
| следующая суббота | 29-09-2021 (ср)      | Future    | 02-10-2021                              |
| на два часа назад | 10-02-2020 14:18     | Default   | 10-02-2020 12:18                        |
| 14 ноября         | 10-08-2021           | Past      | 14-11-2020                              |

#### Дополнительные замечания

##### Сравнение логики работы с VINS

Логика работы с датами у sys_datetime отличается от Vins, поэтому в некоторых случаях может потребоваться дополнительная корректировка параметров. Если мы сконструируем `TSlotSysDatetimeParser` с днем недели "Четверг" и `dateCurrent` также будет равно четвергу (например 16.12.2021), то ответ `GetTargetDateTime()` будет следующим:

| Параметр времени  | Результат                                                 |
| ----------------- |:----------------------------------------------------------|
| `TenseDefault`    | Будет возвращен текущий четверг (16.12.2021)              |
| `TenseFuture`     | Будет возвращен следующий четверг (23.12.2021)            |
| `TensePast`       | Будет возвращен предыдущий четверг (9.12.2021)            |

Чтобы избежать неоднозначности, если текущий день недели совпадает с запрошенным, и tense == TenseDefault, рекомендуется переставлять его в TenseFuture.

##### Использование лет по умолчанию

Метод `TSysDatetimeParser::SetDefautYearCorrection()` позволяет выполнить автоматическое преобразование абсолютного года, заданного двузначной цифрой.

Допустим, мы спрашиваем у пользователя про "двадцать второй год". Очевидно, что речь идет про 2022 год.
Однако если мы спросим про "девяносто восьмой год", то с большой долей вероятности (если не задан `Tense`), речь идет про 1998 год.

Чтобы справиться с такими коллизиями, `TSysDatetimeParser` имеет метод автоматической корректировки двузначных абсолютных лет.
Если речь идет про текущий год + 40 лет вперед, двузначный год превращается в будущее время.
В остальных случаях двузначный год превращается в прошедшее время.
Эта логика работает только в случае `Tense` = `Default`. При наличии явно заданного времени `Past`/`Future` корректировка ведется в соответствии с этим параметром.

Таблица ниже показывает разницу превращений двузначного года в четырехзначный.

| Текущий год `dateCurrent` | Запрошенный год | 'Tense'  | Итоговый год |
| ------------------------- | --------------- | -------- | ------------ |
| 2022                      | 42              | Defaullt | 2042         |
| 2022                      | 42              | Future   | 2042         |
| 2022                      | 42              | Past     | 1942         |
| 2022                      | 99              | Default  | 1999         |
| 2022                      | 99              | Future   | 2099         |
| 2022                      | 99              | Past     | 1999         |

Чтобы изменить границу по умолчанию (текущий год + 40 лет считаются в будущее, остальное в прошлое), используйте метод `TSysDatetimeParser::SetDefautYearCorrection()`.
Например, вызов `TSysDatetimeParser::SetDefautYearCorrection(10)` будет считать в будущее только даты, отстоящие не более чем на 10 лет вперед от `dateCurrent`, все остальные даты будут автоматически считаться в прошлом.

##### Использование 'human-hours' корректировки

При запросе пользователей типа "Поставь напоминание на завтра на 8 утра", которые произошли вскоре после полуночи возможна ситуация, что итоговая дата будет рассчитана неверно, и вместо напоминания на завтра мы получим напоминание на послезавтра.
Для контроля этой ситуации используется метод `TSysDatetimeParser::SetHumanCorrection()`, который позволяет "сдвинуть полночь" и считать полуночные запросы пользователей такими же запросами, которые реально происходили прошедшим вечером.

Корректировка 'human-hours' требует выполнения следующих условий:

* В исходном запросе фигурирует относительная дата (завтра, через 3 дня, вчера и т.п.);
* Время в исходном запросе - вскоре после полуночи;

Если условия соблюдены, и если время исходного запроса не превысило лимит 'human-hours', то происходит корректировка результата на сутки назад.

По умолчанию корректировка 'human-hours' выключена (=0). Чтобы включить корректировку, надо вызвать `TSysDatetimeParser::SetHumanCorrection()`, передав туда число МИНУТ после полуночи, пока система будет считать этот день "вчерашним".
