# Контекст диалога

В сценариях общения с Алисой часто бывает нужно сохранять контекст диалога между репликами пользователя. Для этого можно использовать формально структурированные [фреймы](#frames-forms) и поле протокола `state`, с произвольным содержимым.

* Фреймы будут полезны, если сценарий нацелен на решение определенной задачи с предсказуемым набором параметров: например, чтобы вернуть прогноз погоды, обязательно нужно знать дату и место, для которых запрашивается прогноз. В этом случае сценарий может описать правила разбора реплики, которые помогут Мегамайнду корректно извлекать нужные данные из распознанной речи.

* Если же сценарий обрабатывает слабо формализуемый ввод, формализовать его фреймами будет малоэффективно — например, в квестовых играх, где смысл в явной неопределенности правил. В таких случаях правильнее сохранять данные в произвольном формате в поле `state`, которое только пробрасывается Мегамайндом по цепочке запросов диалога, и держать всю логику разбора на стороне бэкенда сценария.

Чаще всего сценариям естественно комбинировать эти подходы — формализовать реплики с помощью фреймов настолько, насколько это имеет смысл, а остальной контекст обрабатывать самостоятельно.

{% note info %}

Придерживайтесь [ограничений](megamind/limits.md) при разработке сценария.

{% endnote %}

## Фреймы и формы {#frames-forms}

Чтобы формализовать [разбор реплик](nlu/index.md), на обработку которых нацелен сценарий, нужно:

* описывать реплики, которые могут быть ему релевантны, с помощью одной из ([технологий NLU](nlu/index.md));
* явно связывать результаты разбора реплики и соответствующие сценарии (с помощью [конфига](megamind/config.md)).

Каждый разбор описывает _форму_ с уникальным именем — структуру, согласно которой следует извлекать данные из реплик (по аналогии с заполнением бланков или анкет в реальной жизни). Структура задается _слотами_ — полями определенных типов, которые заполняются Бегемотом в соответствии с разбором.  Например, в реплике, обращенной к сценарию случайного числа, может быть два слота — верхняя и нижняя границы нужного диапазона чисел.

Данные, извлеченные из реплики согласно разбору, помещаются во _фрейм_ (структурированное представление содержания диалога). Имя фрейма соответствует имени формы, из которой он был создан. Фрейм является центральной сущностью протокола передачи данных реплики между компонентами платформы сценариев:

* Именно фрейм является результатом разбора реплики в Бегемоте и передается в запросе от Мегамайнда к сценарию.
* Именно имя фрейма указывается в конфиге сценария, чтобы показать Мегамайнду, для каких реплик сценарий предназначен.


### Алгоритм разбора реплики {#algorithm}

В каждый момент времени у пользователя может быть не больше одного _активного фрейма_ (контекст реального диалога с Алисой). Активный фрейм может меняться в процессе диалога, если реплики пользователя продолжают обрабатываться в рамках одного сценария.

Общий алгоритм разбора реплики на примере вопроса о погоде:

1. Мегамайнд отправляет запрос с репликой в Бегемот («какая завтра погода»).
1. Бегемот разбирает фразу с помощью всего доступного множества инструментов NLU.

   Одна и та же реплика может быть успешно разобрана разными способами и породить разные фреймы. Поэтому Бегемот в общем случае возвращает в Мегамайнд набор фреймов. Для вопроса про погоду подходит `alice.get_weather`.
1. Мегамайнд сопоставляет список полученных фреймов с конфигами всех известных сценариев (допустим, на фрейм `alice.get_weather` подписан только сценарий `get_weather`).
1. Мегамайнд отправляет запросы с каждым из полученных фреймов в каждый сценарий, в конфиге которого указан этот фрейм (в примере — в сценарий `get_weather`, а также в сценарии, которые подписаны на все фреймы подряд).
1. Мегамайнд собирает ответы сценариев и производит ранжирование.
   1. Если в ранжировании побеждает сценарий, фрейм которого был активен при получении реплики, фрейм из ответа сценария перезаписывает активный фрейм.

      Сценарий может пометить слот в новом фрейме как требующий дозаполнения: при разборе следующей реплики реплики Бегемот пытается извлечь для такого слота данные нужного типа. Если это удалось, то дозаполненный фрейм отправляется всем ранжируемым сценариям. Но при этом ответ сценария, который запросил дозаполнение, ранжируется выше.

      Например, сценарий `get_weather` может запросить населенный пункт, для которого нужен прогноз погоды: вернуть в ответном фрейме слот `$Where` с полем `IsRequested`.

   1. Если в ранжировании победил новый сценарий, его фрейм становится _активным_.
1. Мегамайнд отправляет ответ пользователю.
1. От пользователя приходит новая реплика («в Санкт-Петербурге»), и обработка начинается заново.
