# Регистрация графа

По умолчанию считается, что новый сценарий работает на двухнодовом графе аппхоста с ручками `/run` и `/main`. Кастомизация графа может потребоваться в случаях:
* если сценарий сложный;
* если вы переносите сценарий на традиционном способе.

Чтобы Hollywood Framework принял новый граф аппхоста и начал с ним работать, в конструкторе сценария вызовите функцию `SetApphostGraph()`:

```cpp
void TScenario::SetApphostGraph(ROUTE);
```

Где `ROUTE` при помощи перегрузки `>>` описывает, какой граф будет использоваться для управления работой сценария.

{% list tabs %}

- Двухнодовый граф

  Если вы используете именно такой граф, эта строчка будет добавлена в код инициализации сценария автоматически:
  ```cpp
  SetApphostGraph(ScenarioRequest() >> TNodeRun() >> TNodeMain() >> ScenarioResponse());
  ```

- Однонодовый граф

  ```cpp
  SetApphostGraph(ScenarioRequest >> TNodeRun() >> ScenarioResponse);
  ```

{% endlist %}


{% note alert %}

Названия нод `run`, `main`, `continue`, `commit` и `apply` предопределены и поясняют фреймворку, какие локальные узлы следует вызывать в каждом случае. Если вы используете кастомные названия нод, то может потребоваться детализация. Подробнее в разделе [Совместимость и развитие сценариев](../compatibility/intro.md).

Если вы задекларировали однонодовый граф, попытка зарегистрировать функцию `SceneMainSetup` или `DispatchSetup` приведет к исключению в момент инициализации сервера.

{% endnote %}


