# Класс TRequest

Класс с данными для получения информации о входящем запросе.
Содержит в себе полную информацию о всех исходных параметрах. Всегда доступен только по чтению.

Класс `TRequest` содержит 6 дополнительных классов, все данные распределены по этим 6 подклассам.

| Подкласс      | Доступ             | Описание            |
|:------------- |:------------------ |:------------------ |
| `TSystem`       | `request.System()`   | Системные данные запроса - идентификаторы, серверное время, общие ресурсы, другие параметры |
| `TDebug`      | `request.Debug()`    | Отладочные данные и логгер |
| `TClient`       | `request.Client()`   | Характеристики устройства и ее параметры |
| `TFlags`        | `request.Flags()`    | Доступ к экспериментам
| `TUser`        | `request.User()`     | Характеристики пользователя и его параметры |
| `TInput`       | `request.Input()`    | Характеристики исходного запроса |

Не все виды запросов в настоящее время поддержаны в полном объеме, поэтому `TRequest` предоставляет несколько дополнительных методов, которые через какое-то время будут объявлены устаревшими. Эти методы позволяют получить прямой доступ непосредственно к протобафам внутри `TRequest`.

К этим методам относятся:

* `const NScenarios::TRequestMeta& TRequest::GetRequestMeta() const`
* `const NAppHost::IServiceContext& TRequest::GetServiceCtx() const`
* `const NScenarios::TScenarioRunRequest& TRequest::GetRunRequest() const`
* `const NAlice::TClientInfo& TClient::GetClientInfo() const`
* `template <class T> bool TClient::TryGetMessage(T& proto) const`

## Методы TSystem

Класс `TSystem` позволяет получить информацию о системных данных запроса.
В настоящее время поддержаны следующие запросы в `TSystem`:

| Метод                | Тип                  | Опиание            |
|:-------------------- |:-------------------- |:------------------ |
| `RequestId()`         | `TString`              | UUID запроса       |
| `Random()`            | `TRng`                 | Генератор случайных чисел, проинициалиирован корректно с учетом тестов IT2/EVO |
| `GetServerTime()`      | `chrono::milliseconds` | Текущее серверное время в миллисекундах |
| `GetCommonResources()` | `TCommonResources`     | Объект с общими ресурсами Hollywood (геобаза и т.п.) |

При работе с юнит-тестами см. дополнительное описание инициализации `TCommonResources` через `Test Fixture`.

## Методы TDebug

Класс `TDebug` содержит методы для отладки и диагностики сценария. В настоящее время содержит только 1 метод `Logger()`, функционал класса будет расширен после рефактора системы логгирования.

Использование старого логгера:

```cpp
LOG_INFO(request.Debug().Logger()) << "Some message";
```

## Методы TFlags

Объект `TResuest::Flags()` позволяет проверить флаги экспериментов. Доступно несколько вариантов проверок в сценариях:

* `bool TFlags::HasExperiment(TStringBuf key)` — позволяет проверить наличие произвольного флага в блоке запроса.
* `TMaybe<T> TFlags::GetValue(TStringBuf key)` — позволяет получить строковое или числовое значение флага эксперимента по ключу.
* `T TFlags::GetValue(TStringBuf key, T defaultValue)` — альтернативный вариант для предыдущей функции, возвращает значение по умолчанию вместо `Nothing()`.
* `bool TFlags::ForEach(T obj, std::function<...)> fn)` — метод для прямого перебора существующих флагов.

### Прямой перебор флагов

Прямой перебор флагов эксперимента позволяет выполнить полный обход всех флагов с выполнением определенных действий в лямбде.

Функция `fn` имеет сигнатуру `bool [](T obj, const TString& arg, const TMaybe<TString>& value)` и получает каждый флаг и ассоциированное с ним значение.

* Если лямбда возвращает `false`, перебор флагов прекращается, итоговая функция возвращает `false`.
* Если лямбда возвращает `true`, перебор флагов продолжается, итоговая функция после окончания перебора всех флагов вернет `true`.

Объект `T obj` передается в функцию `ForEach()` первым аргументом и позволяет сохранять результаты перебора флагов эксперимента во внешней к лямбде переменной.

Некоторые флаги экспериментов автоматически транслируются в поля контекста [NLG](../nlg/intro.md).

### Поддержка значений в ключе экспериментов

В ряде случаев флаги экспериментов задаются в формате `"key=value":"1"`, то есть значение эксперимента находится сразу в поле ключа. Для поддержки этого формата используйте дополнительные функции, которые работают с ключами в формате `'A=B':ignored_value`:

* `bool TFlags::HasExperiment(TStringBuf key, bool bIgnoreEq = false)` — поставьте второй параметр в `true`, чтобы искать не по полному ключу, а по подстроке до первого символа `=`.
* `TMaybe<T> TFlags::GetSubValue(TStringBuf key)` — получает вторую часть ключа по первой части в виде базового типа.
* `T TFlags::GetSubValue(TStringBuf key, T defaultValue)` — получает вторую часть ключа по первой части в виде базового типа (альтернативный вариант).