# Класс TStorage

Класс с длительными данными, которые сценарий может хранить между отдельными запросами. Используется для сохранения информации о:

* Scenario State
* Memento

В отличии от `TRequest` структура `TStorage` доступна не только по чтению, но и по записи. Это позволяет сценарию сохранять отдельные параметры в долгосрочной памяти и пользоваться ими при последующих вызовах в сценарий.

Для собственных данных сценария можно установить таймаут времени жизни, чтобы после определенного интервала (обычно 5 минут) запросы к станции считались новым контекстом, а не продолжением предыдущего разговора.

Диспетчер сценария не может изменять структуру `TStorage`, эта возможность есть только у конкретных обработчиков сцен.

## Работа со ScenarioState

Получение данных ScenarioState:
```c++
template <typename T>
EScenarioStateResult GetScenarioState(T& arg, std::chrono::duration timeout) const;
```

Темплейтный параметр `T` определяет протобаф сценария, который сохраняется в `BaseRequest::State` (тип `google::protobuf::any`).

Функция возвращает заполненную структуру через параметр `arg` и дополнительный код возврата, который определяет состояние стейта сценария:

* `TStorage::EScenarioStateResult::Absent` — данные для сценария отсутствуют. Структура `T` остается пустой.
* `TStorage::EScenarioStateResult::Expired` — превышен таймаут сохранения данных. Таймаут задается аргументом `timeout` (по умолчанию 5 минут). Несмотря на возврат Expired, сохраненные значения в структуре `T` могут быть возвращены из системы, если они не являются актуальными, рекомендуется очистить их при помощи `T::Clear()`.
* `TStorage::EScenarioStateResult::NewSession` — данные найдены, однако установлен флаг новой сессии. Сценарий может самостоятельно решить, продолжать ли их использовать в текущем запросе.
* `TStorage::EScenarioStateResult::Present` — данные найдены.

```c++
template <typename T>
void SetScenarioState(const T& state);
```

Сохраняет данные сценария и автоматически обновляет время `ScenarioState` до таймаута. Класс `T` должен совпадать с классом, который используется в функции `GetScenarioState()`.