# Ellipsis-фреймы

Ellipsis-фреймы (фреймы уточняющих запросов) — это фреймы [Гранета](../../nlu/granet/index.md). Такие фреймы пишутся с окончанием `__ellipsis`. Варианты использования ellipsis-фреймов в Hollywood Framework:
* **Рекомендуется.** Как голосовой кнопки через NLU Hints.
* Как обычный фрейм. Категорически не рекомендуется, требуется только в особо нетривиальных случаях.

## Голосовая кнопка

Ellipsis-фрейм добавляется в ответ сценария только при наличии релевантного ответа от основного запроса или от предыдущего заданного уточнения. Чтобы разрешить ellipsis-запрос, используйте метод класса `TResponse`:

```cpp
void TResponse::SetEllipsisFrame(const TStringBuf ellipsis, const TString& actionName = "");
```

Сценарий может добавить в Frame Action произвольное количество эллипсисов.

Если параметр `actionName`:
* **задан по умолчанию,** то имя эллипсиса в протобафе `FrameActions` будет `ellipsis_0`, `ellipsis_1` и т.&nbsp;д.;
* **кастомный**, то укажите его вторым параметром.

При наличии конфликтов в именах `FrameActions` (если заданные имена `actionName` имеют формат `ellipsis_%i`), при формировании итогового ответа система подберет уникальные имена.

Ellipsis-фрейм не регистрируется в [Megamind](../../megamind/index.md). Проставьте в настройках Гранета `is_action: true`. Подробнее в [документации NLU](../../../nlu/granet/alice-test#dlya-bystrogo-reliza).

## Обычный фрейм

{% note warning %}

Если вам необходимо использовать ellipsis в качестве обычного фрейма, [проконсультируйтесь](https://t.me/joinchat/WLI9XSTsGdIdeek2) с разработчиками Hollywood Framework.

{% endnote %}

Для работы с ellipsis-фреймами в качестве обычных:
1. Подключите ellipsis-фрейм в [конфигурацию мегамайнда](https://a.yandex-team.ru/arc/trunk/arcadia/alice/megamind/configs).
2. Добавьте ellipsis-фрейм в `TScenatio::AddSemanticFrame()`.

### Решение проблем

* Используйте в ellipsis только уникальные запросы конкретно для вашего сценария.
    * **Почему?** Если ваш ellipsis достаточно общий, то сильно вырастет число запросов к сценарию.
* Извлеките из `TStorage` данные предыдущего состояния сценария, чтобы выполнить проверки ellipsis-запроса без предыдущего основного запроса (`EScenarioStateResult::Absent`, `EScenarioStateResult::Expired` и `EScenarioStateResult::NewSession`). Если ellipsis-запрос пришел без предыдущего основного запроса, то всегда возвращайте `Irrelevant`, чтобы ваш сценарий в постклассификаторе не смог выиграть у текущего сценария.
    * **Почему?** Если сценарий попробует ответить на ellipsis, ваш ответ может «перебить» существующий диалог.
