# Сводный список функций и методов

* [Функции](#functions)
* [Ключевые слова](#keywords)
* [Методы](#methods)

## Функции NLG {#functions}

### abs

**Синтаксис** | **Описание** | **Объект** | **Тип объекта**
:--- | :--- | :--- | :---
**{{ var &vert; abs }}**| Вычисляет абсолютное значение целого или вещественного числа. | `var` | `integer` или `double`


### attr

**Синтаксис** | **Описание** | **Объект** | **Тип объекта**
:--- | :--- | :--- | :---
**{{ voice_and_text &vert; attr('voice') }}**| Отправляет указанную фразу в голосовой вывод (`'voice'`) или в текстовый вывод (`'text'`). Использование этой функции эквивалентно использованию атрибутов `{% text %}` и `{% voice %}`. | `voice_and_text` | `string`


### capitalize

**Синтаксис** | **Описание** | **Объект** | **Тип объекта**
:--- | :--- | :--- | :---
**{{ name &vert; capitalize }}** | Преобразует указанную строку во фразу, написанную ЗАГЛАВНЫМИ БУКВАМИ. |`name` | `string`


### capitalize_first

**Синтаксис** | **Описание** | **Объект** | **Тип объекта**
:--- | :--- | :--- | :---
**{{ name &vert; capitalize_first }}** |  Преобразует первый символ строки в заглавный. Используйте эту функцию, например, если вам надо начать новое предложение после точки.|`name` | `string`

### ceil_seconds

### city_prepcase

**Синтаксис** | **Описание** | **Объект** | **Тип объекта**
:--- | :--- | :--- | :---
**{{ city &vert; city_prepcase }}** | Выбирает название города в соответствии со склонением (в Санкт-Петербурге, в Японии, на Сахалине). | `city`| Объект, который подготовлен в С++ коде при помощи метода `NAlice::AddAllCaseForms()`.


### decapitalize

**Синтаксис** | **Описание** | **Объект** | **Тип объекта**
:--- | :--- | :--- | :---
**{{ name &vert; decapitalize }}**|  Преобразует указанную строку во фразу, написанную строчными буквами (обратная функция к `capitalize`).| `name`| `string`

### decapitalize_first

**Синтаксис** | **Описание** | **Объект** | **Тип объекта**
:--- | :--- | :--- | :---
**{{ name &vert; decapitalize_first }}**| Преобразует первый символ строки в строчный (обратная функция к `capitalize_first`). | `name`| `string`

### default

### div2_escape

### emojize

### first

### float

**Синтаксис** | **Описание** | **Объект** | **Тип объекта**
:--- | :--- | :--- | :---
**{{ val &vert; float }}**| Преобразует объект в переменную типа `float`. |`val` | `string` или `integer`

### format_weekday

### get_item

**Синтаксис** | **Описание** | **Объект** | **Тип объекта**
:--- | :--- | :--- | :---
**{{ data &vert; get_item('text') }}** | Извлекает элемент из мапы либо с соответствующим атрибутом (если аргументом функции является строка вида `'text'`). Либо извлекает элемент из мапы по порядковому номеру (если аргументом функции является целое число). |`data` | `map`

### html_escape

### human_date

### human_day_rel

### is_human_day_rel

### human_month

### inflect

### int

**Синтаксис** | **Описание** | **Объект** | **Тип объекта**
:--- | :--- | :--- | :---
**{{ val &vert; int }}** | Преобразует объект в переменную типа `integer`. |`val` | `string` или `float`

### join

### last

### length

### list

### lower

### map

### max

### min

### music_title_shorten

### normalize_time_units

### number_of_readable_tokens

### only_text

### only_voice

### parse_dt

### pluralize

### pluralize_tag

### random

**Синтаксис** | **Описание** | **Объект** | **Тип объекта**
:--- | :--- | :--- | :---
**{{ val &vert; random }}**| `string` выбирает случайную букву из указанного текста; `list` выбирает случайный элемент из указанного списка (содержимым списка могут быть произвольные объекты); `range` (целочисленный) генерирует случайное целое число в заданном интервале. | `val` | `string`, `list` или `range`

### render_weekday_type

### render_weekday_simple

### render_datetime_raw

### render_units_time

### replace

### round

### singularize

### split_big_number

### string

### time_format

### to_json

### trim

### trim_with_ellipsis

### tts_domain

### upper

### urlencode

### add_hours

### client_action_directive

### create_date_safe

### datetime

### datetime_strptime

### parse_tz

### randuniform

### server_action_directive

### timestamp_to_datetime

## Ключевые слова {#keywords}

### chooseline

Синтаксис:

```
{% chooseline %}
  строка 1
  строка 2
  строка 3
  ...
{% endchooseline %}
```

`chooseline` позволяет выбрать одну из строчек для вывода пользователю. Этот способ подходит только для простейших фраз, выдача которых равновероятно или в которых нет переводов строк. Для более сложного варианта выдачи используйте ключевое слово `chooseitem`.

### chooseitem

Синтаксис:

```
{% chooseitem %}
  блок текста и функций №1
  {% or %}
  блок текста и функций №2
  {% or %}
  блок текста и функций №3
  {% or %}
  ...
{% endchooseitem %}
```

После `chooseitem` или `or` может быть указано целочисленное или вещественное число для корректировки вероятности выпадения одного или другого варианта.

`chooseitem` позволяет выбрать один из блоков для выдачи пользователю. В отличии от `chooseline` этот способ нечувствителен к переводам строк.

Если после ключевого слова `chooseitem` указывается вес как целочисленное или вещественное значение, то правила подсчета веса следующие:

* все веса всех `chooseitem` в пределах блока суммируются (если вес какого либо отдельного chooseitem не указан, используется 1.0).
* для выбора фразы из списка генерируется случайное число в интервале 0...sum
* выбирается фраза в соответствии с выпавшим числом

Пример. Если у нас есть 5 вариантов `chooseitem` со следующими весами: "по умолчанию", 0.5, 0.2, 0.3, 2.

Сумма значение равна `1 + 0.5 + 0.2 + 0.3 + 2 = 4`. При рендеринге NLG фразы будет сгенерировано случайное число в интервале `0...4`.

* Если это число находится в интервале `(0...1)`, то будет выбрана первая фраза;
* Если это число находится в интервале `(1...1.5)`, то будет выбрана вторая фраза;
* Если это число находится в интервале `(1.5...1.7)`, то будет выбрана третья фраза;
* Если это число находится в интервале `(1.7...2.0)`, то будет выбрана четвертая фраза;
* Если это число находится в интервале `(2.0...4.0)`, то будет выбрана пятая фраза.

### maybe

Альтернативная форма записи для `chooseitem` — позволяет вставить указанный текст с определенной долей вероятности.

```
Блок текста 1.
{% maybe %}
  блок текста 2.
{% endmaybe %}
Блок текста 3.
```

С вероятностью 50% между блоками текста 1 и 3 будет появляться текст 2. Значение вероятности можно изменить, как в `chooseitem`:

* `{% maybe 0.2 %}` дает 20% вероятность выдачи текста;
* `{% maybe 0.5 %}` дает 50% вероятность выдачи текста (по умолчанию);
* `{% maybe 1.0 %}` будет выдавать текст со 100%-й вероятностью.

## Методы {#methods}

### datetime_strftime

### datetime_isoweekday

### dict_get

### dict_items

### dict_keys

### dict_update

### dict_values

### list_append

### localize

### str_ends_with

### str_join

### str_lower

### str_lstrip

### str_replace

### str_rstrip

### str_split

### str_starts_with

### str_strip

### str_upper
