# Рендер

## Описание

Рендеринг — последний этап в формировании ответа пользователю. Данные, подготовленные бизнес-логикой сцены, транслируются в итоговый ответ. 

Ответ может содержать:
* текст и голос (на языке пользователя);
* графический ответ (например, [div-card](https://doc.yandex-team.ru/divkit/overview/concepts/about.html));
* вспомогательные визуальные данные (например, анимации gif/scled);
* дополнительные клиентские директивы для управления колонкой;
* дополнительные серверные директивы для изменения параметров (например, лайки на музыку, установка будильников).

Функции рендера стоят особняком, для них не определено типовой точки, где их надо создавать. Фреймворк позволяет размещать рендеры:
* **Как часть диспетчера.** Например, если у сценария есть только один рендер.
* **Как часть сцен.** Например, если каждая из сцен имеет разные ответы и логику поведения и ответы.
* **Как часть диспетчера и сцен.** Например, если есть общий рендер для ошибочных ответов, а в классах сцен — рендеры для верных ответов.

## Аргументы функции

```cpp
TRetResponse MyRender(const TMyRenderProto&, TRender& render);
TRetResponse TMyScenario::MyRender(const TMyRenderProto&, TRender& render) const;
TRetResponse TMyScene::MyRender(const TMyRenderProto&, TRender& render) const;
```

* `const TMyRenderProto` — аргументы рендера, которые были переданы из сцены или диспетчера.
* `TRender` — указатель на экземпляр `TRender`, который используется в процессе формирования ответа.

## Результат рендера

| Результат | Описание |
| ----------- | ----------- | 
| [TResponse](##tresponse) | Успешный ответ. | 
| [TError](#terror) | Ошибка. | 

{% note warning %}

У функции рендера нет возможности поставить `Irrelevant` для ответа. В Hollywood Framework единственный способ вернуть нерелевантный ответ — вернуть код возврата `TReturnValueRenderIrrelevant` вместо `TReturnValueRender` из функции диспетчера или сцены.

{% endnote %}

### Успешный ответ {#tresponse}

Функция рендера выполнит следующие действия:

1. Сконструирует экземпляр класса `TResponse`.
2. Вызовет методы:
   * `TRender` для формирования ответа пользователю.
   * `TResponse` для формирования директив серверу или клиенту.
3. Вернет созданный экземпляр класса `TResponse`.

{% cut "Пример" %}

```cpp
TRetResponse MyRender(const TMyRenderProto&, TRender& render) {
    TResponse response(render);
    ...
    ... // Вызываем методы render и response для формирования ответа
    ...
    return response;
}
```
{% endcut %}


### Ошибка {#terror}

`TError` (или бросающий исключение макрос `HW_ERROR()`) позволяет вернуть из любых функций сценария ошибку. Сообщение об ошибке передается в ММ, сценарий автоматически отвечает иррелевантом.

Применяйте `TError` и `HW_ERROR` только в крайних случаях, когда нет возможности восстановить работу сценария другими способами. Например, если глубоко внутри стандартных библиотек `alice/library` обнаружена невосстановимая ошибка.
