# Сетевые походы

## Из сцены

Если бизнес-логика сцены требует уточнения данных из внешнего источника, то добавьте функцию настройки сетевого похода:

```cpp
class TMyScene1 : public TScene {
public:
    TMyScene1(const TScenario* owner);
    // Новая предварительная функция для организации сетевых походов
    TRetSetup Setup(const TMySceneProto&, const TRunRequest&, const TStorage&) const;
    // Основная функция с бизнес логикой сцены
    TRetMain Main(const TMySceneProto&, const TRunRequest&, TStorage&, const TSource&) const;
};
```
И `Setup()`, и `Main()` первым аргументом примут данные из протобафа, который был задан в диспетчере сценария.

Для выбора сцены в диспетчере укажите функцию `Setup()` вместо функции `Main()`:
```cpp
return TReturnValueScene(&TMyScene1::Setup, mySceneProto, "my_semantic_frame_name");
```

При регистрации сцены в сценарии укажите новую функцию рядом с функцией `Main()`. Порядок регистрации в списке не важен.

```cpp
TMyScenario::TMyScenario()
    : TScenario("my_scenario")
{
    Register(&TMyScenario::Dispatch);
    RegisterScene<TMyScene1>([this]() {
        RegisterSceneFn(&TMyScene1::Setup); // Новая функция должна быть зарегистрирована
        RegisterSceneFn(&TMyScene1::Run);
    });
    ...    
}
```

### Изменения в работе сценария

* Функция `Setup()` получит управление первой и может выполнить следующие действия:
   * проанализировать входные аргументы (переданные диспетчером параметры в `TRunRequest` и `TStorage`);
   * создать экземпляр класса `TSetup`;
   * наполнить экземпляр класса `TSetup` запросами в источники;
   * вернуть экземпляр переменной `TSetup` во фреймворк.
* Функция `Main()` получит управление после окончания сетевых походов, в переменной `TSource` будут содержаться полученные ответы.

Дальнейшая логика работы сценария не изменяется.

## Из диспетчера

Иногда сетевой поход требуется не только сцене, но и диспетчеру — для выбора правильной сцены. Это связано с вариативностью входных запросов от пользователя, когда требуется сетевая расшифровка запроса пользователя перед обработкой данных сценой.

Чтобы дать возможность диспетчеру читать ответы источников, используйте функцию `DispatchSetup()` до `Dispatch()`:

```cpp
class TMyScenario : public TScenario {
public:
    TMyScenario();
    TRetSetup DispatchSetup(const TRunRequest&, const TStorage&) const; // Сетевой поход из диспетчера
    TRetScene Dispatch(const TRunRequest&, const TStorage&, const TSource&) const;
};
...
// Регистрация функции в конструкторе сценария 
TMyScenario::TMyScenario()
    : TScenario("my_scenario")
{
    Register(&TMyScenario::Dispatch);
    Register(&TMyScenario::DispatchSetup); // Зарегистрируйте функцию тут, порядок вызовов Register() неважен
    ...
}
```

После регистрации функции метод `DispatchSetup()` получит управление и сможет настроить сетевой поход при помощи переменной `TSetup`.
Логика организации сетевого похода та же, что и в сценах. Когда функция `Dispatch()` получит управление, в переменной `TSource` будет список ответов источников.

Для реализации функции `DispatchSetup()` переключите граф аппхоста на трехнодовую схему. Подробнее см. в разделе [Взаимодействие с графом сценария](../apphost/interact.md).

### Последовательные сетевые подходы

В сценариях, когда результаты предыдущего запроса влияют на параметры следующего, используйте `DispatchSetup()`. В явном виде схема не поддержана — у сцены есть только одна функция для организации сетевого похода. 

Для двух последовательных сетевых подходов:
1. Используйте `DispatchSetup()` для первого обращения к источнику.
2. Используйте `SceneSetup()` для второго обращения.
