# Сцена

## Описание

Сцена — основной обработчик запросов пользователя. Сцена не формирует ответ, а определяет бизнес-логику, при помощи которой рендер подготовит результат.

В одном сценарии может быть несколько сцен с разной бизнес-логикой работы. Рекомендуется делать несколько сцен, если:
* **Сценарий обрабатывает принципиально разные операции.** Например, «узнать о текущих напоминаниях», «поставить новое напоминание» и «удалить напоминания».
* **Ответы сценария принципиально отличаются.** Например, «12 декабря что за день недели» и «покажи календарь на декабрь».

По возможности изолируйте действующие в продакшене сцены от экспериментов.
Если в диспетчере обнаружен флаг эксперимента, создавайте новый тип сцены и уходите в него.
Проверки `IsExperimentEnabled()` внутри действующего в продакшене кода не рекомендуются.

## Аргументы функции

Для каждой из сцен в сценарии создайте свой отдельный класс вида `TMyScene : public NAlice::NHollywoodFw::TScene`.

```cpp
class TMyScene1 : public TScene<TMySceneProto> {
public:
    TMyScene1(const TScenario* owner);
    TRetMain Main(const TMySceneProto&, const TRunRequest&, TStorage&, const TSource&) const override;
};
```

* `const TMySceneProto` — аргументы сцены, которые были переданы в диспетчере в `TReturnValueScene()`.
* `const TRunRequest` — указатель на общий блок входных данных.
* `TStorage` — указатель на долговременное хранилище (memento, scenario state).
* `const TSource` — данные ответа источников.

## Результат сцены

Метод `Main()` анализирует запрос и возвращает результат через `TRetMain` (`std::variant`).

| Результат | Описание |
| ----------- | ----------- | 
| [TReturnValueRender](#returnvaluerender) | Бизнес-логика успешно отработала и готова предоставить данные для финального ответа пользователю. | 
| TReturnValueContinue| Требуется продолжение обработки в ручке `/continue`. | 
| TReturnValueApply | Требуется продолжение обработки в ручке `/apply`. | 
| TReturnValueCommit | Требуется продолжение обработки в ручке `/commit`. | 
| [TError](#terror) | В ходе работы функции произошла невосстановимая ошибка. | 
| [TReturnValueDo](#valuedo) | Надо переключиться на старый вариант работы сценария. | 


### Релеватный ответ {#returnvaluerender}

Сцена может выбирать рендер и задавать его аргументы.

Функция `TTReturnValueRender()` имеет следующие варианты описания:

```cpp
// Вариант для своей функции рендера
TReturnValueRender(pointerToRenderFn, Protobuf)
// Вариант для стандартной функции рендера
TReturnValueRender(const TString& nlgName, const TString& phrase, Protobuf);
```

{% cut "Пример" %}
Функция рендера:

```cpp
class TMyScenario : public TScenario {
    ...
    TRetResponse RenderAnswer(const TMyRenderProto&, TRender& render) const;
};
```

Чтобы вызвать эту функцию рендера, сцена должна:

1. Создать экземпляр протобафа `TMyRenderProto`.
2. Заполнить его параметрами.
3. Вызвать `TReturnValueRender(&TMyScenario::RenderAnswer, myRenderProto);`.

{% endcut %}


### Ошибка {#terror}

`TError` (или бросающий исключение макрос `HW_ERROR()`) позволяет вернуть из любых функций сценария ошибку. Сообщение об ошибке передается в ММ, сценарий автоматически отвечает иррелевантом.

Применяйте `TError` и `HW_ERROR` только в крайних случаях, когда нет возможности восстановить работу сценария другими способами. Например, если глубоко внутри стандартных библиотек `alice/library` обнаружена невосстановимая ошибка.

### Переключение на традиционный способ {#valuedo}

Код возврата используется только в процессе переноса традиционных сценариев на Hollywood Framework, подробнее см. в разделе [Прямая и обратная совместимость сценариев](../compatibility/intro.md).

