# Как создавать сценарии для Алисы


{% note info %}

О том, как быстро создать сценарий, читайте в разделе [Быстрый старт](quickstart.md).

{% endnote %}

Разработчики Яндекса могут создавать (и создают) собственные сценарии, которым Алиса может следовать, отвечая на определенные реплики пользователей. Инфраструктура сценариев позволяет:

* легко научить Алису новому сценарию, не конфликтуя с уже написанными;
* упростить задачу обработки сырых реплик (с помощью Бегемота и [технологий NLU](nlu/index.md));
* протестировать логику обработки реплик в условиях, приближенных к боевым;
* развернуть сценарий на собственном бэкенде (на любом языке программирования, нужно только реализовать [протокол](megamind/protocol.md) работы с Мегамайндом) или в готовом бэкенде [Голливуда](hollywood/index.md) (С++).

Основные этапы разработки и релиза сценария:

1. Задайте [правила разбора](nlu/index.md) пользовательских фраз, которые должны запускать сценарий.
1. Закоммитьте все [конфиги сценария](megamind/config.md) с флагом `Enabled: False`.
1. Реализуйте серверную логику: сервер должен поддерживать [протокол Мегамайнда](megamind/protocol.md).
1. Параллельно с реализацией бизнес логики в сценарии вам **необходимо** [заняться работой над качеством](https://wiki.yandex-team.ru/alice/analytics/newscenarioacceptance/#formirovanieoflajjnkorziniprorabotkalogirovanija).
1. Подключите сервер к Мегамайнду и Бегемоту (в централизованной тестовой среде, или к развернутым вами копиям).
1. Отладьте работу сценария.
1. После того, как сценарий пройдет [приемку](#product-feature), можно начинать [выкатывать сценарий на пользователей](https://wiki.yandex-team.ru/alice/megamind/protocolscenarios/releases/).

Подробная схема и логика взаимодействия компонентов платформы описана в разделе [Архитектура платформы сценариев](architecture.md).

Вопросы можно задавать в [чаты поддержки](faq.md#support) компонент Алисы.

## Приемка сценария в Алисе {#product-feature}

{% note info %}

Процесс приемки, от первой версии сценария до окончательного релиза, может занять примерно столько же времени, сколько непосредственно разработка сценария: учитывайте это при долгосрочном планировании.

{% endnote %}

Несмотря на модульную систему сценариев, для внешних потребителей Алиса остается единым продуктом. Поэтому чтобы запустить сценарий на всех пользователей Алисы, необходимо согласовать его идею и реализацию с ответственными за продукт, а также показать в процессе тестирования, что сценарий положительно влияет на метрики Алисы в целом.

Подробнее об этом процессе — в [продуктовом описании](https://wiki.yandex-team.ru/voicetechnology/dev/analytics/new_scenario_acceptance/) проектирования и приемки сценария.
