# Обучение арабского классификатора интентов

## Верхнеуровневое intro

Для классификации интентов на арабском языке в большинстве случаев используется машиннообученный multilabel классификатор.
Multilabel означает, что запрос после классификации может относиться сразу к нескольким интентам.
Пример -- запрос "останови" может относиться как к остановке музыки, так и остановке будильника или таймера.
Более подробно о [multilabel](https://scikit-learn.org/stable/modules/multiclass.html#multilabel-classification).

В качестве модели в данном классификаторе применяется нейронная сеть LSTM, использующая в качестве признаков векторные представления слов [FastText](https://fasttext.cc/docs/en/crawl-vectors.html).
На выходе сети -- вектор p_i, где p_i -- вероятность принадлежности запроса к i-му интенту.
Получается, что для одновременной классификации всех интентов используется одна модель.
Более подробно -- лучше посмотреть в [код](https://a.yandex-team.ru/arc/trunk/arcadia/alice/nlu/tools/lstm_classifier_trainer).

## Обучение

Кошерный граф обучения обитает в этом [воркфлоу](https://nirvana.yandex-team.ru/flow/c1965498-03c4-46f6-b800-db22095fdd48/96721302-7464-4d9a-8aab-fab5e8a35741).
При каждом новом обучении всегда стоит брать main instance (тот, что с короной), а не клонировать существующие успешные обучения, так как могут быть пофикшены баги.

{% note warning %}

**Убедительная просьба** -- клонируйте граф обучения в свой личный воркфлоу, не используйте воркфлоу с кошерным графом обучения, даже если у вас есть к нему доступ.

{% endnote %}

### Глобальные опции

Помимо стандартных опций -- токенов и MR-аккаунта на YT, где будут сохранены промежуточные результаты обучения, в глобальных опциях присутствуют три важных блока параметров:
1. Настройки сбора датасета: `Arcadia path to dataset info file`, `Revision to checkout dataset info file`, `negative sources`, `negative intent name`, `ignore intents`, `train size`, `val size`.
Более подробно о них в [следующем разделе](#Сбор-датасета), информация **обязательна** к прочтению.
2. Настройки внутреннего процессинга датасета -- с названием `Dataset \(.+\)`.
Обычно их не требуется настраивать, дефолты вполне ок.
3. Гиперпараметры обучения -- с названием `YOPT \(.+\)` и некоторые из `UTIL \(.+\)`.
Дефолты обычно вполне ок, но для душевного спокойствия можно поподбирать их с помощью [YOPT](https://docs.yandex-team.ru/mltools/pulsar/tracking/yopt).
**Note** -- опция pulsar-instance-id для подбора гиперпараметров уже присутствует в графе, ничего дополнительно делать не требуется.

### Сбор датасета

Для сбора обучающего датасета используется кубик `generate intent classification dataset` ([пример](https://nirvana.yandex-team.ru/flow/c1965498-03c4-46f6-b800-db22095fdd48/96721302-7464-4d9a-8aab-fab5e8a35741/graph/FlowchartBlockOperation/code/generate_intent_classification_dataset)).
На его выходах -- train/val/test части, которые будут использованы при обучении.

В качестве данных и таргета используется информация из файла, заданного в опции `Arcadia path to dataset info file`.
На данный момент для арабского используется [этот](https://a.yandex-team.ru/arc/trunk/arcadia/alice/nlu/data/ar/datasets/data.json).
Коротко -- в данном файле для каждого интента задается набор существующих корзинок, которые используются для обучения.
Кубик чекаутит из аркадийного транка файл ревизии, заданной в опции `Revision to checkout dataset info file`.
Если требуется обучить классификатор для новых интентов, убедитесь, что в счекаутенной ревизии присутствует информация по корзинкам с данными для этих интентов.
Также стоит убедиться, что новых интентов не присутствует в списке опции `ignore intents` -- данные для этих интентов не используются в обучении.
Мы стараемся обновлять этот список в кошерном графе по мере сбора данных.

В качестве негативных сэмплов при обучении классификатора используются примеры, относящихся к интентам в опции `negative sources`.
На выходе негативы имеют единственный интент -- заданный в опции `negative intent name`, по-дефолту == `other`.
Запросы, отнесенные в это множество, выступают как универсальные негативные для запросов всех остальных интентов.

Далее полученный датасет бьется на три части train / val / test в пропорциях, задаваемых опциями `train size` и `val size`. `test size` = 1 - `train size` - `val size`.
Стандартные пропорции 60 / 20 / 20 являются рекомендованными к использованию.


{% note info %}

**Для особо любопытных -- как формируется датасет, как происходит сплит и почему таргет не получается битым**

Алгоритм таков:
1. Из файла с мета-информацией про датасеты берутся все интенты, кроме проигнорированных.
Для них берутся все существующие корзинки: dev / accept / kpi;
2. Строится маппинг {запрос -> множество интентов}.
Если интент указан в `negative sources`, то во множество он добавляется как `negative intent name`.
Если по итогу построения маппинга во множестве интентов наряду с `negative intent name` присутствует какой-либо еще интент, то интент `negative intent name` удаляется из этого множества.
3. Берутся все запросы из dev-корзинок и по построенному маппингу для них выставляется таргет, как множество интентов.
4. Стратифицированный сплит на train / val / test.
Берется каждое уникальное множество интентов и запросы, принадлежащие этому множеству.
Запросы и шафлятся и сплитятся на три части.

Почему на первом шаге берутся все корзинки -- dev / accept / kpi?
Для классификации мы должны знать множество интентов, к которому принадлежит запрос.
Бывает так, что в корзинке первого интента запрос попал в dev часть, а в корзинке второго -- в accept.
Тогда, если выставлять таргет для запроса только по dev частям, то получим битый таргет -- запрос на самом деле принадлежит не только первому интенту, но и второму.

Почему таргет не получается битым, когда в `negative sources` присутствуют запросы вполне конкретных интентов?
Запросы, принадлежащие к какому-то конкретному интенту, старательно вычленялись и классифицировались в корзинках, указанных в `negative sources`, и относились в запросы конкретного интента.
Поэтому в конце шага 2 они относятся к позитивам конкретного интента.

{% endnote %}

### Препроцессинг и обучение

После кубика сбора датасета идет его препроцессинг -- уникализация запросов, токенизация, label encoding таргета.
Далее происходит обучение в кубике Train LSTM ([пример](https://nirvana.yandex-team.ru/flow/c1965498-03c4-46f6-b800-db22095fdd48/96721302-7464-4d9a-8aab-fab5e8a35741/graph/FlowchartBlockOperation/code/train_lstm_clf_2)).
На данном этапе в большинстве случаев ничего трогать не требуется.

Для обучения используется запросы из train выборки.
Во время обучения применяется early stopping по метрике accuracy, замеряющейся на val выборке.

Если после обучения что-то пошло не так, может быть полезным для дебага посмотреть в логи обучения -- они прорастают во вкладку Logs кубика Train LSTM.

### Подбор порогов

После обучения модели она применяется на val выборке для подбора порогов бинаризации по каждому интенту.
Это происходит в кубике Find Thresholds ([пример](https://nirvana.yandex-team.ru/flow/c1965498-03c4-46f6-b800-db22095fdd48/96721302-7464-4d9a-8aab-fab5e8a35741/graph/FlowchartBlockOperation/code/find_thresholds)).

На данный момент подбираются три порога по каждому интенту, оптимизируя следующие функционалы качества:
* [F1](https://en.wikipedia.org/wiki/F-score)
* [Youden-index](https://en.wikipedia.org/wiki/Youden%27s_J_statistic)
* G-mean = sqrt(Sensitivity * Specificity)

По опыту последние два почти всегда совпадают и максимизируют recall.
Поэтому для баланса precision и recall далее в графе по-дефолту используется **F1**.

На выходе кубика помимо подобранных порогов есть html-страница с графиками precision-recall и roc-auc.
Не пугайтесь -- она грузится достаточно долго.
Но может быть очень полезна для раздебага.

Затем подобранные пороги применяются на предсказаниях модели на val и test выборке.
Это происходит в кубиках Apply Thresholds.

### Оценка качества

Метрики на test-выборке подсчитываются в кубике Calculate Metrics ([пример](https://nirvana.yandex-team.ru/flow/c1965498-03c4-46f6-b800-db22095fdd48/96721302-7464-4d9a-8aab-fab5e8a35741/graph/FlowchartBlockOperation/code/Calculate_Metrics)) и прорастают в пульсар.
Ссылку на инстанс пульсара можно найти в выходах графа ([пример](https://nirvana.yandex-team.ru/flow/c1965498-03c4-46f6-b800-db22095fdd48/96721302-7464-4d9a-8aab-fab5e8a35741/graph/FlowchartEndpoint/c4c84eac-c297-43e0-bbef-a21cb7a45559)).

Если обучается классификатор для нового интента, то рекомендуется внимательно смотреть на метрики для нового интента, метрики смежних интентов и интента `other`.

Также в кубиках Mispreds выгружается ошибки классификатора по каждому из интентов.
Стоит грепнуть и посмотреть на false positive и false negative по новому интенту.
Mispreds на test выборке прорастают в выходы графа ([пример](https://nirvana.yandex-team.ru/flow/c1965498-03c4-46f6-b800-db22095fdd48/96721302-7464-4d9a-8aab-fab5e8a35741/graph/FlowchartEndpoint/ffa664fc-e6f9-4e2f-a735-426bff0403e3)).

## Выкатка в production

Если качество полученного классификатора устраивает, то надо покатить его в прод.

Для этого требуется склонировать успешный граф обучения и проставить галочку в глобальных опциях `UTIL (upload to sandbox)` (в самом низу глобальных опций).
При запуске рекомендуется указывать копировать результаты всех блоков склонированного графа, так как кэш нирваны может не сработать и тогда классификатор будет обучаться заново.

В результате будет получен id-шник ресурса в выходах графа ([пример](https://nirvana.yandex-team.ru/flow/c1965498-03c4-46f6-b800-db22095fdd48/96721302-7464-4d9a-8aab-fab5e8a35741/graph/FlowchartEndpoint/1bff0052-4ef6-4696-af82-9bb924ed124f)).

Далее требуется руками создать ревью со следующими изменениями:
* полученный id-шник вписать [сюда](https://a.yandex-team.ru/arcadia/alice/nlu/data/ar/models/alice_multi_intent_classifier/data.inc?rev=r9525172#L5)
* добавить описания фреймов для новых интентов в [описание фреймов](https://a.yandex-team.ru/arc/trunk/arcadia/alice/nlu/data/ar/config/frames.pb.txt).
Какая-то документация по [агрегатору фреймов](https://docs.yandex-team.ru/alice-scenarios/nlu/frame_aggregator), но в целом можно взять по-примеру уже готовых интентов.
Традиционно описание выглядит так:
```
{
    Name: "alice.scenarios.get_weather_wind"
    Rules: [
      {
        Classifier: {
          Source: "AliceMultiIntentClassifier"
          Model: "multilabel_intent_classifier"
          Threshold: 0.6177635192871094
        }
        Tagger: {
          Source: "AliceTagger"
        }
      }
    ]
}
```
Если для интента не требуется теггер, то секцию `Tagger` нужно опустить:
```
{
    Name: "personal_assistant.scenarios.timer_stop_playing"
    Rules: [
      {
        Classifier: {
          Source: "AliceMultiIntentClassifier"
          Model: "multilabel_intent_classifier"
          Threshold: 0.6177635192871094
        }
      }
    ]
}
```
* проставить новые пороги для существующих фреймов.
Можно сделать руками, а можно воспользоваться [таким скриптом](https://a.yandex-team.ru/arcadia/junk/vl-trifonov/update_thresholds.ipynb?from_pr=2643133&rev=r9591588).
Стоит обратить внимание на те интенты, для которых порог обновлен не был, так как скрипт наколеночный.

В описание ревью также необходимо прикрепить ссылку на граф обучения.
Перед этим стоит клонировать граф обучения с рекурсивным клонированием результатов и оставить пустым поле `Results Time To Live (days)` в Config-е инстанса.
Это требуется для сохранения результатов обучения.
Ссылку на полученный граф оставляем в description ревью.

## Notes

1. Что-то полезное можно получить из [документации](https://docs.yandex-team.ru/alice-scenarios/nlu/intents/lstm) для аналогичного графа классификации интентов на русском языке.
2. По всем вопросам можно обращаться в [чат поддержки NLU](https://t.me/+DJryz0GP71djN2Ri).
Если там не ответили, то к [@vl-trifonov](https://staff.yandex-team.ru/vl-trifonov).
