# Агрегатор фреймов

В NLU Алисы можно использовать разные технологии классификации и тегирования запросов.
В основном эти технологии живут в Бегемоте в виде так называемых правил Бегемота:
Granet, AliceBinaryIntentClassifier, AliceTagger и так далее. Ответы этих правил содержат
результаты классификации и/или тегирования запроса. Из этих ответов формируется единый
список сработавших (сматчившихся) фреймов и их слотов. Делает это агрегатор фреймов -
AliceParsedFrames.

Обычно фрейм формируется автоматически, без каких либо дополнительных настроек.
Например формы, сматчившиеся Гранетом автоматически превращаются во фреймы.

Но в некоторых случаях требуется указать особые правила формирования фрейма.
Например, в качестве классификатора использовать AliceBinaryIntentClassifier,
а в качестве теггера - AliceTagger или Granet. Эти правила описываются в конфиге
[alice/nlu/data/ru/config/frames.pb.txt](https://a.yandex-team.ru/arc/trunk/arcadia/alice/nlu/data/ru/config/frames.pb.txt)

Алгоритм обработки фреймов выглядит так:
- Предобработка конфига:
  - Объединяются конфиги из быстрых и медленных данных.
  - Из конфига удаляются секции, не удовлетворяющие переданным экспериментам.
- Фреймы, описанные в конфиге, обрабатываются в соответствии с правилами, описанными в конфиге
- Фреймы, не описанные в конфиге, обрабатываются встроенными правилами.

## Предобработка конфига

### Объединение конфигов {#merging}

Сначала объединяются конфиги из медленных и быстрых данных. То есть версия `frames.pb.txt` на момент
релиза Бегемота и свежая версия `frames.pb.txt`, которая раскатывается на инстансы Бегемота каждые 30 минут.

Примечание: сейчас выкатка быстрых данных временно приостановлена, но их можно выкатить в ручном режиме.

По умолчанию используется только конфиг из медленных данных. Быстрые данные доступны под экспериментами:
- `bg_fresh_alice` - использовать только быстрые данные.
- `bg_fresh_alice_form=my_form` - использовать быстрые данные для фрейма `my_form`
- `bg_fresh_alice_prefix=my_prefix` - использовать быстрые данные для фреймов, начинающихся с `my_prefix`.

Дополнительно подмешивается конфиг, переданный с помощью эксперимента вида
`bg_frame_aggregator_config_patch_base64=part_of_my_config_encoded_in_base64`.
Этот конфиг дописывается в начало общего конфига.

### Обработка экспериментов {#experiments}

Некоторые участки конфига можно прятать под эксперимент. Для этого у секций `Frames` и `Rules`
есть поле `Experiments`. В нём описываются условия, при которых эта секция видна. Пример:

```
  {
    Name: "alice.my_frame"
    Experiments: ["bg_flag1", "bg_flag2", "!bg_flag3"]
    // ...
  }
```

В этом примере описание фрейма `alice.my_frame` будет видно, только если переданы эксперименты
`bg_flag1` и `bg_flag2` и не передан эксперимент `bg_flag3`. Иначе вся секция конфига будет удалена.

Обратите внимание, если в результате обработки эксперимента из конфига были удалены все описания
какого-то фрейма, то для него будут работать встроенные правила обработки фреймов. Чтобы это
не происходило, можно добавить второе описание того же самого фрейма:

```
  {
    Name: "alice.my_frame"
    Experiments: ["bg_my_flag"]
    // ...
  }
  {
    Name: "alice.my_frame"
    Experiments: ["!bg_my_flag"]
    // ...
  }
```

## Структура конфига

Корень конфига:
- `Language` - язык, для которого применяется конфиг. Язык необходимо указывать, если вы передаёте
  патч конфига с помощью эксперимента `bg_frame_aggregator_config_patch_base64`.
- `Frames` - список описаний фреймов.

Описание фрейма (элемент массива `Frames`):
- `Name` - имя фрейма.
- `Experiments` - флаги экспериментов, подробности в [Обработка экспериментов](#experiments).
- `Rules` - список правил формирования фрейма. Исполняется сверху вниз. Как только срабатывает
  одно из правил, итерация прекращается.

Правило формирования фрейма (элемент массива `Rules`):
- `Experiments` - флаги экспериментов, подробности в [Обработка экспериментов](#experiments).
- `Classifier` - классификатор, по которому срабатывает это правило.
- `Tagger` - теггер, из которого берутся слоты, если сработало это правило.

Секция Classifier:
- `Source` - имя подсистемы классификации (см. ниже).
- `Model` - используется в некоторых мульти-интентных классификаторах.
- `Intent` - название модели бинарного классификатора интента. Если не указано, используется название
  фрейма (поле `Name`).
- `Threshold` - порог для бинарного классификатора.
- `Confidence` - качество, которое будет записано во фрейм. По умолчанию во фрейм пишется качество,
  полученное от классификатора. С помощью этого поля можно задать фиксированное качество фрейма.
  Все гранетные фреймы имеют качество 1. Если вы хотите, чтобы срабатывания вашего бинарного классификатора
  выглядели для Мегамайнда как срабатывания гранета, укажите здесь 1.
- `IsNegative` - не создавать фрейм, если сработало это правило. В этом случае итерация массива `Rules`
  прекращается.

Секция Tagger:
- `Source` - имя подсистемы тегирования (см. ниже).
- `Intent` - название модели. Если не указано, используется название фрейма (поле `Name`).

Возможные значения поля `Source`: `Always`, `AliceActionRecognizer`,  `AliceBinaryIntentClassifier`,
`AliceFixlist`, `AliceFrameFiller`, `AliceMultiIntentClassifier`, `AliceScenariosWordLstm`,
`AliceTolokaWordLstm`, `AliceTagger`, `AliceTrivialTagger`, `AliceWizDetection`, `Granet`.

Некоторые из этих подсистем являются теггерами, некоторые - классификаторами, а некоторые и тем и другим
(например Granet).

## Встроенные правила обработки фрейма

TODO
