# Частые вопросы о Гранете

### Как обрабатывать запрос с произвольным текстом (название песни, товара и т. д.)? {#random-text}

**Пример проблемы**

Хочется уметь отличать такое:

```
'телефон самсунг эс десять'(request) цена
```

от такого:

```
'тут'(request) цена
'старый оскол потапыч меню и'(request) цена
```

**Краткий ответ**

Рекомендуемый способ работы с нечеткими слотами - сбор датасета и обучение tagger'а.

В granet'е такие вещи можно обрабатывать только костыльно: с помощью `.*` и фиксированного списка топовых фраз (см. в
подробном ответе). Но мы работаем над тем, чтобы можно было создавать свои ML-сущности, обучающиеся по спискам примеров
(можно проконсультироваться с [@the0](https://staff.yandex-team.ru/the0).

**Подробный ответ**

К таким слотам применяется следующий подход. Без похода в сценарий мы не можем быть уверены, что какое-то
словосочетание не относится к нужной сценарию сущности (песня, фильм, товар, точка назначения и т. п.). И никогда не
будем уверены, так как в общем случае это бизнес-логика. Которая к тому же часто зависит от контекста запроса.
Например, музыкальных предпочтений пользователя, истории запросов и т. п. То есть в любом случае содержимое такого
слота нужно отправлять в бэкенд сценария на оценку.

При таком подходе задача NLU заключается в следующем:

1. Правильно найти этот слот. Здесь пока приходится полагаться на:
   - `.*` в сочетании с фильтрацией мусорных слов (filler),
   - списки популярных значений слота,
   - а также, если надо, списки типичных неправильных значений слота (добавляются с директивой `%negative`).

2. По возможности найти запросы, которые точно относятся к этому интенту. Для этого интент можно разбить на две формы:
   - Форма с высоким precision (без false positive) — слот описывается с помощью списка известных/популярных значений,
без использования `.*`.
   - Форма с высоким recall (без false negative) — слот описывается с помощью `.*`. Срабатывания этой формы
дооцениваются в бэкенде сценария или постклассификаторе.

Вот, например, как это делается для названия внешнего навыка. Интент разбит на 3 гранетные формы:
- [alice.external_skill_fixed_activate](https://a.yandex-team.ru/arc/trunk/arcadia/alice/nlu/data/ru/granet/external_skills/activate_with_fixed_skill.grnt) —
максимальный precision со списком известных навыков,
- [alice.external_skill_activate](https://a.yandex-team.ru/arc/trunk/arcadia/alice/nlu/data/ru/granet/external_skills/activate.grnt) —
высокий precision с `.*`,
- [alice.external_skill_activate_weak](https://a.yandex-team.ru/arc/trunk/arcadia/alice/nlu/data/ru/granet/external_skills/activate_weak.grnt) —
максимальный recall.

Какие есть/планируются альтернативы `.*`:

1. Списки топовых значений (упомянутый выше). Этот список можно сделать большим, до миллиона строк. Такой список
желательно добавлять через директиву `%include_raw`, чтобы компилятор обрабатывал его как набор строк, а не гранетных
выражений. Вот так:
   ```
   $HardcodedGoods:
       %include_raw "market/goods.txt"
   ```
2. User Entities или NLU Hints — сущности, которые ищутся по словарикам, переданным в Бегемот вместе с запросом. Можно
использовать для выделения в запросе navigator favorites, контактов из телефонной книги, списка фильмов на экране и т.п.
3. Планируется сделать искалку сущностей, которые описывались бы несколькими положительными и отрицательными примерами.
Как раз для товаров, точек назначения, названий песен и т.п.
4. Можно попробовать найти в поисковом NER искалку нужной вам сущности. У них богатый NER, он как раз живёт в Бегемоте.
Вполне вероятно, что нужная вам сущность найдётся. Оформить её в виде сущности, доступной Гранету (это просто,
[samoylovboris@](https://staff.yandex-team.ru/samoylovboris) может помочь), и потом поддерживать эту искалку (это не
просто).

### Как прогнать Гранет на своём датасете? {#process-custom-dataset}

[Подробная инструкция](custom-datasets.md#process-custom-dataset).

### Как спрятать под флаг эксперимента свои изменения в грамматиках? {#grammar-exp-flag}

[Подробная инструкция](alice-test.md#experiment).


### Как одновременно вносить необходимые правки и в Бегемот, и в Мегамайнд, и в свой сценарий? {#transition}

При добавлении сценария приходится вносить правки и в Бегемот, и в Мегамайнд, и в свой сценарий. К тому, как переживать
переходный период, когда правки в одном сервисе выкатились, а в другом — ещё нет, есть разные подходы:
[DIALOG-5840](https://st.yandex-team.ru/DIALOG-5840)

Конкретные инструменты описаны в комментариях:

- [Экспериментальные формы](https://st.yandex-team.ru/DIALOG-5840#5dfb639c48984024cb7c093e)
- [Версии компонент Бегемота](https://st.yandex-team.ru/DIALOG-5840#5dfb5cb10f8ae6267c15c46a)


### Аркадийные тесты не видят .tsv-файл

Пример полного текста сообщения об ошибке:

```
(TFileError) (No such file or directory) util/system/file.cpp:799: can't open "https://proxy.sandbox.yandex-team.ru/1438823482/build-release/alice.tar/alice/nlu/data/ru/test/granet/medium/target/my_form.tsv" with mode RdOnly|Seq (0x00000028)
```

**Решение**: скорее всего, вы забыли добавить `my_form.tsv` в
[alice/nlu/data/ru/test/granet/medium/target/ya.make](https://a.yandex-team.ru/arc/trunk/arcadia/alice/nlu/data/ru/test/granet/medium/target/ya.make).

### Как направить granet в другой Бегемот? {#own-begemot}

При обновлении сущностей утилита granet ходит в хамстер Бегемота: `hamzard.yandex.net:8891/wizard`. Он доступен с ноутбуков, но может быть [недоступен для некоторых дев-машин](https://st.yandex-team.ru/DIALOG-5620). Если не пускают, закажите дырку в панчере. Также есть переменная `GRANET_BEGEMOT`, с помощью которой можно направить granet в другой Бегемот. Пример: `export GRANET_BEGEMOT=reqwizard.yandex.net:8891`.
