# Granet

Granet позволяет извлечь данные из реплики пользователя с помощью конечного набора правил разбора. Правила описываются в виде грамматик, которые могут состоять из словарей фраз, регулярных выражений, и найденных именованных сущностей (числа, даты, адреса и т. п.).

Granet позволяет лаконично описывать достаточно вариативные запросы благодаря интеллектуальной предобработке текста с помощью различных нормализаций и поиска несущественных участков. При этом парсер работает сразу на всем наборе получившихся переформулировок реплики.

{% note info %}

Важно понимать, что основное ограничение грамматик в их полноте, за которой автор грамматики должен следить сам. Для улучшения полноты лучше писать правила как код: переиспользовать общие проверенные сущности, определенные в [common](https://a.yandex-team.ru/arc/trunk/arcadia/alice/nlu/data/ru/granet/common), а также расширять их, или добавлять туда новые по необходимости.

{% endnote %}


## Быстро попробовать

Посмотреть на то, как грамматика работает на историческом массиве запросов к Алисе, можно с помощью сервиса [Гранет Ферштейн](https://verstehen.n.yandex-team.ru/granet). Чтобы применить грамматику к массиву запросов, нажмите кнопку **Run**.

Сервис пока работает только для русского языка. Датесеты и грамматики обновляются в ручном режиме.


## Детальнее

Чтобы прорастить грамматику в продакшен, нужно:

* разобраться с [синтаксическими возможностями](syntax.md) языка описания грамматик;
* закоммитить [код в Аркадию](add-intent.md) вместе с тестами;
* протестировать [Алису с подключенной грамматикой](alice-test.md).

Часто задаваемые вопросы: [FAQ](faq.md)
