# Тестовые пакеты Гранета

Тестовый пакет гранета это папка, которая содержит:
- файл config.json с описанием тестов,
- tsv-датасеты для этих тестов,
- скрипты для более удобного запуска утилиты granet с этим пакетом.

Пимеры тестовых пакетов:
- [alice/nlu/data/ru/test/granet/small](https://a.yandex-team.ru/arc/trunk/arcadia/alice/nlu/data/ru/test/granet/small)
- [alice/nlu/data/ru/test/granet/medium](https://a.yandex-team.ru/arc/trunk/arcadia/alice/nlu/data/ru/test/granet/medium)
- [alice/nlu/data/ru/test/granet/custom](https://a.yandex-team.ru/arc/trunk/arcadia/alice/nlu/data/ru/test/granet/custom)

Тестовые пакеты хранятся в Аркадии. При этом небольшие датасеты комитятся как есть, а большие (больше 20 тысяч примеров) загружаются в сэндбокс.

## Структура конфига

### Корень

| Поле                  | Тип       |Описание                                                                                                       |
| --------------------- | --------- | ------------------------------------------------------------------------------------------------------------- |
| language              | string    | Язык.                                                                                                         |
| paskills              | bool      | Режим для внешних навыков. Синтаксис грамматик для внешних навыков немного отличается от грамматик NLU Алисы. |
| wizard                | bool      | Режим для колдунщиков.                                                                                        |
| sample_cache_size     | int       | Размер кэша сэмплов. В штуках. Значение по умолчанию: 40000.                                                  |
| dataset_cache_size    | int       | Размер кэша загруженных датасетов. В штуках. Значение по умолчанию: 20.                                       |
| default               | dict      | Дефолтные значения полей для конфигов тестовых прогонов (элемнтов массива cases).                             |
| cases                 | array     | Конфиги тестовых прогонов.                                                                                    |
| suites                | array     | Наборы тестовых прогонов с отдельной секцией default на каждый набор.                                         |

### Элементы секции suites {#suites}

| Поле                  | Тип       |Описание                                                                                                       |
| --------------------- | --------- | ------------------------------------------------------------------------------------------------------------- |
| default               | dict      | Дефолтные значения полей для конфигов тестовых прогонов (элемнтов массива cases).                             |
| cases                 | array     | Конфиги тестовых прогонов.                                                                                    |

### Конфиг тестового прогона {#case}

Конфиги тестовых прогонов содержатся в массиве cases, а также в секции default, в которую выносятся одинаковые для всех прогонов параметры.

| Поле                      | Тип       |Описание                                                                                                               |
| ------------------------- | --------- | --------------------------------------------------------------------------------------------------------------------- |
| comment                   | string    | Комментарий к тестовому прогону.                                                                                      |
| name                      | string    | Краткое имя тестового прогона. Если не указано, в качестве имени берётся значение поля form, entity или user_entity.  |
| form                      | string    | Имя тестируемой гранетной формы.                                                                                      |
| entity                    | string    | Имя тестируемой гранетной сущности.                                                                                   |
| verbose                   | bool      | Печатать краткую информацию для каждого ошибочного примера.                                                           |
| debug                     | bool      | Печатать отладочную информацию для каждого ошибочного примера: список сущностей, дерево разбора, наложения нетерминалов и тому подобное. |
| disable                   | bool      | Не запускать этот тестовый прогон.                                                                                    |
| disable_auto_test         | bool      | Не запускать этот тестовый прогон в прекоммитных тестах. Тест запускается только явным вызовом утилиты granet (в частности, через `test.sh` и `test_all.sh`)                              |
| base                      | string    | Путь к базовому датасету. Обычно это общий большой датасет с заранее собранными сущностями. Если указан, то датасеты positive, negative и ignore описывают подмножества в этом датасете. |
| positive          | string или array  | Путь к tsv-датасету с положительными примерами.                                                                       |
| negative          | string или array  | Путь к tsv-датасету с отрицательными примерами.                                                                       |
| ignore            | string или array  | Путь к tsv-датасету с примерами, которые нужно убрать из отрицательных и положительных примеров. Предполагалось, что в этих датасетах будут храниться известные ошибочные примеры, для которых пока не надо запускать тесты. Но эта идея так и не развилась. |
| negative_from_base_count  | int       | Набрать указанное количество отрицательных примеров из множества base минус positive, negative, ignore.               |
| negative_from_base_ratio  | float     | Набрать указанную долю отрицательных примеров из множества base минус positive, negative, ignore.                     |
| canonization_limit        | int       | Выдавать ошибку, если в результате канонизации получился датасет, содержащий больше указанного количества сэмплов.    |
| consider_slots            | bool      | Канонизировать расположение слотов `включи 'первый'(index)`. По умолчанию true.                                       |
| consider_slot_values      | bool      | Канонизировать расположение и значения слотов: `включи 'первый'(index:1)`. По умолчанию false.                        |
| consider_slot_types       | bool      | Канонизировать расположение, значения и типы слотов: `включи 'первый'(index/sys.num)`. Совместно с consider_slot_values получается такой вывод: `включи 'первый'(index/sys.num:1)`. По умолчанию false. |
| consider_slot_value_variants | bool      | Канонизировать список всех гипотез значений слота: `включи 'первый'(index:1;first_channel)`. По умолчанию false.      |
| print_slots               | bool      | Канонизировать расположение слотов `включи 'первый'(index)` и вывести результат в консоль. По умолчанию false.                                       |
| print_slot_values         | bool      | Канонизировать расположение и значения слотов: `включи 'первый'(index:1)` и вывести результат в консоль. По умолчанию false.                        |
| print_slot_types          | bool      | Канонизировать расположение, значения и типы слотов: `включи 'первый'(index/sys.num)` и вывести результат в консоль. Совместно с print_slot_values получается такой вывод: `включи 'первый'(index/sys.num:1)`. По умолчанию false. |
| print_slot_value_variants | bool      | Канонизировать список всех гипотез значений слота: `включи 'первый'(index:1;first_channel)` и вывести результат в консоль. По умолчанию false.      |
| collect_blockers          | bool      | Канонизировать список блокирующих парсинг фраз. `STATE_LIMIT` выставляется в случае если сэмпл не сматчился из-за обрезания стейтов. `WEAK_TEXT` - если парсер сматчился до конца фразы, но root всё равно не наложился, т.е. не наложился какой-то обязательный нетерминал. По умолчанию false. |
| compare_slots_by_top      | bool      | По умолчанию true. Значение false используется совместно с print_slot_value_variants. TODO: написать, что это.        |
| keep_weight               | bool      | Cохранять колонку weight в результаты канонизации и тестирования (если эта колонка была в исходном датасете). По умолчанию false. |
| keep_reqid                | bool      | Cохранять колонку reqid (аналогично weight).                                                                          |
| keep_wizextra             | bool      | Cохранять колонку wizextra (аналогично weight).                                                                       |
| keep_mock                 | bool      | Cохранять колонку mock (аналогично weight).                                                                           |
| keep_embeddings           | bool      | Cохранять колонку embeddings (аналогично weight).                                                                     |
| keep_context              | bool      | Cохранять колонку context (аналогично weight).                                                                        |
| keep_extra                | bool      | Сохранять все остальные колонки, не перечисленные выше.                                                               |
| enable_tsv_entities       | bool      | Сущности, необходимые гранету для обработки примеров, хранятся в датасетах (в колонке mock). По умолчанию true.       |
| enable_online_entities    | bool      | Пытаться ходить в Бегемот за сущностями для гранета. По умолчанию false.                                              |
| enable_empty_entities     | bool      | Не выдавать ошибку, если не удалось найти сущности для примера (ни в датасете, ни походом в Бегемот). Использовать пустой список сущностей для таких примеров. По умолчанию false. |
| user_entity               | string    | Устарело. Имя сущности для тестирования механизма user_entity_finder.                                                 |
| context_storage           | string    | Устарело. Путь к контекстам тестовых примеров. По этим контекстами генерируются словари для user_entity_finder.       |

Пути указываются относительно папки, в которой лежит файл конфига.

К строковым значениям полей применяется простенький препроцессинг:
- `{name}` заменяется на значение поля name.
- `{form}` заменяется на значение поля form.
- `{form_short_name}` заменяется на значение поля form с отброшенным префиксом `personal_assistant.`.
- `{entity}` заменяется на значение поля entity.
- `{user_entity}` заменяется на значение поля user_entity.

Препроцессинг сделан, чтобы в секции default можно было описывать почти все поля. Не уверен, что это хорошая идея. Конфиг получается более лаконичный, но менее понятный.
