# Beggins
Это набор технологий который позволяет собирать данные и обучать бинарные классификаторы для Алисы.

## Подготовка данных
Необходимо собрать качественный датасет. По возможности взгляните самостоятельно на несколько вхождений, и если что-то не так - необходимо пересобрать/переразметить данные.
Признаками плохого датасета являются: 
    - Наличие примеров позитивов в негативах и наоборот.
    - Низкая вариативность датасета: большинство вхождений образованы добавлением разных префиксов (Алиса, помощник, привет, и т.д.).
Важно понимать, что качество данных имеет **ключевую** роль в качестве классификатора.

### Сбор данных
1. Соберите [AToM корзинку](https://domains.yandex-team.ru/domain/aliceofflinequality/start/alice_top_of_mind_basket). Проверьте что галочка "Собирать ли ещё корзинку по логам?" включена. Если вы подозреваете пересечения вашего нового интента с другими существующими запросами или интентами, не стесняйтесь заполнить поля `regexp` и `intents`, они помогут автоматике собрать более репрезентативную корзинку.
2. На выходе у графа будут три корзины: dev, accept, kpi. Dev корзинку нужно использовать для обучения, accept для приемки и подбора порога, в kpi мы не заглядываем, она нужна для дальнейшего мониторинга работы шортката в продакшене. Такое разделение на три корзины нужно, чтобы не выкатывать в продакшен [переобученные](https://ru.wikipedia.org/wiki/Переобучение) модели.

## Обучение классификатора
1. Чтобы начать обучать классификаторы, необходимо получить роль разработчика в ABC [Разработка сценариев Алисы](https://abc.yandex-team.ru/services/bassdevelopers). Это даст вам доступ к ряду сущностей, которые мы используем в графах. 
2. Склонируйте граф [repeatable training](https://nirvana.yandex-team.ru/flow/d1b12ee3-19dd-471f-a103-0cb2ecb395c8/)
3. Дайте read права роботу `robot-beggins` на ваш склонированный граф. Лучше давать права на всю рабочую директорию, чтобы избежать повторения таких действий. Вот последовательность действий: 
    - Тыкните на граф или директорию, на которые хотите дать права
    - В выпавшем меню будет кнопка, на которой находятся коронка и надпись Owner, кликните на нее 
    - Нажмите `Set permissions` и дайте `robot-beggins` права уровня `Reader`
4. Заполните параметры графа:
    - **Глобальные опции**
        - `model_name` -- название вашего классификатора в `snake_case`. Например, `throw dice`
        - `mr_account` -- имя раздела в *YT* вида `//home/<mr_account>`. Например, `alice-dev`
        - `st_ticket ` -- тикет, посвященный разработке этого сценария. Например, `MEGAMIND-1234`
        - `week` -- дата понедельника недели, которая будет использована при подсчете матчей на недельных логах, стоит оставить дефолт: `latest`
        - `timestamp` -- дата и время, необходимые для работы кеша нирваны, следует выбрать текущий день
        - **Токены**, [тут](https://wiki.yandex-team.ru/market/analytics/stackoverflow-analitiki-marketa/yt/gde-vzjat-token-dlja-yt/) можно посмотреть, где их брать. 
            - `yt_token` -- личный токен для *YT*
            - `yql_token` -- личный токен для *YQL*
        - **Для Толоки** -- опции для классификации Толоки, есть два пути:
            - Ссылка на AToM:
                - `tom_creation_url` -- ссылка на граф по сбору AToM'а, откуда будут скопированы эти параметры 
            - Задать параметры явно: 
                - `task_question` -- вопрос для толокеру
                - `project_instruction` -- инструкция для толокера
                - `positives` -- позитивные ханипоты для толокера
                - `negatives` -- негативные ханипоты для толокера
            - Эти методы можно комбинировать, приоритет будет у явного подхода. 
    - **Описание данных**
       Есть два способа описать данные: конфиг манифеста или входы для таблиц кубика `train binary classifier`. Данные способы можно комбинировать или использовать по отдельности.
        - **Manifest**
        Подробная информация о минифесте представлена в [README.md](https://a.yandex-team.ru/arc_vcs/alice/beggins/cmd/manifestator/README.md). В общем случае необходимо подставить конфиг в опцию кубика `get manifest`.
        *Пример*
        ```yaml
        random_seed: 42
        data:
          train:
            sources:
              - type: yt
                table: '//home/alice-ue2e/top_of_mind_for_new_scenarios/baskets/ALICESHORTCUT-47__baibik/basket_dev_50947'  # ссылка на dev AToM
                parser:
                  type: analytics_basket_parser  # специальный парсер для таблиц вида AToM(text и is_negative_query)
                  source: 'dev atom'
          accept:
            sources:
              - type: yt
                table: '//home/alice-ue2e/top_of_mind_for_new_scenarios/baskets/ALICESHORTCUT-47__baibik/basket_accept_50947'  # ссылка на accept AToM
                parser:
                  type: analytics_basket_parser  # специальный парсер для таблиц вида AToM(text и is_negative_query)
                  source: 'accept atom'
        ```
        Также манифест поддерживает взятие данных из Датасетницы:
        ```yaml
        # case 1
        pulsar:
            link: https://pulsar.yandex-team.ru/datasets/f3d91985-0e1d-4ea8-a461-fdf6c3af4319?version=1

        # case 2
        pulsar:
            link: https://pulsar.yandex-team.ru/datasets/f3d91985-0e1d-4ea8-a461-fdf6c3af4319
            version: 1

        # case 3
        pulsar:
            uid: f3d91985-0e1d-4ea8-a461-fdf6c3af4319
            version: 1

        # case 4
        pulsar:
            alias: phone_assistant
            version: 1
        ```
        - **Nirvana**
        У кубика `train binary classifier` есть два входа: `train` и `accept`. Данные входы принимают таблицы со схемой: (`text: String`,  `target: Int32`(`0` -- негатив, `1` -- позитив), `source: String?`). 
5. Запустите обучение и оцените качество. 
    - **Как проходит обучение**
        На данный момент обучение проходит в несколько итераций. В целом, процесс выглядит так:
        1. На указанном датасете обучаем первый классификатор.
        2. При помощи кубика `negatives sampler` вычленяем негативы из матчей на годовых логах и доливаем их в обучение. 
        3. С новым датасетом запускаем вторую итерацию обучения.
    - **Оценка полученных результатов**
      После обучения в тикете будет html-отчет, посмотрите на следующие секции:
        - `Срабатывания на недельных/годовых логах` последней итерации обучения. Это срабатывания нашего классификатора на недельных или годовых логах. Для интента которого никогда не было в потоке нормальным является не больше 700 ложно положительных примеров на недельных логах. На годовых логах стоит обращать внимание на то в каких интентах больше всего ложно-положительных срабатываний. Посмотрев глазами на запросы, скорее всего будет понятно как доработать инструкцию для толоки чтобы собрать больше полезных данных (возвращайтесь на пункт сбор данных).
        - Посмотрите разделы `Метрики` и `Подбор порога`. Если полнота кажется слишком низкой, можно опопробовать поменять порог классификатора ориентируясь на графики из раздела `Подбор порога`.
        - Если ничего не помогает создавайте тикет в https://st.yandex-team.ru/BEGGINSSUP/add постараемся помочь
6. Если результаты соответствуют критериям приемки, то модель можно катить в прод! На выходе `train binary classifier` есть выход `commit draft`. Содержимое представляет собой инструкцию, что куда коммитить.

### Получились плохие результаты? 
1. Первое, что нужно сделать, это провалидировать данные для обучения. 
    * Убедитесь в корректности инструкции и ханипотов, приложенных к ней. Часто бывает, что инструкция не соответствует требованиям заказчика: либо не покрывает ключевые запросы, либо содержит ложные позитивные примеры. Поэтому **важно**, чтобы инструкция была сделана ответственно. Хорошо, если ее будет делать заказчик, или хотя бы она будет согласована через него. 
1. Изучите отчет как написано выше в разделе **Оценка полученных результатов**
1. Также можно долить в обучение произвольные запросы с потока, предварительно пропустив их через классификацию Толоки. В этом вам также поможет кубик [negatives sampler](https://nirvana.yandex-team.ru/flow/d2143f77-9620-4035-9acc-62a4a3529548).

Важное замечание: не советуется доливать слишком много негативов в обучение, так как датасет должен быть сбалансированным. Идеальное соотношение позитивов и негативов это `50/50`

## Включение

Надо закоммитить модель.
Далее описаны варианты по добавлению классификатора.

{% note info %}

 В графе обучения есть выход `commit draft` представлены шаблоны кода, необходимые для добавления классификатора. Ими удобно воспользоваться, чтобы не ошибиться в названиях и числах.

{% endnote %}

В архитектуре фреймов сущности классификаторов и фреймов разделены. Например, один классификатор может быть использован для разбора разных фреймов.

Поэтому первым делом необходимо добавить модель в ресурсы Бегемота.

Скопируйте код из частей для файла `data.inc` в выходе `commit draft` кубика обучения и добавьте в [data.inc](https://a.yandex-team.ru/arc_vcs/alice/nlu/data/ru/models/alice_binary_intent_classifier/data.inc).


### Добавление фрейма без разбора слотов
1. В файл [frames.pb.txt](https://a.yandex-team.ru/arc_vcs/alice/nlu/data/ru/config/frames.pb.txt) необходимо добавить следующее вхождение:
   ```yaml
    Frames: [
     ..., {
        Name: "<название вашего фрейма>"
        Experiments: ["bg_beggins_<название вашего фрейма>"]
        Rules: [{
            Classifier: {
                Source: "AliceBinaryIntentClassifier"
                Intent: "<название модели из data.inc>"
                Threshold: <порог>
                Confidence: 1
            }
            Tagger: {
                Source: "Always"
            }
        }]
    }]
   ```



{% note warning %}

Не используйте теггеры без суффикса `.tagger`. В случае гранета это может привести к ложным срабатываям.

{% endnote %}


### Добавление фрейма с фиксированным разбором
1. В файл [trivial_tagger.json](https://a.yandex-team.ru/arc_vcs/alice/nlu/data/ru/config/trivial_tagger.json) необходимо добваить frame вида:
   ```json
   {
     "language": "ru",
     "frames": [
        ...,
        {
          "name": "<название вашего фрейма>.tagger",
          "slots": [] # перечислить нужные слоты
        }
      ]
   }
   ```
2. В файл [frames.pb.txt](https://a.yandex-team.ru/arc_vcs/alice/nlu/data/ru/config/frames.pb.txt) необходимо добавить следующее вхождение:
   ```yaml
    Frames: [
     ..., {
        Name: "<название вашего фрейма>"
        Experiments: ["bg_beggins_<название вашего фрейма>"]
        Rules: [{
            Classifier: {
                Source: "AliceBinaryIntentClassifier"
                Intent: "<название модели из data.inc>"
                Threshold: <порог>
                Confidence: 1
            }
            Tagger: {
                Source: "AliceTrivialTagger"
                Intent: "<название вашего фрейма>.tagger"
            }
        }]
    }]
   ```

### Добавление фрейма с гранетным разбором
1. Добавьте фрейм по [инструкции](https://docs.yandex-team.ru/alice-scenarios/nlu/granet/add-intent) с именем `<название вашего фрейма>.tagger`.
2. В файл [frames.pb.txt](https://a.yandex-team.ru/arc_vcs/alice/nlu/data/ru/config/frames.pb.txt) необходимо добавить следующее вхождение:
   ```yaml
    Frames: [
     ..., {
        Name: "<название вашего фрейма>"
        Experiments: ["bg_beggins_<название вашего фрейма>"]
        Rules: [{
            Classifier: {
                Source: "AliceBinaryIntentClassifier"
                Intent: "<название модели из data.inc>"
                Threshold: <порог>
                Confidence: 1
            }
            Tagger: {
                Source: "Granet"
                Intent: "<название вашего фрейма>.tagger"
            }
        }]
    }]
   ```


### Добавление фреймы с ML разбором
В будущем будет добавлена возможность обучения теггеров поверх Бертовых разборов.

1. Добавьте теггер по [инструкции](https://docs.yandex-team.ru/alice-scenarios/nlu/tagger) с именем `<название вашего фрейма>.tagger`.
2. В файл [frames.pb.txt](https://a.yandex-team.ru/arc_vcs/alice/nlu/data/ru/config/frames.pb.txt) необходимо добавить следующее вхождение:
   ```yaml
    Frames: [
     ..., {
        Name: "<название вашего фрейма>"
        Experiments: ["bg_beggins_<название вашего фрейма>"]
        Rules: [{
            Classifier: {
                Source: "AliceBinaryIntentClassifier"
                Intent: "<название модели из data.inc>"
                Threshold: <порог>
                Confidence: 1
            }
            Tagger: {
                Source: "AliceTagger"
                Intent: "<название вашего фрейма>.tagger"
            }
        }]
    }]
   ```

---

{% note info %}

После выкатки коммита, эксперимент `bg_beggins_<название вашего фрейма>` включит данный фрейм.

{% endnote %}


## Тестирование
### Тестирование фреймов
На данный момент нет инструментов для тестирования каскада `frames.pb.txt`.

Вместо этого необходимо писать [интеграционные тесты](https://a.yandex-team.ru/arc/trunk/arcadia/alice/tests/integration_tests/readme.md).

### e2e
Перед принятием решения о включении в прод, необходимо провести замер [ue2e](https://wiki.yandex-team.ru/alice/analytics/ue2e/).

Для того чтобы провести ue2e не дожидаясь релиза бегемота можно поднять бету begemot_megamind (модель находится именно в этом шарде), [инструкция по поднятию беты](https://wiki.yandex-team.ru/alice/begemot/beta/)

Надо правильно заполнить поля ue2e: 
- `test_experiments `. Ваша модель сейчас находится под экспериментом. Поэтому нужно включить флаг, чтобы до нее достучаться. Название эксперимента можно найти в том кусочке, который вы добавляли в `frames.pb.txt`. Пример:
```json
{"bg_beggins_tvscreensaver" : 1}
```
- `metrics_params`. Конфиг для метрик. Вот ссылка на [документацию](https://wiki.yandex-team.ru/alice/analytics/ue2e/priemka/#classificationmetrics). Пример: 
```json
{
    "classification_metrics_selector": {
        "intent": ["alice\tmetronome\tstart"]
    }
}
```

## FAQ
### LoggingThreshold
LoggingThreshold позволяет логировать срабатывания классификатора, даже если он выключен.

LoggingThreshold можно указать в конфиге `frames.pb.txt` в нужном классификаторе:
```yaml
Classifier: {
    ...
    LoggingThreshold: <порог для логирования>
    ...
}
```
### Как переопределить порог по эксперименту?
1. В конфиге `frames.pb.txt` в нужном классификаторе необходимо добавить имя якоря (Anchor):
   ```yaml
   Classifier: {
       ...
       Anchor: "<Anchor>"
       ...
   }
   ```
2. После порог можно переобределять с помощью флага эксперимента `bg_frames_override_rule_threshold=<Anchor>:<Threshold>`, например:
`bg_frames_override_rule_threshold=QRCode:3.3`.

### Где задавать вопросы
Вопросы можно задвать в чате [beggins](https://t.me/+vw-t5sLnYao0YTli)

### Куда репортить баги
В случае ошибок графе, проблем с доступами или бетами, если нужны какие-то доработки, то создавайте тикет https://st.yandex-team.ru/BEGGINSSUP/add
