# Нейросетевой теггер запросов

Нейросетевой теггер решает задачу выделения слотов фреймов из запросов пользователей с помощью нейросетевой модели.

## Устройство теггера

Теггер размечает в запросе пользователя участки, относящиеся к определенным слотам, с помощью нейросетевой модели, обученной на размеченных примерах запросов.
Для того, чтобы таким образом размеченный запрос превратить во фрейм, используются выделенные независимо от теггера в запросе [сущности](entities/custom.md) (числа, даты, имена, и т.п.) и правила сопоставления сущностей слотам, описанные в виде [гранетной](granet/syntax.md) формы.
Специальным типом значения слота является *строковое* значение.
В этом случае значением слота становится подстрока запроса, отнесенная нейросетевым теггером к этому слоту.

## Описание фрейма

Фрейм описывается в виде [гранетной](granet/syntax.md) формы.

В качестве примера рассмотрим такую форму:

```bash
form alice.find_poi:
    enable_granet_parser: false
    enable_alice_tagger: true
    slots:
        open:
            type:
                poi_open
        what:
            type:
                custom.named_location
                string
        where:
            type:
                custom.named_location
                custom.special_location
                string
```

Директива `enable_alice_tagger: true` включает распознавание фрейма `alice.find_poi` с помощью нейросетевого теггера.
Если не указывать, по умолчанию – `false`.
Директива `enable_granet_parser: false` выключает распознавание фрейма `alice.find_poi` с помощью грамматик гранета.
Если не указывать, по умолчанию – `true`.
Если вам нужно разбирать фрейм также и грамматиками, выставьте `enable_granet_parser: true` (или уберите директиву вовсе, `true` – значение по умолчанию).
После этого необходимо будет задать директиву `root:`, определяющую набор грамматических правил для текущего фрейма.
В секции слотов `type:` (она же `types:`) определяются типы, разрешенные в качестве значения слота.
В качестве типа может выступать название сущости или особым вариант типа – `string`: в этом случае значением слота может становиться строка выделенная для него непосредственно теггером.
Порядок перечисления типов важен: если внутри слота выделилось несколько доступных для заполнения сущностей, в качестве значения слота будет выбрана та, название которой указано в секции `type:` (`types:`) раньше прочих.

## Модели теггера

Сейчас теггер работает в двух местах Алисы: в [бегемотном](https://wiki.yandex-team.ru/begemot) шарде, с которым взаимодействует [Мегамайнд](../architecture.md) и в VINS, который является одним из сценариев [Мегамайнда](../architecture.md). Модели, доступные в бегемоте указаны [здесь](https://a.yandex-team.ru/arc/trunk/arcadia/search/wizard/data/wizard/AliceTagger/ya.make), в VINS – [здесь](https://a.yandex-team.ru/arc/trunk/arcadia/alice/vins/apps/personal_assistant/personal_assistant/config/chunks.yaml). Важно при обновлении модели обновить каждый из файлов, в котором она упомянута.

## Обучающая выборка

Обучающая выборка состоит из размеченных строк запросов.
Рассмотрим пример такой строки:
```bash
поставь будильник на 'восемь тридцать'(time) на 'пятницу'(date)
```

Здесь в запросе размечено два слота: `time`, к которому относится подстрока `'восемь тридцать'`, и `date`, к которому относится подстрока `'пятницу'`.
Строчка, отнесенная к слоту, размечается кавычками.
Сразу после закрывающей кавычки в скобках указывается имя соответствующего слота.
Выделение именованных сущностей (даты, времена, имена, и т.п.) происходит отдельно от работы теггера.

Сопоставление выделенных сущностей слотам происходит после работы теггера, в соответствии с описанием формы.
Поэтому в обучающей выборке именованные сущности никак не размечаются и не упоминаются.

В настоящий момент, все обучающие выборки теггера хранятся в Аркадии по путям вида:

`alice/vins/apps/personal_assistant/personal_assistant/config/scenarios/intents/**/*.nlu`

Причем, в самих файлах, для удобства описания, в могут встречаться *шаблоны* обучающих примеров.
Шаблон примера отличается от простого примера упоминанием словарей синонимов.
Такие словари служат для подстановки своих значений из словаря на месте в тексте примера, где указана ссылка на словарь.
Таким образом порождается несколько однотипных примеров, отличающихся подстановкой различных таких значений.

Рассмотрим пример шаблона:

```bash
@set будильник на 'восемь тридать'(time) на 'пятницу'(date)
```

Здесь `@set(10)` является ссылкой на словарь [`set`](https://a.yandex-team.ru/arc/trunk/arcadia/alice/vins/apps/personal_assistant/personal_assistant/config/nlu_templates/set.txt).

Словаря `set` содержит следующие значения:

```
ставь
поставь
поставить
включи
включай
включить
установи
установить
заведи
завести
запусти
запустить
запили
забабахай
добавь
добавить
добавляй
сделай
выставь
```

В результате раскрытия шаблона будут порождены 10 примеров фраз, отличающихся только подстановкой одного из значений словаря вместо `set`.

В шаблоне можно сослаться на несколько словарей:

```bash
@set(10) будильник на '@abs_time_ru(5:acc)'(time) на 'пятницу'(date)
```

В этом примере есть ссылка на словари [`set`](https://a.yandex-team.ru/arc/trunk/arcadia/alice/vins/apps/personal_assistant/personal_assistant/config/nlu_templates/set.txt) и [`abs_time_ru`](https://a.yandex-team.ru/arc/trunk/arcadia/alice/vins/core/vins_core/nlu/data/abs_time_ru.txt).
Обратите внимание, что для словаря `abs_time_ru` в скобках также указана директива `:acc` – требование установить подставленное значение в определенный падеж, винительный. Такой шаблон будет раскрыт в декартово произведение значений словарей `set` и `abs_time_ru`: всего получится `10 * 5 = 50` примеров.

## Обучение теггера

[Граф обучения теггера](https://nirvana.yandex-team.ru/flow/7199c85c-31e6-4273-a2f1-c7cbf38f06e2) (стоит брать всегда версию с короной)

Граф обучения теггера состоит из 4 блоков:
1. Конвертация имеющихся синтетических разметок в таблицу с обучающими примерами.
   Этап сохранился для возможности переиспользования уже существующей синтетической разметки.
   Может быть опущен и заменен на работу с произвольной готовой табличкой, содержащей обучающие примеры в формате, описанном выше (см. *Обучающая выборка*).
   Поддерживается возможность наложить патч на синтетические данные в глобальной опции `Data patch`.
2. Сбор признаков для обучающих примеров, путом обстреливания примерами запросов шарда Мегаманд [Бегемота](https://wiki.yandex-team.ru/begemot/).
   Поддерживается возможность наложить патч на процесс формирования признаков в глобальной опции `Feature patch`.
   Типичный пример – изменение или добавление [именованных сущностей](entities/custom.md).
3. Обучение заданных в глобальной опции графа (`Intents`) теггеров.
4. Сборка бегемота с переобученными теггерами и поднятие беты. Бета доступна по адресу `https://yappy.z.yandex-team.ru/b/alice-begemot-megamind-<BETA_SUFFIX>`, где **<BETA_SUFFIX>** – значение глобальной опции **Beta name suffix** графа обучения теггера.

{% note warning %}

**Если вы планируете параллельные запуски графа!** \
\
В графе теггера обратите внимание на опцию **MR Path**.
Эта опция определяет путь, по которому будут записаны создаваемые графом YT таблицы.
Весь путь для таблички `<table_name>`, создаваемой графом, задается следующим образом: \
`//home/${global["mr-account"]}/${meta["owner"]}/${global["mr-path"]}/<table_name>` \
Если вы запустите несколько параллельных инстансов графа, не меняя эту опцию при запусках – все они будут писать в одни и те же таблички.
В итоге в любой из табличек может оказаться результат любого из параллельно выполнящихся инстансов.

{% endnote %}

### Оценка изменения качества ответов Алисы с учетом обученного теггера

После обучения теггера полезно посмотреть на то как поменялись ответы Алисы в целом на приемочных корзинках запросов. Для этого необходимо [запустить ue2e-приемку](https://wiki.yandex-team.ru/alice/analytics/ue2e/priemka/), в рамках которой можно получить и сравнить численные оценки качества работы текущей Алисы и Алисы с новым теггером.

При запуске ue2e в качестве значения опции `test_url` укажите следующее:
```
http://vins.hamster.alice.yandex.net/speechkit/app/pa/?srcrwr=ALICE__BEGEMOT_WORKER_MEGAMIND:<BETA_INSTANCE>:81:10000
```

Здесь вместо **<BETA_INSTANCE>** нужно подставить адрес **инстанса** поднятой беты.

Адрес инстанса можно узнать, перейдя в раздел **Components** на страничке беты (см. пункт 4 в описании графа обучения теггера) и нажав на ссылку вида **yappy_alice_begemot_megamind_yp_18**. Откроется страничка сервиса беты в няне. Там жмем кнопку **Instances** и выбираем любой из открывшегося списка.

### Как применить патч со всеми необходимыми изменениями
В графе на выходе кубика **update alice tagger resources** лежит URL с результирующим патчем.
Применить патч к локальной копии аркадии можно так:
```bash
curl -o my.patch <URL патча из графа>
patch -d $ARCADIA --ignore-whitespace -p0 <my.patch
```

Где в переменной `$ARCADIA` должен быть путь к локальной копии аркадии.
