# Интерактивный майнинг похожих запросов

[Verstehen](https://verstehen.n.yandex-team.ru/) - инструмент, который позволяет быстро искать в больших количествах коротких текстов и размечать полученные результаты.
Имеет свою документацию в кнопочке i в интерфейсе.
Наиболее полное описание есть на [wiki разработчиков](https://wiki.yandex-team.ru/users/artemkorenev/verstehen/).


## Как использовать

1. Добавьте несколько строчек, которые будут вашим первым запросом, с помощью кнопки **Add**, или используйте кнопку **Importing**, чтобы загрузить много фраз сразу.
2. Запустите поиск нажатием на кнопку **Search**.
3. Разметьте поисковую выдачу, можно не всю.
Если нет уверенности, относится ли элемент выдачи к релевантным (positive) или нерелевантным (negative), используйте опцию **Skip**.
4. Перезапустите поиск кнопкой **Search** и повторяйте до тех пор, пока не получите достаточно релевантных данных для ваших потребностей.
5. Нажатием кнопки **Exporting** можно выгрузить текущие данные в нужном формате для дальнейшего использования.


## FAQ

### Как эффективнее всего набрать запросов из нужных мне логов?

Наиболее эффективный способ поиска логов отличается от случая к случаю, но есть несколько базовых рекомендаций, как делать это эффективно:
* Для начала нужно добавить несколько базовых запросов, чтобы начать поиск.
Желательно, чтобы эти фразы были максимально разнообразны, чтобы поиск смог наиболее лучшим образом понять семантику того, что хочется найти.
* После составления начального запроса, попытайтесь воспользоваться каким-нибудь индексом, **кроме [Active Learning]**, чтобы найти больше релевантных примеров.
Постепенно размечайте выдачу, и со временем выдача начнет быть наиболее точной.
* Не забывайте выделять негативные примеры, это очень важно для более корректной выдачи.
* Если выдача все-таки слишком однообразная, попробуйте использовать индекс **с [Active Learning]**, который будет выдавать менее уверенные примеры, что увеличит разнообразие.


### Какой индекс лучше использовать для поиска?

В среднем лучше всего работают индексы **DSSM + KNN with Logistic Regression** и **DSSM + KNN with Logistic Regression + CatBoost**.
Оба алгоритма хорошо учитывают как позитивные, так и негативные запросы.
Однако, если необходимо иметь наиболее разнообразную выдачу, то могут помочь индексы **[Active Learning]**.
Если же важно иметь поиск, который находит определенные слова, не обращая внимания на семантику, используйте **BM25**.
