## Тестирование на проде {#testing_prod}
Пусть вы закоммитили под флагом постролл c ```postroll_id``` и хотите его протестировать. 
Обычно тестирование включает проверку, что ваш постролл приклеивается к ожидаемому интенту и что его кнопка работает.
Какие нужны флаги:
* Все флаги из `Condition` постролла, обычно это флаг самого постролла и флаги сценария постролла, если сценарий еще не включен на проде.
* Флаг `skillrec_debug` -- отключает условие на минимальное время и количество запросов между показами постролла и позволяет построллить на каждом запросе.
* Флаги `mm_proactivity_time_delta_threshold=0` и `mm_proactivity_request_delta_threshold=0` -- отключают ограничение по времени и количеству запросов со стороны Megamind, тоже нужны для постролла на каждом запросе.
* Пара флагов `skillrec_disable_all_items` и `skillrec_enable_item=postroll_id`, чтобы был доступен только постролл `postroll_id`. 
Первый отключает все построллы, второй -- оверрайдит первый и включает постролл с именем `postroll_id`.
* Иногда нужен флаг `skillrec_debug_ignore_conditions`, он отключает проверку всех Condition-ов. 
Его стоит использовать, если у вас не получается выполнить все условия из постролла. 

Для тестирования:
1. Указываем в конфиге колонки перечисленные выше флаги.
2. Задаем запрос, к которому должен клеиться ваш постролл. Если у вас нет особенных условия на source, то можно тестировать на ```"Алиса, привет"```.
3. Проверяем, что постролл клеиться и звучит как ожидается.
4. Если постролл с кнопкой, то соглашаемся на кнопку и смотрим, чтобы по ней корректно включился сценарий.

## Тестирование локально {#testing_local}
Если вы хотите протестировать постролл до коммита, то можно поднять локалько сервис проактивности и проверить на нем ваши построллы.
Как поднять сервис локально:
* Завести себе виртуалку в [qyp](qyp.yandex-team.ru/), с макросом `__SEARCHSAND__` или `_ALICEDEVNETS_`.
Либо можно использовать общую [alice-managers.vla.yp-c.yandex.net](https://qyp.yandex-team.ru/vm/vla/alice-managers) (доступ можно попросить у [@dozornin](https://staff.yandex-team.ru/dozornin))
* Зайти на виртуалку. Как это сделать, можно прочитать [здесь](https://wiki.yandex-team.ru/security/ssh/).
* Cчекаутить себе всё, что есть в `arcadia/dj/services/alisa_skills/`.
* Загрузить ваши локальные изменения на виртулаку, [инструкция](https://wiki.yandex-team.ru/security/ssh/#kakkopirovatfajjlysodnojjmashinynadruguju).
* Перейти в `arcadia/dj/services/alisa_skills/server/bin` и выполнить команды 
   * `ya make -r --checkout --sanitize address` -- сборка кода сервиса
   * ` && ./run_local --port XXXX ` -- запуск сервиса, XXXX -- рандомного четырехзначное число.
* Прописать в конфиге колонки изменение источника для проактивности: 
   ```
   "vinsUrl": "http://vins.alice.yandex.net/speechkit/app/pa/?srcrwr=SKILL_PROACTIVITY_HTTP:<your_VM>:XXXX"
   ``` 
   , где XXXX из пункта выше.
* Прописываем эксперименты и тестируем по [инструкции](#testing_prod) выше.


{% cut "Что пишется в логи сервиса при локальном запуске." %}

1. `Source groups filter results json` - мапа из названия source группы в данные предварительной проверки. В данных есть конкретно result, который OK для прошедших проверки сорс групп, и разные другие варианты для непрошедших, например unsatisfied condition, applied recently. Еще в данных есть info, где в более свободной форме написаны подробности, например, что именно не прошло в условии.
2. `Viable sources json` - мапа из прошедших проверки source-ов (уже не source групп) в разную информацию о них. Пока в информации есть только conditionCount - количествно apply condition для этого сорса (пока всегда 0 или 1). Если Viable sources json в принципе нет в логе, значит ни один сорс не прошел проверки (а в пункте 1 не было ни одного OK).
3. `Promotion filter results json` - все как в 1, но для промоушенов. Соответственно прошли проверки только те, у которых result: OK.
4. `Item filter results json (only NOT OK)` - как 1 и 3, но для айтемов из промоушенов. При этом, тут НЕ указываются OK, потому что они будут указаны потом отдельно. То есть все эти айтемы не прошли проверки. У многих будет result: tag applied recently - это айтемы, тег которых недавно показывали.
5. `Item score calculation constants json` - разные константы для подсчета score-ов айтемов. Пока не особо важно.
6. `Viable item scores json` - здесь только прошедшие проверки айтемы и у них уже посчитан score. Это мапа из названия айтема в инфу о нем, в инфе всегда score и priorScore. Если используются какие-то способы подсчета скора, в инфе появятся другие дополнительные значения, но score - всегда результирующее.
7. Дальше начинается много SPLIT-ов для каждого source. Там можно найти `Promotions ignored by source regex json` - какие промоушены для этого сорса были проигнорированы (из отфильтрованных ранее). Selected XXX items from promotions - сколько айтемов подходят для этого сорса. Selected XXX items with max_score=YYY - сколько победителей и с каким скором.
8. `Per source results json` - идет после всех сплитов и это мапа из source в результат для него. В результате есть result, который OK, если что-то порекомендовали или no items (или multiple items, но это не должно происходить). Если OK, то в результате еще есть item с победителем для этого сорса и conditionCount с количеством apply condition-ов.
9. В конце будет что-то вроде `Finished with code: HTTP_OK. Processing took 10 msec. Proto response body (displayed as json)` и дальше json ответа. HTTP_OK не означает, что мы что-то порекомендовали, это просто хороший ответ. Если не HTTP_OK, значит произошла какая-то ошибка. А вот в json-е может быть Status. Если его нет - он ОК - было что порекомендовать. Если есть, он будет один из: NoViableItems, NoViableSources, DisabledByFlags, DisabledInApp, AppliedRecently, DisabledAnswer, DisabledInSettings.

{% endcut %}

