# Amanda Johnson
[@AmandaJohnson](https://t.me/AmandaJohnsonBot) – это телеграм-бот, который умеет эмулировать устройства с Алисой и поисковое приложение.
Аманда удобна для отладки сценария во время разработки, она может рендерить ответы Алисы (текст, текст с кнопками, дивные карточки), переопределять эксперименты, менять адрес Мегамайнда, настраивать DeviceState и многое другое.

## Начало работы
1. Добавьте свой Telegram-username в анкету на Стаффе.
2. [Начните диалог с @AmandaJohnson](https://t.me/AmandaJohnsonBot).

Запросы в Аманду имитируют запросы с произвольного приложения. Помимо текстовых запросов Аманда поддерживает запросы с картинкой – просто отправьте изображение.

Аманда поддерживает множество команд для настройки. Отправьте `/help`, чтобы ознакомиться с актуальным списком команд.

{% note info %}

В большинстве команд начинающихся с `/set` поддержан вариант `/set value`.

Используйте `/cancel`, чтобы отменить текущий ввод.

{% endnote %}

## Параметры
Вы можете настраивать работу Аманды с помощью доступных команд.
Для того, чтобы посмотреть текущие параметры, используйте команду `/me`.

### Параметры приложения
Вы можете выбрать конфигурацию приложения из доступных пресетов `/apppresets` и/или настроить каждый параметр по отдельности, например `/setappid myAppID`.
С текущей конфигурацией можно ознакомиться с помощью команды `/app`.

Пресеты соответствуют конфигурациям используемым при прокачках Алисы.

#### Колонки
- **quasar** – Яндекс.Станция;
- **yandexmini** – Яндекс.Станция Мини;
- **small_smart_speakers** – колонка Elari.
- **dexp** – колонка Dexp.

#### Поисковое приложение
- **search_app_ios** – ПП для iOS;
- **search_app_prod** – ПП для Android;
- **search_app_ipad** – ПП для iPad.

#### Браузер
- **yabro_prod** – Я.Бро для Windows;
- **browser_prod** – Я.Бро для Android.

#### Другие приложения и устройства
- **tv** – телевизор;
- **auto** – автоголова;
- **navigator** – навигатор;
- **elariwatch** – часы elari.

### Параметры аккаунта
Аманда позволяет добавить несколько аккаунтов и переключаться между ними.

Для того, чтобы добавить аккаунт, выполните следующие действия.
1. Отправьте команду `/addacc`.
2. Нажмите на кнопку "Yandex.OAuth". Откроется страница предоставления доступа к приложению.
3. Нажмите кнопку "Разрешить" и скопируйте код подтверждения.
4. Отправьте код подтверждения в Аманду в виде `/addacc <code>`.

Для того, чтобы посмотреть текущий аккаунт или сменить его, используйте команду `/acc`.
Кроме того можно отправлять запросы от лица неавторизованного пользователя – для этого выберите аккаунт **Инкогнито**.

{% note warning %}

Обратите внимание, что не все поверхности поддерживают взаимодействие без авторизации.

{% endnote %}

### Параметры устройства
Вы можете изменить уровень громкости, режим фильтрации контента или выбрать споттер. Используйте команду `/device`.

## Тестирование сценариев
### Переопределение адреса Мегамайнда
1. Используйте команду `/setmmurl`.
2. Введите адрес в следующем формате:
    ```
    http://vins.hamster.alice.yandex.net/speechkit/app/pa/:srcrwr=MEGAMIND_ALIAS:<адрес_dev-сервера>:<номер_порта>, номер_порта = порт + 3
    ```
    Например, если Мегамайнд запущен на порту 7007:
    ```
    http://vins.hamster.alice.yandex.net/speechkit/app/pa/:srcrwr=MEGAMIND_ALIAS:my-dev-server.man.yp-c.yandex.net:7010
    ```

В меню доступны стандартные адреса Мегамайнда, а также последние установленные Вами.

### Включение сценария
Добавьте эксперимент `mm_enable_protocol_scenario` с помощью команды `/setexp`.
Например, для того, чтобы включить сценарий **BestScenario**, необходимо добавить следующий эксперимент: `/setexp mm_enable_protocol_scenario=BestScenario`.

{% note info %}

Используйте `/switchexp` для того, чтобы быстро включать или отключать эксперименты.

{% endnote %}

### Переопределение адреса сценария
Добавьте параметр запроса `srcrwr` с помощью команды `/addqueryparam`. Например, для того, чтобы переопределить сценарий **BestScenario**, необходимо добавить следующий параметр: `/addqueryparam srcrwr=BestScenario:host:port`.

{% note info %}

Используйте `/switchqueryparam` для того, чтобы быстро включать или отключать параметры запроса.

{% endnote %}

### Отладка
Чтобы посмотреть логи запросов, воспользуйтесь командой `/setrace`.
Данная команда отображает request id последних запросов со ссылкой на [setrace](../setrace/index.md).
Также можно перейти к списку всех запросов, нажав на кнопку "Посмотреть все".

### Произвольная настройка DeviceState
В некоторых случаях Вам может потребоваться задать параметры DeviceState, например, задать состояние навигатора или плеера. Для этого:
1. Выполните команду `/device`.
2. Нажмите кнопку "Редактировать". Откроется редактор DeviceState в браузере.
3. Внесите необходимые изменения в соответствии со схемой [TDeviceState](https://a.yandex-team.ru/arc/trunk/arcadia/alice/megamind/protos/common/device_state.proto).
4. Нажмите кнопку "Сохранить".

### Отображение голосового ответа
Для включения отображения голосового ответа на все запросы выполните следующие шаги.
1. Выполните команду `/voicesession`.
2. Установите значение параметра в **true**.

{% note warning %}

Обратите внимание, что по умолчанию голосовой ответ будет возвращен в виде "голосового сообщения".
Если ответ слишком длинный, то стриминг TTS не будет укладываться в установленные таймауты и Вы будете получать ошибку.
Чтобы исправить это, выполните команду `/tts` и выберите режим "Отображать TTS в виде текста".

{% endnote %}

### Рендер дивных карточек
Аманда умеет рендерить произвольные дивные карточки.
Отправьте файл с расширением `.json` с дивной карточкой и Аманда ее отрендерит.

```json
{
    "states": [
        {
            "action": {
                "log_id": "whole_card",
                "url": "yellowskin://?primary_color=%23ffffff&secondary_color=%23000000&url=https%3A//yandex.ru/pogoda/irkutsk%3Fappsearch_header%3D1%26appsearch_ys%3D2%23d_1"
            },
            "state_id": 1,
            "blocks": [
                {
                    "type": "div-separator-block",
                    "size": "xs"
                },
                {
                    "type": "div-universal-block",
                    "title": "Сейчас в Иркутске "
                },
                {
                    "text": "Переменная облачность от +9 до +23 ",
                    "type": "div-universal-block"
                }
            ]
        }
    ],
    "background": [
        {
            "color": "#FFFFFF",
            "type": "div-solid-background"
        }
    ]
}
```

Также можно выполнить команду `/renderdivcard`, чтобы получить пример файла с дивной карточкой.

### Отладка паровозных сценариев
По умолчанию Аманда сразу выполняет все директивы в ответе.
В случае, если взаимодействие с пользователем построено на механизме `get_next`, удобно отлаживать пайплайн с помощью отложенного исполнения директив.
В этом режиме для серверных директив в ответе будут создавать кнопки для запуска этой директивы.
Для того, чтобы включить данный режим, воспользуйтесь командой `/directives`.

### Сброс сессии
Иногда Вам может потребоваться сбросить сценарный стейт или историю запросов.
Для этого выполните команду `/resetsession`.
Перед выполнением следующего запроса сессия будет сброшена.

## FAQ

### Как оставить отзыв, предложение или рассказать о баге?
Обо всем этом можно писать в [чате поддержки Мегамайнда](https://t.me/joinchat/BBPaeRGYwx3cNiNYXnK0SQ) или лично [@alkapov](https://staff.yandex-team.ru/alkapov).

### Как самостоятельно добавить фичу?
Код расположен по пути [alice/amanda](https://a.yandex-team.ru/arc/trunk/arcadia/alice/amanda).
Вы можете самостоятельно сделать PR, дождаться ревью и закоммитить изменения.

### Как сбросить настройки бота?
Используйте команду `/resetbot`.

### Как узнать все текущие настройки?
Используйте команду `/me`.

### Что за сообщение с облачком 💭?
Это специальное сообщение для отображения саджестов.
