package patterns

import (
	sdk "a.yandex-team.ru/alice/gamma/sdk/golang"
)

const (
	StartGameIntent     = "start"
	RulesGameIntent     = "rules"
	GetDefinitionIntent = "getDefinition"
	UserWordIntent      = "userWord"
	EndGameIntent       = "end"

	ChangeWordIntent          = "change"
	ChangeWordFromStartIntent = "changeFromStart"
	UserChangeWordIntent      = "userChange"

	SampleAnswerIntent = "sampleAnswer"
	UserMainWordIntent = "userMainWord"

	YesContinueGameIntent = "yes"
	NoContinueGameIntent  = "no"

	DontUnderstandFromTipAndRulesIntent = "TipAndRules"

	GenerateMainWord = "generateMainWord"
	UserDontKnow     = "userDontKnow"

	NewTipIntent         = "newTip"
	NextTipIntent        = "nextTip"
	DontUnderstandIntent = "dontUnderstand"

	ExtraTalkThink = "extraThink"
	ExtraTalkGood  = "extraGood"
	ExtraTalkAgree = "extraAgree"
)

const (
	agree = "(* " + agreeStrong + " *|" + agreeWeak + "|" + yes + ")"

	agreeWeak = "(логично|могу|было дело|бывало|бывает)"

	yes = "[ну] [конечно|всё|все|вроде|пожалуй|возможно]" +
		" (да|даа|lf|ага|точно|угу|верно|ок|ok|окей|окай|okay|оке|именно|подтвержд*|йес)" +
		" [да|конечно|конешно|канешна|всё|все|вроде|пожалуй|возможно]"

	agreeStrong = "(давай|конечно|конешно|канешна|а то [нет]|очень|[ты] прав*|абсолютно|обязательно|непременно|" +
		"а как же|подтверждаю|точно|пожалуй|запросто|норм|(почему|что|че) [бы] [и] нет|хочу|было [бы] (неплохо|не плохо)|" +
		"[(" + yes + "|очень)] (хочу|хо чу|ладно|хорошо|можно|валяй*|договорились|согла*|вполне|в полной мере|естественно|разумеется|" +
		"(еще|ещё) как|не (против|возражаю|сомневаюсь)|я только за|безусловн*|[это] так [и есть]|давай*) [(конечно|конешно|канешна)]|" +
		"[все] правильно|все так)"

	disagree = "(не надо|не хочу|неа|нет|не)"

	notNow = "(не [могу] сейчас|мне (некогда|не до *того)|(в другой|не в этот) раз |" +
		"[давай] (*позже|потом|не сегодня|завтра|не сейчас|пока не надо|в (следующий|другой) раз) [поговорим]|" +
		"нет времени|я (занят|занята)|не готов|не готова) "

	dontKnow = "[([я] даже|ну [я]|сам*)] ((не|откуда" + me + ") (зна*|задумывал*|думал*|решил*|представляю|уверен*|помню)" +
		"|незнаю|неизвестно|надо подумать|без понятия|без понятий|понятия не имею|сомневаюсь|сложны* вопрос*|сложно сказать|" +
		"все сложно|ну ты [и]спросил|спросишь тоже|забыл*|сдаюсь) "

	good = "[(очень|так*|конечно|всё|все|просто)] (добр*|хорошо|хорош*|отличн*|классн*|крут*|замечательн*|потряс*|" +
		"великолепн*|прекрасн*|прекрасно|заебись|зашибись|[о] кей|здорово|здорого|порядок|в порядке)[(очень|так*|конечно|всё|все|просто)]"

	me = "[" + preposition + "] (я|меня|мне|мной|мой|моя|мою|мое*|моим|моём|моей|себ*|мня|мну)"

	preposition = "(у|про|для|за|из [за]|из-за|в|без|до|через|с|со|об|от|к|ко|о|обо|об|при|по|на|с|над|под|перед)"

	stopGame = "(* " + stopGameStrong + "*|" + stopGameWeak + ")"

	stopGameStrong = "(давай (хватит|закончим)|хватит играть|надоело|(больше не (хочу|хочется))|прекращ*|" +
		"прекрат*|стоп|останов*|заканч*|[давай] законч* [игр*]|устал* игр*|(не (хочу|хочется) " +
		"[больше] играть)|надоел|надоела|мне надоело играть|((не нравится) * игра)|(выйти|выход) из * игры)"

	stopGameWeak = "(конец|хватит|[я] устал*|выход|выйти|сдаюсь)"

	think = "((думать|думаю|думаем|думал[а])|(подумать|подумаю|подумаем|подумал[а]))"
)

var GameCommands = []sdk.Pattern{
	{
		Name: StartGameIntent,
		Pattern: "* (из большого слова маленькое|(игре|игры|игра|игрой|игру) в слова|игру в слова|составь слова) * |" +
			"* ((поиграю|поиграем|поиграй|поиграть)|(играю|играем|играй|играть)|(сыграю|сыграем|сыграй|сыграть)|играм) в слова * |" +
			"* (включи|активируй) слова * |" +
			"* давай (сначала|заново) * |" +
			"* (вернуться|вернись|(продолжу|продолжи|продолжить|продолжим)|(продолжать|продолжаю|продолжай|продолжаем)) * ((игре|игры|игра|игрой|игру)|играть) * ",
	},
	{
		Name:    NewTipIntent,
		Pattern: "* ((подсказке|подсказках|подсказки|подсказок|подсказкам|подсказка|подсказкой|подсказками|подсказку)|подскажи|подсказывай|намекни|помоги|помощь|" + dontKnow + ") *",
	},
	{
		Name: ChangeWordFromStartIntent,
		Pattern: " ((другой|другая|другую)|(новой|новая|новую)) |" +
			" * (дай|давай|хочу) * (попроще|посложнее) * |" +
			" * ((поменять|поменяю|поменяем|поменяй)|(менять|меняю|меняем|меняй)|(было слово)|(давай|хочу) ((другой|другая|другую)|(новой|новая|новую))|((уже|это) было)) *",
	},
	{
		Name:    UserWordIntent,
		Pattern: "[а|ну] [а|ну|пусть [будет]|давай|например|[мое|моё] слов*|а |тогда] $Any",
	},
	{
		Name:    SampleAnswerIntent,
		Pattern: "* (скажи|дай) (слово|ответ*) *",
	},
}

var GlobalCommands = []sdk.Pattern{
	{
		Name:    DontUnderstandFromTipAndRulesIntent,
		Pattern: "(* (че|что) делать *)|и че|и что",
	},
	{
		Name: RulesGameIntent,
		Pattern: "* (правила|как играть|что делать|как дальше) * |" +
			" (и че|и что|и как)",
	},
	{
		Name: ChangeWordIntent,
		Pattern: " * (((другом|других|другого|другому|другим|другое|другие|другими|другой|другая|другую)|" +
			"(новом|новых|нового|новому|новым|новое|новые|новыми|новой|новая|новую|новый)|" +
			"поменяй|поменяйте|меняй|измени|измените)" +
			" * (слове|словах|слова|слов|слову|словам|слово|словом|словами)) * |" +
			" * (дай|давай|хочу) * (слово * (попроще|посложнее)) * |",
	},
	{
		Name: UserChangeWordIntent,
		Pattern: "* (хочу|давай я|дай мне) * ((загадать|загадываю|загадаю|загадаем)|(выбрать|выберу|выберем)|(выбирать|выбираю)|(придумывать|придумаю|придумаем|придумываю)) * [новое|другое] слово *|" +
			"* (хочу|давай я|дай мне) * ((поменять|менять|изменить) * слово) *|" +
			"* (дай|давай|хочу) * ((загадать|загадываю|загадаю|загадаем)|(выбрать|выберу|выберем)|(выбирать|выбираю)|(придумывать|придумаю|придумаем|придумываю)) * (попроще|посложнее) *",
	},

	{
		Name: GetDefinitionIntent,
		Pattern: " * [" + disagree + "] * ((что|че) (такое|значит|[это] за)|определение) [(слове|словах|слова|слов|слову|словам|слово|словом|словами)] $Any |" +
			"(значит|означает|значени*|(((что|че) [это] [за]|(не знаю|нет|не существует)) (это*|тако*)|незнакомое|странное) [слово|словечко]) * |" +
			" * это * (не существительное|глагол|прилагательное|наречие|имя собственное) * |" +
			" [а|и] (что|кто) это [такое|такой|такая]|" +
			" * ((что|че) (такое|значит|это за)) [слово] (блин|такое|скажи|напиши)",
	},
	{
		Name:    ExtraTalkThink,
		Pattern: "* " + think + "слово *",
	},
	{
		Name:    ExtraTalkGood,
		Pattern: "* " + good + "слово *",
	},
	{
		Name:    ExtraTalkAgree,
		Pattern: "* " + agree + "слово *",
	},
	{
		Name:    EndGameIntent,
		Pattern: "* (" + stopGame + ") *",
	},
}

var ContinueGameCommands = []sdk.Pattern{
	{
		Name: NoContinueGameIntent,
		Pattern: "* (" + disagree + "|" + notNow + "|не ((начать|начну|начнем|начни)|(буду|быть|будем)|(хотеть|хочу|хочется|хотим)|(начинать|начинаем|начинай)|" +
			"(продолжу|продолжи|продолжить|продолжим)|(продолжать|продолжаю|продолжай|продолжаем)|(играю|играем|играй|играть)|(сыграю|сыграем|сыграй|сыграть))) * |" +
			" * (" + disagree + "|" + notNow + "|не ((начать|начну|начнем|начни)|(буду|быть|будем)|(хотеть|хочу|хочется|хотим)|(начинать|начинаем|начинай)|" +
			"(продолжу|продолжи|продолжить|продолжим)|(продолжать|продолжаю|продолжай|продолжаем)|(играю|играем|играй|играть)|(сыграю|сыграем|сыграй|сыграть))) * |" +
			" * (" + disagree + "|" + notNow + "|не ((начать|начну|начнем|начни)|(буду|быть|будем)|(хотеть|хочу|хочется|хотим)|(начинать|начинаем|начинай)|" +
			"(продолжу|продолжи|продолжить|продолжим)|(продолжать|продолжаю|продолжай|продолжаем)|(играю|играем|играй|играть)|(сыграю|сыграем|сыграй|сыграть))) *",
	},
	{
		Name: YesContinueGameIntent,
		Pattern: "* (" + agree + "|продолж*|(постараюсь|стараюсь|стараться)|попытаюсь|попробую|поехали|го|гоу|погнали|сыграем|играем) " +
			"[продолж*|поигра*|сыгра*|игра*|попробую|попробуем] *",
	},
}

var MainWordChangeState = []sdk.Pattern{
	{
		Name: NoContinueGameIntent,
		Pattern: "* (" + disagree + "|" + notNow + "|не ((начать|начну|начнем|начни)|(буду|быть|будем)|(хотеть|хочу|хочется|хотим)|(начинать|начинаем|начинай)|" +
			"(продолжу|продолжи|продолжить|продолжим)|(продолжать|продолжаю|продолжай|продолжаем)|(играю|играем|играй|играть)|(сыграю|сыграем|сыграй|сыграть))) * |" +
			" * (" + disagree + "|" + notNow + "|не ((начать|начну|начнем|начни)|(буду|быть|будем)|(хотеть|хочу|хочется|хотим)|(начинать|начинаем|начинай)|" +
			"(продолжу|продолжи|продолжить|продолжим)|(продолжать|продолжаю|продолжай|продолжаем)|(играю|играем|играй|играть)|(сыграю|сыграем|сыграй|сыграть))) * |" +
			" * (" + disagree + "|" + notNow + "|не ((начать|начну|начнем|начни)|(буду|быть|будем)|(хотеть|хочу|хочется|хотим)|(начинать|начинаем|начинай)|" +
			"(продолжу|продолжи|продолжить|продолжим)|(продолжать|продолжаю|продолжай|продолжаем)|(играю|играем|играй|играть)|(сыграю|сыграем|сыграй|сыграть))) *",
	},
}

var UserMainWordCommands = []sdk.Pattern{
	{
		Name:    UserMainWordIntent,
		Pattern: "[* ([ну] (слово|пусть|например|давай [попробуем]|хочу|как насчет|предлагаю|тогда) [будет])] $Any",
	},
	{
		Name:    GenerateMainWord,
		Pattern: "* (случайное слово|давай случайное) *",
	},
	{
		Name:    UserDontKnow,
		Pattern: "* " + dontKnow + " *",
	},
}

var TipCommands = []sdk.Pattern{
	{
		Name: NextTipIntent,
		Pattern: "* (еще|(новом|новых|нового|новому|новым|новое|новые|новыми|новой|новая|новую|новый)|" +
			"(другом|других|другого|другому|другим|другое|другие|другими|другой|другая|другую)) *",
	},
	{
		Name:    DontUnderstandIntent,
		Pattern: "* (не понят*|не понял*|" + dontKnow + "|(че|что) делать|и (че|что)) *",
	},
}
