//
// Autogenerated file
// This file was created from directives.proto and directives.jinja2 template
//
// Don't edit it manually!
// Please refer to doc: https://docs.yandex-team.ru/alice-scenarios/hollywood/main/codegen
// for more information about custom codegeneration
//

#include "gen_directives.pb.h"

#include <alice/megamind/protos/scenarios/directives.pb.h>
#include <alice/megamind/protos/scenarios/response.pb.h>

#include <alice/protos/endpoint/capability.pb.h>
#include <alice/protos/endpoint/common.pb.h>
#include <alice/protos/endpoint/endpoint.pb.h>
#include <alice/protos/endpoint/capabilities/battery/capability.pb.h>
#include <alice/protos/endpoint/capabilities/div_view/capability.pb.h>
#include <alice/protos/endpoint/capabilities/iot_scenarios/capability.pb.h>
#include <alice/protos/endpoint/capabilities/opening_sensor/capability.pb.h>
#include <alice/protos/endpoint/capabilities/route_manager/route_manager.pb.h>
#include <alice/protos/endpoint/capabilities/vibration_sensor/capability.pb.h>
#include <alice/protos/endpoint/capabilities/water_leak_sensor/capability.pb.h>

namespace NAlice::NHollywoodFw {
namespace {

template <class T>
class TCustomDirectiveWrapper final : public TDirectiveWrapper {
public:
    TCustomDirectiveWrapper(T&& directive, T*(NScenarios::TDirective::*fn)(), const TString& name)
        : TDirectiveWrapper(name)
        , Directive_(std::move(directive))
        , Fn_(fn)
    {
    }
    void Attach(NScenarios::TScenarioResponseBody& response) override {
        NScenarios::TDirective directive;
        T& directive2 = *((directive.*Fn_)());
        directive2.CopyFrom(Directive_);
        *(response.MutableLayout()->AddDirectives()) = std::move(directive);
    };
private:
    T Directive_;
    T*(NScenarios::TDirective::*Fn_)();
};

} // anonymous namespace

/*
    Add all compiled directives to response
*/
void TDirectivesWrapper::BuildAnswer(NScenarios::TScenarioResponseBody& response) {
    for (const auto& it : Directives_) {
        it->Attach(response);
    }
}

/*
    Simplified methods - add simple directives w/o name
*/
void TDirectivesWrapper::AddPlayerShuffleDirective() {
    NAlice::NScenarios::TPlayerShuffleDirective directive;
    directive.SetName("player_shuffle_directive");
    AddPlayerShuffleDirective(std::move(directive));
}
void TDirectivesWrapper::AddPlayerOrderDirective() {
    NAlice::NScenarios::TPlayerOrderDirective directive;
    directive.SetName("player_order_directive");
    AddPlayerOrderDirective(std::move(directive));
}
void TDirectivesWrapper::AddPlayerReplayDirective() {
    NAlice::NScenarios::TPlayerReplayDirective directive;
    directive.SetName("player_replay_directive");
    AddPlayerReplayDirective(std::move(directive));
}
void TDirectivesWrapper::AddPlayerRepeatDirective() {
    NAlice::NScenarios::TPlayerRepeatDirective directive;
    directive.SetName("player_repeat_directive");
    AddPlayerRepeatDirective(std::move(directive));
}
void TDirectivesWrapper::AddSoundMuteDirective() {
    NAlice::NScenarios::TSoundMuteDirective directive;
    directive.SetName("sound_mute_directive");
    AddSoundMuteDirective(std::move(directive));
}
void TDirectivesWrapper::AddSoundUnmuteDirective() {
    NAlice::NScenarios::TSoundUnmuteDirective directive;
    directive.SetName("sound_unmute_directive");
    AddSoundUnmuteDirective(std::move(directive));
}
void TDirectivesWrapper::AddStartMusicRecognizerDirective() {
    NAlice::NScenarios::TStartMusicRecognizerDirective directive;
    directive.SetName("start_music_recognizer_directive");
    AddStartMusicRecognizerDirective(std::move(directive));
}
void TDirectivesWrapper::AddAlarmResetSoundDirective() {
    NAlice::NScenarios::TAlarmResetSoundDirective directive;
    directive.SetName("alarm_reset_sound_directive");
    AddAlarmResetSoundDirective(std::move(directive));
}
void TDirectivesWrapper::AddShowAlarmsDirective() {
    NAlice::NScenarios::TShowAlarmsDirective directive;
    directive.SetName("show_alarms_directive");
    AddShowAlarmsDirective(std::move(directive));
}
void TDirectivesWrapper::AddShowTimersDirective() {
    NAlice::NScenarios::TShowTimersDirective directive;
    directive.SetName("show_timers_directive");
    AddShowTimersDirective(std::move(directive));
}
void TDirectivesWrapper::AddStopBluetoothDirective() {
    NAlice::NScenarios::TStopBluetoothDirective directive;
    directive.SetName("stop_bluetooth_directive");
    AddStopBluetoothDirective(std::move(directive));
}
void TDirectivesWrapper::AddStartBluetoothDirective() {
    NAlice::NScenarios::TStartBluetoothDirective directive;
    directive.SetName("start_bluetooth_directive");
    AddStartBluetoothDirective(std::move(directive));
}
void TDirectivesWrapper::AddReadPageDirective() {
    NAlice::NScenarios::TReadPageDirective directive;
    directive.SetName("read_page_directive");
    AddReadPageDirective(std::move(directive));
}
void TDirectivesWrapper::AddReadPagePauseDirective() {
    NAlice::NScenarios::TReadPagePauseDirective directive;
    directive.SetName("read_page_pause_directive");
    AddReadPagePauseDirective(std::move(directive));
}
void TDirectivesWrapper::AddReadPageContinueDirective() {
    NAlice::NScenarios::TReadPageContinueDirective directive;
    directive.SetName("read_page_continue_directive");
    AddReadPageContinueDirective(std::move(directive));
}
void TDirectivesWrapper::AddPowerOffDirective() {
    NAlice::NScenarios::TPowerOffDirective directive;
    directive.SetName("power_off_directive");
    AddPowerOffDirective(std::move(directive));
}
void TDirectivesWrapper::AddHibernateDirective() {
    NAlice::NScenarios::THibernateDirective directive;
    directive.SetName("hibernate_directive");
    AddHibernateDirective(std::move(directive));
}
void TDirectivesWrapper::AddRestartPcDirective() {
    NAlice::NScenarios::TRestartPcDirective directive;
    directive.SetName("restart_pc_directive");
    AddRestartPcDirective(std::move(directive));
}
void TDirectivesWrapper::AddMuteDirective() {
    NAlice::NScenarios::TMuteDirective directive;
    directive.SetName("mute_directive");
    AddMuteDirective(std::move(directive));
}
void TDirectivesWrapper::AddUnmuteDirective() {
    NAlice::NScenarios::TUnmuteDirective directive;
    directive.SetName("unmute_directive");
    AddUnmuteDirective(std::move(directive));
}
void TDirectivesWrapper::AddOpenDefaultBrowserDirective() {
    NAlice::NScenarios::TOpenDefaultBrowserDirective directive;
    directive.SetName("open_default_browser_directive");
    AddOpenDefaultBrowserDirective(std::move(directive));
}
void TDirectivesWrapper::AddOpenYaBrowserDirective() {
    NAlice::NScenarios::TOpenYaBrowserDirective directive;
    directive.SetName("open_ya_browser_directive");
    AddOpenYaBrowserDirective(std::move(directive));
}
void TDirectivesWrapper::AddOpenFlashCardDirective() {
    NAlice::NScenarios::TOpenFlashCardDirective directive;
    directive.SetName("open_flash_card_directive");
    AddOpenFlashCardDirective(std::move(directive));
}
void TDirectivesWrapper::AddOpenStartDirective() {
    NAlice::NScenarios::TOpenStartDirective directive;
    directive.SetName("open_start_directive");
    AddOpenStartDirective(std::move(directive));
}
void TDirectivesWrapper::AddGoForwardDirective() {
    NAlice::NScenarios::TGoForwardDirective directive;
    directive.SetName("go_forward_directive");
    AddGoForwardDirective(std::move(directive));
}
void TDirectivesWrapper::AddGoToTheBeginningDirective() {
    NAlice::NScenarios::TGoToTheBeginningDirective directive;
    directive.SetName("go_to_the_beginning_directive");
    AddGoToTheBeginningDirective(std::move(directive));
}
void TDirectivesWrapper::AddGoToTheEndDirective() {
    NAlice::NScenarios::TGoToTheEndDirective directive;
    directive.SetName("go_to_the_end_directive");
    AddGoToTheEndDirective(std::move(directive));
}
void TDirectivesWrapper::AddGoHomeDirective() {
    NAlice::NScenarios::TGoHomeDirective directive;
    directive.SetName("go_home_directive");
    AddGoHomeDirective(std::move(directive));
}
void TDirectivesWrapper::AddGoDownDirective() {
    NAlice::NScenarios::TGoDownDirective directive;
    directive.SetName("go_down_directive");
    AddGoDownDirective(std::move(directive));
}
void TDirectivesWrapper::AddGoTopDirective() {
    NAlice::NScenarios::TGoTopDirective directive;
    directive.SetName("go_top_directive");
    AddGoTopDirective(std::move(directive));
}
void TDirectivesWrapper::AddGoUpDirective() {
    NAlice::NScenarios::TGoUpDirective directive;
    directive.SetName("go_up_directive");
    AddGoUpDirective(std::move(directive));
}
void TDirectivesWrapper::AddScreenOffDirective() {
    NAlice::NScenarios::TScreenOffDirective directive;
    directive.SetName("screen_off_directive");
    AddScreenOffDirective(std::move(directive));
}
void TDirectivesWrapper::AddAlarmStopDirective() {
    NAlice::NScenarios::TAlarmStopDirective directive;
    directive.SetName("alarm_stop_directive");
    AddAlarmStopDirective(std::move(directive));
}
void TDirectivesWrapper::AddShowVideoSettingsDirective() {
    NAlice::NScenarios::TShowVideoSettingsDirective directive;
    directive.SetName("show_video_settings_directive");
    AddShowVideoSettingsDirective(std::move(directive));
}
void TDirectivesWrapper::AddStopBroadcastDirective() {
    NAlice::NScenarios::TStopBroadcastDirective directive;
    directive.SetName("stop_broadcast_directive");
    AddStopBroadcastDirective(std::move(directive));
}
void TDirectivesWrapper::AddSetupRcuDirective() {
    NAlice::NScenarios::TSetupRcuDirective directive;
    directive.SetName("setup_rcu_directive");
    AddSetupRcuDirective(std::move(directive));
}
void TDirectivesWrapper::AddSetupRcuCheckDirective() {
    NAlice::NScenarios::TSetupRcuCheckDirective directive;
    directive.SetName("setup_rcu_check_directive");
    AddSetupRcuCheckDirective(std::move(directive));
}
void TDirectivesWrapper::AddSetupRcuManualDirective() {
    NAlice::NScenarios::TSetupRcuManualDirective directive;
    directive.SetName("setup_rcu_manual_directive");
    AddSetupRcuManualDirective(std::move(directive));
}
void TDirectivesWrapper::AddSetupRcuAdvancedDirective() {
    NAlice::NScenarios::TSetupRcuAdvancedDirective directive;
    directive.SetName("setup_rcu_advanced_directive");
    AddSetupRcuAdvancedDirective(std::move(directive));
}
void TDirectivesWrapper::AddForceDisplayCardsDirective() {
    NAlice::NScenarios::TForceDisplayCardsDirective directive;
    directive.SetName("force_display_cards_directive");
    AddForceDisplayCardsDirective(std::move(directive));
}
void TDirectivesWrapper::AddScreenOnDirective() {
    NAlice::NScenarios::TScreenOnDirective directive;
    directive.SetName("screen_on_directive");
    AddScreenOnDirective(std::move(directive));
}
void TDirectivesWrapper::AddIoTDiscoveryStopDirective() {
    NAlice::NScenarios::TIoTDiscoveryStopDirective directive;
    directive.SetName("io_tdiscovery_stop_directive");
    AddIoTDiscoveryStopDirective(std::move(directive));
}
void TDirectivesWrapper::AddClearQueueDirective() {
    NAlice::NScenarios::TClearQueueDirective directive;
    directive.SetName("clear_queue_directive");
    AddClearQueueDirective(std::move(directive));
}
void TDirectivesWrapper::AddSuccessStartingOnboardingDirective() {
    NAlice::NScenarios::TSuccessStartingOnboardingDirective directive;
    directive.SetName("success_starting_onboarding_directive");
    AddSuccessStartingOnboardingDirective(std::move(directive));
}
void TDirectivesWrapper::AddShowLoginDirective() {
    NAlice::NScenarios::TShowLoginDirective directive;
    directive.SetName("show_login_directive");
    AddShowLoginDirective(std::move(directive));
}
void TDirectivesWrapper::AddShowPlusPurchaseDirective() {
    NAlice::NScenarios::TShowPlusPurchaseDirective directive;
    directive.SetName("show_plus_purchase_directive");
    AddShowPlusPurchaseDirective(std::move(directive));
}
void TDirectivesWrapper::AddShowPlusPromoDirective() {
    NAlice::NScenarios::TShowPlusPromoDirective directive;
    directive.SetName("show_plus_promo_directive");
    AddShowPlusPromoDirective(std::move(directive));
}
void TDirectivesWrapper::AddFindRcuDirective() {
    NAlice::NScenarios::TFindRcuDirective directive;
    directive.SetName("find_rcu_directive");
    AddFindRcuDirective(std::move(directive));
}
void TDirectivesWrapper::AddShowClockDirective() {
    NAlice::NScenarios::TShowClockDirective directive;
    directive.SetName("show_clock_directive");
    AddShowClockDirective(std::move(directive));
}
void TDirectivesWrapper::AddHideClockDirective() {
    NAlice::NScenarios::THideClockDirective directive;
    directive.SetName("hide_clock_directive");
    AddHideClockDirective(std::move(directive));
}
void TDirectivesWrapper::AddDoNotDisturbOnDirective() {
    NAlice::NScenarios::TDoNotDisturbOnDirective directive;
    directive.SetName("do_not_disturb_on_directive");
    AddDoNotDisturbOnDirective(std::move(directive));
}
void TDirectivesWrapper::AddDoNotDisturbOffDirective() {
    NAlice::NScenarios::TDoNotDisturbOffDirective directive;
    directive.SetName("do_not_disturb_off_directive");
    AddDoNotDisturbOffDirective(std::move(directive));
}
void TDirectivesWrapper::AddStopMoveLevelDirective() {
    NAlice::TLevelCapability_TStopMoveLevelDirective directive;
    directive.SetName("stop_move_level_directive");
    AddStopMoveLevelDirective(std::move(directive));
}
void TDirectivesWrapper::AddIotCancelDiscoveryDirective() {
    NAlice::TIotDiscoveryCapability_TCancelDiscoveryDirective directive;
    directive.SetName("iot_cancel_discovery_directive");
    AddIotCancelDiscoveryDirective(std::move(directive));
}
void TDirectivesWrapper::AddRouteManagerStartDirective() {
    NAlice::TRouteManagerCapability_TStartDirective directive;
    directive.SetName("route_manager_start_directive");
    AddRouteManagerStartDirective(std::move(directive));
}
void TDirectivesWrapper::AddRouteManagerStopDirective() {
    NAlice::TRouteManagerCapability_TStopDirective directive;
    directive.SetName("route_manager_stop_directive");
    AddRouteManagerStopDirective(std::move(directive));
}
void TDirectivesWrapper::AddRouteManagerShowDirective() {
    NAlice::TRouteManagerCapability_TShowDirective directive;
    directive.SetName("route_manager_show_directive");
    AddRouteManagerShowDirective(std::move(directive));
}
void TDirectivesWrapper::AddRouteManagerContinueDirective() {
    NAlice::TRouteManagerCapability_TContinueDirective directive;
    directive.SetName("route_manager_continue_directive");
    AddRouteManagerContinueDirective(std::move(directive));
}
void TDirectivesWrapper::AddOpenScreensaverDirective() {
    NAlice::NScenarios::TOpenScreensaverDirective directive;
    directive.SetName("open_screensaver_directive");
    AddOpenScreensaverDirective(std::move(directive));
}
void TDirectivesWrapper::AddShowPromoDirective() {
    NAlice::NScenarios::TShowPromoDirective directive;
    directive.SetName("show_promo_directive");
    AddShowPromoDirective(std::move(directive));
}
/*
    Full access
*/
void TDirectivesWrapper::AddCallbackDirective(NAlice::NScenarios::TCallbackDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TCallbackDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableCallbackDirective, "callback_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddOpenDialogDirective(NAlice::NScenarios::TOpenDialogDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TOpenDialogDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableOpenDialogDirective, "open_dialog_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddUpdateDialogInfoDirective(NAlice::NScenarios::TUpdateDialogInfoDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TUpdateDialogInfoDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableUpdateDialogInfoDirective, "update_dialog_info_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddOpenUriDirective(NAlice::NScenarios::TOpenUriDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TOpenUriDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableOpenUriDirective, "open_uri_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddEndDialogSessionDirective(NAlice::NScenarios::TEndDialogSessionDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TEndDialogSessionDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableEndDialogSessionDirective, "end_dialog_session_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddTypeTextDirective(NAlice::NScenarios::TTypeTextDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TTypeTextDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableTypeTextDirective, "type_text_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddTypeTextSilentDirective(NAlice::NScenarios::TTypeTextSilentDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TTypeTextSilentDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableTypeTextSilentDirective, "type_text_silent_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddCloseDialogDirective(NAlice::NScenarios::TCloseDialogDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TCloseDialogDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableCloseDialogDirective, "close_dialog_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddStartImageRecognizerDirective(NAlice::NScenarios::TStartImageRecognizerDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TStartImageRecognizerDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableStartImageRecognizerDirective, "start_image_recognizer_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddThereminPlayDirective(NAlice::NScenarios::TThereminPlayDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TThereminPlayDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableThereminPlayDirective, "theremin_play_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddMordoviaShowDirective(NAlice::NScenarios::TMordoviaShowDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TMordoviaShowDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableMordoviaShowDirective, "mordovia_show_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddMordoviaCommandDirective(NAlice::NScenarios::TMordoviaCommandDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TMordoviaCommandDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableMordoviaCommandDirective, "mordovia_command_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddMusicPlayDirective(NAlice::NScenarios::TMusicPlayDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TMusicPlayDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableMusicPlayDirective, "music_play_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddSoundSetLevelDirective(NAlice::NScenarios::TSoundSetLevelDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TSoundSetLevelDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableSoundSetLevelDirective, "sound_set_level_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddCarDirective(NAlice::NScenarios::TCarDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TCarDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableCarDirective, "car_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddYandexNaviDirective(NAlice::NScenarios::TYandexNaviDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TYandexNaviDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableYandexNaviDirective, "yandex_navi_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddPlayerNextTrackDirective(NAlice::NScenarios::TPlayerNextTrackDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TPlayerNextTrackDirective>>(
        std::move(directive), &NScenarios::TDirective::MutablePlayerNextTrackDirective, "player_next_track_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddPlayerPreviousTrackDirective(NAlice::NScenarios::TPlayerPreviousTrackDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TPlayerPreviousTrackDirective>>(
        std::move(directive), &NScenarios::TDirective::MutablePlayerPreviousTrackDirective, "player_previous_track_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddPlayerPauseDirective(NAlice::NScenarios::TPlayerPauseDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TPlayerPauseDirective>>(
        std::move(directive), &NScenarios::TDirective::MutablePlayerPauseDirective, "player_pause_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddPlayerContinueDirective(NAlice::NScenarios::TPlayerContinueDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TPlayerContinueDirective>>(
        std::move(directive), &NScenarios::TDirective::MutablePlayerContinueDirective, "player_continue_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddPlayerLikeDirective(NAlice::NScenarios::TPlayerLikeDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TPlayerLikeDirective>>(
        std::move(directive), &NScenarios::TDirective::MutablePlayerLikeDirective, "player_like_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddPlayerDislikeDirective(NAlice::NScenarios::TPlayerDislikeDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TPlayerDislikeDirective>>(
        std::move(directive), &NScenarios::TDirective::MutablePlayerDislikeDirective, "player_dislike_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddPlayerShuffleDirective(NAlice::NScenarios::TPlayerShuffleDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TPlayerShuffleDirective>>(
        std::move(directive), &NScenarios::TDirective::MutablePlayerShuffleDirective, "player_shuffle_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddPlayerOrderDirective(NAlice::NScenarios::TPlayerOrderDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TPlayerOrderDirective>>(
        std::move(directive), &NScenarios::TDirective::MutablePlayerOrderDirective, "player_order_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddPlayerReplayDirective(NAlice::NScenarios::TPlayerReplayDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TPlayerReplayDirective>>(
        std::move(directive), &NScenarios::TDirective::MutablePlayerReplayDirective, "player_replay_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddPlayerRepeatDirective(NAlice::NScenarios::TPlayerRepeatDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TPlayerRepeatDirective>>(
        std::move(directive), &NScenarios::TDirective::MutablePlayerRepeatDirective, "player_repeat_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddPlayerRewindDirective(NAlice::NScenarios::TPlayerRewindDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TPlayerRewindDirective>>(
        std::move(directive), &NScenarios::TDirective::MutablePlayerRewindDirective, "player_rewind_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddSoundQuiterDirective(NAlice::NScenarios::TSoundQuiterDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TSoundQuiterDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableSoundQuiterDirective, "sound_quiter_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddSoundLouderDirective(NAlice::NScenarios::TSoundLouderDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TSoundLouderDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableSoundLouderDirective, "sound_louder_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddSoundMuteDirective(NAlice::NScenarios::TSoundMuteDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TSoundMuteDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableSoundMuteDirective, "sound_mute_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddSoundUnmuteDirective(NAlice::NScenarios::TSoundUnmuteDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TSoundUnmuteDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableSoundUnmuteDirective, "sound_unmute_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddStartMusicRecognizerDirective(NAlice::NScenarios::TStartMusicRecognizerDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TStartMusicRecognizerDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableStartMusicRecognizerDirective, "start_music_recognizer_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddAlarmSetSoundDirective(NAlice::NScenarios::TAlarmSetSoundDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TAlarmSetSoundDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableAlarmSetSoundDirective, "alarm_set_sound_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddAlarmResetSoundDirective(NAlice::NScenarios::TAlarmResetSoundDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TAlarmResetSoundDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableAlarmResetSoundDirective, "alarm_reset_sound_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddAlarmNewDirective(NAlice::NScenarios::TAlarmNewDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TAlarmNewDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableAlarmNewDirective, "alarm_new_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddShowAlarmsDirective(NAlice::NScenarios::TShowAlarmsDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TShowAlarmsDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableShowAlarmsDirective, "show_alarms_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddShowTimersDirective(NAlice::NScenarios::TShowTimersDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TShowTimersDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableShowTimersDirective, "show_timers_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddFindContactsDirective(NAlice::NScenarios::TFindContactsDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TFindContactsDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableFindContactsDirective, "find_contacts_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddSetCookiesDirective(NAlice::NScenarios::TSetCookiesDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TSetCookiesDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableSetCookiesDirective, "set_cookies_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddSetSearchFilterDirective(NAlice::NScenarios::TSetSearchFilterDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TSetSearchFilterDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableSetSearchFilterDirective, "set_search_filter_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddAlarmsUpdateDirective(NAlice::NScenarios::TAlarmsUpdateDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TAlarmsUpdateDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableAlarmsUpdateDirective, "alarms_update_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddResumeTimerDirective(NAlice::NScenarios::TResumeTimerDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TResumeTimerDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableResumeTimerDirective, "resume_timer_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddCancelTimerDirective(NAlice::NScenarios::TCancelTimerDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TCancelTimerDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableCancelTimerDirective, "cancel_timer_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddSetTimerDirective(NAlice::NScenarios::TSetTimerDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TSetTimerDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableSetTimerDirective, "set_timer_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddStopBluetoothDirective(NAlice::NScenarios::TStopBluetoothDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TStopBluetoothDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableStopBluetoothDirective, "stop_bluetooth_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddStartBluetoothDirective(NAlice::NScenarios::TStartBluetoothDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TStartBluetoothDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableStartBluetoothDirective, "start_bluetooth_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddReadPageDirective(NAlice::NScenarios::TReadPageDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TReadPageDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableReadPageDirective, "read_page_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddReadPagePauseDirective(NAlice::NScenarios::TReadPagePauseDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TReadPagePauseDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableReadPagePauseDirective, "read_page_pause_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddReadPageContinueDirective(NAlice::NScenarios::TReadPageContinueDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TReadPageContinueDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableReadPageContinueDirective, "read_page_continue_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddSearchLocalDirective(NAlice::NScenarios::TSearchLocalDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TSearchLocalDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableSearchLocalDirective, "search_local_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddOpenFolderDirective(NAlice::NScenarios::TOpenFolderDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TOpenFolderDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableOpenFolderDirective, "open_folder_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddOpenFileDirective(NAlice::NScenarios::TOpenFileDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TOpenFileDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableOpenFileDirective, "open_file_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddOpenSoftDirective(NAlice::NScenarios::TOpenSoftDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TOpenSoftDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableOpenSoftDirective, "open_soft_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddPowerOffDirective(NAlice::NScenarios::TPowerOffDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TPowerOffDirective>>(
        std::move(directive), &NScenarios::TDirective::MutablePowerOffDirective, "power_off_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddHibernateDirective(NAlice::NScenarios::THibernateDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::THibernateDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableHibernateDirective, "hibernate_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddRestartPcDirective(NAlice::NScenarios::TRestartPcDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TRestartPcDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableRestartPcDirective, "restart_pc_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddMuteDirective(NAlice::NScenarios::TMuteDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TMuteDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableMuteDirective, "mute_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddUnmuteDirective(NAlice::NScenarios::TUnmuteDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TUnmuteDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableUnmuteDirective, "unmute_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddOpenDefaultBrowserDirective(NAlice::NScenarios::TOpenDefaultBrowserDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TOpenDefaultBrowserDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableOpenDefaultBrowserDirective, "open_default_browser_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddOpenYaBrowserDirective(NAlice::NScenarios::TOpenYaBrowserDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TOpenYaBrowserDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableOpenYaBrowserDirective, "open_ya_browser_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddOpenFlashCardDirective(NAlice::NScenarios::TOpenFlashCardDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TOpenFlashCardDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableOpenFlashCardDirective, "open_flash_card_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddOpenStartDirective(NAlice::NScenarios::TOpenStartDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TOpenStartDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableOpenStartDirective, "open_start_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddOpenDiskDirective(NAlice::NScenarios::TOpenDiskDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TOpenDiskDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableOpenDiskDirective, "open_disk_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddOpenSettingsDirective(NAlice::NScenarios::TOpenSettingsDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TOpenSettingsDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableOpenSettingsDirective, "open_settings_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddGoForwardDirective(NAlice::NScenarios::TGoForwardDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TGoForwardDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableGoForwardDirective, "go_forward_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddGoBackwardDirective(NAlice::NScenarios::TGoBackwardDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TGoBackwardDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableGoBackwardDirective, "go_backward_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddGoToTheBeginningDirective(NAlice::NScenarios::TGoToTheBeginningDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TGoToTheBeginningDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableGoToTheBeginningDirective, "go_to_the_beginning_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddGoToTheEndDirective(NAlice::NScenarios::TGoToTheEndDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TGoToTheEndDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableGoToTheEndDirective, "go_to_the_end_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddGoHomeDirective(NAlice::NScenarios::TGoHomeDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TGoHomeDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableGoHomeDirective, "go_home_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddShowVideoDescriptionDirective(NAlice::NScenarios::TShowVideoDescriptionDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TShowVideoDescriptionDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableShowVideoDescriptionDirective, "show_video_description_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddVideoPlayDirective(NAlice::NScenarios::TVideoPlayDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TVideoPlayDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableVideoPlayDirective, "video_play_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddShowGalleryDirective(NAlice::NScenarios::TShowGalleryDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TShowGalleryDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableShowGalleryDirective, "show_gallery_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddShowPayPushScreenDirective(NAlice::NScenarios::TShowPayPushScreenDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TShowPayPushScreenDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableShowPayPushScreenDirective, "show_pay_push_screen_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddShowSeasonGalleryDirective(NAlice::NScenarios::TShowSeasonGalleryDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TShowSeasonGalleryDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableShowSeasonGalleryDirective, "show_season_gallery_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddPauseTimerDirective(NAlice::NScenarios::TPauseTimerDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TPauseTimerDirective>>(
        std::move(directive), &NScenarios::TDirective::MutablePauseTimerDirective, "pause_timer_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddTimerStopPlayingDirective(NAlice::NScenarios::TTimerStopPlayingDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TTimerStopPlayingDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableTimerStopPlayingDirective, "timer_stop_playing_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddNavigateBrowserDirective(NAlice::NScenarios::TNavigateBrowserDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TNavigateBrowserDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableNavigateBrowserDirective, "navigate_browser_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddRadioPlayDirective(NAlice::NScenarios::TRadioPlayDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TRadioPlayDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableRadioPlayDirective, "radio_play_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddGoDownDirective(NAlice::NScenarios::TGoDownDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TGoDownDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableGoDownDirective, "go_down_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddGoTopDirective(NAlice::NScenarios::TGoTopDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TGoTopDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableGoTopDirective, "go_top_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddGoUpDirective(NAlice::NScenarios::TGoUpDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TGoUpDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableGoUpDirective, "go_up_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddScreenOffDirective(NAlice::NScenarios::TScreenOffDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TScreenOffDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableScreenOffDirective, "screen_off_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddShowTvGalleryDirective(NAlice::NScenarios::TShowTvGalleryDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TShowTvGalleryDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableShowTvGalleryDirective, "show_tv_gallery_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddAlarmStopDirective(NAlice::NScenarios::TAlarmStopDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TAlarmStopDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableAlarmStopDirective, "alarm_stop_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddAlarmSetMaxLevelDirective(NAlice::NScenarios::TAlarmSetMaxLevelDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TAlarmSetMaxLevelDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableAlarmSetMaxLevelDirective, "alarm_set_max_level_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddMusicRecognitionDirective(NAlice::NScenarios::TMusicRecognitionDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TMusicRecognitionDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableMusicRecognitionDirective, "music_recognition_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddMessengerCallDirective(NAlice::NScenarios::TMessengerCallDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TMessengerCallDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableMessengerCallDirective, "messenger_call_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddSaveVoiceprintDirective(NAlice::NScenarios::TSaveVoiceprintDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TSaveVoiceprintDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableSaveVoiceprintDirective, "save_voiceprint_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddAudioPlayDirective(NAlice::NScenarios::TAudioPlayDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TAudioPlayDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableAudioPlayDirective, "audio_play_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddAudioStopDirective(NAlice::NScenarios::TAudioStopDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TAudioStopDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableAudioStopDirective, "audio_stop_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddRemoveVoiceprintDirective(NAlice::NScenarios::TRemoveVoiceprintDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TRemoveVoiceprintDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableRemoveVoiceprintDirective, "remove_voiceprint_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddChangeAudioDirective(NAlice::NScenarios::TChangeAudioDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TChangeAudioDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableChangeAudioDirective, "change_audio_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddChangeSubtitlesDirective(NAlice::NScenarios::TChangeSubtitlesDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TChangeSubtitlesDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableChangeSubtitlesDirective, "change_subtitles_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddDrawLedScreenDirective(NAlice::NScenarios::TDrawLedScreenDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TDrawLedScreenDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableDrawLedScreenDirective, "draw_led_screen_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddSendBugReportDirective(NAlice::NScenarios::TSendBugReportDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TSendBugReportDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableSendBugReportDirective, "send_bug_report_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddAudioRewindDirective(NAlice::NScenarios::TAudioRewindDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TAudioRewindDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableAudioRewindDirective, "audio_rewind_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddNotifyDirective(NAlice::NScenarios::TNotifyDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TNotifyDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableNotifyDirective, "notify_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddUpdateNotificationSubscriptionDirective(NAlice::NScenarios::TUpdateNotificationSubscriptionDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TUpdateNotificationSubscriptionDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableUpdateNotificationSubscriptionDirective, "update_notification_subscription_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddStartMultiroomDirective(NAlice::NScenarios::TStartMultiroomDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TStartMultiroomDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableStartMultiroomDirective, "start_multiroom_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddMarkNotificationAsReadDirective(NAlice::NScenarios::TMarkNotificationAsReadDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TMarkNotificationAsReadDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableMarkNotificationAsReadDirective, "mark_notification_as_read_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddShowVideoSettingsDirective(NAlice::NScenarios::TShowVideoSettingsDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TShowVideoSettingsDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableShowVideoSettingsDirective, "show_video_settings_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddStartBroadcastDirective(NAlice::NScenarios::TStartBroadcastDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TStartBroadcastDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableStartBroadcastDirective, "start_broadcast_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddStopBroadcastDirective(NAlice::NScenarios::TStopBroadcastDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TStopBroadcastDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableStopBroadcastDirective, "stop_broadcast_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddTtsPlayPlaceholderDirective(NAlice::NScenarios::TTtsPlayPlaceholderDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TTtsPlayPlaceholderDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableTtsPlayPlaceholderDirective, "tts_play_placeholder_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddSetupRcuDirective(NAlice::NScenarios::TSetupRcuDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TSetupRcuDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableSetupRcuDirective, "setup_rcu_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddSetupRcuAutoDirective(NAlice::NScenarios::TSetupRcuAutoDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TSetupRcuAutoDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableSetupRcuAutoDirective, "setup_rcu_auto_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddSetupRcuCheckDirective(NAlice::NScenarios::TSetupRcuCheckDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TSetupRcuCheckDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableSetupRcuCheckDirective, "setup_rcu_check_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddSetupRcuManualDirective(NAlice::NScenarios::TSetupRcuManualDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TSetupRcuManualDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableSetupRcuManualDirective, "setup_rcu_manual_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddSetupRcuAdvancedDirective(NAlice::NScenarios::TSetupRcuAdvancedDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TSetupRcuAdvancedDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableSetupRcuAdvancedDirective, "setup_rcu_advanced_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddForceDisplayCardsDirective(NAlice::NScenarios::TForceDisplayCardsDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TForceDisplayCardsDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableForceDisplayCardsDirective, "force_display_cards_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddScreenOnDirective(NAlice::NScenarios::TScreenOnDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TScreenOnDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableScreenOnDirective, "screen_on_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddIoTDiscoveryStartDirective(NAlice::NScenarios::TIoTDiscoveryStartDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TIoTDiscoveryStartDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableIoTDiscoveryStartDirective, "io_tdiscovery_start_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddIoTDiscoveryCredentialsDirective(NAlice::NScenarios::TIoTDiscoveryCredentialsDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TIoTDiscoveryCredentialsDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableIoTDiscoveryCredentialsDirective, "io_tdiscovery_credentials_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddIoTDiscoveryStopDirective(NAlice::NScenarios::TIoTDiscoveryStopDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TIoTDiscoveryStopDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableIoTDiscoveryStopDirective, "io_tdiscovery_stop_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddClearQueueDirective(NAlice::NScenarios::TClearQueueDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TClearQueueDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableClearQueueDirective, "clear_queue_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddSuccessStartingOnboardingDirective(NAlice::NScenarios::TSuccessStartingOnboardingDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TSuccessStartingOnboardingDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableSuccessStartingOnboardingDirective, "success_starting_onboarding_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddAddCardDirective(NAlice::NScenarios::TAddCardDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TAddCardDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableAddCardDirective, "add_card_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddRotateCardsDirective(NAlice::NScenarios::TRotateCardsDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TRotateCardsDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableRotateCardsDirective, "rotate_cards_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddListenDirective(NAlice::NScenarios::TListenDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TListenDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableListenDirective, "listen_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddShowViewDirective(NAlice::NScenarios::TShowViewDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TShowViewDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableShowViewDirective, "show_view_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddSetMainScreenDirective(NAlice::NScenarios::TSetMainScreenDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TSetMainScreenDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableSetMainScreenDirective, "set_main_screen_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddShowLoginDirective(NAlice::NScenarios::TShowLoginDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TShowLoginDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableShowLoginDirective, "show_login_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddShowPlusPurchaseDirective(NAlice::NScenarios::TShowPlusPurchaseDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TShowPlusPurchaseDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableShowPlusPurchaseDirective, "show_plus_purchase_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddShowPlusPromoDirective(NAlice::NScenarios::TShowPlusPromoDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TShowPlusPromoDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableShowPlusPromoDirective, "show_plus_promo_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddSetSmartTvCategoriesDirective(NAlice::NScenarios::TSetSmartTvCategoriesDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TSetSmartTvCategoriesDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableSetSmartTvCategoriesDirective, "set_smart_tv_categories_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddTvOpenSearchScreenDirective(NAlice::NScenarios::TTvOpenSearchScreenDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TTvOpenSearchScreenDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableTvOpenSearchScreenDirective, "tv_open_search_screen_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddTvOpenDetailsScreenDirective(NAlice::NScenarios::TTvOpenDetailsScreenDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TTvOpenDetailsScreenDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableTvOpenDetailsScreenDirective, "tv_open_details_screen_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddTvOpenSeriesScreenDirective(NAlice::NScenarios::TTvOpenSeriesScreenDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TTvOpenSeriesScreenDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableTvOpenSeriesScreenDirective, "tv_open_series_screen_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddTvOpenPersonScreenDirective(NAlice::NScenarios::TTvOpenPersonScreenDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TTvOpenPersonScreenDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableTvOpenPersonScreenDirective, "tv_open_person_screen_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddTvOpenCollectionScreenDirective(NAlice::NScenarios::TTvOpenCollectionScreenDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TTvOpenCollectionScreenDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableTvOpenCollectionScreenDirective, "tv_open_collection_screen_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddShowButtonsDirective(NAlice::NScenarios::TShowButtonsDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TShowButtonsDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableShowButtonsDirective, "show_buttons_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddSetGlagolMetadataDirective(NAlice::NScenarios::TSetGlagolMetadataDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TSetGlagolMetadataDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableSetGlagolMetadataDirective, "set_glagol_metadata_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddFindRcuDirective(NAlice::NScenarios::TFindRcuDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TFindRcuDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableFindRcuDirective, "find_rcu_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddRemindersCancelDirective(NAlice::NScenarios::TRemindersCancelDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TRemindersCancelDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableRemindersCancelDirective, "reminders_cancel_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddRequestPermissionsDirective(NAlice::NScenarios::TRequestPermissionsDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TRequestPermissionsDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableRequestPermissionsDirective, "request_permissions_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddRemindersSetDirective(NAlice::NScenarios::TRemindersSetDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TRemindersSetDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableRemindersSetDirective, "reminders_set_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddTvSetCarouselsDirective(NAlice::NScenarios::TTvSetCarouselsDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TTvSetCarouselsDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableTvSetCarouselsDirective, "tv_set_carousels_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddTvSetSingleCarouselDirective(NAlice::NScenarios::TTvSetSingleCarouselDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TTvSetSingleCarouselDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableTvSetSingleCarouselDirective, "tv_set_single_carousel_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddSendAndroidAppIntentDirective(NAlice::NScenarios::TSendAndroidAppIntentDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TSendAndroidAppIntentDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableSendAndroidAppIntentDirective, "send_android_app_intent_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddDrawScledAnimationsDirective(NAlice::NScenarios::TDrawScledAnimationsDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TDrawScledAnimationsDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableDrawScledAnimationsDirective, "draw_scled_animations_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddStopMultiroomDirective(NAlice::NScenarios::TStopMultiroomDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TStopMultiroomDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableStopMultiroomDirective, "stop_multiroom_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddShowClockDirective(NAlice::NScenarios::TShowClockDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TShowClockDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableShowClockDirective, "show_clock_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddHideClockDirective(NAlice::NScenarios::THideClockDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::THideClockDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableHideClockDirective, "hide_clock_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddFillCloudUiDirective(NAlice::NScenarios::TFillCloudUiDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TFillCloudUiDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableFillCloudUiDirective, "fill_cloud_ui_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddOnOffDirective(NAlice::TOnOffCapability_TOnOffDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::TOnOffCapability_TOnOffDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableOnOffDirective, "on_off_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddIotStartDiscoveryDirective(NAlice::TIotDiscoveryCapability_TStartDiscoveryDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::TIotDiscoveryCapability_TStartDiscoveryDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableIotStartDiscoveryDirective, "iot_start_discovery_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddIotFinishDiscoveryDirective(NAlice::TIotDiscoveryCapability_TFinishDiscoveryDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::TIotDiscoveryCapability_TFinishDiscoveryDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableIotFinishDiscoveryDirective, "iot_finish_discovery_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddIotForgetDevicesDirective(NAlice::TIotDiscoveryCapability_TForgetDevicesDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::TIotDiscoveryCapability_TForgetDevicesDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableIotForgetDevicesDirective, "iot_forget_devices_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddDoNotDisturbOnDirective(NAlice::NScenarios::TDoNotDisturbOnDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TDoNotDisturbOnDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableDoNotDisturbOnDirective, "do_not_disturb_on_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddDoNotDisturbOffDirective(NAlice::NScenarios::TDoNotDisturbOffDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TDoNotDisturbOffDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableDoNotDisturbOffDirective, "do_not_disturb_off_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddSetUpperShutterDirective(NAlice::NScenarios::TSetUpperShutterDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TSetUpperShutterDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableSetUpperShutterDirective, "set_upper_shutter_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddSetAbsoluteLevelDirective(NAlice::TLevelCapability_TSetAbsoluteLevelDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::TLevelCapability_TSetAbsoluteLevelDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableSetAbsoluteLevelDirective, "set_absolute_level_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddSetRelativeLevelDirective(NAlice::TLevelCapability_TSetRelativeLevelDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::TLevelCapability_TSetRelativeLevelDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableSetRelativeLevelDirective, "set_relative_level_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddStartMoveLevelDirective(NAlice::TLevelCapability_TStartMoveLevelDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::TLevelCapability_TStartMoveLevelDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableStartMoveLevelDirective, "start_move_level_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddStopMoveLevelDirective(NAlice::TLevelCapability_TStopMoveLevelDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::TLevelCapability_TStopMoveLevelDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableStopMoveLevelDirective, "stop_move_level_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddEnrollmentStartDirective(NAlice::NScenarios::TEnrollmentStartDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TEnrollmentStartDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableEnrollmentStartDirective, "enrollment_start_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddEnrollmentCancelDirective(NAlice::NScenarios::TEnrollmentCancelDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TEnrollmentCancelDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableEnrollmentCancelDirective, "enrollment_cancel_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddEnrollmentFinishDirective(NAlice::NScenarios::TEnrollmentFinishDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TEnrollmentFinishDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableEnrollmentFinishDirective, "enrollment_finish_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddSetColorSceneDirective(NAlice::TColorCapability_TSetColorSceneDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::TColorCapability_TSetColorSceneDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableSetColorSceneDirective, "set_color_scene_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddWebOSLaunchAppDirective(NAlice::TWebOSCapability_TWebOSLaunchAppDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::TWebOSCapability_TWebOSLaunchAppDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableWebOSLaunchAppDirective, "web_oslaunch_app_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddWebOSShowGalleryDirective(NAlice::TWebOSCapability_TWebOSShowGalleryDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::TWebOSCapability_TWebOSShowGalleryDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableWebOSShowGalleryDirective, "web_osshow_gallery_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddIotStartTuyaBroadcastDirective(NAlice::TIotDiscoveryCapability_TStartTuyaBroadcastDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::TIotDiscoveryCapability_TStartTuyaBroadcastDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableIotStartTuyaBroadcastDirective, "iot_start_tuya_broadcast_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddIotRestoreNetworksDirective(NAlice::TIotDiscoveryCapability_TRestoreNetworksDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::TIotDiscoveryCapability_TRestoreNetworksDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableIotRestoreNetworksDirective, "iot_restore_networks_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddIotCancelDiscoveryDirective(NAlice::TIotDiscoveryCapability_TCancelDiscoveryDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::TIotDiscoveryCapability_TCancelDiscoveryDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableIotCancelDiscoveryDirective, "iot_cancel_discovery_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddIotDeleteNetworksDirective(NAlice::TIotDiscoveryCapability_TDeleteNetworksDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::TIotDiscoveryCapability_TDeleteNetworksDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableIotDeleteNetworksDirective, "iot_delete_networks_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddMultiroomSemanticFrameDirective(NAlice::NScenarios::TMultiroomSemanticFrameDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TMultiroomSemanticFrameDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableMultiroomSemanticFrameDirective, "multiroom_semantic_frame_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddSetTemperatureKDirective(NAlice::TColorCapability_TSetTemperatureKDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::TColorCapability_TSetTemperatureKDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableSetTemperatureKDirective, "set_temperature_kdirective");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddDrawAnimationDirective(NAlice::TAnimationCapability_TDrawAnimationDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::TAnimationCapability_TDrawAnimationDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableDrawAnimationDirective, "draw_animation_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddSetAdjustableEqualizerBandsDirective(NAlice::TEqualizerCapability_TSetAdjustableEqualizerBandsDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::TEqualizerCapability_TSetAdjustableEqualizerBandsDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableSetAdjustableEqualizerBandsDirective, "set_adjustable_equalizer_bands_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddSetFixedEqualizerBandsDirective(NAlice::TEqualizerCapability_TSetFixedEqualizerBandsDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::TEqualizerCapability_TSetFixedEqualizerBandsDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableSetFixedEqualizerBandsDirective, "set_fixed_equalizer_bands_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddStartVideoCallLoginDirective(NAlice::TVideoCallCapability_TStartVideoCallLoginDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::TVideoCallCapability_TStartVideoCallLoginDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableStartVideoCallLoginDirective, "start_video_call_login_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddStartVideoCallDirective(NAlice::TVideoCallCapability_TStartVideoCallDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::TVideoCallCapability_TStartVideoCallDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableStartVideoCallDirective, "start_video_call_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddAcceptVideoCallDirective(NAlice::TVideoCallCapability_TAcceptVideoCallDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::TVideoCallCapability_TAcceptVideoCallDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableAcceptVideoCallDirective, "accept_video_call_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddDiscardVideoCallDirective(NAlice::TVideoCallCapability_TDiscardVideoCallDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::TVideoCallCapability_TDiscardVideoCallDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableDiscardVideoCallDirective, "discard_video_call_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddRouteManagerStartDirective(NAlice::TRouteManagerCapability_TStartDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::TRouteManagerCapability_TStartDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableRouteManagerStartDirective, "route_manager_start_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddRouteManagerStopDirective(NAlice::TRouteManagerCapability_TStopDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::TRouteManagerCapability_TStopDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableRouteManagerStopDirective, "route_manager_stop_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddRouteManagerShowDirective(NAlice::TRouteManagerCapability_TShowDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::TRouteManagerCapability_TShowDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableRouteManagerShowDirective, "route_manager_show_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddWebViewMediaSessionPlayDirective(NAlice::NScenarios::TWebViewMediaSessionPlayDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TWebViewMediaSessionPlayDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableWebViewMediaSessionPlayDirective, "web_view_media_session_play_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddWebViewMediaSessionPauseDirective(NAlice::NScenarios::TWebViewMediaSessionPauseDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TWebViewMediaSessionPauseDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableWebViewMediaSessionPauseDirective, "web_view_media_session_pause_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddRouteManagerContinueDirective(NAlice::TRouteManagerCapability_TContinueDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::TRouteManagerCapability_TContinueDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableRouteManagerContinueDirective, "route_manager_continue_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddOpenScreensaverDirective(NAlice::NScenarios::TOpenScreensaverDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TOpenScreensaverDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableOpenScreensaverDirective, "open_screensaver_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddPatchViewDirective(NAlice::NScenarios::TPatchViewDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TPatchViewDirective>>(
        std::move(directive), &NScenarios::TDirective::MutablePatchViewDirective, "patch_view_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddAudioMultiroomAttach(NAlice::NScenarios::TAudioMultiroomAttach&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TAudioMultiroomAttach>>(
        std::move(directive), &NScenarios::TDirective::MutableAudioMultiroomAttach, "audio_multiroom_attach");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddStashViewDirective(NAlice::TDivViewCapability_TStashViewDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::TDivViewCapability_TStashViewDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableStashViewDirective, "stash_view_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddUnstashViewDirective(NAlice::TDivViewCapability_TUnstashViewDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::TDivViewCapability_TUnstashViewDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableUnstashViewDirective, "unstash_view_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddHideViewDirective(NAlice::NScenarios::THideViewDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::THideViewDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableHideViewDirective, "hide_view_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddShowPromoDirective(NAlice::NScenarios::TShowPromoDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TShowPromoDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableShowPromoDirective, "show_promo_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddAddIotScenariosDirective(NAlice::TIotScenariosCapability_TAddIotScenariosDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::TIotScenariosCapability_TAddIotScenariosDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableAddIotScenariosDirective, "add_iot_scenarios_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddRemoveIotScenariosDirective(NAlice::TIotScenariosCapability_TRemoveIotScenariosDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::TIotScenariosCapability_TRemoveIotScenariosDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableRemoveIotScenariosDirective, "remove_iot_scenarios_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddSyncIotScenariosDirective(NAlice::TIotScenariosCapability_TSyncIotScenariosDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::TIotScenariosCapability_TSyncIotScenariosDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableSyncIotScenariosDirective, "sync_iot_scenarios_directive");
    Directives_.push_back(p);
}
void TDirectivesWrapper::AddMultiaccountRemoveAccountDirective(NAlice::NScenarios::TMultiaccountRemoveAccountDirective&& directive) {
    auto p = std::make_shared<TCustomDirectiveWrapper<NAlice::NScenarios::TMultiaccountRemoveAccountDirective>>(
        std::move(directive), &NScenarios::TDirective::MutableMultiaccountRemoveAccountDirective, "multiaccount_remove_account_directive");
    Directives_.push_back(p);
}
} // namespace NAlice::NHollywoodFw
