#pragma once

#include "fm_radio_resources.h"

#include <util/generic/hash.h>

#include <alice/hollywood/library/resources/resources.h>

namespace NAlice::NHollywood::NMusic {

class TMusicResources final : public IResourceContainer {
public:
    TMusicResources();

    struct TEnumStringValue {
        TString Value;
        bool Autogenerated;
    };

    using TEnumStringValues = THashMap<TString, TEnumStringValue>;

public:
    void LoadFromPath(const TFsPath& dirPath) override;

    const TEnumStringValues* EnumStringValues(const TStringBuf name) const {
        if (const auto* ptr = ENUM_MAP.FindPtr(name)) {
            const auto fieldPtr = *ptr;
            return &(this->*fieldPtr);
        }

        return nullptr;
    }

    const TFmRadioResources& GetFmRadioResources() const {
        return FmRadioResources_;
    }

private:
    TEnumStringValues Novelties_;
    TEnumStringValues NeedSimilar_;
    TEnumStringValues Moods_;
    TEnumStringValues Genres_;
    TEnumStringValues Activities_;
    TEnumStringValues Epochs_;
    TEnumStringValues Languages_;
    TEnumStringValues Vocals_;

    TFmRadioResources FmRadioResources_;

private:
    static inline const THashMap<TStringBuf, TEnumStringValues TMusicResources::*> ENUM_MAP = {
        {TStringBuf("novelty"), &TMusicResources::Novelties_},
        {TStringBuf("need_similar"), &TMusicResources::NeedSimilar_},
        {TStringBuf("mood"), &TMusicResources::Moods_},
        {TStringBuf("genre"), &TMusicResources::Genres_},
        {TStringBuf("activity"), &TMusicResources::Activities_},
        {TStringBuf("epoch"), &TMusicResources::Epochs_},
        {TStringBuf("language"), &TMusicResources::Languages_},
        {TStringBuf("vocal"), &TMusicResources::Vocals_},
    };
};

std::function<TString(const TStringBuf key, const TString& value)>
SlotToTextProvider(const TMusicResources& musicResources);

} // namespace NAlice::NHollywood::NMusic
