#include "impl.h"

#include <alice/hollywood/library/bass_adapter/bass_adapter.h>

namespace NAlice::NHollywood::NMusic::NImpl {

namespace {

constexpr TStringBuf SPECIAL_ANSWER_INFO = "special_answer_info";

} // namespace

THttpProxyRequest TRunPrepareHandleImpl::CreateBassRunRequest() {
    auto& sensors = Ctx_.Ctx.GlobalContext().Sensors();
    TSourceTextProvider reverseMappingProvider =
        [this, &sensors](const TStringBuf key, const TString& value) -> TString
    {
        if (const auto* mapping = MusicResources_.EnumStringValues(key)) {
            if (const auto* stringValue = mapping->FindPtr(value)) {
                if (stringValue->Autogenerated) {
                    sensors.IncRate({{"music_autogenerated_source_text", key}});
                    LOG_WARNING(Logger_) << "Slot " << key << " is using autogenerated reverse source text mapping: "
                                        << value << " -> " << stringValue->Value;
                }

                return stringValue->Value;
            }
        }

        if (key == SPECIAL_ANSWER_INFO) {
            return {};
        }

        return value;
    };

    LOG_DEBUG(Logger_) << "Pre bass frame: " << JsonStringFromProto(Frame_.ToProto());
    LOG_INFO(Logger_) << "Preparing bass run request";
    return PrepareBassRunRequest(Logger_, Request_, Frame_, &reverseMappingProvider, Meta_, /* imageSearch= */ false, AppHostParams_);
}

} // namespace NAlice::NHollywood::NMusic::NImpl
