#include "fallback_playlists.h"

#include <library/cpp/json/json_reader.h>
#include <util/generic/hash.h>

namespace NAlice::NHollywood::NMusic::NMusicSdk {

namespace {

// source table: https://st.yandex-team.ru/MUSICBACKEND-7684#61668c31ef7f1b2d92849a52
constexpr TStringBuf RAW_FALLBACK_PLAYLIST_MAPPING = R"(
{
    "mood:lullaby": "837761439:1088",
    "mood:sentimental": "837761439:1081",
    "mood:autumn": "837761439:1077",
    "mood:calm": "837761439:1084",
    "mood:newyear": "837761439:1095",
    "mood:summer": "837761439:1069",
    "mood:rainy": "837761439:1066",
    "mood:aggressive": "837761439:1045",
    "mood:winter": "837761439:1067",
    "mood:beautiful": "837761439:1071",
    "mood:dream": "837761439:1068",
    "mood:happy": "837761439:1062",
    "mood:spring": "837761439:1061",
    "mood:discovery": "414787002:1076",
    "mood:sad": "837761439:1065",
    "mood:energetic": "837761439:1085",
    "mood:relaxed": "837761439:1082",
    "mood:dark": "837761439:1070",
    "activity:sex": "837761439:1074",
    "activity:work-background": "837761439:1075",
    "activity:workout": "837761439:1076",
    "activity:fall-asleep": "837761439:1088",
    "activity:party": "837761439:1086",
    "activity:road-trip": "837761439:1072",
    "activity:romantic-date": "837761439:1073",
    "activity:wake-up": "837761439:1087",
    "activity:yoga": "837761439:1116",
    "activity:driving": "837761439:1096",
    "activity:run": "837761439:1078",
    "activity:beloved": "837761439:1080",
    "epoch:sixties": "837761439:1118",
    "epoch:eighties": "837761439:1121",
    "epoch:zeroes": "837761439:1123",
    "epoch:seventies": "837761439:1120",
    "epoch:nineties": "837761439:1122",
    "epoch:fifties": "837761439:1117",
    "language:english": "103372440:1734",
    "language:ukrainian": "960153729:1003",
    "language:italian": "103372440:1662",
    "language:german": "1115047449:1004",
    "language:romanian": "830788960:1002",
    "language:french": "103372440:1663",
    "language:finnish": "103372440:1733",
    "language:spanish": "103372440:1737",
    "language:russian": "103372440:1930",
    "language:not-russian": "103372440:1734",
    "language:turkish": "103372440:1703",
    "genre:all": "414787002:1076",
    "genre:meditation": "414787002:1072",
    "genre:experimental": "414787002:1071",
    "genre:balkan": "414787002:1070",
    "genre:eurofolk": "414787002:1068",
    "genre:tradjazz": "414787002:1067",
    "genre:hardcore": "414787002:1066",
    "genre:rusfolk": "414787002:1065",
    "genre:conjazz": "414787002:1064",
    "genre:modern": "414787002:1063",
    "genre:jewish": "414787002:1062",
    "genre:amerfolk": "414787002:1061",
    "genre:dub": "414787002:1060",
    "genre:dubstep": "414787002:1059",
    "genre:rnr": "414787002:1058",
    "genre:newwave": "414787002:1057",
    "genre:relax": "414787002:1056",
    "genre:dnb": "414787002:1055",
    "genre:estrada": "414787002:1086",
    "genre:prog": "414787002:1053",
    "genre:industrial": "414787002:1052",
    "genre:sport": "414787002:1051",
    "genre:ska": "414787002:1050",
    "genre:celtic": "414787002:1049",
    "genre:bollywood": "414787002:1048",
    "genre:latinfolk": "414787002:1047",
    "genre:techno": "414787002:1046",
    "genre:lounge": "414787002:1045",
    "genre:animemusic": "414787002:1142",
    "genre:azerbaijanpop": "414787002:1141",
    "genre:turkishfolk": "414787002:1140",
    "genre:classicalmasterpieces": "414787002:1138",
    "genre:arabesquemusic": "414787002:1137",
    "genre:israelipop": "414787002:1134",
    "genre:bard": "414787002:1088",
    "genre:poemsforchildren": "414787002:1129",
    "genre:fiction": "414787002:1128",
    "genre:allrock": "414787002:1119",
    "genre:house": "414787002:1043",
    "genre:turkishrock": "414787002:1117",
    "genre:japanesepop": "414787002:1116",
    "genre:azerbaijani": "414787002:1114",
    "genre:georgian": "414787002:1115",
    "genre:armenian": "414787002:1113",
    "genre:filmpodcasts": "414787002:1121",
    "genre:african": "414787002:1042",
    "genre:recreation": "414787002:1120",
    "genre:society": "414787002:1111",
    "genre:reggaeton": "414787002:1041",
    "genre:science": "414787002:1112",
    "genre:religion": "414787002:1136",
    "genre:trance": "414787002:1040",
    "genre:news": "414787002:1110",
    "genre:familypodcasts": "414787002:1123",
    "genre:historypodcasts": "414787002:1124",
    "genre:technology": "414787002:1109",
    "genre:musicpodcasts": "414787002:1122",
    "genre:health": "414787002:1118",
    "genre:hobbies": "414787002:1126",
    "genre:education": "414787002:1108",
    "genre:comedypodcasts": "414787002:1107",
    "genre:rap": "414787002:1039",
    "genre:rnb": "414787002:1038",
    "genre:vocal": "414787002:1037",
    "genre:business": "414787002:1106",
    "genre:arts": "414787002:1105",
    "genre:indie": "414787002:1087",
    "genre:classicalmusic": "414787002:1103",
    "genre:electronics": "414787002:1035",
    "genre:uzbekpop": "414787002:1102",
    "genre:israelirap": "414787002:1100",
    "genre:turkishalternative": "414787002:1101",
    "genre:turkishrap": "414787002:1099",
    "genre:turkishpop": "414787002:1098",
    "genre:podcasts": "414787002:1104",
    "genre:kpop": "414787002:1096",
    "genre:hardrock": "414787002:1095",
    "genre:stonerrock": "414787002:1094",
    "genre:argentinetango": "414787002:1093",
    "genre:folkrock": "414787002:1092",
    "genre:foreignbard": "414787002:1091",
    "genre:posthardcore": "414787002:1090",
    "genre:extrememetal": "414787002:1082",
    "genre:reggae": "414787002:1034",
    "genre:punk": "414787002:1033",
    "genre:newage": "414787002:1032",
    "genre:musical": "414787002:1031",
    "genre:metal": "414787002:1030",
    "genre:folkmetal": "414787002:1081",
    "genre:foreignrap": "414787002:1089",
    "genre:epicmetal": "414787002:1080",
    "genre:numetal": "414787002:1079",
    "genre:progmetal": "414787002:1078",
    "genre:funk": "414787002:1029",
    "genre:classicmetal": "414787002:1077",
    "genre:disco": "414787002:1028",
    "genre:country": "414787002:1027",
    "genre:blues": "414787002:1026",
    "genre:forchildren": "414787002:1075",
    "genre:children": "414787002:1139",
    "genre:naturesounds": "414787002:1125",
    "genre:jazz": "414787002:1024",
    "genre:soul": "414787002:1023",
    "genre:soundtrack": "414787002:1022",
    "genre:fairytales": "414787002:1074",
    "genre:classical": "414787002:1021",
    "genre:caucasian": "414787002:1073",
    "genre:folk": "414787002:1020",
    "genre:ruspop": "414787002:1019",
    "genre:rusestrada": "414787002:1018",
    "genre:animated": "414787002:1017",
    "genre:films": "414787002:1016",
    "genre:dance": "414787002:1015",
    "genre:tvseries": "414787002:1014",
    "genre:rock": "414787002:1083",
    "genre:alternative": "414787002:1012",
    "genre:shanson": "414787002:1011",
    "genre:pop": "414787002:1084",
    "genre:tatar": "414787002:1009",
    "genre:videogame": "414787002:1008",
    "genre:romances": "414787002:1007",
    "genre:rusbards": "414787002:1006",
    "genre:local-indie": "414787002:1005",
    "genre:ukrrock": "414787002:1004",
    "genre:postrock": "414787002:1003",
    "genre:rusrap": "414787002:1002",
    "genre:rusrock": "414787002:1001",
    "genre:eastern": "414787002:1000",
    "genre:israelirock": "414787002:1135",
    "genre:government": "414787002:1133",
    "genre:booksnotinrussian": "414787002:1144",
    "genre:audiobooksinenglish": "414787002:1143",
    "genre:selfdevelopment": "414787002:1130",
    "genre:community": "414787002:1132",
    "genre:work": "414787002:1131",
    "genre:urban": "414787002:1069"
}
)";

THashMap<TString, TPlaylistId> BuildFallbackPlaylistMapping() {
    THashMap<TString, TPlaylistId> result;
    const auto jsonObj = NJson::ReadJsonFastTree(RAW_FALLBACK_PLAYLIST_MAPPING);
    for (const auto& [key, value] : jsonObj.GetMap()) {
        result.emplace(key, *TPlaylistId::FromString(value.GetStringRobust()));
    }
    return result;
}

const auto FALLBACK_PLAYLIST_MAPPING = BuildFallbackPlaylistMapping();

} // namespace

TMaybe<TPlaylistId> TryGetFallbackPlaylist(const TStringBuf metatag) {
    if (const auto iter = FALLBACK_PLAYLIST_MAPPING.find(metatag); iter != FALLBACK_PLAYLIST_MAPPING.end()) {
        return iter->second;
    }
    return Nothing();
}

} // namespace NAlice::NHollywood::NMusic::NMusicSdk
