package tuya

import (
	"a.yandex-team.ru/alice/iot/bulbasaur/model"
)

type ScenePoolID string

const (
	YeelightScenePool ScenePoolID = "yeelight"
	TuyaScenePool     ScenePoolID = "tuya"
	TuyaV2ScenePool   ScenePoolID = "tuya_v2"
)

func getColorScenePool(productID TuyaDeviceProductID, fwVersion *string) ScenePoolID {
	lampSpec := LampSpecByPID(productID)
	switch lampSpec.chipsetType {
	case YeelightChipsetType:
		return YeelightScenePool
	case TuyaChipsetType:
		switch productID {
		case LampE14MPYandexProductID:
			if fwVersion != nil {
				number, err := GetLastNumberOfFirmwareVersion(*fwVersion)
				if err != nil {
					return TuyaScenePool
				}
				if number >= 18 {
					return TuyaV2ScenePool
				}
			}
			return TuyaScenePool
		case LampGU10MPYandexProductID:
			if fwVersion != nil {
				number, err := GetLastNumberOfFirmwareVersion(*fwVersion)
				if err != nil {
					return TuyaScenePool
				}
				if number >= 7 {
					return TuyaV2ScenePool
				}
			}
			return TuyaScenePool
		default:
			return TuyaScenePool
		}
	default:
		return TuyaScenePool
	}
}

var knownScenePools = map[ScenePoolID]map[model.ColorSceneID]ColorScene{
	YeelightScenePool: {
		model.ColorSceneIDReading: {
			SceneNum: 1,
			SceneUnits: []ColorSceneUnit{
				{
					UnitChangeMode:       StaticColorSceneUnitChangeMode,
					UnitSwitchDuration:   0,
					UnitGradientDuration: 0,
					H:                    0,
					S:                    0,
					V:                    0,
					Bright:               1000,
					Temperature:          400,
				},
			},
		},
		model.ColorSceneIDNight: {
			SceneNum: 2,
			SceneUnits: []ColorSceneUnit{
				{
					UnitChangeMode:       StaticColorSceneUnitChangeMode,
					UnitSwitchDuration:   0,
					UnitGradientDuration: 0,
					H:                    0,
					S:                    0,
					V:                    0,
					Bright:               200,
					Temperature:          300,
				},
			},
		},
		model.ColorSceneIDCandle: {
			SceneNum: 3,
			SceneUnits: []ColorSceneUnit{
				{
					UnitChangeMode:       StaticColorSceneUnitChangeMode,
					UnitSwitchDuration:   93,
					UnitGradientDuration: 0,
					H:                    0,
					S:                    0,
					V:                    0,
					Bright:               833,
					Temperature:          10,
				},
				{
					UnitChangeMode:       StaticColorSceneUnitChangeMode,
					UnitSwitchDuration:   100,
					UnitGradientDuration: 0,
					H:                    0,
					S:                    0,
					V:                    0,
					Bright:               606,
					Temperature:          20,
				},
				{
					UnitChangeMode:       StaticColorSceneUnitChangeMode,
					UnitSwitchDuration:   95,
					UnitGradientDuration: 0,
					H:                    0,
					S:                    0,
					V:                    0,
					Bright:               806,
					Temperature:          20,
				},
				{
					UnitChangeMode:       StaticColorSceneUnitChangeMode,
					UnitSwitchDuration:   100,
					UnitGradientDuration: 0,
					H:                    0,
					S:                    0,
					V:                    0,
					Bright:               641,
					Temperature:          10,
				},
				{
					UnitChangeMode:       StaticColorSceneUnitChangeMode,
					UnitSwitchDuration:   96,
					UnitGradientDuration: 0,
					H:                    0,
					S:                    0,
					V:                    0,
					Bright:               784,
					Temperature:          10,
				},
				{
					UnitChangeMode:       StaticColorSceneUnitChangeMode,
					UnitSwitchDuration:   99,
					UnitGradientDuration: 0,
					H:                    0,
					S:                    0,
					V:                    0,
					Bright:               847,
					Temperature:          10,
				},
				{
					UnitChangeMode:       StaticColorSceneUnitChangeMode,
					UnitSwitchDuration:   93,
					UnitGradientDuration: 0,
					H:                    0,
					S:                    0,
					V:                    0,
					Bright:               741,
					Temperature:          20,
				},
				{
					UnitChangeMode:       StaticColorSceneUnitChangeMode,
					UnitSwitchDuration:   98,
					UnitGradientDuration: 0,
					H:                    0,
					S:                    0,
					V:                    0,
					Bright:               888,
					Temperature:          30,
				},
				{
					UnitChangeMode:       StaticColorSceneUnitChangeMode,
					UnitSwitchDuration:   93,
					UnitGradientDuration: 0,
					H:                    0,
					S:                    0,
					V:                    0,
					Bright:               845,
					Temperature:          10,
				},
				{
					UnitChangeMode:       StaticColorSceneUnitChangeMode,
					UnitSwitchDuration:   95,
					UnitGradientDuration: 0,
					H:                    0,
					S:                    0,
					V:                    0,
					Bright:               890,
					Temperature:          20,
				},
			},
		},
		model.ColorSceneIDAlarm: {
			SceneNum: 4,
			SceneUnits: []ColorSceneUnit{
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   93,
					UnitGradientDuration: 50,
					H:                    360,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   93,
					UnitGradientDuration: 50,
					H:                    360,
					S:                    1000,
					V:                    10,
					Bright:               0,
					Temperature:          0,
				},
			},
		},
		model.ColorSceneIDFantasy: {
			SceneNum: 5,
			SceneUnits: []ColorSceneUnit{
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   90,
					UnitGradientDuration: 100,
					H:                    100,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   90,
					UnitGradientDuration: 100,
					H:                    175,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   90,
					UnitGradientDuration: 100,
					H:                    205,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   90,
					UnitGradientDuration: 100,
					H:                    265,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   90,
					UnitGradientDuration: 100,
					H:                    310,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   90,
					UnitGradientDuration: 100,
					H:                    265,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   90,
					UnitGradientDuration: 100,
					H:                    205,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   90,
					UnitGradientDuration: 100,
					H:                    175,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
			},
		},
		model.ColorSceneIDParty: {
			SceneNum: 6,
			SceneUnits: []ColorSceneUnit{
				{
					UnitChangeMode:       StaticColorSceneUnitChangeMode,
					UnitSwitchDuration:   95,
					UnitGradientDuration: 0,
					H:                    120,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       StaticColorSceneUnitChangeMode,
					UnitSwitchDuration:   95,
					UnitGradientDuration: 0,
					H:                    120,
					S:                    1000,
					V:                    10,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       StaticColorSceneUnitChangeMode,
					UnitSwitchDuration:   95,
					UnitGradientDuration: 0,
					H:                    14,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       StaticColorSceneUnitChangeMode,
					UnitSwitchDuration:   95,
					UnitGradientDuration: 0,
					H:                    14,
					S:                    1000,
					V:                    10,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       StaticColorSceneUnitChangeMode,
					UnitSwitchDuration:   95,
					UnitGradientDuration: 0,
					H:                    240,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       StaticColorSceneUnitChangeMode,
					UnitSwitchDuration:   95,
					UnitGradientDuration: 0,
					H:                    240,
					S:                    1000,
					V:                    10,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       StaticColorSceneUnitChangeMode,
					UnitSwitchDuration:   95,
					UnitGradientDuration: 0,
					H:                    360,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       StaticColorSceneUnitChangeMode,
					UnitSwitchDuration:   95,
					UnitGradientDuration: 0,
					H:                    360,
					S:                    1000,
					V:                    10,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       StaticColorSceneUnitChangeMode,
					UnitSwitchDuration:   95,
					UnitGradientDuration: 0,
					H:                    280,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       StaticColorSceneUnitChangeMode,
					UnitSwitchDuration:   95,
					UnitGradientDuration: 0,
					H:                    280,
					S:                    1000,
					V:                    10,
					Bright:               0,
					Temperature:          0,
				},
			},
		},
		model.ColorSceneIDRomance: {
			SceneNum: 7,
			SceneUnits: []ColorSceneUnit{
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   20,
					UnitGradientDuration: 50,
					H:                    340,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   60,
					UnitGradientDuration: 50,
					H:                    310,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
			},
		},
		model.ColorSceneIDSiren: {
			SceneNum: 8,
			SceneUnits: []ColorSceneUnit{
				{
					UnitChangeMode:       JumpColorSceneUnitChangeMode,
					UnitSwitchDuration:   100,
					UnitGradientDuration: 100,
					H:                    0,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       JumpColorSceneUnitChangeMode,
					UnitSwitchDuration:   100,
					UnitGradientDuration: 100,
					H:                    230,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
			},
		},
		model.ColorSceneIDOcean: {
			SceneNum: 9,
			SceneUnits: []ColorSceneUnit{
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   90,
					UnitGradientDuration: 0,
					H:                    191,
					S:                    669,
					V:                    949,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   90,
					UnitGradientDuration: 0,
					H:                    191,
					S:                    979,
					V:                    749,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   90,
					UnitGradientDuration: 0,
					H:                    197,
					S:                    982,
					V:                    651,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   90,
					UnitGradientDuration: 0,
					H:                    191,
					S:                    772,
					V:                    910,
					Bright:               0,
					Temperature:          0,
				},
			},
		},
		model.ColorSceneIDJungle: {
			SceneNum: 10,
			SceneUnits: []ColorSceneUnit{
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   60,
					UnitGradientDuration: 0,
					H:                    79,
					S:                    971,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   70,
					UnitGradientDuration: 0,
					H:                    74,
					S:                    939,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   75,
					UnitGradientDuration: 0,
					H:                    90,
					S:                    970,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
			},
		},
		model.ColorSceneIDNeon: {
			SceneNum: 11,
			SceneUnits: []ColorSceneUnit{
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   70,
					UnitGradientDuration: 0,
					H:                    316,
					S:                    894,
					V:                    922,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   70,
					UnitGradientDuration: 0,
					H:                    215,
					S:                    1000,
					V:                    937,
					Bright:               0,
					Temperature:          0,
				},
			},
		},
		model.ColorSceneIDAlice: {
			SceneNum: 12,
			SceneUnits: []ColorSceneUnit{
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   70,
					UnitGradientDuration: 0,
					H:                    280,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   70,
					UnitGradientDuration: 0,
					H:                    265,
					S:                    979,
					V:                    949,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   70,
					UnitGradientDuration: 0,
					H:                    316,
					S:                    894,
					V:                    922,
					Bright:               0,
					Temperature:          0,
				},
			},
		},
	},
	TuyaScenePool: {
		model.ColorSceneIDReading: {
			SceneNum: 1,
			SceneUnits: []ColorSceneUnit{
				{
					UnitChangeMode:       StaticColorSceneUnitChangeMode,
					UnitSwitchDuration:   0,
					UnitGradientDuration: 0,
					H:                    0,
					S:                    0,
					V:                    0,
					Bright:               1000,
					Temperature:          400,
				},
			},
		},
		model.ColorSceneIDNight: {
			SceneNum: 2,
			SceneUnits: []ColorSceneUnit{
				{
					UnitChangeMode:       StaticColorSceneUnitChangeMode,
					UnitSwitchDuration:   20,
					UnitGradientDuration: 0,
					H:                    0,
					S:                    0,
					V:                    0,
					Bright:               10,
					Temperature:          10,
				},
			},
		},
		model.ColorSceneIDCandle: {
			SceneNum: 3,
			SceneUnits: []ColorSceneUnit{
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   90,
					UnitGradientDuration: 0,
					H:                    0,
					S:                    0,
					V:                    0,
					Bright:               10,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   83,
					UnitGradientDuration: 0,
					H:                    28,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   90,
					UnitGradientDuration: 0,
					H:                    0,
					S:                    0,
					V:                    0,
					Bright:               10,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   90,
					UnitGradientDuration: 0,
					H:                    28,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   90,
					UnitGradientDuration: 0,
					H:                    0,
					S:                    0,
					V:                    0,
					Bright:               10,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   80,
					UnitGradientDuration: 0,
					H:                    24,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
			},
		},
		model.ColorSceneIDAlarm: {
			SceneNum: 4,
			SceneUnits: []ColorSceneUnit{
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   93,
					UnitGradientDuration: 50,
					H:                    360,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   93,
					UnitGradientDuration: 50,
					H:                    360,
					S:                    1000,
					V:                    10,
					Bright:               0,
					Temperature:          0,
				},
			},
		},
		model.ColorSceneIDFantasy: {
			SceneNum: 5,
			SceneUnits: []ColorSceneUnit{
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   90,
					UnitGradientDuration: 100,
					H:                    100,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   90,
					UnitGradientDuration: 100,
					H:                    175,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   90,
					UnitGradientDuration: 100,
					H:                    205,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   90,
					UnitGradientDuration: 100,
					H:                    265,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   90,
					UnitGradientDuration: 100,
					H:                    310,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   90,
					UnitGradientDuration: 100,
					H:                    265,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   90,
					UnitGradientDuration: 100,
					H:                    205,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   90,
					UnitGradientDuration: 100,
					H:                    175,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
			},
		},
		model.ColorSceneIDParty: {
			SceneNum: 6,
			SceneUnits: []ColorSceneUnit{
				{
					UnitChangeMode:       JumpColorSceneUnitChangeMode,
					UnitSwitchDuration:   100,
					UnitGradientDuration: 0,
					H:                    120,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       JumpColorSceneUnitChangeMode,
					UnitSwitchDuration:   100,
					UnitGradientDuration: 0,
					H:                    14,
					S:                    1000,
					V:                    200,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       JumpColorSceneUnitChangeMode,
					UnitSwitchDuration:   100,
					UnitGradientDuration: 0,
					H:                    240,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       JumpColorSceneUnitChangeMode,
					UnitSwitchDuration:   100,
					UnitGradientDuration: 0,
					H:                    360,
					S:                    1000,
					V:                    200,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       JumpColorSceneUnitChangeMode,
					UnitSwitchDuration:   100,
					UnitGradientDuration: 0,
					H:                    14,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       JumpColorSceneUnitChangeMode,
					UnitSwitchDuration:   100,
					UnitGradientDuration: 0,
					H:                    120,
					S:                    1000,
					V:                    200,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       JumpColorSceneUnitChangeMode,
					UnitSwitchDuration:   100,
					UnitGradientDuration: 0,
					H:                    360,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       JumpColorSceneUnitChangeMode,
					UnitSwitchDuration:   100,
					UnitGradientDuration: 0,
					H:                    240,
					S:                    1000,
					V:                    200,
					Bright:               0,
					Temperature:          0,
				},
			},
		},
		model.ColorSceneIDRomance: {
			SceneNum: 7,
			SceneUnits: []ColorSceneUnit{
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   20,
					UnitGradientDuration: 50,
					H:                    340,
					S:                    800,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   60,
					UnitGradientDuration: 50,
					H:                    310,
					S:                    800,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
			},
		},
		model.ColorSceneIDSiren: {
			SceneNum: 8,
			SceneUnits: []ColorSceneUnit{
				{
					UnitChangeMode:       JumpColorSceneUnitChangeMode,
					UnitSwitchDuration:   99,
					UnitGradientDuration: 100,
					H:                    0,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       JumpColorSceneUnitChangeMode,
					UnitSwitchDuration:   99,
					UnitGradientDuration: 100,
					H:                    230,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
			},
		},
		model.ColorSceneIDOcean: {
			SceneNum: 9,
			SceneUnits: []ColorSceneUnit{
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   85,
					UnitGradientDuration: 0,
					H:                    217,
					S:                    1000,
					V:                    651,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   70,
					UnitGradientDuration: 0,
					H:                    201,
					S:                    1000,
					V:                    949,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   65,
					UnitGradientDuration: 0,
					H:                    211,
					S:                    1000,
					V:                    749,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   80,
					UnitGradientDuration: 0,
					H:                    220,
					S:                    1000,
					V:                    910,
					Bright:               0,
					Temperature:          0,
				},
			},
		},
		model.ColorSceneIDJungle: {
			SceneNum: 10,
			SceneUnits: []ColorSceneUnit{
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   60,
					UnitGradientDuration: 0,
					H:                    79,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   70,
					UnitGradientDuration: 0,
					H:                    74,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   75,
					UnitGradientDuration: 0,
					H:                    90,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
			},
		},
		model.ColorSceneIDNeon: {
			SceneNum: 11,
			SceneUnits: []ColorSceneUnit{
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   70,
					UnitGradientDuration: 0,
					H:                    316,
					S:                    894,
					V:                    922,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   70,
					UnitGradientDuration: 0,
					H:                    215,
					S:                    1000,
					V:                    937,
					Bright:               0,
					Temperature:          0,
				},
			},
		},
		model.ColorSceneIDAlice: {
			SceneNum: 12,
			SceneUnits: []ColorSceneUnit{
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   70,
					UnitGradientDuration: 0,
					H:                    280,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   70,
					UnitGradientDuration: 0,
					H:                    265,
					S:                    979,
					V:                    949,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   70,
					UnitGradientDuration: 0,
					H:                    316,
					S:                    894,
					V:                    922,
					Bright:               0,
					Temperature:          0,
				},
			},
		},
	},
	TuyaV2ScenePool: {
		model.ColorSceneIDReading: {
			SceneNum: 1,
			SceneUnits: []ColorSceneUnit{
				{
					UnitChangeMode:       StaticColorSceneUnitChangeMode,
					UnitSwitchDuration:   0,
					UnitGradientDuration: 0,
					H:                    0,
					S:                    0,
					V:                    0,
					Bright:               1000,
					Temperature:          400,
				},
			},
		},
		model.ColorSceneIDNight: {
			SceneNum: 2,
			SceneUnits: []ColorSceneUnit{
				{
					UnitChangeMode:       StaticColorSceneUnitChangeMode,
					UnitSwitchDuration:   20,
					UnitGradientDuration: 0,
					H:                    0,
					S:                    0,
					V:                    0,
					Bright:               10,
					Temperature:          10,
				},
			},
		},
		model.ColorSceneIDCandle: {
			SceneNum: 3,
			SceneUnits: []ColorSceneUnit{
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   93,
					UnitGradientDuration: 0,
					H:                    0,
					S:                    0,
					V:                    0,
					Bright:               333,
					Temperature:          10,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   100,
					UnitGradientDuration: 0,
					H:                    0,
					S:                    0,
					V:                    0,
					Bright:               106,
					Temperature:          20,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   95,
					UnitGradientDuration: 0,
					H:                    0,
					S:                    0,
					V:                    0,
					Bright:               306,
					Temperature:          20,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   100,
					UnitGradientDuration: 0,
					H:                    0,
					S:                    0,
					V:                    0,
					Bright:               141,
					Temperature:          10,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   96,
					UnitGradientDuration: 0,
					H:                    0,
					S:                    0,
					V:                    0,
					Bright:               284,
					Temperature:          10,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   99,
					UnitGradientDuration: 0,
					H:                    0,
					S:                    0,
					V:                    0,
					Bright:               347,
					Temperature:          10,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   93,
					UnitGradientDuration: 0,
					H:                    0,
					S:                    0,
					V:                    0,
					Bright:               241,
					Temperature:          20,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   98,
					UnitGradientDuration: 0,
					H:                    0,
					S:                    0,
					V:                    0,
					Bright:               388,
					Temperature:          30,
				},
			},
		},
		model.ColorSceneIDAlarm: {
			SceneNum: 4,
			SceneUnits: []ColorSceneUnit{
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   93,
					UnitGradientDuration: 50,
					H:                    360,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   93,
					UnitGradientDuration: 50,
					H:                    360,
					S:                    1000,
					V:                    10,
					Bright:               0,
					Temperature:          0,
				},
			},
		},
		model.ColorSceneIDFantasy: {
			SceneNum: 5,
			SceneUnits: []ColorSceneUnit{
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   90,
					UnitGradientDuration: 100,
					H:                    100,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   90,
					UnitGradientDuration: 100,
					H:                    175,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   90,
					UnitGradientDuration: 100,
					H:                    205,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   90,
					UnitGradientDuration: 100,
					H:                    265,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   90,
					UnitGradientDuration: 100,
					H:                    310,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   90,
					UnitGradientDuration: 100,
					H:                    265,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   90,
					UnitGradientDuration: 100,
					H:                    205,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   90,
					UnitGradientDuration: 100,
					H:                    175,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
			},
		},
		model.ColorSceneIDParty: {
			SceneNum: 6,
			SceneUnits: []ColorSceneUnit{
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   95,
					UnitGradientDuration: 0,
					H:                    120,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   95,
					UnitGradientDuration: 0,
					H:                    120,
					S:                    1000,
					V:                    10,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   95,
					UnitGradientDuration: 0,
					H:                    14,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   95,
					UnitGradientDuration: 0,
					H:                    14,
					S:                    1000,
					V:                    10,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   95,
					UnitGradientDuration: 0,
					H:                    240,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   95,
					UnitGradientDuration: 0,
					H:                    240,
					S:                    1000,
					V:                    10,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   95,
					UnitGradientDuration: 0,
					H:                    360,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   95,
					UnitGradientDuration: 0,
					H:                    360,
					S:                    1000,
					V:                    10,
					Bright:               0,
					Temperature:          0,
				},
			},
		},
		model.ColorSceneIDRomance: {
			SceneNum: 7,
			SceneUnits: []ColorSceneUnit{
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   20,
					UnitGradientDuration: 50,
					H:                    340,
					S:                    900,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   60,
					UnitGradientDuration: 50,
					H:                    310,
					S:                    900,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
			},
		},
		model.ColorSceneIDSiren: {
			SceneNum: 8,
			SceneUnits: []ColorSceneUnit{
				{
					UnitChangeMode:       JumpColorSceneUnitChangeMode,
					UnitSwitchDuration:   100,
					UnitGradientDuration: 100,
					H:                    0,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       JumpColorSceneUnitChangeMode,
					UnitSwitchDuration:   100,
					UnitGradientDuration: 100,
					H:                    230,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
			},
		},
		model.ColorSceneIDOcean: {
			SceneNum: 9,
			SceneUnits: []ColorSceneUnit{
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   90,
					UnitGradientDuration: 0,
					H:                    191,
					S:                    669,
					V:                    949,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   90,
					UnitGradientDuration: 0,
					H:                    191,
					S:                    979,
					V:                    749,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   90,
					UnitGradientDuration: 0,
					H:                    197,
					S:                    982,
					V:                    651,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   90,
					UnitGradientDuration: 0,
					H:                    191,
					S:                    772,
					V:                    910,
					Bright:               0,
					Temperature:          0,
				},
			},
		},
		model.ColorSceneIDJungle: {
			SceneNum: 10,
			SceneUnits: []ColorSceneUnit{
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   60,
					UnitGradientDuration: 0,
					H:                    79,
					S:                    971,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   70,
					UnitGradientDuration: 0,
					H:                    74,
					S:                    939,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   75,
					UnitGradientDuration: 0,
					H:                    90,
					S:                    970,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
			},
		},
		model.ColorSceneIDNeon: {
			SceneNum: 11,
			SceneUnits: []ColorSceneUnit{
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   70,
					UnitGradientDuration: 0,
					H:                    316,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   70,
					UnitGradientDuration: 0,
					H:                    215,
					S:                    1000,
					V:                    937,
					Bright:               0,
					Temperature:          0,
				},
			},
		},
		model.ColorSceneIDAlice: {
			SceneNum: 12,
			SceneUnits: []ColorSceneUnit{
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   70,
					UnitGradientDuration: 0,
					H:                    280,
					S:                    1000,
					V:                    1000,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   70,
					UnitGradientDuration: 0,
					H:                    265,
					S:                    979,
					V:                    949,
					Bright:               0,
					Temperature:          0,
				},
				{
					UnitChangeMode:       GradientColorSceneUnitChangeMode,
					UnitSwitchDuration:   70,
					UnitGradientDuration: 0,
					H:                    316,
					S:                    894,
					V:                    922,
					Bright:               0,
					Temperature:          0,
				},
			},
		},
	},
}
