#pragma once

//////////////////////////////////////////////////////////////////////
// WARNING: this code was automatically generated by alice/json_schema_builder/tool,
// don't edit it manually.
//////////////////////////////////////////////////////////////////////

#include <alice/json_schema_builder/runtime/runtime.h>

#include "enums.h"
#include "patterns.h"

namespace NAlice::NJsonSchemaBuilder::NDiv1 {

struct TDivPredefinedSizeBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivPredefinedSizeBuilder() {
        Value_.SetType(NJson::JSON_MAP);
        Value_[TStringBuf("type")] = TStringBuf("predefined");
    }

    [[nodiscard]] TDivPredefinedSizeBuilder&& Value(const EDivPredefinedSizeValue value) && {
        Value_[TStringBuf("value")] = ToString(value);
        return std::move(*this);
    }

    TDivPredefinedSizeBuilder& Value(const EDivPredefinedSizeValue value) & {
        Value_[TStringBuf("value")] = ToString(value);
        return *this;
    }

};

[[nodiscard]] inline TDivPredefinedSizeBuilder DivPredefinedSize() {
    return {};
}

[[nodiscard]] inline TDivPredefinedSizeBuilder DivPredefinedSize(const EDivPredefinedSizeValue value) {
    return TDivPredefinedSizeBuilder{}.Value(value);
}

struct TDivContainerBlockBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivContainerBlockBuilder() {
        Value_.SetType(NJson::JSON_MAP);
        Value_[TStringBuf("type")] = TStringBuf("div-container-block");
    }

    [[nodiscard]] TDivContainerBlockBuilder&& AddChild(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("children")].AppendValue(value.ValueWithoutValidation());
        return std::move(*this);
    }

    TDivContainerBlockBuilder& AddChild(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("children")].AppendValue(value.ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivContainerBlockBuilder&& AddChild(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("children")].AppendValue(std::move(value).ValueWithoutValidation());
        return std::move(*this);
    }

    TDivContainerBlockBuilder& AddChild(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("children")].AppendValue(std::move(value).ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivContainerBlockBuilder&& Children(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) && {
        Value_[TStringBuf("children")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivContainerBlockBuilder& Children(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) & {
        Value_[TStringBuf("children")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivContainerBlockBuilder&& Children(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) && {
        Value_[TStringBuf("children")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivContainerBlockBuilder& Children(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) & {
        Value_[TStringBuf("children")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivContainerBlockBuilder&& Direction(const EDivContainerBlockDirection value) && {
        Value_[TStringBuf("direction")] = ToString(value);
        return std::move(*this);
    }

    TDivContainerBlockBuilder& Direction(const EDivContainerBlockDirection value) & {
        Value_[TStringBuf("direction")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivContainerBlockBuilder&& AlignmentVertical(const EDivAlignmentVertical value) && {
        Value_[TStringBuf("alignment_vertical")] = ToString(value);
        return std::move(*this);
    }

    TDivContainerBlockBuilder& AlignmentVertical(const EDivAlignmentVertical value) & {
        Value_[TStringBuf("alignment_vertical")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivContainerBlockBuilder&& AlignmentHorizontal(const EDivAlignment value) && {
        Value_[TStringBuf("alignment_horizontal")] = ToString(value);
        return std::move(*this);
    }

    TDivContainerBlockBuilder& AlignmentHorizontal(const EDivAlignment value) & {
        Value_[TStringBuf("alignment_horizontal")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivContainerBlockBuilder&& AddBackground(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("background")].AppendValue(value.ValueWithoutValidation());
        return std::move(*this);
    }

    TDivContainerBlockBuilder& AddBackground(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("background")].AppendValue(value.ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivContainerBlockBuilder&& AddBackground(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("background")].AppendValue(std::move(value).ValueWithoutValidation());
        return std::move(*this);
    }

    TDivContainerBlockBuilder& AddBackground(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("background")].AppendValue(std::move(value).ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivContainerBlockBuilder&& Background(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) && {
        Value_[TStringBuf("background")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivContainerBlockBuilder& Background(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) & {
        Value_[TStringBuf("background")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivContainerBlockBuilder&& Background(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) && {
        Value_[TStringBuf("background")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivContainerBlockBuilder& Background(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) & {
        Value_[TStringBuf("background")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivContainerBlockBuilder&& Frame(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("frame")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivContainerBlockBuilder& Frame(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("frame")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivContainerBlockBuilder&& Frame(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("frame")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivContainerBlockBuilder& Frame(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("frame")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivContainerBlockBuilder&& Width(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("width")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivContainerBlockBuilder& Width(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("width")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivContainerBlockBuilder&& Width(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("width")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivContainerBlockBuilder& Width(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("width")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivContainerBlockBuilder&& Height(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("height")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivContainerBlockBuilder& Height(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("height")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivContainerBlockBuilder&& Height(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("height")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivContainerBlockBuilder& Height(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("height")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

};

[[nodiscard]] inline TDivContainerBlockBuilder DivContainerBlock() {
    return {};
}

[[nodiscard]] inline TDivContainerBlockBuilder DivContainerBlock(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& width, const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& height) {
    return TDivContainerBlockBuilder{}.Width(width).Height(height);
}

[[nodiscard]] inline TDivContainerBlockBuilder DivContainerBlock(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& width, NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& height) {
    return TDivContainerBlockBuilder{}.Width(width).Height(std::move(height));
}

[[nodiscard]] inline TDivContainerBlockBuilder DivContainerBlock(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& width, const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& height) {
    return TDivContainerBlockBuilder{}.Width(std::move(width)).Height(height);
}

[[nodiscard]] inline TDivContainerBlockBuilder DivContainerBlock(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& width, NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& height) {
    return TDivContainerBlockBuilder{}.Width(std::move(width)).Height(std::move(height));
}

struct TDivContainerBlockFrameBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivContainerBlockFrameBuilder() {
        Value_.SetType(NJson::JSON_MAP);
    }

    [[nodiscard]] TDivContainerBlockFrameBuilder&& Style(const EDivContainerBlockFrameStyle value) && {
        Value_[TStringBuf("style")] = ToString(value);
        return std::move(*this);
    }

    TDivContainerBlockFrameBuilder& Style(const EDivContainerBlockFrameStyle value) & {
        Value_[TStringBuf("style")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivContainerBlockFrameBuilder&& Color(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("color")] = value;
        return std::move(*this);
    }

    TDivContainerBlockFrameBuilder& Color(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("color")] = value;
        return *this;
    }

};

[[nodiscard]] inline TDivContainerBlockFrameBuilder DivContainerBlockFrame() {
    return {};
}

[[nodiscard]] inline TDivContainerBlockFrameBuilder DivContainerBlockFrame(const EDivContainerBlockFrameStyle style) {
    return TDivContainerBlockFrameBuilder{}.Style(style);
}

struct TDivTrafficBlockBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivTrafficBlockBuilder() {
        Value_.SetType(NJson::JSON_MAP);
        Value_[TStringBuf("type")] = TStringBuf("div-traffic-block");
    }

    [[nodiscard]] TDivTrafficBlockBuilder&& AddItem(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("items")].AppendValue(value.ValueWithoutValidation());
        return std::move(*this);
    }

    TDivTrafficBlockBuilder& AddItem(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("items")].AppendValue(value.ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivTrafficBlockBuilder&& AddItem(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("items")].AppendValue(std::move(value).ValueWithoutValidation());
        return std::move(*this);
    }

    TDivTrafficBlockBuilder& AddItem(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("items")].AppendValue(std::move(value).ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivTrafficBlockBuilder&& Items(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) && {
        Value_[TStringBuf("items")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTrafficBlockBuilder& Items(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) & {
        Value_[TStringBuf("items")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTrafficBlockBuilder&& Items(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) && {
        Value_[TStringBuf("items")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTrafficBlockBuilder& Items(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) & {
        Value_[TStringBuf("items")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTrafficBlockBuilder&& Alignment(const EDivAlignment value) && {
        Value_[TStringBuf("alignment")] = ToString(value);
        return std::move(*this);
    }

    TDivTrafficBlockBuilder& Alignment(const EDivAlignment value) & {
        Value_[TStringBuf("alignment")] = ToString(value);
        return *this;
    }

};

[[nodiscard]] inline TDivTrafficBlockBuilder DivTrafficBlock() {
    return {};
}

struct TDivTrafficBlockTrafficElementBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivTrafficBlockTrafficElementBuilder() {
        Value_.SetType(NJson::JSON_MAP);
    }

    [[nodiscard]] TDivTrafficBlockTrafficElementBuilder&& Color(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("color")] = value;
        return std::move(*this);
    }

    TDivTrafficBlockTrafficElementBuilder& Color(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("color")] = value;
        return *this;
    }

    [[nodiscard]] TDivTrafficBlockTrafficElementBuilder&& Score(const TString& value) && {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMinLength(length, 1 /* minLength */);
        Value_[TStringBuf("score")] = value;
        return std::move(*this);
    }

    TDivTrafficBlockTrafficElementBuilder& Score(const TString& value) & {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMinLength(length, 1 /* minLength */);
        Value_[TStringBuf("score")] = value;
        return *this;
    }

    [[nodiscard]] TDivTrafficBlockTrafficElementBuilder&& Text(const TString& value) && {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMinLength(length, 1 /* minLength */);
        Value_[TStringBuf("text")] = value;
        return std::move(*this);
    }

    TDivTrafficBlockTrafficElementBuilder& Text(const TString& value) & {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMinLength(length, 1 /* minLength */);
        Value_[TStringBuf("text")] = value;
        return *this;
    }

};

[[nodiscard]] inline TDivTrafficBlockTrafficElementBuilder DivTrafficBlockTrafficElement() {
    return {};
}

[[nodiscard]] inline TDivTrafficBlockTrafficElementBuilder DivTrafficBlockTrafficElement(const TString& score) {
    return TDivTrafficBlockTrafficElementBuilder{}.Score(score);
}

struct TDivTableBlockBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivTableBlockBuilder() {
        Value_.SetType(NJson::JSON_MAP);
        Value_[TStringBuf("type")] = TStringBuf("div-table-block");
    }

    [[nodiscard]] TDivTableBlockBuilder&& AddRow(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("rows")].AppendValue(value.ValueWithoutValidation());
        return std::move(*this);
    }

    TDivTableBlockBuilder& AddRow(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("rows")].AppendValue(value.ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivTableBlockBuilder&& AddRow(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("rows")].AppendValue(std::move(value).ValueWithoutValidation());
        return std::move(*this);
    }

    TDivTableBlockBuilder& AddRow(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("rows")].AppendValue(std::move(value).ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivTableBlockBuilder&& Rows(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) && {
        Value_[TStringBuf("rows")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTableBlockBuilder& Rows(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) & {
        Value_[TStringBuf("rows")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTableBlockBuilder&& Rows(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) && {
        Value_[TStringBuf("rows")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTableBlockBuilder& Rows(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) & {
        Value_[TStringBuf("rows")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTableBlockBuilder&& AddColumn(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("columns")].AppendValue(value.ValueWithoutValidation());
        return std::move(*this);
    }

    TDivTableBlockBuilder& AddColumn(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("columns")].AppendValue(value.ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivTableBlockBuilder&& AddColumn(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("columns")].AppendValue(std::move(value).ValueWithoutValidation());
        return std::move(*this);
    }

    TDivTableBlockBuilder& AddColumn(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("columns")].AppendValue(std::move(value).ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivTableBlockBuilder&& Columns(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) && {
        Value_[TStringBuf("columns")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTableBlockBuilder& Columns(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) & {
        Value_[TStringBuf("columns")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTableBlockBuilder&& Columns(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) && {
        Value_[TStringBuf("columns")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTableBlockBuilder& Columns(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) & {
        Value_[TStringBuf("columns")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

};

[[nodiscard]] inline TDivTableBlockBuilder DivTableBlock() {
    return {};
}

struct TDivTableBlockCellElementBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivTableBlockCellElementBuilder() {
        Value_.SetType(NJson::JSON_MAP);
    }

    [[nodiscard]] TDivTableBlockCellElementBuilder&& Text(const TString& value) && {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMinLength(length, 1 /* minLength */);
        Value_[TStringBuf("text")] = value;
        return std::move(*this);
    }

    TDivTableBlockCellElementBuilder& Text(const TString& value) & {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMinLength(length, 1 /* minLength */);
        Value_[TStringBuf("text")] = value;
        return *this;
    }

    [[nodiscard]] TDivTableBlockCellElementBuilder&& TextStyle(const EDivTextStyle value) && {
        Value_[TStringBuf("text_style")] = ToString(value);
        return std::move(*this);
    }

    TDivTableBlockCellElementBuilder& TextStyle(const EDivTextStyle value) & {
        Value_[TStringBuf("text_style")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivTableBlockCellElementBuilder&& Image(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("image")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTableBlockCellElementBuilder& Image(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("image")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTableBlockCellElementBuilder&& Image(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("image")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTableBlockCellElementBuilder& Image(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("image")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTableBlockCellElementBuilder&& ImageSize(const EDivSize value) && {
        Value_[TStringBuf("image_size")] = ToString(value);
        return std::move(*this);
    }

    TDivTableBlockCellElementBuilder& ImageSize(const EDivSize value) & {
        Value_[TStringBuf("image_size")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivTableBlockCellElementBuilder&& ImagePosition(const EDivPosition value) && {
        Value_[TStringBuf("image_position")] = ToString(value);
        return std::move(*this);
    }

    TDivTableBlockCellElementBuilder& ImagePosition(const EDivPosition value) & {
        Value_[TStringBuf("image_position")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivTableBlockCellElementBuilder&& HorizontalAlignment(const EDivAlignment value) && {
        Value_[TStringBuf("horizontal_alignment")] = ToString(value);
        return std::move(*this);
    }

    TDivTableBlockCellElementBuilder& HorizontalAlignment(const EDivAlignment value) & {
        Value_[TStringBuf("horizontal_alignment")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivTableBlockCellElementBuilder&& VerticalAlignment(const EDivAlignmentVertical value) && {
        Value_[TStringBuf("vertical_alignment")] = ToString(value);
        return std::move(*this);
    }

    TDivTableBlockCellElementBuilder& VerticalAlignment(const EDivAlignmentVertical value) & {
        Value_[TStringBuf("vertical_alignment")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivTableBlockCellElementBuilder&& Action(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("action")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTableBlockCellElementBuilder& Action(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("action")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTableBlockCellElementBuilder&& Action(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("action")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTableBlockCellElementBuilder& Action(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("action")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

};

[[nodiscard]] inline TDivTableBlockCellElementBuilder DivTableBlockCellElement() {
    return {};
}

struct TDivTableBlockRowElementBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivTableBlockRowElementBuilder() {
        Value_.SetType(NJson::JSON_MAP);
        Value_[TStringBuf("type")] = TStringBuf("row_element");
    }

    [[nodiscard]] TDivTableBlockRowElementBuilder&& AddCell(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("cells")].AppendValue(value.ValueWithoutValidation());
        return std::move(*this);
    }

    TDivTableBlockRowElementBuilder& AddCell(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("cells")].AppendValue(value.ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivTableBlockRowElementBuilder&& AddCell(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("cells")].AppendValue(std::move(value).ValueWithoutValidation());
        return std::move(*this);
    }

    TDivTableBlockRowElementBuilder& AddCell(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("cells")].AppendValue(std::move(value).ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivTableBlockRowElementBuilder&& Cells(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) && {
        Value_[TStringBuf("cells")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTableBlockRowElementBuilder& Cells(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) & {
        Value_[TStringBuf("cells")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTableBlockRowElementBuilder&& Cells(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) && {
        Value_[TStringBuf("cells")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTableBlockRowElementBuilder& Cells(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) & {
        Value_[TStringBuf("cells")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTableBlockRowElementBuilder&& TopPadding(const EDivSize value) && {
        Value_[TStringBuf("top_padding")] = ToString(value);
        return std::move(*this);
    }

    TDivTableBlockRowElementBuilder& TopPadding(const EDivSize value) & {
        Value_[TStringBuf("top_padding")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivTableBlockRowElementBuilder&& BottomPadding(const EDivSize value) && {
        Value_[TStringBuf("bottom_padding")] = ToString(value);
        return std::move(*this);
    }

    TDivTableBlockRowElementBuilder& BottomPadding(const EDivSize value) & {
        Value_[TStringBuf("bottom_padding")] = ToString(value);
        return *this;
    }

};

[[nodiscard]] inline TDivTableBlockRowElementBuilder DivTableBlockRowElement() {
    return {};
}

struct TDivTableBlockSeparatorElementBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivTableBlockSeparatorElementBuilder() {
        Value_.SetType(NJson::JSON_MAP);
        Value_[TStringBuf("type")] = TStringBuf("separator_element");
    }

    [[nodiscard]] TDivTableBlockSeparatorElementBuilder&& Color(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("color")] = value;
        return std::move(*this);
    }

    TDivTableBlockSeparatorElementBuilder& Color(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("color")] = value;
        return *this;
    }

};

[[nodiscard]] inline TDivTableBlockSeparatorElementBuilder DivTableBlockSeparatorElement() {
    return {};
}

struct TDivTableBlockColumnElementBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivTableBlockColumnElementBuilder() {
        Value_.SetType(NJson::JSON_MAP);
    }

    [[nodiscard]] TDivTableBlockColumnElementBuilder&& Weight(const i64 value) && {
        Value_[TStringBuf("weight")] = value;
        return std::move(*this);
    }

    TDivTableBlockColumnElementBuilder& Weight(const i64 value) & {
        Value_[TStringBuf("weight")] = value;
        return *this;
    }

    [[nodiscard]] TDivTableBlockColumnElementBuilder&& LeftPadding(const EDivSize value) && {
        Value_[TStringBuf("left_padding")] = ToString(value);
        return std::move(*this);
    }

    TDivTableBlockColumnElementBuilder& LeftPadding(const EDivSize value) & {
        Value_[TStringBuf("left_padding")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivTableBlockColumnElementBuilder&& RightPadding(const EDivSize value) && {
        Value_[TStringBuf("right_padding")] = ToString(value);
        return std::move(*this);
    }

    TDivTableBlockColumnElementBuilder& RightPadding(const EDivSize value) & {
        Value_[TStringBuf("right_padding")] = ToString(value);
        return *this;
    }

};

[[nodiscard]] inline TDivTableBlockColumnElementBuilder DivTableBlockColumnElement() {
    return {};
}

struct TDivCustomTextStyleBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivCustomTextStyleBuilder() {
        Value_.SetType(NJson::JSON_MAP);
    }

    [[nodiscard]] TDivCustomTextStyleBuilder&& FontSize(const i64 value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("font_size")] = value;
        return std::move(*this);
    }

    TDivCustomTextStyleBuilder& FontSize(const i64 value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("font_size")] = value;
        return *this;
    }

    [[nodiscard]] TDivCustomTextStyleBuilder&& LineHeight(const i64 value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("line_height")] = value;
        return std::move(*this);
    }

    TDivCustomTextStyleBuilder& LineHeight(const i64 value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("line_height")] = value;
        return *this;
    }

    [[nodiscard]] TDivCustomTextStyleBuilder&& MaxLines(const i64 value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("max_lines")] = value;
        return std::move(*this);
    }

    TDivCustomTextStyleBuilder& MaxLines(const i64 value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("max_lines")] = value;
        return *this;
    }

    [[nodiscard]] TDivCustomTextStyleBuilder&& MaxLetters(const i64 value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("max_letters")] = value;
        return std::move(*this);
    }

    TDivCustomTextStyleBuilder& MaxLetters(const i64 value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("max_letters")] = value;
        return *this;
    }

    [[nodiscard]] TDivCustomTextStyleBuilder&& LetterSpacing(const double value) && {
        Value_[TStringBuf("letter_spacing")] = value;
        return std::move(*this);
    }

    TDivCustomTextStyleBuilder& LetterSpacing(const double value) & {
        Value_[TStringBuf("letter_spacing")] = value;
        return *this;
    }

    [[nodiscard]] TDivCustomTextStyleBuilder&& Ellipsis(const TString& value) && {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMaxLength(length, 1 /* maxLength */);
        Value_[TStringBuf("ellipsis")] = value;
        return std::move(*this);
    }

    TDivCustomTextStyleBuilder& Ellipsis(const TString& value) & {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMaxLength(length, 1 /* maxLength */);
        Value_[TStringBuf("ellipsis")] = value;
        return *this;
    }

    [[nodiscard]] TDivCustomTextStyleBuilder&& FontStyle(const EDivCustomTextStyleFontStyle value) && {
        Value_[TStringBuf("font_style")] = ToString(value);
        return std::move(*this);
    }

    TDivCustomTextStyleBuilder& FontStyle(const EDivCustomTextStyleFontStyle value) & {
        Value_[TStringBuf("font_style")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivCustomTextStyleBuilder&& Alignment(const EDivAlignment value) && {
        Value_[TStringBuf("alignment")] = ToString(value);
        return std::move(*this);
    }

    TDivCustomTextStyleBuilder& Alignment(const EDivAlignment value) & {
        Value_[TStringBuf("alignment")] = ToString(value);
        return *this;
    }

};

[[nodiscard]] inline TDivCustomTextStyleBuilder DivCustomTextStyle() {
    return {};
}

[[nodiscard]] inline TDivCustomTextStyleBuilder DivCustomTextStyle(const i64 fontSize) {
    return TDivCustomTextStyleBuilder{}.FontSize(fontSize);
}

struct TDivUniversalBlockBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivUniversalBlockBuilder() {
        Value_.SetType(NJson::JSON_MAP);
        Value_[TStringBuf("type")] = TStringBuf("div-universal-block");
    }

    [[nodiscard]] TDivUniversalBlockBuilder&& Title(const TString& value) && {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMinLength(length, 1 /* minLength */);
        Value_[TStringBuf("title")] = value;
        return std::move(*this);
    }

    TDivUniversalBlockBuilder& Title(const TString& value) & {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMinLength(length, 1 /* minLength */);
        Value_[TStringBuf("title")] = value;
        return *this;
    }

    [[nodiscard]] TDivUniversalBlockBuilder&& TitleStyle(const EDivTextStyle value) && {
        Value_[TStringBuf("title_style")] = ToString(value);
        return std::move(*this);
    }

    TDivUniversalBlockBuilder& TitleStyle(const EDivTextStyle value) & {
        Value_[TStringBuf("title_style")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivUniversalBlockBuilder&& TitleMaxLines(const i64 value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number > 0"), [](const i64 number) { return number > 0; }, value);
        Value_[TStringBuf("title_max_lines")] = value;
        return std::move(*this);
    }

    TDivUniversalBlockBuilder& TitleMaxLines(const i64 value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number > 0"), [](const i64 number) { return number > 0; }, value);
        Value_[TStringBuf("title_max_lines")] = value;
        return *this;
    }

    [[nodiscard]] TDivUniversalBlockBuilder&& Text(const TString& value) && {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMinLength(length, 1 /* minLength */);
        Value_[TStringBuf("text")] = value;
        return std::move(*this);
    }

    TDivUniversalBlockBuilder& Text(const TString& value) & {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMinLength(length, 1 /* minLength */);
        Value_[TStringBuf("text")] = value;
        return *this;
    }

    [[nodiscard]] TDivUniversalBlockBuilder&& TextStyle(const EDivTextStyle value) && {
        Value_[TStringBuf("text_style")] = ToString(value);
        return std::move(*this);
    }

    TDivUniversalBlockBuilder& TextStyle(const EDivTextStyle value) & {
        Value_[TStringBuf("text_style")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivUniversalBlockBuilder&& TextMaxLines(const i64 value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number > 0"), [](const i64 number) { return number > 0; }, value);
        Value_[TStringBuf("text_max_lines")] = value;
        return std::move(*this);
    }

    TDivUniversalBlockBuilder& TextMaxLines(const i64 value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number > 0"), [](const i64 number) { return number > 0; }, value);
        Value_[TStringBuf("text_max_lines")] = value;
        return *this;
    }

    [[nodiscard]] TDivUniversalBlockBuilder&& SideElement(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("side_element")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivUniversalBlockBuilder& SideElement(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("side_element")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivUniversalBlockBuilder&& SideElement(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("side_element")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivUniversalBlockBuilder& SideElement(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("side_element")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

};

[[nodiscard]] inline TDivUniversalBlockBuilder DivUniversalBlock() {
    return {};
}

struct TDivUniversalBlockDateElementBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivUniversalBlockDateElementBuilder() {
        Value_.SetType(NJson::JSON_MAP);
        Value_[TStringBuf("type")] = TStringBuf("date_element");
    }

    [[nodiscard]] TDivUniversalBlockDateElementBuilder&& DateDay(const TString& value) && {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMinLength(length, 1 /* minLength */);
        Value_[TStringBuf("date_day")] = value;
        return std::move(*this);
    }

    TDivUniversalBlockDateElementBuilder& DateDay(const TString& value) & {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMinLength(length, 1 /* minLength */);
        Value_[TStringBuf("date_day")] = value;
        return *this;
    }

    [[nodiscard]] TDivUniversalBlockDateElementBuilder&& DateMonth(const TString& value) && {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMinLength(length, 1 /* minLength */);
        Value_[TStringBuf("date_month")] = value;
        return std::move(*this);
    }

    TDivUniversalBlockDateElementBuilder& DateMonth(const TString& value) & {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMinLength(length, 1 /* minLength */);
        Value_[TStringBuf("date_month")] = value;
        return *this;
    }

};

[[nodiscard]] inline TDivUniversalBlockDateElementBuilder DivUniversalBlockDateElement() {
    return {};
}

[[nodiscard]] inline TDivUniversalBlockDateElementBuilder DivUniversalBlockDateElement(const TString& dateDay) {
    return TDivUniversalBlockDateElementBuilder{}.DateDay(dateDay);
}

struct TDivUniversalBlockSideElementBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivUniversalBlockSideElementBuilder() {
        Value_.SetType(NJson::JSON_MAP);
    }

    [[nodiscard]] TDivUniversalBlockSideElementBuilder&& Element(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("element")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivUniversalBlockSideElementBuilder& Element(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("element")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivUniversalBlockSideElementBuilder&& Element(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("element")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivUniversalBlockSideElementBuilder& Element(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("element")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivUniversalBlockSideElementBuilder&& Size(const EDivSize value) && {
        Value_[TStringBuf("size")] = ToString(value);
        return std::move(*this);
    }

    TDivUniversalBlockSideElementBuilder& Size(const EDivSize value) & {
        Value_[TStringBuf("size")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivUniversalBlockSideElementBuilder&& Position(const EDivPosition value) && {
        Value_[TStringBuf("position")] = ToString(value);
        return std::move(*this);
    }

    TDivUniversalBlockSideElementBuilder& Position(const EDivPosition value) & {
        Value_[TStringBuf("position")] = ToString(value);
        return *this;
    }

};

[[nodiscard]] inline TDivUniversalBlockSideElementBuilder DivUniversalBlockSideElement() {
    return {};
}

[[nodiscard]] inline TDivUniversalBlockSideElementBuilder DivUniversalBlockSideElement(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& element) {
    return TDivUniversalBlockSideElementBuilder{}.Element(element);
}

[[nodiscard]] inline TDivUniversalBlockSideElementBuilder DivUniversalBlockSideElement(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& element) {
    return TDivUniversalBlockSideElementBuilder{}.Element(std::move(element));
}

struct TDivImageElementBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivImageElementBuilder() {
        Value_.SetType(NJson::JSON_MAP);
        Value_[TStringBuf("type")] = TStringBuf("div-image-element");
    }

    [[nodiscard]] TDivImageElementBuilder&& ImageUrl(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateUri(value);
        Value_[TStringBuf("image_url")] = value;
        return std::move(*this);
    }

    TDivImageElementBuilder& ImageUrl(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateUri(value);
        Value_[TStringBuf("image_url")] = value;
        return *this;
    }

    [[nodiscard]] TDivImageElementBuilder&& Ratio(const double value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateDoubleConstraint(TStringBuf("number >= 0.01 && number <= 100"), [](const double number) { return number >= 0.01 && number <= 100; }, value);
        Value_[TStringBuf("ratio")] = value;
        return std::move(*this);
    }

    TDivImageElementBuilder& Ratio(const double value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateDoubleConstraint(TStringBuf("number >= 0.01 && number <= 100"), [](const double number) { return number >= 0.01 && number <= 100; }, value);
        Value_[TStringBuf("ratio")] = value;
        return *this;
    }

};

[[nodiscard]] inline TDivImageElementBuilder DivImageElement() {
    return {};
}

[[nodiscard]] inline TDivImageElementBuilder DivImageElement(const TString& imageUrl) {
    return TDivImageElementBuilder{}.ImageUrl(imageUrl);
}

struct TDivDataBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivDataBuilder() {
        Value_.SetType(NJson::JSON_MAP);
    }

    [[nodiscard]] TDivDataBuilder&& AddState(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("states")].AppendValue(value.ValueWithoutValidation());
        return std::move(*this);
    }

    TDivDataBuilder& AddState(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("states")].AppendValue(value.ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivDataBuilder&& AddState(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("states")].AppendValue(std::move(value).ValueWithoutValidation());
        return std::move(*this);
    }

    TDivDataBuilder& AddState(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("states")].AppendValue(std::move(value).ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivDataBuilder&& States(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) && {
        Value_[TStringBuf("states")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivDataBuilder& States(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) & {
        Value_[TStringBuf("states")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivDataBuilder&& States(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) && {
        Value_[TStringBuf("states")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivDataBuilder& States(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) & {
        Value_[TStringBuf("states")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivDataBuilder&& Width(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("width")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivDataBuilder& Width(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("width")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivDataBuilder&& Width(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("width")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivDataBuilder& Width(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("width")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivDataBuilder&& AddBackground(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("background")].AppendValue(value.ValueWithoutValidation());
        return std::move(*this);
    }

    TDivDataBuilder& AddBackground(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("background")].AppendValue(value.ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivDataBuilder&& AddBackground(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("background")].AppendValue(std::move(value).ValueWithoutValidation());
        return std::move(*this);
    }

    TDivDataBuilder& AddBackground(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("background")].AppendValue(std::move(value).ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivDataBuilder&& Background(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) && {
        Value_[TStringBuf("background")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivDataBuilder& Background(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) & {
        Value_[TStringBuf("background")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivDataBuilder&& Background(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) && {
        Value_[TStringBuf("background")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivDataBuilder& Background(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) & {
        Value_[TStringBuf("background")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

};

[[nodiscard]] inline TDivDataBuilder DivData() {
    return {};
}

struct TDivDataDivStateBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivDataDivStateBuilder() {
        Value_.SetType(NJson::JSON_MAP);
    }

    [[nodiscard]] TDivDataDivStateBuilder&& StateId(const i64 value) && {
        Value_[TStringBuf("state_id")] = value;
        return std::move(*this);
    }

    TDivDataDivStateBuilder& StateId(const i64 value) & {
        Value_[TStringBuf("state_id")] = value;
        return *this;
    }

    [[nodiscard]] TDivDataDivStateBuilder&& AddBlock(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("blocks")].AppendValue(value.ValueWithoutValidation());
        return std::move(*this);
    }

    TDivDataDivStateBuilder& AddBlock(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("blocks")].AppendValue(value.ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivDataDivStateBuilder&& AddBlock(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("blocks")].AppendValue(std::move(value).ValueWithoutValidation());
        return std::move(*this);
    }

    TDivDataDivStateBuilder& AddBlock(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("blocks")].AppendValue(std::move(value).ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivDataDivStateBuilder&& Blocks(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) && {
        Value_[TStringBuf("blocks")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivDataDivStateBuilder& Blocks(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) & {
        Value_[TStringBuf("blocks")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivDataDivStateBuilder&& Blocks(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) && {
        Value_[TStringBuf("blocks")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivDataDivStateBuilder& Blocks(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) & {
        Value_[TStringBuf("blocks")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivDataDivStateBuilder&& Action(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("action")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivDataDivStateBuilder& Action(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("action")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivDataDivStateBuilder&& Action(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("action")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivDataDivStateBuilder& Action(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("action")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

};

[[nodiscard]] inline TDivDataDivStateBuilder DivDataDivState() {
    return {};
}

[[nodiscard]] inline TDivDataDivStateBuilder DivDataDivState(const i64 stateId) {
    return TDivDataDivStateBuilder{}.StateId(stateId);
}

struct TDivFooterBlockBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivFooterBlockBuilder() {
        Value_.SetType(NJson::JSON_MAP);
        Value_[TStringBuf("type")] = TStringBuf("div-footer-block");
    }

    [[nodiscard]] TDivFooterBlockBuilder&& Text(const TString& value) && {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMinLength(length, 1 /* minLength */);
        Value_[TStringBuf("text")] = value;
        return std::move(*this);
    }

    TDivFooterBlockBuilder& Text(const TString& value) & {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMinLength(length, 1 /* minLength */);
        Value_[TStringBuf("text")] = value;
        return *this;
    }

    [[nodiscard]] TDivFooterBlockBuilder&& TextStyle(const EDivTextStyle value) && {
        Value_[TStringBuf("text_style")] = ToString(value);
        return std::move(*this);
    }

    TDivFooterBlockBuilder& TextStyle(const EDivTextStyle value) & {
        Value_[TStringBuf("text_style")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivFooterBlockBuilder&& Image(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("image")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivFooterBlockBuilder& Image(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("image")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivFooterBlockBuilder&& Image(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("image")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivFooterBlockBuilder& Image(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("image")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

};

[[nodiscard]] inline TDivFooterBlockBuilder DivFooterBlock() {
    return {};
}

struct TDivTitleBlockBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivTitleBlockBuilder() {
        Value_.SetType(NJson::JSON_MAP);
        Value_[TStringBuf("type")] = TStringBuf("div-title-block");
    }

    [[nodiscard]] TDivTitleBlockBuilder&& Text(const TString& value) && {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMinLength(length, 1 /* minLength */);
        Value_[TStringBuf("text")] = value;
        return std::move(*this);
    }

    TDivTitleBlockBuilder& Text(const TString& value) & {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMinLength(length, 1 /* minLength */);
        Value_[TStringBuf("text")] = value;
        return *this;
    }

    [[nodiscard]] TDivTitleBlockBuilder&& TextStyle(const EDivTextStyle value) && {
        Value_[TStringBuf("text_style")] = ToString(value);
        return std::move(*this);
    }

    TDivTitleBlockBuilder& TextStyle(const EDivTextStyle value) & {
        Value_[TStringBuf("text_style")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivTitleBlockBuilder&& MenuColor(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("menu_color")] = value;
        return std::move(*this);
    }

    TDivTitleBlockBuilder& MenuColor(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("menu_color")] = value;
        return *this;
    }

    [[nodiscard]] TDivTitleBlockBuilder&& AddMenuItem(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("menu_items")].AppendValue(value.ValueWithoutValidation());
        return std::move(*this);
    }

    TDivTitleBlockBuilder& AddMenuItem(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("menu_items")].AppendValue(value.ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivTitleBlockBuilder&& AddMenuItem(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("menu_items")].AppendValue(std::move(value).ValueWithoutValidation());
        return std::move(*this);
    }

    TDivTitleBlockBuilder& AddMenuItem(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("menu_items")].AppendValue(std::move(value).ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivTitleBlockBuilder&& MenuItems(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) && {
        Value_[TStringBuf("menu_items")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTitleBlockBuilder& MenuItems(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) & {
        Value_[TStringBuf("menu_items")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTitleBlockBuilder&& MenuItems(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) && {
        Value_[TStringBuf("menu_items")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTitleBlockBuilder& MenuItems(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) & {
        Value_[TStringBuf("menu_items")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

};

[[nodiscard]] inline TDivTitleBlockBuilder DivTitleBlock() {
    return {};
}

struct TDivTitleBlockMenuItemBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivTitleBlockMenuItemBuilder() {
        Value_.SetType(NJson::JSON_MAP);
    }

    [[nodiscard]] TDivTitleBlockMenuItemBuilder&& Text(const TString& value) && {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMinLength(length, 1 /* minLength */);
        Value_[TStringBuf("text")] = value;
        return std::move(*this);
    }

    TDivTitleBlockMenuItemBuilder& Text(const TString& value) & {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMinLength(length, 1 /* minLength */);
        Value_[TStringBuf("text")] = value;
        return *this;
    }

    [[nodiscard]] TDivTitleBlockMenuItemBuilder&& Url(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateUri(value);
        Value_[TStringBuf("url")] = value;
        return std::move(*this);
    }

    TDivTitleBlockMenuItemBuilder& Url(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateUri(value);
        Value_[TStringBuf("url")] = value;
        return *this;
    }

};

[[nodiscard]] inline TDivTitleBlockMenuItemBuilder DivTitleBlockMenuItem() {
    return {};
}

[[nodiscard]] inline TDivTitleBlockMenuItemBuilder DivTitleBlockMenuItem(const TString& text, const TString& url) {
    return TDivTitleBlockMenuItemBuilder{}.Text(text).Url(url);
}

struct TDivSolidBackgroundBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivSolidBackgroundBuilder() {
        Value_.SetType(NJson::JSON_MAP);
        Value_[TStringBuf("type")] = TStringBuf("div-solid-background");
    }

    [[nodiscard]] TDivSolidBackgroundBuilder&& Color(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("color")] = value;
        return std::move(*this);
    }

    TDivSolidBackgroundBuilder& Color(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("color")] = value;
        return *this;
    }

};

[[nodiscard]] inline TDivSolidBackgroundBuilder DivSolidBackground() {
    return {};
}

[[nodiscard]] inline TDivSolidBackgroundBuilder DivSolidBackground(const TString& color) {
    return TDivSolidBackgroundBuilder{}.Color(color);
}

struct TDivGradientBackgroundBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivGradientBackgroundBuilder() {
        Value_.SetType(NJson::JSON_MAP);
        Value_[TStringBuf("type")] = TStringBuf("div-gradient-background");
    }

    [[nodiscard]] TDivGradientBackgroundBuilder&& StartColor(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("start_color")] = value;
        return std::move(*this);
    }

    TDivGradientBackgroundBuilder& StartColor(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("start_color")] = value;
        return *this;
    }

    [[nodiscard]] TDivGradientBackgroundBuilder&& EndColor(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("end_color")] = value;
        return std::move(*this);
    }

    TDivGradientBackgroundBuilder& EndColor(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("end_color")] = value;
        return *this;
    }

};

[[nodiscard]] inline TDivGradientBackgroundBuilder DivGradientBackground() {
    return {};
}

[[nodiscard]] inline TDivGradientBackgroundBuilder DivGradientBackground(const TString& startColor, const TString& endColor) {
    return TDivGradientBackgroundBuilder{}.StartColor(startColor).EndColor(endColor);
}

struct TDivActionBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivActionBuilder() {
        Value_.SetType(NJson::JSON_MAP);
    }

    [[nodiscard]] TDivActionBuilder&& Url(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateUri(value);
        Value_[TStringBuf("url")] = value;
        return std::move(*this);
    }

    TDivActionBuilder& Url(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateUri(value);
        Value_[TStringBuf("url")] = value;
        return *this;
    }

    [[nodiscard]] TDivActionBuilder&& LogId(const TString& value) && {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMinLength(length, 1 /* minLength */);
        Value_[TStringBuf("log_id")] = value;
        return std::move(*this);
    }

    TDivActionBuilder& LogId(const TString& value) & {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMinLength(length, 1 /* minLength */);
        Value_[TStringBuf("log_id")] = value;
        return *this;
    }

};

[[nodiscard]] inline TDivActionBuilder DivAction() {
    return {};
}

[[nodiscard]] inline TDivActionBuilder DivAction(const TString& url) {
    return TDivActionBuilder{}.Url(url);
}

struct TDivPaddingModifierBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivPaddingModifierBuilder() {
        Value_.SetType(NJson::JSON_MAP);
    }

    [[nodiscard]] TDivPaddingModifierBuilder&& Size(const EDivSize value) && {
        Value_[TStringBuf("size")] = ToString(value);
        return std::move(*this);
    }

    TDivPaddingModifierBuilder& Size(const EDivSize value) & {
        Value_[TStringBuf("size")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivPaddingModifierBuilder&& Position(const EDivPosition value) && {
        Value_[TStringBuf("position")] = ToString(value);
        return std::move(*this);
    }

    TDivPaddingModifierBuilder& Position(const EDivPosition value) & {
        Value_[TStringBuf("position")] = ToString(value);
        return *this;
    }

};

[[nodiscard]] inline TDivPaddingModifierBuilder DivPaddingModifier() {
    return {};
}

[[nodiscard]] inline TDivPaddingModifierBuilder DivPaddingModifier(const EDivSize size) {
    return TDivPaddingModifierBuilder{}.Size(size);
}

struct TDivButtonsBlockBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivButtonsBlockBuilder() {
        Value_.SetType(NJson::JSON_MAP);
        Value_[TStringBuf("type")] = TStringBuf("div-buttons-block");
    }

    [[nodiscard]] TDivButtonsBlockBuilder&& AddItem(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("items")].AppendValue(value.ValueWithoutValidation());
        return std::move(*this);
    }

    TDivButtonsBlockBuilder& AddItem(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("items")].AppendValue(value.ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivButtonsBlockBuilder&& AddItem(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("items")].AppendValue(std::move(value).ValueWithoutValidation());
        return std::move(*this);
    }

    TDivButtonsBlockBuilder& AddItem(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("items")].AppendValue(std::move(value).ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivButtonsBlockBuilder&& Items(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) && {
        Value_[TStringBuf("items")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivButtonsBlockBuilder& Items(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) & {
        Value_[TStringBuf("items")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivButtonsBlockBuilder&& Items(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) && {
        Value_[TStringBuf("items")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivButtonsBlockBuilder& Items(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) & {
        Value_[TStringBuf("items")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivButtonsBlockBuilder&& Alignment(const EDivAlignment value) && {
        Value_[TStringBuf("alignment")] = ToString(value);
        return std::move(*this);
    }

    TDivButtonsBlockBuilder& Alignment(const EDivAlignment value) & {
        Value_[TStringBuf("alignment")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivButtonsBlockBuilder&& IsFullwidth(const bool value) && {
        Value_[TStringBuf("is_fullwidth")] = static_cast<i64>(value);
        return std::move(*this);
    }

    TDivButtonsBlockBuilder& IsFullwidth(const bool value) & {
        Value_[TStringBuf("is_fullwidth")] = static_cast<i64>(value);
        return *this;
    }

};

[[nodiscard]] inline TDivButtonsBlockBuilder DivButtonsBlock() {
    return {};
}

struct TDivButtonsBlockDivButtonElementBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivButtonsBlockDivButtonElementBuilder() {
        Value_.SetType(NJson::JSON_MAP);
    }

    [[nodiscard]] TDivButtonsBlockDivButtonElementBuilder&& Text(const TString& value) && {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMinLength(length, 1 /* minLength */);
        Value_[TStringBuf("text")] = value;
        return std::move(*this);
    }

    TDivButtonsBlockDivButtonElementBuilder& Text(const TString& value) & {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMinLength(length, 1 /* minLength */);
        Value_[TStringBuf("text")] = value;
        return *this;
    }

    [[nodiscard]] TDivButtonsBlockDivButtonElementBuilder&& Image(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("image")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivButtonsBlockDivButtonElementBuilder& Image(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("image")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivButtonsBlockDivButtonElementBuilder&& Image(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("image")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivButtonsBlockDivButtonElementBuilder& Image(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("image")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivButtonsBlockDivButtonElementBuilder&& BackgroundColor(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("background_color")] = value;
        return std::move(*this);
    }

    TDivButtonsBlockDivButtonElementBuilder& BackgroundColor(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("background_color")] = value;
        return *this;
    }

    [[nodiscard]] TDivButtonsBlockDivButtonElementBuilder&& Action(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("action")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivButtonsBlockDivButtonElementBuilder& Action(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("action")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivButtonsBlockDivButtonElementBuilder&& Action(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("action")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivButtonsBlockDivButtonElementBuilder& Action(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("action")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

};

[[nodiscard]] inline TDivButtonsBlockDivButtonElementBuilder DivButtonsBlockDivButtonElement() {
    return {};
}

[[nodiscard]] inline TDivButtonsBlockDivButtonElementBuilder DivButtonsBlockDivButtonElement(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& action) {
    return TDivButtonsBlockDivButtonElementBuilder{}.Action(action);
}

[[nodiscard]] inline TDivButtonsBlockDivButtonElementBuilder DivButtonsBlockDivButtonElement(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& action) {
    return TDivButtonsBlockDivButtonElementBuilder{}.Action(std::move(action));
}

struct TDivTabsBlockBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivTabsBlockBuilder() {
        Value_.SetType(NJson::JSON_MAP);
        Value_[TStringBuf("type")] = TStringBuf("div-tabs-block");
    }

    [[nodiscard]] TDivTabsBlockBuilder&& AddItem(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("items")].AppendValue(value.ValueWithoutValidation());
        return std::move(*this);
    }

    TDivTabsBlockBuilder& AddItem(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("items")].AppendValue(value.ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivTabsBlockBuilder&& AddItem(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("items")].AppendValue(std::move(value).ValueWithoutValidation());
        return std::move(*this);
    }

    TDivTabsBlockBuilder& AddItem(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("items")].AppendValue(std::move(value).ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivTabsBlockBuilder&& Items(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) && {
        Value_[TStringBuf("items")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTabsBlockBuilder& Items(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) & {
        Value_[TStringBuf("items")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTabsBlockBuilder&& Items(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) && {
        Value_[TStringBuf("items")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTabsBlockBuilder& Items(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) & {
        Value_[TStringBuf("items")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTabsBlockBuilder&& InactiveTabColor(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("inactive_tab_color")] = value;
        return std::move(*this);
    }

    TDivTabsBlockBuilder& InactiveTabColor(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("inactive_tab_color")] = value;
        return *this;
    }

    [[nodiscard]] TDivTabsBlockBuilder&& InactiveTabCustomTextStyle(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("inactive_tab_custom_text_style")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTabsBlockBuilder& InactiveTabCustomTextStyle(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("inactive_tab_custom_text_style")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTabsBlockBuilder&& InactiveTabCustomTextStyle(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("inactive_tab_custom_text_style")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTabsBlockBuilder& InactiveTabCustomTextStyle(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("inactive_tab_custom_text_style")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTabsBlockBuilder&& ActiveTabColor(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("active_tab_color")] = value;
        return std::move(*this);
    }

    TDivTabsBlockBuilder& ActiveTabColor(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("active_tab_color")] = value;
        return *this;
    }

    [[nodiscard]] TDivTabsBlockBuilder&& ActiveTabBgColor(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("active_tab_bg_color")] = value;
        return std::move(*this);
    }

    TDivTabsBlockBuilder& ActiveTabBgColor(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("active_tab_bg_color")] = value;
        return *this;
    }

    [[nodiscard]] TDivTabsBlockBuilder&& ActiveTabCustomTextStyle(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("active_tab_custom_text_style")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTabsBlockBuilder& ActiveTabCustomTextStyle(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("active_tab_custom_text_style")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTabsBlockBuilder&& ActiveTabCustomTextStyle(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("active_tab_custom_text_style")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTabsBlockBuilder& ActiveTabCustomTextStyle(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("active_tab_custom_text_style")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTabsBlockBuilder&& DelimiterColor(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("delimiter_color")] = value;
        return std::move(*this);
    }

    TDivTabsBlockBuilder& DelimiterColor(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("delimiter_color")] = value;
        return *this;
    }

    [[nodiscard]] TDivTabsBlockBuilder&& HasDelimiter(const bool value) && {
        Value_[TStringBuf("has_delimiter")] = static_cast<i64>(value);
        return std::move(*this);
    }

    TDivTabsBlockBuilder& HasDelimiter(const bool value) & {
        Value_[TStringBuf("has_delimiter")] = static_cast<i64>(value);
        return *this;
    }

};

[[nodiscard]] inline TDivTabsBlockBuilder DivTabsBlock() {
    return {};
}

struct TDivTabsBlockItemBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivTabsBlockItemBuilder() {
        Value_.SetType(NJson::JSON_MAP);
    }

    [[nodiscard]] TDivTabsBlockItemBuilder&& Title(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("title")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTabsBlockItemBuilder& Title(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("title")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTabsBlockItemBuilder&& Title(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("title")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTabsBlockItemBuilder& Title(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("title")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTabsBlockItemBuilder&& Content(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("content")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTabsBlockItemBuilder& Content(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("content")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTabsBlockItemBuilder&& Content(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("content")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTabsBlockItemBuilder& Content(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("content")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

};

[[nodiscard]] inline TDivTabsBlockItemBuilder DivTabsBlockItem() {
    return {};
}

[[nodiscard]] inline TDivTabsBlockItemBuilder DivTabsBlockItem(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& title, const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& content) {
    return TDivTabsBlockItemBuilder{}.Title(title).Content(content);
}

[[nodiscard]] inline TDivTabsBlockItemBuilder DivTabsBlockItem(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& title, NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& content) {
    return TDivTabsBlockItemBuilder{}.Title(title).Content(std::move(content));
}

[[nodiscard]] inline TDivTabsBlockItemBuilder DivTabsBlockItem(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& title, const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& content) {
    return TDivTabsBlockItemBuilder{}.Title(std::move(title)).Content(content);
}

[[nodiscard]] inline TDivTabsBlockItemBuilder DivTabsBlockItem(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& title, NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& content) {
    return TDivTabsBlockItemBuilder{}.Title(std::move(title)).Content(std::move(content));
}

struct TDivTabsBlockItemTitleBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivTabsBlockItemTitleBuilder() {
        Value_.SetType(NJson::JSON_MAP);
    }

    [[nodiscard]] TDivTabsBlockItemTitleBuilder&& Text(const TString& value) && {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMinLength(length, 1 /* minLength */);
        Value_[TStringBuf("text")] = value;
        return std::move(*this);
    }

    TDivTabsBlockItemTitleBuilder& Text(const TString& value) & {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMinLength(length, 1 /* minLength */);
        Value_[TStringBuf("text")] = value;
        return *this;
    }

    [[nodiscard]] TDivTabsBlockItemTitleBuilder&& Action(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("action")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTabsBlockItemTitleBuilder& Action(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("action")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTabsBlockItemTitleBuilder&& Action(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("action")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTabsBlockItemTitleBuilder& Action(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("action")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

};

[[nodiscard]] inline TDivTabsBlockItemTitleBuilder DivTabsBlockItemTitle() {
    return {};
}

[[nodiscard]] inline TDivTabsBlockItemTitleBuilder DivTabsBlockItemTitle(const TString& text) {
    return TDivTabsBlockItemTitleBuilder{}.Text(text);
}

struct TDivNumericSizeBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivNumericSizeBuilder() {
        Value_.SetType(NJson::JSON_MAP);
        Value_[TStringBuf("type")] = TStringBuf("numeric");
    }

    [[nodiscard]] TDivNumericSizeBuilder&& Value(const i64 value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("value")] = value;
        return std::move(*this);
    }

    TDivNumericSizeBuilder& Value(const i64 value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("value")] = value;
        return *this;
    }

    [[nodiscard]] TDivNumericSizeBuilder&& Unit(const EDivSizeUnit value) && {
        Value_[TStringBuf("unit")] = ToString(value);
        return std::move(*this);
    }

    TDivNumericSizeBuilder& Unit(const EDivSizeUnit value) & {
        Value_[TStringBuf("unit")] = ToString(value);
        return *this;
    }

};

[[nodiscard]] inline TDivNumericSizeBuilder DivNumericSize() {
    return {};
}

[[nodiscard]] inline TDivNumericSizeBuilder DivNumericSize(const i64 value) {
    return TDivNumericSizeBuilder{}.Value(value);
}

struct TDivGalleryBlockBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivGalleryBlockBuilder() {
        Value_.SetType(NJson::JSON_MAP);
        Value_[TStringBuf("type")] = TStringBuf("div-gallery-block");
    }

    [[nodiscard]] TDivGalleryBlockBuilder&& AddItem(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("items")].AppendValue(value.ValueWithoutValidation());
        return std::move(*this);
    }

    TDivGalleryBlockBuilder& AddItem(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("items")].AppendValue(value.ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivGalleryBlockBuilder&& AddItem(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("items")].AppendValue(std::move(value).ValueWithoutValidation());
        return std::move(*this);
    }

    TDivGalleryBlockBuilder& AddItem(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("items")].AppendValue(std::move(value).ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivGalleryBlockBuilder&& Items(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) && {
        Value_[TStringBuf("items")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivGalleryBlockBuilder& Items(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) & {
        Value_[TStringBuf("items")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivGalleryBlockBuilder&& Items(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) && {
        Value_[TStringBuf("items")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivGalleryBlockBuilder& Items(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) & {
        Value_[TStringBuf("items")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivGalleryBlockBuilder&& PaddingBetweenItems(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("padding_between_items")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivGalleryBlockBuilder& PaddingBetweenItems(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("padding_between_items")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivGalleryBlockBuilder&& PaddingBetweenItems(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("padding_between_items")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivGalleryBlockBuilder& PaddingBetweenItems(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("padding_between_items")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivGalleryBlockBuilder&& Tail(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("tail")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivGalleryBlockBuilder& Tail(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("tail")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivGalleryBlockBuilder&& Tail(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("tail")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivGalleryBlockBuilder& Tail(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("tail")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivGalleryBlockBuilder&& PaddingTop(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("padding_top")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivGalleryBlockBuilder& PaddingTop(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("padding_top")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivGalleryBlockBuilder&& PaddingTop(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("padding_top")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivGalleryBlockBuilder& PaddingTop(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("padding_top")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivGalleryBlockBuilder&& PaddingBottom(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("padding_bottom")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivGalleryBlockBuilder& PaddingBottom(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("padding_bottom")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivGalleryBlockBuilder&& PaddingBottom(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("padding_bottom")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivGalleryBlockBuilder& PaddingBottom(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("padding_bottom")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

};

[[nodiscard]] inline TDivGalleryBlockBuilder DivGalleryBlock() {
    return {};
}

struct TDivGalleryBlockIconBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivGalleryBlockIconBuilder() {
        Value_.SetType(NJson::JSON_MAP);
    }

    [[nodiscard]] TDivGalleryBlockIconBuilder&& ImageUrl(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateUri(value);
        Value_[TStringBuf("image_url")] = value;
        return std::move(*this);
    }

    TDivGalleryBlockIconBuilder& ImageUrl(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateUri(value);
        Value_[TStringBuf("image_url")] = value;
        return *this;
    }

    [[nodiscard]] TDivGalleryBlockIconBuilder&& IconColor(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("icon_color")] = value;
        return std::move(*this);
    }

    TDivGalleryBlockIconBuilder& IconColor(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("icon_color")] = value;
        return *this;
    }

    [[nodiscard]] TDivGalleryBlockIconBuilder&& BorderColor(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("border_color")] = value;
        return std::move(*this);
    }

    TDivGalleryBlockIconBuilder& BorderColor(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("border_color")] = value;
        return *this;
    }

    [[nodiscard]] TDivGalleryBlockIconBuilder&& FillColor(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("fill_color")] = value;
        return std::move(*this);
    }

    TDivGalleryBlockIconBuilder& FillColor(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("fill_color")] = value;
        return *this;
    }

};

[[nodiscard]] inline TDivGalleryBlockIconBuilder DivGalleryBlockIcon() {
    return {};
}

struct TDivGalleryBlockTailBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivGalleryBlockTailBuilder() {
        Value_.SetType(NJson::JSON_MAP);
    }

    [[nodiscard]] TDivGalleryBlockTailBuilder&& Action(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("action")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivGalleryBlockTailBuilder& Action(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("action")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivGalleryBlockTailBuilder&& Action(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("action")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivGalleryBlockTailBuilder& Action(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("action")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivGalleryBlockTailBuilder&& Text(const TString& value) && {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMinLength(length, 1 /* minLength */);
        Value_[TStringBuf("text")] = value;
        return std::move(*this);
    }

    TDivGalleryBlockTailBuilder& Text(const TString& value) & {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMinLength(length, 1 /* minLength */);
        Value_[TStringBuf("text")] = value;
        return *this;
    }

    [[nodiscard]] TDivGalleryBlockTailBuilder&& TextStyle(const EDivTextStyle value) && {
        Value_[TStringBuf("text_style")] = ToString(value);
        return std::move(*this);
    }

    TDivGalleryBlockTailBuilder& TextStyle(const EDivTextStyle value) & {
        Value_[TStringBuf("text_style")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivGalleryBlockTailBuilder&& Icon(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("icon")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivGalleryBlockTailBuilder& Icon(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("icon")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivGalleryBlockTailBuilder&& Icon(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("icon")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivGalleryBlockTailBuilder& Icon(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("icon")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

};

[[nodiscard]] inline TDivGalleryBlockTailBuilder DivGalleryBlockTail() {
    return {};
}

[[nodiscard]] inline TDivGalleryBlockTailBuilder DivGalleryBlockTail(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& action, const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& icon) {
    return TDivGalleryBlockTailBuilder{}.Action(action).Icon(icon);
}

[[nodiscard]] inline TDivGalleryBlockTailBuilder DivGalleryBlockTail(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& action, NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& icon) {
    return TDivGalleryBlockTailBuilder{}.Action(action).Icon(std::move(icon));
}

[[nodiscard]] inline TDivGalleryBlockTailBuilder DivGalleryBlockTail(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& action, const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& icon) {
    return TDivGalleryBlockTailBuilder{}.Action(std::move(action)).Icon(icon);
}

[[nodiscard]] inline TDivGalleryBlockTailBuilder DivGalleryBlockTail(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& action, NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& icon) {
    return TDivGalleryBlockTailBuilder{}.Action(std::move(action)).Icon(std::move(icon));
}

struct TDivImageBackgroundBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivImageBackgroundBuilder() {
        Value_.SetType(NJson::JSON_MAP);
        Value_[TStringBuf("type")] = TStringBuf("div-image-background");
    }

    [[nodiscard]] TDivImageBackgroundBuilder&& ImageUrl(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateUri(value);
        Value_[TStringBuf("image_url")] = value;
        return std::move(*this);
    }

    TDivImageBackgroundBuilder& ImageUrl(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateUri(value);
        Value_[TStringBuf("image_url")] = value;
        return *this;
    }

};

[[nodiscard]] inline TDivImageBackgroundBuilder DivImageBackground() {
    return {};
}

[[nodiscard]] inline TDivImageBackgroundBuilder DivImageBackground(const TString& imageUrl) {
    return TDivImageBackgroundBuilder{}.ImageUrl(imageUrl);
}

struct TDivSeparatorBlockBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivSeparatorBlockBuilder() {
        Value_.SetType(NJson::JSON_MAP);
        Value_[TStringBuf("type")] = TStringBuf("div-separator-block");
    }

    [[nodiscard]] TDivSeparatorBlockBuilder&& Size(const EDivSize value) && {
        Value_[TStringBuf("size")] = ToString(value);
        return std::move(*this);
    }

    TDivSeparatorBlockBuilder& Size(const EDivSize value) & {
        Value_[TStringBuf("size")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivSeparatorBlockBuilder&& Weight(const i64 value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("weight")] = value;
        return std::move(*this);
    }

    TDivSeparatorBlockBuilder& Weight(const i64 value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("weight")] = value;
        return *this;
    }

    [[nodiscard]] TDivSeparatorBlockBuilder&& HasDelimiter(const bool value) && {
        Value_[TStringBuf("has_delimiter")] = static_cast<i64>(value);
        return std::move(*this);
    }

    TDivSeparatorBlockBuilder& HasDelimiter(const bool value) & {
        Value_[TStringBuf("has_delimiter")] = static_cast<i64>(value);
        return *this;
    }

    [[nodiscard]] TDivSeparatorBlockBuilder&& DelimiterColor(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("delimiter_color")] = value;
        return std::move(*this);
    }

    TDivSeparatorBlockBuilder& DelimiterColor(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("delimiter_color")] = value;
        return *this;
    }

};

[[nodiscard]] inline TDivSeparatorBlockBuilder DivSeparatorBlock() {
    return {};
}

struct TDivImageBlockBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivImageBlockBuilder() {
        Value_.SetType(NJson::JSON_MAP);
        Value_[TStringBuf("type")] = TStringBuf("div-image-block");
    }

    [[nodiscard]] TDivImageBlockBuilder&& Image(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("image")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivImageBlockBuilder& Image(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("image")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivImageBlockBuilder&& Image(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("image")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivImageBlockBuilder& Image(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("image")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

};

[[nodiscard]] inline TDivImageBlockBuilder DivImageBlock() {
    return {};
}

[[nodiscard]] inline TDivImageBlockBuilder DivImageBlock(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& image) {
    return TDivImageBlockBuilder{}.Image(image);
}

[[nodiscard]] inline TDivImageBlockBuilder DivImageBlock(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& image) {
    return TDivImageBlockBuilder{}.Image(std::move(image));
}

struct TDivBaseBlockBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivBaseBlockBuilder() {
        Value_.SetType(NJson::JSON_MAP);
    }

    [[nodiscard]] TDivBaseBlockBuilder&& PaddingModifier(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("padding_modifier")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivBaseBlockBuilder& PaddingModifier(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("padding_modifier")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivBaseBlockBuilder&& PaddingModifier(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("padding_modifier")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivBaseBlockBuilder& PaddingModifier(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("padding_modifier")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivBaseBlockBuilder&& Action(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("action")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivBaseBlockBuilder& Action(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("action")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivBaseBlockBuilder&& Action(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("action")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivBaseBlockBuilder& Action(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("action")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

};

[[nodiscard]] inline TDivBaseBlockBuilder DivBaseBlock() {
    return {};
}

}  // namespace NAlice::NJsonSchemaBuilder::NDiv1
