#pragma once

//////////////////////////////////////////////////////////////////////
// WARNING: this code was automatically generated by alice/json_schema_builder/tool,
// don't edit it manually.
//////////////////////////////////////////////////////////////////////

#include <alice/json_schema_builder/runtime/runtime.h>

#include "enums.h"
#include "patterns.h"

namespace NAlice::NJsonSchemaBuilder::NDiv2 {

struct TDivEdgeInsetsBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivEdgeInsetsBuilder() {
        Value_.SetType(NJson::JSON_MAP);
    }

    [[nodiscard]] TDivEdgeInsetsBuilder&& Left(const i64 value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("left")] = value;
        return std::move(*this);
    }

    TDivEdgeInsetsBuilder& Left(const i64 value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("left")] = value;
        return *this;
    }

    [[nodiscard]] TDivEdgeInsetsBuilder&& Right(const i64 value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("right")] = value;
        return std::move(*this);
    }

    TDivEdgeInsetsBuilder& Right(const i64 value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("right")] = value;
        return *this;
    }

    [[nodiscard]] TDivEdgeInsetsBuilder&& Top(const i64 value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("top")] = value;
        return std::move(*this);
    }

    TDivEdgeInsetsBuilder& Top(const i64 value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("top")] = value;
        return *this;
    }

    [[nodiscard]] TDivEdgeInsetsBuilder&& Bottom(const i64 value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("bottom")] = value;
        return std::move(*this);
    }

    TDivEdgeInsetsBuilder& Bottom(const i64 value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("bottom")] = value;
        return *this;
    }

};

[[nodiscard]] inline TDivEdgeInsetsBuilder DivEdgeInsets() {
    return {};
}

struct TDivTabsBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivTabsBuilder() {
        Value_.SetType(NJson::JSON_MAP);
        Value_[TStringBuf("type")] = TStringBuf("tabs");
    }

    [[nodiscard]] TDivTabsBuilder&& TitlePaddings(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("title_paddings")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTabsBuilder& TitlePaddings(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("title_paddings")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTabsBuilder&& TitlePaddings(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("title_paddings")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTabsBuilder& TitlePaddings(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("title_paddings")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTabsBuilder&& SeparatorPaddings(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("separator_paddings")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTabsBuilder& SeparatorPaddings(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("separator_paddings")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTabsBuilder&& SeparatorPaddings(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("separator_paddings")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTabsBuilder& SeparatorPaddings(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("separator_paddings")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTabsBuilder&& TabTitleStyle(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("tab_title_style")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTabsBuilder& TabTitleStyle(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("tab_title_style")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTabsBuilder&& TabTitleStyle(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("tab_title_style")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTabsBuilder& TabTitleStyle(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("tab_title_style")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTabsBuilder&& SelectedTab(const i64 value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("selected_tab")] = value;
        return std::move(*this);
    }

    TDivTabsBuilder& SelectedTab(const i64 value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("selected_tab")] = value;
        return *this;
    }

    [[nodiscard]] TDivTabsBuilder&& HasSeparator(const bool value) && {
        Value_[TStringBuf("has_separator")] = static_cast<i64>(value);
        return std::move(*this);
    }

    TDivTabsBuilder& HasSeparator(const bool value) & {
        Value_[TStringBuf("has_separator")] = static_cast<i64>(value);
        return *this;
    }

    [[nodiscard]] TDivTabsBuilder&& SwitchTabsByContentSwipeEnabled(const bool value) && {
        Value_[TStringBuf("switch_tabs_by_content_swipe_enabled")] = static_cast<i64>(value);
        return std::move(*this);
    }

    TDivTabsBuilder& SwitchTabsByContentSwipeEnabled(const bool value) & {
        Value_[TStringBuf("switch_tabs_by_content_swipe_enabled")] = static_cast<i64>(value);
        return *this;
    }

    [[nodiscard]] TDivTabsBuilder&& SeparatorColor(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("separator_color")] = value;
        return std::move(*this);
    }

    TDivTabsBuilder& SeparatorColor(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("separator_color")] = value;
        return *this;
    }

    [[nodiscard]] TDivTabsBuilder&& AddItem(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("items")].AppendValue(value.ValueWithoutValidation());
        return std::move(*this);
    }

    TDivTabsBuilder& AddItem(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("items")].AppendValue(value.ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivTabsBuilder&& AddItem(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("items")].AppendValue(std::move(value).ValueWithoutValidation());
        return std::move(*this);
    }

    TDivTabsBuilder& AddItem(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("items")].AppendValue(std::move(value).ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivTabsBuilder&& Items(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) && {
        Value_[TStringBuf("items")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTabsBuilder& Items(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) & {
        Value_[TStringBuf("items")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTabsBuilder&& Items(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) && {
        Value_[TStringBuf("items")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTabsBuilder& Items(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) & {
        Value_[TStringBuf("items")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

};

[[nodiscard]] inline TDivTabsBuilder DivTabs() {
    return {};
}

struct TDivTabsItemBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivTabsItemBuilder() {
        Value_.SetType(NJson::JSON_MAP);
    }

    [[nodiscard]] TDivTabsItemBuilder&& Title(const TString& value) && {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMinLength(length, 1 /* minLength */);
        Value_[TStringBuf("title")] = value;
        return std::move(*this);
    }

    TDivTabsItemBuilder& Title(const TString& value) & {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMinLength(length, 1 /* minLength */);
        Value_[TStringBuf("title")] = value;
        return *this;
    }

    [[nodiscard]] TDivTabsItemBuilder&& TitleClickAction(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("title_click_action")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTabsItemBuilder& TitleClickAction(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("title_click_action")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTabsItemBuilder&& TitleClickAction(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("title_click_action")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTabsItemBuilder& TitleClickAction(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("title_click_action")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTabsItemBuilder&& Div(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("div")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTabsItemBuilder& Div(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("div")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTabsItemBuilder&& Div(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("div")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTabsItemBuilder& Div(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("div")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

};

[[nodiscard]] inline TDivTabsItemBuilder DivTabsItem() {
    return {};
}

[[nodiscard]] inline TDivTabsItemBuilder DivTabsItem(const TString& title, const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& div) {
    return TDivTabsItemBuilder{}.Title(title).Div(div);
}

[[nodiscard]] inline TDivTabsItemBuilder DivTabsItem(const TString& title, NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& div) {
    return TDivTabsItemBuilder{}.Title(title).Div(std::move(div));
}

struct TDivTabsTabTitleStyleBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivTabsTabTitleStyleBuilder() {
        Value_.SetType(NJson::JSON_MAP);
    }

    [[nodiscard]] TDivTabsTabTitleStyleBuilder&& FontSize(const i64 value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("font_size")] = value;
        return std::move(*this);
    }

    TDivTabsTabTitleStyleBuilder& FontSize(const i64 value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("font_size")] = value;
        return *this;
    }

    [[nodiscard]] TDivTabsTabTitleStyleBuilder&& Paddings(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("paddings")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTabsTabTitleStyleBuilder& Paddings(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("paddings")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTabsTabTitleStyleBuilder&& Paddings(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("paddings")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTabsTabTitleStyleBuilder& Paddings(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("paddings")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTabsTabTitleStyleBuilder&& LineHeight(const i64 value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("line_height")] = value;
        return std::move(*this);
    }

    TDivTabsTabTitleStyleBuilder& LineHeight(const i64 value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("line_height")] = value;
        return *this;
    }

    [[nodiscard]] TDivTabsTabTitleStyleBuilder&& LetterSpacing(const double value) && {
        Value_[TStringBuf("letter_spacing")] = value;
        return std::move(*this);
    }

    TDivTabsTabTitleStyleBuilder& LetterSpacing(const double value) & {
        Value_[TStringBuf("letter_spacing")] = value;
        return *this;
    }

    [[nodiscard]] TDivTabsTabTitleStyleBuilder&& FontWeight(const EDivFontWeight value) && {
        Value_[TStringBuf("font_weight")] = ToString(value);
        return std::move(*this);
    }

    TDivTabsTabTitleStyleBuilder& FontWeight(const EDivFontWeight value) & {
        Value_[TStringBuf("font_weight")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivTabsTabTitleStyleBuilder&& ActiveTextColor(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("active_text_color")] = value;
        return std::move(*this);
    }

    TDivTabsTabTitleStyleBuilder& ActiveTextColor(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("active_text_color")] = value;
        return *this;
    }

    [[nodiscard]] TDivTabsTabTitleStyleBuilder&& InactiveTextColor(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("inactive_text_color")] = value;
        return std::move(*this);
    }

    TDivTabsTabTitleStyleBuilder& InactiveTextColor(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("inactive_text_color")] = value;
        return *this;
    }

    [[nodiscard]] TDivTabsTabTitleStyleBuilder&& ActiveBackgroundColor(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("active_background_color")] = value;
        return std::move(*this);
    }

    TDivTabsTabTitleStyleBuilder& ActiveBackgroundColor(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("active_background_color")] = value;
        return *this;
    }

};

[[nodiscard]] inline TDivTabsTabTitleStyleBuilder DivTabsTabTitleStyle() {
    return {};
}

struct TDivInfinityCountBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivInfinityCountBuilder() {
        Value_.SetType(NJson::JSON_MAP);
        Value_[TStringBuf("type")] = TStringBuf("infinity");
    }

};

[[nodiscard]] inline TDivInfinityCountBuilder DivInfinityCount() {
    return {};
}

struct TDivWrapContentSizeBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivWrapContentSizeBuilder() {
        Value_.SetType(NJson::JSON_MAP);
        Value_[TStringBuf("type")] = TStringBuf("wrap_content");
    }

};

[[nodiscard]] inline TDivWrapContentSizeBuilder DivWrapContentSize() {
    return {};
}

struct TDivBorderBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivBorderBuilder() {
        Value_.SetType(NJson::JSON_MAP);
    }

    [[nodiscard]] TDivBorderBuilder&& HasShadow(const bool value) && {
        Value_[TStringBuf("has_shadow")] = static_cast<i64>(value);
        return std::move(*this);
    }

    TDivBorderBuilder& HasShadow(const bool value) & {
        Value_[TStringBuf("has_shadow")] = static_cast<i64>(value);
        return *this;
    }

    [[nodiscard]] TDivBorderBuilder&& Stroke(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("stroke")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivBorderBuilder& Stroke(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("stroke")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivBorderBuilder&& Stroke(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("stroke")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivBorderBuilder& Stroke(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("stroke")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivBorderBuilder&& CornerRadius(const i64 value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("corner_radius")] = value;
        return std::move(*this);
    }

    TDivBorderBuilder& CornerRadius(const i64 value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("corner_radius")] = value;
        return *this;
    }

};

[[nodiscard]] inline TDivBorderBuilder DivBorder() {
    return {};
}

struct TDivBorderStrokeBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivBorderStrokeBuilder() {
        Value_.SetType(NJson::JSON_MAP);
    }

    [[nodiscard]] TDivBorderStrokeBuilder&& Width(const i64 value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("width")] = value;
        return std::move(*this);
    }

    TDivBorderStrokeBuilder& Width(const i64 value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("width")] = value;
        return *this;
    }

    [[nodiscard]] TDivBorderStrokeBuilder&& Color(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("color")] = value;
        return std::move(*this);
    }

    TDivBorderStrokeBuilder& Color(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("color")] = value;
        return *this;
    }

};

[[nodiscard]] inline TDivBorderStrokeBuilder DivBorderStroke() {
    return {};
}

[[nodiscard]] inline TDivBorderStrokeBuilder DivBorderStroke(const TString& color) {
    return TDivBorderStrokeBuilder{}.Color(color);
}

struct TDivImageBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivImageBuilder() {
        Value_.SetType(NJson::JSON_MAP);
        Value_[TStringBuf("type")] = TStringBuf("image");
    }

    [[nodiscard]] TDivImageBuilder&& ImageUrl(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateUri(value);
        Value_[TStringBuf("image_url")] = value;
        return std::move(*this);
    }

    TDivImageBuilder& ImageUrl(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateUri(value);
        Value_[TStringBuf("image_url")] = value;
        return *this;
    }

    [[nodiscard]] TDivImageBuilder&& PlaceholderColor(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("placeholder_color")] = value;
        return std::move(*this);
    }

    TDivImageBuilder& PlaceholderColor(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("placeholder_color")] = value;
        return *this;
    }

    [[nodiscard]] TDivImageBuilder&& Scale(const EDivImageScale value) && {
        Value_[TStringBuf("scale")] = ToString(value);
        return std::move(*this);
    }

    TDivImageBuilder& Scale(const EDivImageScale value) & {
        Value_[TStringBuf("scale")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivImageBuilder&& ContentAlignmentVertical(const EDivAlignmentVertical value) && {
        Value_[TStringBuf("content_alignment_vertical")] = ToString(value);
        return std::move(*this);
    }

    TDivImageBuilder& ContentAlignmentVertical(const EDivAlignmentVertical value) & {
        Value_[TStringBuf("content_alignment_vertical")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivImageBuilder&& ContentAlignmentHorizontal(const EDivAlignmentHorizontal value) && {
        Value_[TStringBuf("content_alignment_horizontal")] = ToString(value);
        return std::move(*this);
    }

    TDivImageBuilder& ContentAlignmentHorizontal(const EDivAlignmentHorizontal value) & {
        Value_[TStringBuf("content_alignment_horizontal")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivImageBuilder&& Action(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("action")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivImageBuilder& Action(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("action")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivImageBuilder&& Action(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("action")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivImageBuilder& Action(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("action")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

};

[[nodiscard]] inline TDivImageBuilder DivImage() {
    return {};
}

[[nodiscard]] inline TDivImageBuilder DivImage(const TString& imageUrl) {
    return TDivImageBuilder{}.ImageUrl(imageUrl);
}

struct TDivMatchParentSizeBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivMatchParentSizeBuilder() {
        Value_.SetType(NJson::JSON_MAP);
        Value_[TStringBuf("type")] = TStringBuf("match_parent");
    }

    [[nodiscard]] TDivMatchParentSizeBuilder&& Weight(const double value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateDoubleConstraint(TStringBuf("number > 0.0"), [](const double number) { return number > 0.0; }, value);
        Value_[TStringBuf("weight")] = value;
        return std::move(*this);
    }

    TDivMatchParentSizeBuilder& Weight(const double value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateDoubleConstraint(TStringBuf("number > 0.0"), [](const double number) { return number > 0.0; }, value);
        Value_[TStringBuf("weight")] = value;
        return *this;
    }

};

[[nodiscard]] inline TDivMatchParentSizeBuilder DivMatchParentSize() {
    return {};
}

struct TDivBaseBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivBaseBuilder() {
        Value_.SetType(NJson::JSON_MAP);
    }

    [[nodiscard]] TDivBaseBuilder&& Border(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("border")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivBaseBuilder& Border(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("border")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivBaseBuilder&& Border(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("border")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivBaseBuilder& Border(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("border")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivBaseBuilder&& Width(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("width")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivBaseBuilder& Width(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("width")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivBaseBuilder&& Width(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("width")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivBaseBuilder& Width(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("width")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivBaseBuilder&& Height(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("height")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivBaseBuilder& Height(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("height")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivBaseBuilder&& Height(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("height")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivBaseBuilder& Height(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("height")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivBaseBuilder&& AddBackground(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("background")].AppendValue(value.ValueWithoutValidation());
        return std::move(*this);
    }

    TDivBaseBuilder& AddBackground(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("background")].AppendValue(value.ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivBaseBuilder&& AddBackground(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("background")].AppendValue(std::move(value).ValueWithoutValidation());
        return std::move(*this);
    }

    TDivBaseBuilder& AddBackground(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("background")].AppendValue(std::move(value).ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivBaseBuilder&& Background(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) && {
        Value_[TStringBuf("background")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivBaseBuilder& Background(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) & {
        Value_[TStringBuf("background")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivBaseBuilder&& Background(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) && {
        Value_[TStringBuf("background")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivBaseBuilder& Background(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) & {
        Value_[TStringBuf("background")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivBaseBuilder&& Paddings(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("paddings")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivBaseBuilder& Paddings(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("paddings")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivBaseBuilder&& Paddings(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("paddings")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivBaseBuilder& Paddings(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("paddings")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivBaseBuilder&& Margins(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("margins")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivBaseBuilder& Margins(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("margins")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivBaseBuilder&& Margins(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("margins")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivBaseBuilder& Margins(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("margins")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivBaseBuilder&& Alpha(const double value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateDoubleConstraint(TStringBuf("number >= 0.0 && number <= 1.0"), [](const double number) { return number >= 0.0 && number <= 1.0; }, value);
        Value_[TStringBuf("alpha")] = value;
        return std::move(*this);
    }

    TDivBaseBuilder& Alpha(const double value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateDoubleConstraint(TStringBuf("number >= 0.0 && number <= 1.0"), [](const double number) { return number >= 0.0 && number <= 1.0; }, value);
        Value_[TStringBuf("alpha")] = value;
        return *this;
    }

    [[nodiscard]] TDivBaseBuilder&& AlignmentVertical(const EDivAlignmentVertical value) && {
        Value_[TStringBuf("alignment_vertical")] = ToString(value);
        return std::move(*this);
    }

    TDivBaseBuilder& AlignmentVertical(const EDivAlignmentVertical value) & {
        Value_[TStringBuf("alignment_vertical")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivBaseBuilder&& AlignmentHorizontal(const EDivAlignmentHorizontal value) && {
        Value_[TStringBuf("alignment_horizontal")] = ToString(value);
        return std::move(*this);
    }

    TDivBaseBuilder& AlignmentHorizontal(const EDivAlignmentHorizontal value) & {
        Value_[TStringBuf("alignment_horizontal")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivBaseBuilder&& RowSpan(const i64 value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("row_span")] = value;
        return std::move(*this);
    }

    TDivBaseBuilder& RowSpan(const i64 value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("row_span")] = value;
        return *this;
    }

    [[nodiscard]] TDivBaseBuilder&& ColumnSpan(const i64 value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("column_span")] = value;
        return std::move(*this);
    }

    TDivBaseBuilder& ColumnSpan(const i64 value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("column_span")] = value;
        return *this;
    }

    [[nodiscard]] TDivBaseBuilder&& VisibilityAction(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("visibility_action")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivBaseBuilder& VisibilityAction(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("visibility_action")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivBaseBuilder&& VisibilityAction(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("visibility_action")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivBaseBuilder& VisibilityAction(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("visibility_action")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivBaseBuilder&& AddVisibilityAction(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("visibility_actions")].AppendValue(value.ValueWithoutValidation());
        return std::move(*this);
    }

    TDivBaseBuilder& AddVisibilityAction(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("visibility_actions")].AppendValue(value.ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivBaseBuilder&& AddVisibilityAction(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("visibility_actions")].AppendValue(std::move(value).ValueWithoutValidation());
        return std::move(*this);
    }

    TDivBaseBuilder& AddVisibilityAction(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("visibility_actions")].AppendValue(std::move(value).ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivBaseBuilder&& VisibilityActions(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) && {
        Value_[TStringBuf("visibility_actions")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivBaseBuilder& VisibilityActions(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) & {
        Value_[TStringBuf("visibility_actions")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivBaseBuilder&& VisibilityActions(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) && {
        Value_[TStringBuf("visibility_actions")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivBaseBuilder& VisibilityActions(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) & {
        Value_[TStringBuf("visibility_actions")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

};

[[nodiscard]] inline TDivBaseBuilder DivBase() {
    return {};
}

struct TDivGifImageBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivGifImageBuilder() {
        Value_.SetType(NJson::JSON_MAP);
        Value_[TStringBuf("type")] = TStringBuf("gif");
    }

    [[nodiscard]] TDivGifImageBuilder&& GifUrl(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateUri(value);
        Value_[TStringBuf("gif_url")] = value;
        return std::move(*this);
    }

    TDivGifImageBuilder& GifUrl(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateUri(value);
        Value_[TStringBuf("gif_url")] = value;
        return *this;
    }

    [[nodiscard]] TDivGifImageBuilder&& PlaceholderColor(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("placeholder_color")] = value;
        return std::move(*this);
    }

    TDivGifImageBuilder& PlaceholderColor(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("placeholder_color")] = value;
        return *this;
    }

    [[nodiscard]] TDivGifImageBuilder&& Scale(const EDivImageScale value) && {
        Value_[TStringBuf("scale")] = ToString(value);
        return std::move(*this);
    }

    TDivGifImageBuilder& Scale(const EDivImageScale value) & {
        Value_[TStringBuf("scale")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivGifImageBuilder&& Action(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("action")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivGifImageBuilder& Action(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("action")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivGifImageBuilder&& Action(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("action")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivGifImageBuilder& Action(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("action")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

};

[[nodiscard]] inline TDivGifImageBuilder DivGifImage() {
    return {};
}

[[nodiscard]] inline TDivGifImageBuilder DivGifImage(const TString& gifUrl) {
    return TDivGifImageBuilder{}.GifUrl(gifUrl);
}

struct TDivGridBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivGridBuilder() {
        Value_.SetType(NJson::JSON_MAP);
        Value_[TStringBuf("type")] = TStringBuf("grid");
    }

    [[nodiscard]] TDivGridBuilder&& ContentAlignmentVertical(const EDivAlignmentVertical value) && {
        Value_[TStringBuf("content_alignment_vertical")] = ToString(value);
        return std::move(*this);
    }

    TDivGridBuilder& ContentAlignmentVertical(const EDivAlignmentVertical value) & {
        Value_[TStringBuf("content_alignment_vertical")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivGridBuilder&& ContentAlignmentHorizontal(const EDivAlignmentHorizontal value) && {
        Value_[TStringBuf("content_alignment_horizontal")] = ToString(value);
        return std::move(*this);
    }

    TDivGridBuilder& ContentAlignmentHorizontal(const EDivAlignmentHorizontal value) & {
        Value_[TStringBuf("content_alignment_horizontal")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivGridBuilder&& Action(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("action")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivGridBuilder& Action(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("action")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivGridBuilder&& Action(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("action")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivGridBuilder& Action(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("action")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivGridBuilder&& AddItem(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("items")].AppendValue(value.ValueWithoutValidation());
        return std::move(*this);
    }

    TDivGridBuilder& AddItem(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("items")].AppendValue(value.ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivGridBuilder&& AddItem(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("items")].AppendValue(std::move(value).ValueWithoutValidation());
        return std::move(*this);
    }

    TDivGridBuilder& AddItem(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("items")].AppendValue(std::move(value).ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivGridBuilder&& Items(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) && {
        Value_[TStringBuf("items")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivGridBuilder& Items(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) & {
        Value_[TStringBuf("items")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivGridBuilder&& Items(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) && {
        Value_[TStringBuf("items")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivGridBuilder& Items(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) & {
        Value_[TStringBuf("items")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivGridBuilder&& ColumnCount(const i64 value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("column_count")] = value;
        return std::move(*this);
    }

    TDivGridBuilder& ColumnCount(const i64 value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("column_count")] = value;
        return *this;
    }

};

[[nodiscard]] inline TDivGridBuilder DivGrid() {
    return {};
}

[[nodiscard]] inline TDivGridBuilder DivGrid(const i64 columnCount) {
    return TDivGridBuilder{}.ColumnCount(columnCount);
}

struct TDivSeparatorBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivSeparatorBuilder() {
        Value_.SetType(NJson::JSON_MAP);
        Value_[TStringBuf("type")] = TStringBuf("separator");
    }

    [[nodiscard]] TDivSeparatorBuilder&& Action(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("action")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivSeparatorBuilder& Action(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("action")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivSeparatorBuilder&& Action(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("action")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivSeparatorBuilder& Action(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("action")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivSeparatorBuilder&& DelimiterStyle(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("delimiter_style")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivSeparatorBuilder& DelimiterStyle(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("delimiter_style")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivSeparatorBuilder&& DelimiterStyle(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("delimiter_style")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivSeparatorBuilder& DelimiterStyle(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("delimiter_style")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

};

[[nodiscard]] inline TDivSeparatorBuilder DivSeparator() {
    return {};
}

struct TDivSeparatorStyleBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivSeparatorStyleBuilder() {
        Value_.SetType(NJson::JSON_MAP);
    }

    [[nodiscard]] TDivSeparatorStyleBuilder&& Color(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("color")] = value;
        return std::move(*this);
    }

    TDivSeparatorStyleBuilder& Color(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("color")] = value;
        return *this;
    }

    [[nodiscard]] TDivSeparatorStyleBuilder&& Orientation(const EDivSeparatorStyleOrientation value) && {
        Value_[TStringBuf("orientation")] = ToString(value);
        return std::move(*this);
    }

    TDivSeparatorStyleBuilder& Orientation(const EDivSeparatorStyleOrientation value) & {
        Value_[TStringBuf("orientation")] = ToString(value);
        return *this;
    }

};

[[nodiscard]] inline TDivSeparatorStyleBuilder DivSeparatorStyle() {
    return {};
}

struct TDivFixedSizeBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivFixedSizeBuilder() {
        Value_.SetType(NJson::JSON_MAP);
        Value_[TStringBuf("type")] = TStringBuf("fixed");
    }

    [[nodiscard]] TDivFixedSizeBuilder&& Value(const i64 value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("value")] = value;
        return std::move(*this);
    }

    TDivFixedSizeBuilder& Value(const i64 value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("value")] = value;
        return *this;
    }

    [[nodiscard]] TDivFixedSizeBuilder&& Unit(const EDivFixedSizeUnit value) && {
        Value_[TStringBuf("unit")] = ToString(value);
        return std::move(*this);
    }

    TDivFixedSizeBuilder& Unit(const EDivFixedSizeUnit value) & {
        Value_[TStringBuf("unit")] = ToString(value);
        return *this;
    }

};

[[nodiscard]] inline TDivFixedSizeBuilder DivFixedSize() {
    return {};
}

[[nodiscard]] inline TDivFixedSizeBuilder DivFixedSize(const i64 value) {
    return TDivFixedSizeBuilder{}.Value(value);
}

struct TDivDataBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivDataBuilder() {
        Value_.SetType(NJson::JSON_MAP);
    }

    [[nodiscard]] TDivDataBuilder&& AddState(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("states")].AppendValue(value.ValueWithoutValidation());
        return std::move(*this);
    }

    TDivDataBuilder& AddState(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("states")].AppendValue(value.ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivDataBuilder&& AddState(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("states")].AppendValue(std::move(value).ValueWithoutValidation());
        return std::move(*this);
    }

    TDivDataBuilder& AddState(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("states")].AppendValue(std::move(value).ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivDataBuilder&& States(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) && {
        Value_[TStringBuf("states")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivDataBuilder& States(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) & {
        Value_[TStringBuf("states")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivDataBuilder&& States(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) && {
        Value_[TStringBuf("states")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivDataBuilder& States(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) & {
        Value_[TStringBuf("states")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivDataBuilder&& LogId(const TString& value) && {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMinLength(length, 1 /* minLength */);
        Value_[TStringBuf("log_id")] = value;
        return std::move(*this);
    }

    TDivDataBuilder& LogId(const TString& value) & {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMinLength(length, 1 /* minLength */);
        Value_[TStringBuf("log_id")] = value;
        return *this;
    }

};

[[nodiscard]] inline TDivDataBuilder DivData() {
    return {};
}

[[nodiscard]] inline TDivDataBuilder DivData(const TString& logId) {
    return TDivDataBuilder{}.LogId(logId);
}

struct TDivDataDivStateBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivDataDivStateBuilder() {
        Value_.SetType(NJson::JSON_MAP);
    }

    [[nodiscard]] TDivDataDivStateBuilder&& StateId(const i64 value) && {
        Value_[TStringBuf("state_id")] = value;
        return std::move(*this);
    }

    TDivDataDivStateBuilder& StateId(const i64 value) & {
        Value_[TStringBuf("state_id")] = value;
        return *this;
    }

    [[nodiscard]] TDivDataDivStateBuilder&& Div(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("div")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivDataDivStateBuilder& Div(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("div")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivDataDivStateBuilder&& Div(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("div")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivDataDivStateBuilder& Div(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("div")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

};

[[nodiscard]] inline TDivDataDivStateBuilder DivDataDivState() {
    return {};
}

[[nodiscard]] inline TDivDataDivStateBuilder DivDataDivState(const i64 stateId, const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& div) {
    return TDivDataDivStateBuilder{}.StateId(stateId).Div(div);
}

[[nodiscard]] inline TDivDataDivStateBuilder DivDataDivState(const i64 stateId, NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& div) {
    return TDivDataDivStateBuilder{}.StateId(stateId).Div(std::move(div));
}

struct TDivSolidBackgroundBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivSolidBackgroundBuilder() {
        Value_.SetType(NJson::JSON_MAP);
        Value_[TStringBuf("type")] = TStringBuf("solid");
    }

    [[nodiscard]] TDivSolidBackgroundBuilder&& Color(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("color")] = value;
        return std::move(*this);
    }

    TDivSolidBackgroundBuilder& Color(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("color")] = value;
        return *this;
    }

};

[[nodiscard]] inline TDivSolidBackgroundBuilder DivSolidBackground() {
    return {};
}

[[nodiscard]] inline TDivSolidBackgroundBuilder DivSolidBackground(const TString& color) {
    return TDivSolidBackgroundBuilder{}.Color(color);
}

struct TDivFixedCountBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivFixedCountBuilder() {
        Value_.SetType(NJson::JSON_MAP);
        Value_[TStringBuf("type")] = TStringBuf("fixed");
    }

    [[nodiscard]] TDivFixedCountBuilder&& Value(const i64 value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("value")] = value;
        return std::move(*this);
    }

    TDivFixedCountBuilder& Value(const i64 value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("value")] = value;
        return *this;
    }

};

[[nodiscard]] inline TDivFixedCountBuilder DivFixedCount() {
    return {};
}

[[nodiscard]] inline TDivFixedCountBuilder DivFixedCount(const i64 value) {
    return TDivFixedCountBuilder{}.Value(value);
}

struct TDivGradientBackgroundBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivGradientBackgroundBuilder() {
        Value_.SetType(NJson::JSON_MAP);
        Value_[TStringBuf("type")] = TStringBuf("gradient");
    }

    [[nodiscard]] TDivGradientBackgroundBuilder&& AddColor(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("colors")].AppendValue(value);
        return std::move(*this);
    }

    TDivGradientBackgroundBuilder& AddColor(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("colors")].AppendValue(value);
        return *this;
    }

    [[nodiscard]] TDivGradientBackgroundBuilder&& Colors(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) && {
        Value_[TStringBuf("colors")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivGradientBackgroundBuilder& Colors(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) & {
        Value_[TStringBuf("colors")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivGradientBackgroundBuilder&& Colors(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) && {
        Value_[TStringBuf("colors")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivGradientBackgroundBuilder& Colors(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) & {
        Value_[TStringBuf("colors")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivGradientBackgroundBuilder&& Angle(const i64 value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0 && number <= 360"), [](const i64 number) { return number >= 0 && number <= 360; }, value);
        Value_[TStringBuf("angle")] = value;
        return std::move(*this);
    }

    TDivGradientBackgroundBuilder& Angle(const i64 value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0 && number <= 360"), [](const i64 number) { return number >= 0 && number <= 360; }, value);
        Value_[TStringBuf("angle")] = value;
        return *this;
    }

};

[[nodiscard]] inline TDivGradientBackgroundBuilder DivGradientBackground() {
    return {};
}

struct TDivContainerBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivContainerBuilder() {
        Value_.SetType(NJson::JSON_MAP);
        Value_[TStringBuf("type")] = TStringBuf("container");
    }

    [[nodiscard]] TDivContainerBuilder&& ContentAlignmentVertical(const EDivAlignmentVertical value) && {
        Value_[TStringBuf("content_alignment_vertical")] = ToString(value);
        return std::move(*this);
    }

    TDivContainerBuilder& ContentAlignmentVertical(const EDivAlignmentVertical value) & {
        Value_[TStringBuf("content_alignment_vertical")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivContainerBuilder&& ContentAlignmentHorizontal(const EDivAlignmentHorizontal value) && {
        Value_[TStringBuf("content_alignment_horizontal")] = ToString(value);
        return std::move(*this);
    }

    TDivContainerBuilder& ContentAlignmentHorizontal(const EDivAlignmentHorizontal value) & {
        Value_[TStringBuf("content_alignment_horizontal")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivContainerBuilder&& Action(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("action")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivContainerBuilder& Action(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("action")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivContainerBuilder&& Action(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("action")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivContainerBuilder& Action(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("action")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivContainerBuilder&& Orientation(const EDivContainerOrientation value) && {
        Value_[TStringBuf("orientation")] = ToString(value);
        return std::move(*this);
    }

    TDivContainerBuilder& Orientation(const EDivContainerOrientation value) & {
        Value_[TStringBuf("orientation")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivContainerBuilder&& AddItem(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("items")].AppendValue(value.ValueWithoutValidation());
        return std::move(*this);
    }

    TDivContainerBuilder& AddItem(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("items")].AppendValue(value.ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivContainerBuilder&& AddItem(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("items")].AppendValue(std::move(value).ValueWithoutValidation());
        return std::move(*this);
    }

    TDivContainerBuilder& AddItem(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("items")].AppendValue(std::move(value).ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivContainerBuilder&& Items(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) && {
        Value_[TStringBuf("items")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivContainerBuilder& Items(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) & {
        Value_[TStringBuf("items")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivContainerBuilder&& Items(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) && {
        Value_[TStringBuf("items")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivContainerBuilder& Items(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) & {
        Value_[TStringBuf("items")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

};

[[nodiscard]] inline TDivContainerBuilder DivContainer() {
    return {};
}

struct TDivTextBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivTextBuilder() {
        Value_.SetType(NJson::JSON_MAP);
        Value_[TStringBuf("type")] = TStringBuf("text");
    }

    [[nodiscard]] TDivTextBuilder&& FontSize(const i64 value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("font_size")] = value;
        return std::move(*this);
    }

    TDivTextBuilder& FontSize(const i64 value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("font_size")] = value;
        return *this;
    }

    [[nodiscard]] TDivTextBuilder&& LineHeight(const i64 value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("line_height")] = value;
        return std::move(*this);
    }

    TDivTextBuilder& LineHeight(const i64 value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("line_height")] = value;
        return *this;
    }

    [[nodiscard]] TDivTextBuilder&& MaxLines(const i64 value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("max_lines")] = value;
        return std::move(*this);
    }

    TDivTextBuilder& MaxLines(const i64 value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("max_lines")] = value;
        return *this;
    }

    [[nodiscard]] TDivTextBuilder&& LetterSpacing(const double value) && {
        Value_[TStringBuf("letter_spacing")] = value;
        return std::move(*this);
    }

    TDivTextBuilder& LetterSpacing(const double value) & {
        Value_[TStringBuf("letter_spacing")] = value;
        return *this;
    }

    [[nodiscard]] TDivTextBuilder&& FontWeight(const EDivFontWeight value) && {
        Value_[TStringBuf("font_weight")] = ToString(value);
        return std::move(*this);
    }

    TDivTextBuilder& FontWeight(const EDivFontWeight value) & {
        Value_[TStringBuf("font_weight")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivTextBuilder&& TextAlignmentHorizontal(const EDivAlignmentHorizontal value) && {
        Value_[TStringBuf("text_alignment_horizontal")] = ToString(value);
        return std::move(*this);
    }

    TDivTextBuilder& TextAlignmentHorizontal(const EDivAlignmentHorizontal value) & {
        Value_[TStringBuf("text_alignment_horizontal")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivTextBuilder&& TextAlignmentVertical(const EDivAlignmentVertical value) && {
        Value_[TStringBuf("text_alignment_vertical")] = ToString(value);
        return std::move(*this);
    }

    TDivTextBuilder& TextAlignmentVertical(const EDivAlignmentVertical value) & {
        Value_[TStringBuf("text_alignment_vertical")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivTextBuilder&& TextColor(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("text_color")] = value;
        return std::move(*this);
    }

    TDivTextBuilder& TextColor(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("text_color")] = value;
        return *this;
    }

    [[nodiscard]] TDivTextBuilder&& Action(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("action")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTextBuilder& Action(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("action")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTextBuilder&& Action(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("action")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTextBuilder& Action(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("action")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTextBuilder&& Text(const TString& value) && {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMinLength(length, 1 /* minLength */);
        Value_[TStringBuf("text")] = value;
        return std::move(*this);
    }

    TDivTextBuilder& Text(const TString& value) & {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMinLength(length, 1 /* minLength */);
        Value_[TStringBuf("text")] = value;
        return *this;
    }

    [[nodiscard]] TDivTextBuilder&& Underline(const EDivLineStyle value) && {
        Value_[TStringBuf("underline")] = ToString(value);
        return std::move(*this);
    }

    TDivTextBuilder& Underline(const EDivLineStyle value) & {
        Value_[TStringBuf("underline")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivTextBuilder&& Strike(const EDivLineStyle value) && {
        Value_[TStringBuf("strike")] = ToString(value);
        return std::move(*this);
    }

    TDivTextBuilder& Strike(const EDivLineStyle value) & {
        Value_[TStringBuf("strike")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivTextBuilder&& Truncate(const EDivTextTruncate value) && {
        Value_[TStringBuf("truncate")] = ToString(value);
        return std::move(*this);
    }

    TDivTextBuilder& Truncate(const EDivTextTruncate value) & {
        Value_[TStringBuf("truncate")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivTextBuilder&& MarqueeAnimation(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("marquee_animation")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTextBuilder& MarqueeAnimation(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("marquee_animation")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTextBuilder&& MarqueeAnimation(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("marquee_animation")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTextBuilder& MarqueeAnimation(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("marquee_animation")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTextBuilder&& AddRange(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("ranges")].AppendValue(value.ValueWithoutValidation());
        return std::move(*this);
    }

    TDivTextBuilder& AddRange(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("ranges")].AppendValue(value.ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivTextBuilder&& AddRange(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("ranges")].AppendValue(std::move(value).ValueWithoutValidation());
        return std::move(*this);
    }

    TDivTextBuilder& AddRange(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("ranges")].AppendValue(std::move(value).ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivTextBuilder&& Ranges(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) && {
        Value_[TStringBuf("ranges")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTextBuilder& Ranges(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) & {
        Value_[TStringBuf("ranges")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTextBuilder&& Ranges(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) && {
        Value_[TStringBuf("ranges")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTextBuilder& Ranges(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) & {
        Value_[TStringBuf("ranges")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTextBuilder&& AddImage(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("images")].AppendValue(value.ValueWithoutValidation());
        return std::move(*this);
    }

    TDivTextBuilder& AddImage(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("images")].AppendValue(value.ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivTextBuilder&& AddImage(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("images")].AppendValue(std::move(value).ValueWithoutValidation());
        return std::move(*this);
    }

    TDivTextBuilder& AddImage(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("images")].AppendValue(std::move(value).ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivTextBuilder&& Images(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) && {
        Value_[TStringBuf("images")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTextBuilder& Images(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) & {
        Value_[TStringBuf("images")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTextBuilder&& Images(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) && {
        Value_[TStringBuf("images")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTextBuilder& Images(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) & {
        Value_[TStringBuf("images")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

};

[[nodiscard]] inline TDivTextBuilder DivText() {
    return {};
}

[[nodiscard]] inline TDivTextBuilder DivText(const TString& text) {
    return TDivTextBuilder{}.Text(text);
}

struct TDivTextRangeBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivTextRangeBuilder() {
        Value_.SetType(NJson::JSON_MAP);
    }

    [[nodiscard]] TDivTextRangeBuilder&& Start(const i64 value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("start")] = value;
        return std::move(*this);
    }

    TDivTextRangeBuilder& Start(const i64 value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("start")] = value;
        return *this;
    }

    [[nodiscard]] TDivTextRangeBuilder&& End(const i64 value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number > 0"), [](const i64 number) { return number > 0; }, value);
        Value_[TStringBuf("end")] = value;
        return std::move(*this);
    }

    TDivTextRangeBuilder& End(const i64 value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number > 0"), [](const i64 number) { return number > 0; }, value);
        Value_[TStringBuf("end")] = value;
        return *this;
    }

    [[nodiscard]] TDivTextRangeBuilder&& FontSize(const i64 value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("font_size")] = value;
        return std::move(*this);
    }

    TDivTextRangeBuilder& FontSize(const i64 value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("font_size")] = value;
        return *this;
    }

    [[nodiscard]] TDivTextRangeBuilder&& LetterSpacing(const double value) && {
        Value_[TStringBuf("letter_spacing")] = value;
        return std::move(*this);
    }

    TDivTextRangeBuilder& LetterSpacing(const double value) & {
        Value_[TStringBuf("letter_spacing")] = value;
        return *this;
    }

    [[nodiscard]] TDivTextRangeBuilder&& FontWeight(const EDivFontWeight value) && {
        Value_[TStringBuf("font_weight")] = ToString(value);
        return std::move(*this);
    }

    TDivTextRangeBuilder& FontWeight(const EDivFontWeight value) & {
        Value_[TStringBuf("font_weight")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivTextRangeBuilder&& TextColor(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("text_color")] = value;
        return std::move(*this);
    }

    TDivTextRangeBuilder& TextColor(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateColor(value);
        Value_[TStringBuf("text_color")] = value;
        return *this;
    }

    [[nodiscard]] TDivTextRangeBuilder&& Underline(const EDivLineStyle value) && {
        Value_[TStringBuf("underline")] = ToString(value);
        return std::move(*this);
    }

    TDivTextRangeBuilder& Underline(const EDivLineStyle value) & {
        Value_[TStringBuf("underline")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivTextRangeBuilder&& Strike(const EDivLineStyle value) && {
        Value_[TStringBuf("strike")] = ToString(value);
        return std::move(*this);
    }

    TDivTextRangeBuilder& Strike(const EDivLineStyle value) & {
        Value_[TStringBuf("strike")] = ToString(value);
        return *this;
    }

};

[[nodiscard]] inline TDivTextRangeBuilder DivTextRange() {
    return {};
}

[[nodiscard]] inline TDivTextRangeBuilder DivTextRange(const i64 start, const i64 end) {
    return TDivTextRangeBuilder{}.Start(start).End(end);
}

struct TDivTextImageBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivTextImageBuilder() {
        Value_.SetType(NJson::JSON_MAP);
    }

    [[nodiscard]] TDivTextImageBuilder&& Start(const i64 value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("start")] = value;
        return std::move(*this);
    }

    TDivTextImageBuilder& Start(const i64 value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("start")] = value;
        return *this;
    }

    [[nodiscard]] TDivTextImageBuilder&& Url(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateUri(value);
        Value_[TStringBuf("url")] = value;
        return std::move(*this);
    }

    TDivTextImageBuilder& Url(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateUri(value);
        Value_[TStringBuf("url")] = value;
        return *this;
    }

    [[nodiscard]] TDivTextImageBuilder&& Width(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("width")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTextImageBuilder& Width(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("width")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTextImageBuilder&& Width(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("width")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTextImageBuilder& Width(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("width")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTextImageBuilder&& Height(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("height")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTextImageBuilder& Height(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("height")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivTextImageBuilder&& Height(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("height")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivTextImageBuilder& Height(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("height")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

};

[[nodiscard]] inline TDivTextImageBuilder DivTextImage() {
    return {};
}

[[nodiscard]] inline TDivTextImageBuilder DivTextImage(const i64 start, const TString& url) {
    return TDivTextImageBuilder{}.Start(start).Url(url);
}

struct TDivActionBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivActionBuilder() {
        Value_.SetType(NJson::JSON_MAP);
    }

    [[nodiscard]] TDivActionBuilder&& Url(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateUri(value);
        Value_[TStringBuf("url")] = value;
        return std::move(*this);
    }

    TDivActionBuilder& Url(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateUri(value);
        Value_[TStringBuf("url")] = value;
        return *this;
    }

    [[nodiscard]] TDivActionBuilder&& Payload(const NJson::TJsonValue& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateJsonPayload(value);
        Value_[TStringBuf("payload")] = value;
        return std::move(*this);
    }

    TDivActionBuilder& Payload(const NJson::TJsonValue& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateJsonPayload(value);
        Value_[TStringBuf("payload")] = value;
        return *this;
    }

    [[nodiscard]] TDivActionBuilder&& Payload(NJson::TJsonValue&& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateJsonPayload(value);
        Value_[TStringBuf("payload")] = std::move(value);
        return std::move(*this);
    }

    TDivActionBuilder& Payload(NJson::TJsonValue&& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateJsonPayload(value);
        Value_[TStringBuf("payload")] = std::move(value);
        return *this;
    }

    [[nodiscard]] TDivActionBuilder&& AddMenuItem(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("menu_items")].AppendValue(value.ValueWithoutValidation());
        return std::move(*this);
    }

    TDivActionBuilder& AddMenuItem(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("menu_items")].AppendValue(value.ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivActionBuilder&& AddMenuItem(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("menu_items")].AppendValue(std::move(value).ValueWithoutValidation());
        return std::move(*this);
    }

    TDivActionBuilder& AddMenuItem(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("menu_items")].AppendValue(std::move(value).ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivActionBuilder&& MenuItems(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) && {
        Value_[TStringBuf("menu_items")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivActionBuilder& MenuItems(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) & {
        Value_[TStringBuf("menu_items")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivActionBuilder&& MenuItems(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) && {
        Value_[TStringBuf("menu_items")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivActionBuilder& MenuItems(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) & {
        Value_[TStringBuf("menu_items")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivActionBuilder&& LogId(const TString& value) && {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMinLength(length, 1 /* minLength */);
        Value_[TStringBuf("log_id")] = value;
        return std::move(*this);
    }

    TDivActionBuilder& LogId(const TString& value) & {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMinLength(length, 1 /* minLength */);
        Value_[TStringBuf("log_id")] = value;
        return *this;
    }

    [[nodiscard]] TDivActionBuilder&& LogUrl(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateUri(value);
        Value_[TStringBuf("log_url")] = value;
        return std::move(*this);
    }

    TDivActionBuilder& LogUrl(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateUri(value);
        Value_[TStringBuf("log_url")] = value;
        return *this;
    }

    [[nodiscard]] TDivActionBuilder&& Referer(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateUri(value);
        Value_[TStringBuf("referer")] = value;
        return std::move(*this);
    }

    TDivActionBuilder& Referer(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateUri(value);
        Value_[TStringBuf("referer")] = value;
        return *this;
    }

};

[[nodiscard]] inline TDivActionBuilder DivAction() {
    return {};
}

[[nodiscard]] inline TDivActionBuilder DivAction(const TString& logId) {
    return TDivActionBuilder{}.LogId(logId);
}

struct TDivActionMenuItemBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivActionMenuItemBuilder() {
        Value_.SetType(NJson::JSON_MAP);
    }

    [[nodiscard]] TDivActionMenuItemBuilder&& Text(const TString& value) && {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMinLength(length, 1 /* minLength */);
        Value_[TStringBuf("text")] = value;
        return std::move(*this);
    }

    TDivActionMenuItemBuilder& Text(const TString& value) & {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMinLength(length, 1 /* minLength */);
        Value_[TStringBuf("text")] = value;
        return *this;
    }

    [[nodiscard]] TDivActionMenuItemBuilder&& Action(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("action")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivActionMenuItemBuilder& Action(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("action")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivActionMenuItemBuilder&& Action(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("action")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivActionMenuItemBuilder& Action(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("action")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

};

[[nodiscard]] inline TDivActionMenuItemBuilder DivActionMenuItem() {
    return {};
}

[[nodiscard]] inline TDivActionMenuItemBuilder DivActionMenuItem(const TString& text, const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& action) {
    return TDivActionMenuItemBuilder{}.Text(text).Action(action);
}

[[nodiscard]] inline TDivActionMenuItemBuilder DivActionMenuItem(const TString& text, NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& action) {
    return TDivActionMenuItemBuilder{}.Text(text).Action(std::move(action));
}

struct TDivImageBackgroundBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivImageBackgroundBuilder() {
        Value_.SetType(NJson::JSON_MAP);
        Value_[TStringBuf("type")] = TStringBuf("image");
    }

    [[nodiscard]] TDivImageBackgroundBuilder&& ImageUrl(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateUri(value);
        Value_[TStringBuf("image_url")] = value;
        return std::move(*this);
    }

    TDivImageBackgroundBuilder& ImageUrl(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateUri(value);
        Value_[TStringBuf("image_url")] = value;
        return *this;
    }

    [[nodiscard]] TDivImageBackgroundBuilder&& ContentAlignmentVertical(const EDivAlignmentVertical value) && {
        Value_[TStringBuf("content_alignment_vertical")] = ToString(value);
        return std::move(*this);
    }

    TDivImageBackgroundBuilder& ContentAlignmentVertical(const EDivAlignmentVertical value) & {
        Value_[TStringBuf("content_alignment_vertical")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivImageBackgroundBuilder&& ContentAlignmentHorizontal(const EDivAlignmentHorizontal value) && {
        Value_[TStringBuf("content_alignment_horizontal")] = ToString(value);
        return std::move(*this);
    }

    TDivImageBackgroundBuilder& ContentAlignmentHorizontal(const EDivAlignmentHorizontal value) & {
        Value_[TStringBuf("content_alignment_horizontal")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivImageBackgroundBuilder&& Scale(const EDivImageScale value) && {
        Value_[TStringBuf("scale")] = ToString(value);
        return std::move(*this);
    }

    TDivImageBackgroundBuilder& Scale(const EDivImageScale value) & {
        Value_[TStringBuf("scale")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivImageBackgroundBuilder&& Alpha(const double value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateDoubleConstraint(TStringBuf("number >= 0.0 && number <= 1.0"), [](const double number) { return number >= 0.0 && number <= 1.0; }, value);
        Value_[TStringBuf("alpha")] = value;
        return std::move(*this);
    }

    TDivImageBackgroundBuilder& Alpha(const double value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateDoubleConstraint(TStringBuf("number >= 0.0 && number <= 1.0"), [](const double number) { return number >= 0.0 && number <= 1.0; }, value);
        Value_[TStringBuf("alpha")] = value;
        return *this;
    }

};

[[nodiscard]] inline TDivImageBackgroundBuilder DivImageBackground() {
    return {};
}

[[nodiscard]] inline TDivImageBackgroundBuilder DivImageBackground(const TString& imageUrl) {
    return TDivImageBackgroundBuilder{}.ImageUrl(imageUrl);
}

struct TDivAnimationBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivAnimationBuilder() {
        Value_.SetType(NJson::JSON_MAP);
        Value_[TStringBuf("name")] = TStringBuf("marquee");
    }

    [[nodiscard]] TDivAnimationBuilder&& Autoplay(const bool value) && {
        Value_[TStringBuf("autoplay")] = static_cast<i64>(value);
        return std::move(*this);
    }

    TDivAnimationBuilder& Autoplay(const bool value) & {
        Value_[TStringBuf("autoplay")] = static_cast<i64>(value);
        return *this;
    }

    [[nodiscard]] TDivAnimationBuilder&& Duration(const i64 value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("duration")] = value;
        return std::move(*this);
    }

    TDivAnimationBuilder& Duration(const i64 value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("duration")] = value;
        return *this;
    }

    [[nodiscard]] TDivAnimationBuilder&& StartDelay(const i64 value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("start_delay")] = value;
        return std::move(*this);
    }

    TDivAnimationBuilder& StartDelay(const i64 value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("start_delay")] = value;
        return *this;
    }

    [[nodiscard]] TDivAnimationBuilder&& Repeat(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("repeat")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivAnimationBuilder& Repeat(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("repeat")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivAnimationBuilder&& Repeat(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("repeat")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivAnimationBuilder& Repeat(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("repeat")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

};

[[nodiscard]] inline TDivAnimationBuilder DivAnimation() {
    return {};
}

struct TDivGalleryBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivGalleryBuilder() {
        Value_.SetType(NJson::JSON_MAP);
        Value_[TStringBuf("type")] = TStringBuf("gallery");
    }

    [[nodiscard]] TDivGalleryBuilder&& CrossContentAlignment(const EDivGalleryCrossContentAlignment value) && {
        Value_[TStringBuf("cross_content_alignment")] = ToString(value);
        return std::move(*this);
    }

    TDivGalleryBuilder& CrossContentAlignment(const EDivGalleryCrossContentAlignment value) & {
        Value_[TStringBuf("cross_content_alignment")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivGalleryBuilder&& ItemSpacing(const i64 value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("item_spacing")] = value;
        return std::move(*this);
    }

    TDivGalleryBuilder& ItemSpacing(const i64 value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("item_spacing")] = value;
        return *this;
    }

    [[nodiscard]] TDivGalleryBuilder&& ScrollMode(const EDivGalleryScrollMode value) && {
        Value_[TStringBuf("scroll_mode")] = ToString(value);
        return std::move(*this);
    }

    TDivGalleryBuilder& ScrollMode(const EDivGalleryScrollMode value) & {
        Value_[TStringBuf("scroll_mode")] = ToString(value);
        return *this;
    }

    [[nodiscard]] TDivGalleryBuilder&& AddItem(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) && {
        Value_[TStringBuf("items")].AppendValue(value.ValueWithoutValidation());
        return std::move(*this);
    }

    TDivGalleryBuilder& AddItem(const NAlice::NJsonSchemaBuilder::NRuntime::TBuilder& value) & {
        Value_[TStringBuf("items")].AppendValue(value.ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivGalleryBuilder&& AddItem(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) && {
        Value_[TStringBuf("items")].AppendValue(std::move(value).ValueWithoutValidation());
        return std::move(*this);
    }

    TDivGalleryBuilder& AddItem(NAlice::NJsonSchemaBuilder::NRuntime::TBuilder&& value) & {
        Value_[TStringBuf("items")].AppendValue(std::move(value).ValueWithoutValidation());
        return *this;
    }

    [[nodiscard]] TDivGalleryBuilder&& Items(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) && {
        Value_[TStringBuf("items")] = value.ValueWithoutValidation();
        return std::move(*this);
    }

    TDivGalleryBuilder& Items(const NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder& value) & {
        Value_[TStringBuf("items")] = value.ValueWithoutValidation();
        return *this;
    }

    [[nodiscard]] TDivGalleryBuilder&& Items(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) && {
        Value_[TStringBuf("items")] = std::move(value).ValueWithoutValidation();
        return std::move(*this);
    }

    TDivGalleryBuilder& Items(NAlice::NJsonSchemaBuilder::NRuntime::TArrayBuilder&& value) & {
        Value_[TStringBuf("items")] = std::move(value).ValueWithoutValidation();
        return *this;
    }

};

[[nodiscard]] inline TDivGalleryBuilder DivGallery() {
    return {};
}

struct TDivVisibilityActionBuilder : public NAlice::NJsonSchemaBuilder::NRuntime::TBuilder {
    TDivVisibilityActionBuilder() {
        Value_.SetType(NJson::JSON_MAP);
    }

    [[nodiscard]] TDivVisibilityActionBuilder&& Url(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateUri(value);
        Value_[TStringBuf("url")] = value;
        return std::move(*this);
    }

    TDivVisibilityActionBuilder& Url(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateUri(value);
        Value_[TStringBuf("url")] = value;
        return *this;
    }

    [[nodiscard]] TDivVisibilityActionBuilder&& LogId(const TString& value) && {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMinLength(length, 1 /* minLength */);
        Value_[TStringBuf("log_id")] = value;
        return std::move(*this);
    }

    TDivVisibilityActionBuilder& LogId(const TString& value) & {
        const auto length = NAlice::NJsonSchemaBuilder::NRuntime::GetNumUtf16CharsInUtf8String(value);
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateMinLength(length, 1 /* minLength */);
        Value_[TStringBuf("log_id")] = value;
        return *this;
    }

    [[nodiscard]] TDivVisibilityActionBuilder&& Referer(const TString& value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateUri(value);
        Value_[TStringBuf("referer")] = value;
        return std::move(*this);
    }

    TDivVisibilityActionBuilder& Referer(const TString& value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateUri(value);
        Value_[TStringBuf("referer")] = value;
        return *this;
    }

    [[nodiscard]] TDivVisibilityActionBuilder&& VisibilityPercentage(const i64 value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number > 0 && number <= 100"), [](const i64 number) { return number > 0 && number <= 100; }, value);
        Value_[TStringBuf("visibility_percentage")] = value;
        return std::move(*this);
    }

    TDivVisibilityActionBuilder& VisibilityPercentage(const i64 value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number > 0 && number <= 100"), [](const i64 number) { return number > 0 && number <= 100; }, value);
        Value_[TStringBuf("visibility_percentage")] = value;
        return *this;
    }

    [[nodiscard]] TDivVisibilityActionBuilder&& VisibilityDuration(const i64 value) && {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("visibility_duration")] = value;
        return std::move(*this);
    }

    TDivVisibilityActionBuilder& VisibilityDuration(const i64 value) & {
        NAlice::NJsonSchemaBuilder::NRuntime::ValidateIntegerConstraint(TStringBuf("number >= 0"), [](const i64 number) { return number >= 0; }, value);
        Value_[TStringBuf("visibility_duration")] = value;
        return *this;
    }

};

[[nodiscard]] inline TDivVisibilityActionBuilder DivVisibilityAction() {
    return {};
}

[[nodiscard]] inline TDivVisibilityActionBuilder DivVisibilityAction(const TString& logId) {
    return TDivVisibilityActionBuilder{}.LogId(logId);
}

}  // namespace NAlice::NJsonSchemaBuilder::NDiv2
