#include "fairytale_linear_albums.h"

#include <util/generic/hash_set.h>

namespace NAlice::NMusic {

namespace {

const THashSet<TString> TALES_ALBUMS_WITH_CHAPTERS = {
    "431934",	// Золотые сказки. Синдбад-мореход и Людоед
    "431999",	// Золотые русские сказки
    "1675157",	// П. Ершов. Конёк-Горбунок
    "1712457",	// Г.Х. Андерсен. Гадкий утёнок. Ель
    "1736202",	// Происшествие в стране Мульти-Пульти
    "1952972",	// Пастушок и король эльфов
    "1993505",	// Hans Christian Andersen: Dyuymovochka & Doch bolotnogo tsarya
    "2076064",	// Ali Baba Ve Kırk Haramiler - Sincap Kardeş Masal Dizisi, Vol. 11
    "2519449",	// Сказки А.С. Пушкина
    "2519459",	// Конёк-горбунок
    "3702214",	// История Древнего Мира. Выпуск 1
    "3836015",	// 12 месяцев
    "3836018",	// Снегурочка
    "4006961",	// Сказки А. С. Пушкина
    "4142205",	// Бабушкины сказки. Часть №6
    "6336389",	// Александр Грин: Алые паруса
    "6336660",	// Жюль Верн: Таинственный остров
    "6340712",	// Аркадий Гайдар: Тимур и его команда
    "7245304",	// Сказки из джунглей. Рикки-Тикки-Тави
    "7245440",	// Сказки — Путешествия Синдбада-морехода
    "7574493",	// Вильгельм Гауф — «Карлик Нос, Маленький Мук»
    "7652159",	// Редьярд Киплинг — Книга джунглей
    "7910063",	// Джонатан Свифт. Приключения Гулливера
    "7926797",	// Алексей Толстой — «Золотой ключик или приключения Буратино»
    "8072886",	// «Сказка о царе Салтане»
    "8247285",	// Жюль Верн – «Дети капитана Гранта»
    "8247685",	// Герберт Уэллс – «Человек-невидимка»
    "8464635",	// Вильгельм Гауф – «Холодное сердце»
    "8586689",	// Роберт Льюис Стивенсон - Остров сокровищ (радиоспектакль)
    "8658829",	// Карло Коллоди – «Пиноккио»
    "8834225",	// Александр Пушкин – «Руслан и Людмила»
    "8965734",	// Леонардо да Винчи — «Сказки и притчи»
    "8965743",	// Карел Чапек – «Сказки»
    "9047925",	// Аркадий Гайдар – «Сказки и рассказы»
    "9487780",	// Белый волк. Татарская народная сказка
    "9619382",	// Вълкът и Седемте Козлета
    "9619465",	// Български народни приказки
    "9619627",	// Веселите Градски Музиканти / Червената Шапчица
    "9949264",	// Отиди там — незнам къде, донеси това — незнам какво
    "9949273",	// Спящата красавица
    "9949295",	// Синбад Мореплавателя — Приказки на Шехеразада
    "9949466",	// Магарешката кожа
    "10048629",	// Абаносовият кон
    "10784365",	// Аленький цветочек
    "10787029",	// Василиса Прекрасная
    "10787092",	// Дюймовочка
    "10787827",	// Зербино-дровосек
    "10788310",	// Золотая антилопа
    "10788359",	// Кот в сапогах
    "10788472",	// Маленький принц
    "10788891",	// Малыш и Карлсон, который живёт на крыше
    "10788893",	// Музыкальный магазинчик
    "10789106",	// Сказка о мёртвой царевне и о семи богатырях
    "10789116",	// Сказка о попе и работнике его Балде
    "10789190",	// Сказка о русском солдате
    "10789598",	// Оле-Лукойе
    "10790661",	// Приключения Пифа
    "10790701",	// Приключения Чиполлино
    "10790899",	// Рики-Тикки-Тави
    "10791378",	// В. А. Жуковский. Сказки
    "10791460",	// Снежная королева
    "10791466",	// Три поросёнка
    "10791523",	// Царевна-лягушка
    "10963297",	// Бэмби
    "11044553",	// Бременские музыканты
    "11044587",	// Волшебные башмаки
    "11044772",	// Городок в табакерке
    "11044784",	// Звёздный мальчик
    "11044786",	// Теремок
    "11044822",	// Златовласка
    "11044848",	// Крокодил Гена и его друзья
    "11044889",	// Чудесное приключение Нильса с дикими гусями
    "11044891",	// Ухти-Тухти
    "11551379",	// Александр Волков – «Волшебник Изумрудного города»
    "11552156",	// Вениамин Каверин – Аптека «Голубые шары»
    "11588874",	// Памела Трэверс – «Мэри Поппинс»
    "11589377",	// Александр Островский – «Снегурочка»
    "11722214",	// Конёк-горбунок
    "12043558",	// Павел Бажов - Синюшкин колодец (радиоспектакль)
    "12086155",	// Дино Буццати – «Забастовка телефонов»
    "12925134",	// Кащей Бессмертный
    "12925143",	// Приключения Чиполлино
    "12925144",	// Чёрная курица
    "12925146",	// Бэмби
    "12925147",	// Маугли
    "12939829",	// Мороз Иванович
    "12939830",	// Царевна лягушка
    "13243093",	// Братья Гримм - Король Дроздобород (радиоспектакль)
    "13582939",	// Александр Пушкин — «Сказка о мёртвой царевне и о семи богатырях»
    "13925205",	// Павел Бажов - Хозяйка Медной горы (радиоспектакль)
    "14027926",	// Сребърното копитце. Градче в табакера
    "14236674",	// Иван-крестьянский сын и Чудо-юдо
    "14236675",	// Ганс Христиан Андерсен — «Гадкий утёнок»
    "14236677",	// Лабулэ де Лефевр Эдуард Рене. «Как петушок попал на крышу»
    "14236679",	// Гуси-лебеди
    "14266936",	// Мигель де Сервантес — «Дон Кихот»
    "14267567",	// Сельма Лагерлёф — «Чудесное путешествие Нильса с дикими гусями»
    "14450551",	// Сергей Аксаков. «Аленький цветочек»
    "14451336",	// Василий Жуковский. «Сказка о царе Берендее»
    "14451340",	// Феликс Зальтен. «Бемби»
    "14451502",	// Александр Пушкин. «Сказка о мёртвой царевне и семи богатырях»
    "14451504",	// Владимир Одоевский. «Городок в табакерке»
    "14451506",	// Ганс Христиан Андерсен. «Дюймовочка»
    "14463101",	// Братья Гримм. «Король Дроздобород»
    "14463102",	// Сельма Лагерлёф. «Чудесное путешествие Нильса с дикими гусями»
    "14700122",	// Туркменская народная сказка «Ярты-Гулок»
    "14700125",	// Репка
    "14700129",	// Пётр Ершов. «Конёк-Горбунок»
    "14700132",	// Юрий Дружков. «Волшебная школа, или Приключения Карандаша и Самоделкина»
    "14700258",	// Сивка-бурка
    "14707771",	// Ганс Христиан Андерсен. «Волшебное огниво»
    "14708452",	// Ганс Христиан Андерсен. «Соловей»
    "14708470",	// Редьярд Киплинг. «Слонёнок»
    "14708483",	// Ганс Христиан Андерсен. «Оле Лукойе»
    "14708484",	// Теремок
    "14900173",	// Павел Бажов. «Серебряное копытце»
    "14900178",	// Морис Метерлинк. «Синяя птица»
    "14900179",	// Джанни Родари. «Путешествие Голубой Стрелы»
    "14900184",	// Марджери Уильямс. «Плюшевый кролик, или О том, как игрушки становятся настоящими»
    "14908438",	// Ганс Христиан Андерсен. «Свинопас»
    "14908439",	// Василий Жуковский. «Три пояса»
    "14908443",	// Тибетская народная сказка «О храбром зайце»
    "14911847",	// Антоний Погорельский. «Чёрная курица, или Подземные жители»
    "14911848",	// Редьярд Киплинг. «Как было написано первое письмо»
    "14911851",	// Поди туда, не знаю куда
    "15053434",	// Редьярд Киплинг. «Рикки-Тикки-Тави»
    "15053435",	// Коза-дереза
    "15053436",	// Ваня и Маша
    "15053440",	// Китайская сказка «Братья Лю»
    "15053442",	// Павел Бажов. «Хозяйка Медной горы»
    "15053446",	// Энид Блайтон. «Знаменитый утёнок Тим»
    "15053451",	// Финист – Ясный сокол
    "15053452",	// Ян Ларри. «Необыкновенные приключения Карика и Вали»
    "15053455",	// Александр Волков. «Волшебник Изумрудного города»
    "15054771",	// Александр Пушкин. «Сказка о царе Салтане»
    "15054772",	// Сергей Аксаков. «Аленький цветочек»
    "15054774",	// Сказки о русских богатырях
    "15054775",	// Дмитрий Мамин-Сибиряк. «Серая Шейка«
    "15054777",	// Иван-крестьянский сын и Чудо-Юдо
    "15054778",	// Монгольская народная сказка «Необыкновенные приключения обыкновенного зайца»
    "15054780",	// Русская народная сказка о молодильных яблочках и живой воде
    "15054786",	// Вильгельм Гауф. «Колдовская трава»
    "15054864",	// Эрнст Гофман. «Щелкунчик»
    "15054866",	// Царевна-лягушка
    "15054869",	// Инна Кашежева. «Волшебная семёрка или путешествие нот»
    "15054870",	// Ганс Христиан Андерсен. «Дюймовочка»
    "15061937",	// Про Василису Премудрую
    "15062744"	// Про Морского царя и Василису Премудрую
};

} // namespace

bool IsTalesAlbumWithChapters(const TString& albumId) {
    return TALES_ALBUMS_WITH_CHAPTERS.contains(albumId);
};

} // namespace NAlice::NMusic
