# Что такое Matrix

Matrix это сервис для доставки в колонку какой-то информации. Он содержит обратный индекс endpoint'ов всех колонок, подключенных в данный момент к сети, и умеет правильно ходить в эти endpoint'ы для доставки информации, умеет откладывать поход, если колонка в данный момент не подключена к сети.

Но, к сожалению, изначально это сервис дизайнился с существенными ошибками, поэтому сейчас он состоит из двух сервисов.

Один сервис раньше был частью python uniproxy (сервиса держащего connect с колонкой) и постепенно из нее выделялся в отдельный python сервис, сейчас активно переписывается на C++. Второй сервис - "светлое будущее" первого сервиса, которое решили написать с учетом многих проблем первого.

## Notificator {#notificator}

Изначальный сервис, в данный момент реализует следующий функционал:

1. Поддержание [обратного индекса подключений колонок](https://docs.yandex-team.ru/alice-matrix/pages/notificator/connections_inverted_index)
2. Отправку [технических пушей](https://docs.yandex-team.ru/alice-matrix/pages/notificator/technical_pushes)
3. Отправку [колоночных уведомлений](https://docs.yandex-team.ru/alice-matrix/pages/notificator/quasar_notifications) и управлением подписками на них (аналог обычных push уведомлений для телефона)
4. Имеет API для получения активных устройств пользователя из своей базы данных и из базы данных [умного дома](https://wiki.yandex-team.ru/alice/iot)
5. Является [proxy для отправки запросов](https://docs.yandex-team.ru/alice-matrix/pages/notificator/legacy/sup_and_personal_cards) в [СУП](https://doc.yandex-team.ru/sup-overview/concepts/about.html) и [сервис персональных карточек](https://wiki.yandex-team.ru/users/zhigan/personal-cards)

В будущем в этом сервисе останется только функционал из первых трех пунктов. С некоторой вероятностью из четвертого пункта.

Пятый пункт точно будет переделан [тут](https://st.yandex-team.ru/ZION-159) и [тут](https://st.yandex-team.ru/ZION-124).

## Scheduler и Worker {#scheduler_and_worker}

{% note warning %}

Сервис [уже находится под production трафиком](https://st.yandex-team.ru/MEGAMIND-3536), был прогружен синтетикой, но, к сожалению, был написан совсем недавно.

Так что если вы хотите начать его использовать, пожалуйста, сообщите о своем желании в [чате поддержки](https://docs.yandex-team.ru/alice-matrix/pages/contacts). Мы не хотим чтобы новый клиент, у которого все внезапно сломалось, стал сюрпризом.

{% endnote %}

При написании первого сервиса столкнулись со следующими проблемами:

1. Непонятно как троттлить запросы (например Кинопоиск решил массово всем сообщить о новом сериале)
2. Нет простой возможности отправить что-то в конкретное время, нужно писать свою автоматику для этого
3. Очень неудобно совершать периодичные действия, нужно писать свою автоматику для этого

Для решения проблем выше и начали писать scheduler и worker.

Идея очень простая - есть отдельный сервис scheduler, он принимает запросы на schedule какого-то действия (с конкретным временем отправки, политикой retry'ев, периодичностью, etc), об этом делается запись в базу.
Далее worker обрабатывает действия из этой очереди, он имеет внутренний троттлер и умеет правильно работать с периодичными событиями.

В теории, в будущем технические пуши и колоночные уведомления будут посылаться только через scheduler и worker, а notificator'а будет признан внутренним сервисом и не будет открыт внешнему пользователю (только инфраструктурные команды Алисы будут взаимодействовать с ним напрямую).

## Техническое описание {#technical_docs}

В данным момент написано только техническое описание scheduler'а и worker'а, к сожалению, до полного технического описания notificator'а не доходят руки.

Но есть [вот эта запись](https://disk.yandex.ru/public/nda/?hash=9s2EL%2B5eAHoXjuPZic%2B38aTGiHsnsLJH%2BJApNJduSJhccDKEctJjo%2BbzFkUrE8ROq/J6bpmRyOJonT3VoXnDag%3D%3D) [мегавстречи](https://wiki.yandex-team.ru/alice/megafun/techmeetups/) на которой подробно разбирался принцип работы notificator'а (для просмотра нужна [двухфаторная авторизация в yandex-team](https://wiki.yandex-team.ru/passport/yateamtotp/#kakvkljuchit)).
