# Как поддерживается обратный индекс подключений колонок

Для поддержания обратного индекса подключений есть два механизма, один старый и очень неэффективный, который скоро будет закопан, второй новый, который задизайнили с учетом проблем старого.

## Старый механизм поддержания обратного индекса {#old_mechanism}

В момент подключения и отключения устройства происходит подоход в специальную ручку notificator'а - ```/locator```.

Если это подключение устройства, в таблице в ydb делается запись о нем, если отключение, запись наоборот удаляется.

Схема таблицы следующая:

{% code "/alice/matrix/notificator/tools/ydb_scripts/matrix_notificator_init.ydb" lang="yql" lines="[BEGIN DeviceLocatorSchema]-[END DeviceLocatorSchema]" %}

* ```shard_key``` - хеш от puid
* ```puid``` - puid пользователя, которому принадлежит устройство
* ```device_id``` - id устройства
* ```host``` - fqdn инстанса uniproxy, который в данный момент держит активную сессию с устройством
* ```ts``` - timestamp, который пришел от uniproxy при добавлении этой строки в базу
* ```device_model``` - модель девайса
* ```ttl``` - момент добавления записи в базу (на самом деле поле должно называться ```created_at```)
* ```config``` - подмножество информации о девайсе

Проблемы этого механизма:

1. Если запрос на добавление завершился неуспешно, то до переподключения устройства оно "потеряно"
2. Если случилось массовое переподключение устройств (например из-за закрытия датацентра), происходит достаточно сильный спайк rps, который ddos'ит ручку ```/locator```, и база не выдерживает (в эти моменты теряется много подключений)
3. Из-за проблемы второго пункта есть размазывание запросов в ручку ```/locator```, из-за этого размазывания появляется 30-и секундный лаг

## Новый механизм поддержания обратного индекса {#new_mechanism}

Внутри каждого инстанса uniproxy подключения разделены на ```X``` шардов.

По каждому из этих шардов раз в ```Y``` секунд каждый инстанс uniproxy посылает diff подключений в notificator. Этот diff содержит в себе информацию о девайсах, которые подключились и отключились с момента посылки последнего diff'а по данному шарду.

Каждые ```Y * Z``` секунд вместе с diff'ом подключений посылается full state подключений, сначала применяется пришедший diff, а потом происходит коррекция данных при помощи full state'а.
Если коррекция данных при помощи full state что-то сильно изменила, зажигается алерт (по идее full state'ы никогда не должны ничего менять).

В данный момент
* ```X = 1```
* ```Y = 1 секунда```
* ```Z = 10```

Данные о подключениях хранятся в таблице в ydb, схема таблицы следующая:

{% code "/alice/matrix/notificator/tools/ydb_scripts/matrix_notificator_init.ydb" lang="yql" lines="[BEGIN ConnectionsShardedSchema]-[END ConnectionsShardedSchema]" %}

* ```shard_key``` - хеш от ```ip``` и ```ip_shard_id```
* ```ip``` - ip инстанса uniproxy, который в данный момент держит активную сессию с устройством
* ```ip_shard_id``` - шард подключения внутри конкретного инстанса uniproxy (число от ```0``` до ```X - 1```)
* ```puid``` - puid пользователя, которому принадлежит устройство
* ```device_id``` - id устройства

* ```port``` - порт, по которому надо ходить в api uniproxy
* ```monotonic``` -  монотонно расстущее число, приходящее в запросах от uniproxy, которое пришло при добавлении этой строки в базу (используется чтобы старый "потерявщийся" запрос не перетер новые данные)
* ```device_info``` - подмножество информации о девайсе

* ```created_at``` - момент добавления записи в базу
* ```expired_at``` - момент, в который запись удалят, даже если не придет запрос на удаление

Данный подход избегает проблемы старого механизма:
1. Если какой-то diff будет потерян, full state в скором времени произведет коррекцию
2. Стабильный rps, никак не зависящий от переподключений устройств
3. Лаг обновления обратного индекса - секунды

## Текущие ограничения нового механизма поддержания обратного индекса {#new_mechanism_limitations}

В данный момент новый механизм работает только для [production инсталяции](https://docs.yandex-team.ru/alice-matrix/pages/notificator/api/#installation) notificator'а, ибо пока нельзя через srcrwr переопрделить место для посылки diff'а подключений, в mock и dev инсталяциях спользуется старый механизм для всех ручек.

В данный момент новый механизм применяется только для ручек ```/delivery``` и ```/delivery/push```, для всех остальных ручек работает старый механизм (в том числе для ручки ```/devices```).
Тикеты на переезд остальных ручек:
* [Тикет на ```/delivery/on_connect``` тут.](https://st.yandex-team.ru/VOICESERV-4274)
* [Тикет на остальные ручки тут.](https://st.yandex-team.ru/ZION-176)

