# Что такое обратный индекс подключений колонок

{% include notitle [Взаимодействие между устройствами и backend'ами](../common/_includes/interaction_between_devices_and_backends.md) %}

Для этого хранится обратный индекс подключений колонок, который по id устройства позволяет найти инстанс uniproxy, который в данный момент держит активную сессию с этим устройством.

Для провоцирования действий от внешних триггеров у uniproxy есть специальное api.

## Почему хранится только обратный индекс подключений колонок, но не остальных устройств? {#why_only_quasar}

В отличии от колонок, где мы почти полностью контролируем как поддерживается подключение к uniproxy, другие устройства не дают такой свободы.
Например, в поисковом приложении подключения живут не всегда, а только в моменты когда им недавно пользовались, да и то они бесполезны если приложение скрыто (нельзя спровоцировать действие из скрытого приложения).

Так что любые подключения, за исключением подключений колонок, являются бесполезными, ибо шанс попасть в "активную фазу" для осуществления действия очень мал.

## Какой лаг обновления? {#update_lag}

Для [нового механизма](https://docs.yandex-team.ru/alice-matrix/pages/notificator/connections_inverted_index/implementation#new_mechanism) поддержания обратного индекса лаг обновления составляет секунды.

{% note warning %}

Не смотря на то, что лаг доставки в новом методе поддержания обратного индекса секунды, не все ручки и инсталяции notificator'а используют новый механизм, [больше информации тут](https://docs.yandex-team.ru/alice-matrix/pages/notificator/connections_inverted_index/implementation#new_mechanism_limitations).

Лаг доставки в старом механизме может достигать до 30 секунд, старый механизм может "терять" записи о колонках до их переподключения.

Также есть проблемы с тем, что [колонка offline примерно 30 секунд из часа](https://st.yandex-team.ru/SK-5866#61e80095adffd45227209348).

{% endnote %}
