from enum import Enum
import re


NODE_NAME_POSTPONE_LOG_WRITER = 'POSTPONE_LOG_WRITER'
NODE_NAME_WALKER_RUN_FINALIZE = 'WALKER_RUN_FINALIZE'
NODE_NAME_MODIFIERS_RUN = 'MODIFIERS_RUN'
NODE_NAME_WALKER_FINALIZE = 'WALKER_RUN_FINALIZE'
NODE_NAME_UTTERANCE_POLYGLOT_HTTP = 'UTTERANCE_POLYGLOT_HTTP'

NODE_NAME_BEGEMOT_WORKER_MEGAMIND = 'BEGEMOT_WORKER_MEGAMIND'
NODE_NAME_BEGEMOT_WORKER_BEGGINS = 'BEGEMOT_WORKER_BEGGINS'
NODE_NAME_BEGEMOT_WORKER_MEGAMIND_MERGER = 'BEGEMOT_WORKER_MEGAMIND_MERGER'
NODE_NAME_BEGEMOT_POLYGLOT_WORKER_MEGAMIND = 'BEGEMOT_POLYGLOT_WORKER_MEGAMIND'
NODE_NAME_BEGEMOT_POLYGLOT_WORKER_BEGGINS = 'BEGEMOT_POLYGLOT_WORKER_BEGGINS'
NODE_NAME_BEGEMOT_POLYGLOT_WORKER_MEGAMIND_MERGER = 'BEGEMOT_POLYGLOT_WORKER_MEGAMIND_MERGER'
NODE_NAME_POLYGLOT_BEGEMOT_MERGER_MERGER = 'POLYGLOT_BEGEMOT_MERGER_MERGER'


class Stage(Enum):
    RUN = 'run'
    CONTINUE = 'continue'
    COMMIT = 'commit'
    APPLY = 'apply'


def scenario_node_name(scenario_name: str, stage: Stage) -> str:
    return f'SCENARIO_{scenario_name.upper()}_{stage.value.upper()}'


def combinator_node_name(combinator_name: str, stage: Stage) -> str:
    snaked = re.sub(r'(?<!^)(?=[A-Z])', '_', combinator_name).upper()
    return f'COMBINATOR_{snaked}_{stage.value.upper()}'
