## FAQ

Как запустить и переканонизировать тесты в примерах. Ниже — подробная документация, как всё устроено.

### Запуск
#### Запуск всех тестов
`ya make -j24 -r -tA alice/megamind/`

#### Запуск одного файла с тестами
`ya make -j24 -r -tA alice/megamind/ -F test_smoke.py::test_common`

#### Запуск одного теста
`ya make -j24 -r -tA alice/megamind/ -F test_smoke.py::test_common[love-tests]`

### Переканонизация
Обычно изменения в тестах приводят к обновлению запросов в источники и их ответов (иногда) и обновлению результата теста (почти всегда).

### Обновление запросов в источник (далее — стабов)
На примере конкретного теста `test_smoke.py::test_common[love-tests]`. (Note: аргумент `-F <test_name>` здесь и далее опциональный, без него будет запуск всех тестов).

1. Обновляем стабы в локальном чекауте (команда `tests`): 
`./tests.py -j24 -r -F test_smoke.py::test_common[love-tests] tests -n -f`

2. Смотрим, что получилось (команда `info`): 
`./tests.py -j24 -r -F test_smoke.py::test_common[love-tests] info`

3. Заливаем новые стабы в MDS (команда `push`): 
`./tests.py -j24 -r -F test_smoke.py::test_common[love-tests] push`

4. Канонизируем тест (через `ya make -tA -Z`): 
`ya make -j24 -r -tA -F test_smoke.py::test_common[love-tests] -Z`

**Готово!**


## Подробная документация

Если ты хочешь написать интеграционные тесты, которым нужно для работы нужно поднять megamind с возможностью сохранения ответов (stubs) источников - то эта минидока для тебя.

**ВАЖНО**: в данный момент, эти тесты помечены как LARGE и в review они не запускаются автоматом (но над этим работает команда девтулзов).
Не надо расчитывать на ReviewBoard, надо прогонять тесты руками, а вот как, написано ниже!

Т.к. ответы источников (stubs) теперь хранятся в s3-mds, то для сохранения новых/обновления старых нужны специальные credentials которые автоматом
вытаскивается из секрета bass-dev (https://yav.yandex-team.ru/secret/sec-01cnbk6vvm6mfrhdyzamjhm4cm/). Для чтения стабов credentials не нужны.
Для добавления в этот секрет можно писать petrk@, yulika@, osado@, vi002@ или другим владельцам https://abc.yandex-team.ru/services/bassdevelopers/

Пишем тест (на python3) в megamind/tests/test_YOUR_SUPER_DUPER_TEST_NAME.py (для примера можно взять test_smoke.py). Добавляем его в megamind/tests/ya.make.

Тесты работают в двух режимах:
* Стандартный: `ya make -ttt` либо `ya make -A` - используется для того что бы тесты работали в CI.
  При каждом запуске создает временную директорию где-то в недрах ~/.ya и потм она исчезает. Для простого прогона тестов - этого хватит.
  Но если новый тест или новые заросы появились в стабах надо использовать `tests.py` (см описание ниже).
* Расширенный: `alice/megamind/tests/tests.py <OPTS>` - если нужно добавить новые, переканонизировать старые, ну и просто можно запустить посмотреть что происходит.
  Краткое описание запуска: `tests.py [YA_MAKE_COMPILATION_OPTIONS] <MODE> [MODE_OPTIONS]`
   `YA_MAKE_COMPILATION_OPTIONS` - опции которые будут передаваться напрямую в `ya make`, т.е. если вы проект собираете `-r --sanitize address -j24 -F 'my_super_test.py` то их надо прописать сюда.
   `MODE` - режим работы. На данный момент есть три режима работы:
    * `tests` - запустить тесты (включает в себя `ya make -ttt [YA_MAKE_COMPILATION_OPTIONS]`)
       `MODE_OPTIONS` для этого режима:
        `-n`     - ходить в реальный источник для которого был сделан запрос если для него не нашлось стабов (для нового теста это делать обязательно)
        `--help` - справка по опциям, тут актуальнее!
    Следующие режимы будут работать __только__ после запуска `tests`
    * `info` - показать состояние стабов с последнего запуска `tests`
    * `push` - залить модифицированные и/или новые стабы в хранилище (s3-mds) и прописать их ключи в специальные метаданные теста (megamind/tests/stubs/*.(json,txt)
      для последующего коммита в svn/mercurial/etc... (если стабы заливаются для нового теста, то в диркетории `megamind/tests/stubs`
      появятся новые файлы (сохожие с названием теста), которые надо добавить под vcs)
  После того как залились свежие стабы и нужно переканонизировать ответ теста, можно либо сделать по аркадийному `ya make -A -Z` либо `tests.py [OPTIONS] -Z tests`.

Процесс разработки мне видится следующим:
* Для нового теста:
  0. Говнякаете сам тест, пример можно посмотреть тут: alice/megamind/tests/test_smoke.py
  1. `alice/megamind/tests/tests.py [опции компиляции] tests -n`, запустятся тесты и закачаются стабы, которых небыло.
  2. `alice/megamind/tests/tests.py [опции компиляции] info`, покажет какие стабы запрашивались и их состояние
  3. `alice/megamind/tests/tests.py [опции компиляции] push`, запушает новые стабы в хранилище (s3-mds)
  4. В папочке alice/megamind/tests/stubs появятся несколько новых *.{txt,json} для с названиями, похожими на те тесты, что вы запускали.
     Их надо добавить под сорс контрол (`svn add alice/megamind/tests/stubs/новые_файлы.{txt,json}`)
     и потом вместе с каноническими результатами самих тестов (не путать со стабами) закомитить.

PS: Немного техинфы:
* Для канонизации испольуется марахайка joker_mocker которая находится тут: https://a.yandex-team.ru/arc/trunk/arcadia/alice/joker
* Марахайка запускается как http server, и является проксей. Для каждого запроса в megamind передаеюся два дополнительных заголовка:
  `x-yandex-via-proxy: host:port` - заставляет megamind'овый fetcher отсылать все запросы в источник через прокси на `host:port`
  `x-yandex-proxy-header-x-yandex-joker` - универсальный механизм прокидывания дополнительных хидеров для проксирующихся запросов, т.е. если есть
  заголовок 'x-yandex-via-proxy', то все заголовки совпадающие с регуляркой ^x-yandex-proxy-header-(.+)$ - будут автоматом добавляться в проксирующие запросы в виде $1: $header_value
  Таким образом чтобы joker знал к какому тесту относится тукущий запрос, надо передать примерно следующий заголовок: `x-yandex-joker: prj=megamind&sess=default&test=super_duper_mega_test`
* joker создают временную директорию в папке: alice/megamind/tests/.joker.temp в которой хранятся все стабы которые использутся в тестах и некоторое количество всякой метаинформации
* список ключей стабов хранятся в `alice/megamind/tests/stubs/$FULL_UNIQ_TEST_NAME.txt` в формате: '1 \t megamind/alice-megamind-tests-test_smoke.py@test_common[love-tests]/20939438D28FE3D65D410D6AAA1894BC284455B49E1DB0BA7CFB5A76C011642D/9d567f8a-809950e4-b0f1d0a2-6e26581e'
  1 - это просто версия протокола, на всякий случай (сейчас всегда 1)
  после таба - уникальный ключ для конкретного стаба, как его можно найти в s3-mds
