#pragma once

#include <library/cpp/langs/langs.h>
#include <util/generic/string.h>
#include <util/generic/vector.h>

namespace NGranet::NCompiler {

enum EMessageId {
    MSG_UNDEFINED,

    // compiler.cpp
    MSG_UNDEFINED_PATH,
    MSG_DUPLICATED_KEY,
    MSG_NAME_IS_EMPTY,
    MSG_INVALID_NAME,
    MSG_DUPLICATED_NAME,
    MSG_DUPLICATED_ELEMENT_NAME,
    MSG_UNEXPECTED_KEYWORD,
    MSG_INVALID_SLOT_NAME,
    MSG_DUPLICATED_SLOT_NAME,
    MSG_INVALID_TYPE_NAME,
    MSG_INVALID_MATCHING_TYPE,
    MSG_INVALID_CONCATENATE_STRINGS,
    MSG_INVALID_KEEP_VARIANTS,
    MSG_NO_TYPE_SECTION,
    MSG_CONCATENATE_STRINGS_SUPPORTED_ONLY_FOR_TAGGER,
    MSG_INVALID_ELEMENT_NAME,
    MSG_CAN_NOT_FIND_ELEMENT,
    MSG_AMBIGUOUS_ELEMENT_NAME,
    MSG_UNEXPECTED_PARAM_OF_MODIFIER,
    MSG_UNKNOWN_TYPE_OF_MODIFICATION,
    MSG_GRAMMEME_PARSER_ERROR,
    MSG_STRING_LITERAL_PARSER_ERROR,
    MSG_NOT_QUOTED_STRING_PARSING_ERROR,
    MSG_RECURSION_DETECTED,

    // directives.cpp
    MSG_UNKNOWN_DIRECTIVE,
    MSG_UNKNOWN_SYNONYM_TYPE,
    MSG_ALLOWED_ONLY_BEFORE_ALL_RULES,
    MSG_NOT_ALLOWED_IN_FILLER,
    MSG_NOT_ALLOWED_IN_ROOT_OF_FORM,
    MSG_NOT_ALLOWED_IN_LIST_OF_VALUES,
    MSG_NOT_ALLOWED_HERE,
    MSG_INVALID_ARGUMENT,
    MSG_INVALID_WEIGHT,
    MSG_UNEXPECTED_PARAM_OF_DIRECTIVE,
    MSG_SYNONYM_TYPES_ARE_EMPTY,

    // expression_tree_builder.cpp
    MSG_EMPTY_EXPRESSION,
    MSG_MODIFIER_ONLY_FOR_ELEMENTS,
    MSG_INVALID_QUANTIFIER,
    MSG_NO_WORDS_AFTER_NORMALIZATION,
    MSG_TOO_MANY_OPERANDS_IN_BAG,

    // preprocessor.cpp
    MSG_ABSOLUTE_PATH,
    MSG_FILE_NOT_FOUND,
    MSG_COMMENTS_INSIDE_BRACKETS,
    MSG_OPENING_BRACKET_NOT_FOUND,
    MSG_CLOSING_QUOTE_NOT_FOUND,
    MSG_CLOSING_BRACKET_NOT_FOUND,
    MSG_UNEXPECTED_INDENT,
    MSG_TAB_SYMBOL_IN_INDENT,
    MSG_EMPTY_KEY,
    MSG_IMPLICIT_EMPTY_TOKEN_IS_FORBIDEN,
    MSG_INVALID_DIRECTIVE,

    // rule_parser.cpp
    MSG_UNEXPECTED_TOKEN,
    MSG_UNEXPECTED_SYMBOL,

    // src_line.cpp
    MSG_NO_VALUE,
    MSG_NOT_A_VALUE,
    MSG_BOOLEAN_EXPECTED,
    MSG_UNSIGNED_INT_EXPECTED,
};

class TMessageTable : public TMoveOnly {
public:
    TMessageTable(std::initializer_list<std::pair<EMessageId, TStringBuf>> table);

    const TString& GetMessage(EMessageId messageId) const {
        return Table[messageId];
    }

private:
    TVector<TString> Table;
};

const TMessageTable& GetMessageTable(ELanguage lang);

} // namespace NGranet::NCompiler
