#include <alice/nlu/libs/occurrence_searcher/searcher_app.h>
#include <alice/nlu/proto/entities/custom.pb.h>

class TApp : public TSearcherApp<NAlice::NNlu::TCustomEntityValues> { };

//
// NOTE(the0): The tool takes the path to the data file generated by the `build_automaton` tool
// located in the neighbouring directory as an argument and processes lines from stdin
// printing all the strings from the data file found in each line with the corresponding values.
//
// Each value is a serialized protobuf message defined at ../rule/proto/custom_entities.proto.
// Each sequence of (string, value) pairs corresponding to a single input line is followed by
// an empty line making it possible to align input lines with output pair sequences.
//
// If the input consists of the following two lines:
// ====
// включи радио маяк
// открой youtube
// ====
//
// Then the output (depending on the data file) could be:
// ====
// включи { CustomEntityValues { Type: "action_request" Value: "autoplay" } CustomEntityValues { Type: "launch_command" Value: "launch_command" } CustomEntityValues { Type: "video_action" Value: "play" } CustomEntityValues { Type: "video_selection_action" Value: "play" } }
// радио { CustomEntityValues { Type: "player_type" Value: "radio" } CustomEntityValues { Type: "popular_goods" Value: "popular" } }
// маяк { CustomEntityValues { Type: "fm_radio_station" Value: "Маяк" } }
//
// открой { CustomEntityValues { Type: "list_todo_reminders_action" Value: "list_todo_reminders_action" } CustomEntityValues { Type: "video_action" Value: "play" } CustomEntityValues { Type: "video_selection_action" Value: "play" } }
// youtube { CustomEntityValues { Type: "video_provider" Value: "youtube" } }
//
// ====
//
int main(int argc, const char* argv[]) {
    return TApp().Run(argc, argv);
}
