Это маппер, который умеет конвертировать nlu-разметку на слоты и токенизированный векторизованный текст в формат sample_features, пригодный для обучения теггера.

На вход подается табличка, которая должна содержать столбцы:
* utterance_text типа string -- оригинальный текст запроса;
* markup типа string -- nlu разметка слотами, пример `поставь будильник на 'три часа'(time)`;
* embeddings типа any (yson) -- о нем ниже.

Любые другие столбцы не будут использованы маппером, а лишь прокинуты на выход.

embeddings содержит json (конвертированный в yson) такого вида:
```
[
    {
        "token": "привет",
        "subtokens": [
            {
                "subtoken": "▁при",
                "embedding": [
                    0.0,
                    1.0
                ]
            },
            {
                "subtoken": "вет",
                "embedding": [
                    0.0,
                    1.0
                ]
            }
        ]
    },
    {
        "token": "алиса",
        "subtokens": [
            {
                "subtoken": "▁алиса",
                "embedding": [
                    99.0,
                    1.0
                ]
            }
        ]
    }
]
```

token должен являться подстрокой исходного текста. Это требуется для корректного выравнивания nlu markup с токенизацией и формирования target-тегов для обучения.
subtokens представляет собой массив сабтокенов для каждого токена и их эмбеддингов. subtoken не используется для выравнивания и не обязан являться подстрокой исходного текста.

На выходе маппер добавляет к исходным колонкам столбец sample_features в формате TAliceSampleFeatures.
Таргет теггирования будет построен для сабтокенов (на основе выравнивания токенов и распространении тегов на сабтокены), в качестве входа теггеру будут доступны эмбеддинги сабтокенов.

Другие признаки теггера (pos, сущности) выставляются пустыми.
