# Нагрузочное тестирование и AppHost. Пошаговое руководство

В [инструкции AppHost](https://doc.yandex-team.ru/apphost/dg/concepts/testing-high_load.html) достаточно информации,
чтобы провести стрельбы; здесь собраны советы и подсказки, как пройти этот путь быстро. К сожалению, эта инструкция
актуальна только на момент написания.

Стрелять в AppHost как таковой — сложно. В графе очень много источников, в т.ч. скрытых во вложенных графах. Они живут 
своей жизнью, обслуживаются независимыми командами, и замокать их все — очень дорогая задача. Сам аппхост также
не представляет интереса, т.к. наша инсталляция имеет огромный запас мощности, и нагрузка сервиса "не делает погоды".
Таким образом, **нагружать нужно конкретный источник** (бэкенд).

## Сбор данных
Первым делом, необходимо получить полный дамп всех запросов, которые летают по сети между апхостом и источниками. Для
этого можно запустить апхост на дев-машине и вытащить данные из eventlog — но это путь для настоящего Джедая. Проще
сделать запрос в хамстер, добавив cgi-параметр `dumpAllNodes=true` и потом воспользоваться инструментом
[Horizon trace](https://horizon-nora.z.yandex-team.ru/traces/new).

1. Аккуратно, в дампе окажутся все-все-все заголовки, включая куки и tvm-токены. Я открывал режим инкогнито, чтобы
после снятия дампа разлогиниться и "деактивировать" куки.

1. Открываем `https://hamster.yandex.ru/alice/home?dumpAllNodes=true`. Можно добавить нужные `srcrwr` и/или задать
другой граф.

1. Получаем значение заголовка `X-Yandex-Req-Id`. Вставляем его в поле ввода на странице
[https://horizon-nora.z.yandex-team.ru/traces/new], жмём кнопку Trace. Ждём, пока будет собрана информация.

1. На странице трейса открываем Events, выбираем интересующую нас вершину. Например
[TEMPLATES](https://horizon-nora.z.yandex-team.ru/traces/5daa8889-7119-4817-b903-c46fa1eb7729/events). Во вкладке
Request/Response можно скопировать контекст запроса в формате json. Именно этот контекст нужен, чтобы сгенерировать
патроны для танка.

   Можно убедиться, что бэкенд корректно отвечает на полученный контекст. Сохраняем контекст в файл и действуем
[по инструкции](https://doc.yandex-team.ru/apphost/dg/concepts/testing-sources.html). В зависимости от типа бэкенда надо
выбрать правильную утилиту: для HTTP-бэкенда сработает `servant_client`, а для gRPC-бэкенда — `grpc_client`.

   **NB:** Утилита `grpc_client` принимает в адресе бэкенда порт и даже путь. Довольно часто выбрасывает ошибку
`Connection timeout`, в этом случае помогает увеличение этого значения:
   ```
   ./grpc_client --connection-timeout=500 my-alice-testing-1.vla.yp-c.yandex.net:10000/_setup/blackbox context.json
   ```

1. Превращаем контекст в однострочный JSON, это можно сделать прямо в консоли браузера: `JSON.stringify(<Ctrl-V сюда>)`.
Добавляем этот однострочник в файл `contexts`. Повторяем для всех контекстов, которые должны ротироваться во время
стрельбы.

## Генерация патронов
Бэкенды (источники) апхоста могут работать по HTTP- или gRPC-протоколу. Наш шаблонизатор `Report renderer` работает по
HTTP, а бэкенд `my_alice` по gRPC. Для стрельбы по HTTP-источнику используется обычный танк, а для gRPC нужна "пушка"
(Пандора) и особый формат патронов.

Ленту патронов можно получить при помощи утилиты `apphost/tools/make_tank_ammo`. На вход подаём файл `contexts`,
полученный ранее.
* `--grpc` включает режим генерации патронов для gRPC-бэкенда; 
* `--addr` работает только в HTTP-режиме. Значение превращается в заголовок `Host` и практически бесполезно; реальный
адрес "мишени" будет задан при запуске стрельбы;
* `--path` задаёт URI в HTTP-режиме, причем его надо указывать без первого слэша. При стрельбе по gRPC-источникам
одноименный параметр `path` содержится прямо в контексте, т.е. параметр задавать не надо;
* `--shell` позволяет сгруппировать патроны по "гильзам"
([см. документацию Танка](https://wiki.yandex-team.ru/load/guides/ammo/#tegia.k.a.gilzy)).

В случае HTTP-бэкенда можно проверить, что запросы в ленте сформированы корректно — 
[см. документацию Танка](https://wiki.yandex-team.ru/load/guides/ammo/#proverkakorrektnostipatronov). Протокол общения —
бинарные protobuf, можно пропустить ответ бэкенда через `protoc --decode_raw`.

## Стреляем
В случае HTTP-бэкенда параметры стрельбы в Лунапарке тривиальные: указываем хост и порт "мишени", заливаем файл
с патронами. Огонь!

Стрельба в gRPC-источники немного сложнее. Нам потребуется "пушка" для апхостового источника:
`apphost/tools/pandora_gun/gun`. Патроны для неё тоже нужны особые, при их генерации надо указать параметр
`--grpc`.

1. Собираем пушку:
   ```
   cd <ARCADIA_ROOT>/apphost/tools/pandora_gun/gun
   ya make --target-platform=linux 
   ```

1. Открываем страничку [запуска стрельбы](https://lunapark.yandex-team.ru/firestarter/) в Лунапарке.
[Уи уи уи уи уиу](https://youtu.be/zcOhrtAFc-Y), если понимаете. Прямо сейчас интерфейс firestarter не умеет нормально
конфигурировать пушки, поэтому придётся исправлять конфиг руками. Указываем мишень, заливаем файл с патронами и пушку
(бинарь из предыдущего пункта). Схему нагрузки можно не задавать, всё равно пушка не поймёт этот формат. Дальше 
редактируем конфиг:
   * заполняем секцию `pandora`:
   ```yaml
   pandora:
       enabled: true
       pandora_cmd: <заполняется автоматически при выборе пушки>
       resources:
         - src: <переносим значение из phantom.ammofile>
           dst: ./ammo.jsonlines
       config_content:
           pools: 
             - id: my_alice
               gun: 
                   type: app_host_pandora_gun
                   app_host_servant_method: InvokeEx # ещё есть значение Invoke, надо экспериментировать
                   target: <переносим из phantom.address>
               rps: # здесь задаём профиль нагрузки. См. https://wiki.yandex-team.ru/Load/Pandora/#podgotovkakonfiga
                 - {duration: 10s, ops: 10, type: const}
               startup: # количество инстансов — важный параметр. См. https://wiki.yandex-team.ru/Load/Pandora/#podgotovkakonfiga 
                 - {times: 10, type: once}
               ammo: {source: {path: ./ammo.jsonlines, type: file}, type: app_host_provider}             
               result: {destination: ./phout.log, type: phout}
           log: {level: error}
           monitoring: {expvar: {enabled: true, port: 1234}}
   ```
   * добавляем поле `phantom.enabled: false`. В секции `phantom` обязательно надо оставить поле `address`, иначе
firestarter не даст запустить стрельбу. Остальные поля не будут использоваться, и их можно удалить.

   Теперь можно запускать стрельбу.
