from alice.megamind.protos.common.iot_pb2 import TIoTUserInfo
from alice.protos.data.device.info_pb2 import EUserDeviceType
from alice.protos.data.location.group_pb2 import TUserGroup
from alice.protos.data.location.room_pb2 import TUserRoom

TCapability = TIoTUserInfo.TCapability
TProperty = TIoTUserInfo.TProperty
ECapabilityType = TCapability.ECapabilityType

group_and_room = TIoTUserInfo(
    RawUserInfo='{}',
    Scenarios=[],
    Colors=[
        TIoTUserInfo.TColor(
            Id='blue',
            Name='Синий',
        ),
    ],
    Rooms=[
        TUserRoom(
            Id='room-test-id-1',
            Name='Кухня',
            HouseholdId='evo-test-household-id-1',
        ),
    ],
    Households=[
        TIoTUserInfo.THousehold(
            Id='evo-test-household-id-1',
            Name='Дом',
        ),
    ],
    CurrentHouseholdId='evo-test-household-id-1',
    Groups=[
        TUserGroup(
            Id='evo-test-group-id-1',
            Name='Люстра',
            AnalyticsType='devices.types.light',
            Type=EUserDeviceType.LightDeviceType,
            HouseholdId='evo-test-household-id-1',
        )
    ],
    Devices=[
        TIoTUserInfo.TDevice(
            HouseholdId='evo-test-household-id-1',
            Id='evo-test-lamp-id-1',
            ExternalId='evo-test-lamp-external-id-1',
            GroupIds=['evo-test-group-id-1'],
            Name='Лампочка 1',
            Aliases=[],
            SkillId='QUALITY',
            Status=TIoTUserInfo.TDevice.EDeviceState.OnlineDeviceState,
            Type=EUserDeviceType.LightDeviceType,
            OriginalType=EUserDeviceType.LightDeviceType,
            AnalyticsType='devices.types.light',
            RoomId='room-test-id-1',
            Capabilities=[
                TCapability(
                    Type=ECapabilityType.OnOffCapabilityType,
                    OnOffCapabilityParameters=TCapability.TOnOffCapabilityParameters(),
                    OnOffCapabilityState=TCapability.TOnOffCapabilityState(
                        Instance='on',
                        Value=True,
                    ),
                    AnalyticsType='devices.capabilities.on_off',
                    Retrievable=True,
                    Reportable=True,
                ),
                TCapability(
                    Type=ECapabilityType.ColorSettingCapabilityType,
                    ColorSettingCapabilityParameters=TCapability.TColorSettingCapabilityParameters(
                        TemperatureK=TCapability.TColorSettingCapabilityParameters.TTemperatureKCapabilityParameters(
                            Min=2000,
                            Max=9000,
                        ),
                        ColorSceneParameters=TCapability.TColorSettingCapabilityParameters.TColorSceneParameters(),
                        ColorModel=TCapability.TColorSettingCapabilityParameters.TColorModel(
                            Type=TCapability.TColorSettingCapabilityParameters.TColorModel.EColorModelType.HsvColorModel,
                        ),
                    ),
                    ColorSettingCapabilityState=TCapability.TColorSettingCapabilityState(
                        Instance='temperature_k',
                        TemperatureK=4000,
                    ),
                    AnalyticsType='devices.capabilities.color_setting',
                    Retrievable=True,
                    Reportable=False,
                ),
                TCapability(
                    Type=ECapabilityType.RangeCapabilityType,
                    RangeCapabilityParameters=TCapability.TRangeCapabilityParameters(
                        Range=TCapability.TRangeCapabilityParameters.TRange(
                            Min=1,
                            Max=100,
                            Precision=1,
                        ),
                        RandomAccess=True,
                        Unit='unit.percent',
                        Instance='brightness',
                        Looped=False,
                    ),
                ),
            ]
        ),
        TIoTUserInfo.TDevice(
            HouseholdId='evo-test-household-id-1',
            Id='evo-test-lamp-id-2',
            ExternalId='evo-test-lamp-external-id-2',
            GroupIds=['evo-test-group-id-1'],
            Name='Лампочка 2',
            Aliases=[],
            SkillId='QUALITY',
            Status=TIoTUserInfo.TDevice.EDeviceState.OnlineDeviceState,
            Type=EUserDeviceType.LightDeviceType,
            OriginalType=EUserDeviceType.LightDeviceType,
            AnalyticsType='devices.types.light',
            RoomId='room-test-id-1',
            Capabilities=[
                TCapability(
                    Type=ECapabilityType.OnOffCapabilityType,
                    OnOffCapabilityParameters=TCapability.TOnOffCapabilityParameters(),
                    OnOffCapabilityState=TCapability.TOnOffCapabilityState(
                        Instance='on',
                        Value=True,
                    ),
                    AnalyticsType='devices.capabilities.on_off',
                    Retrievable=True,
                    Reportable=True,
                ),
                TCapability(
                    Type=ECapabilityType.ColorSettingCapabilityType,
                    ColorSettingCapabilityParameters=TCapability.TColorSettingCapabilityParameters(
                        TemperatureK=TCapability.TColorSettingCapabilityParameters.TTemperatureKCapabilityParameters(
                            Min=2000,
                            Max=9000,
                        ),
                        ColorSceneParameters=TCapability.TColorSettingCapabilityParameters.TColorSceneParameters(),
                        ColorModel=TCapability.TColorSettingCapabilityParameters.TColorModel(
                            Type=TCapability.TColorSettingCapabilityParameters.TColorModel.EColorModelType.HsvColorModel,
                        ),
                    ),
                    ColorSettingCapabilityState=TCapability.TColorSettingCapabilityState(
                        Instance='temperature_k',
                        TemperatureK=4000,
                    ),
                    AnalyticsType='devices.capabilities.color_setting',
                    Retrievable=True,
                    Reportable=False,
                ),
                TCapability(
                    Type=ECapabilityType.RangeCapabilityType,
                    RangeCapabilityParameters=TCapability.TRangeCapabilityParameters(
                        Range=TCapability.TRangeCapabilityParameters.TRange(
                            Min=1,
                            Max=100,
                            Precision=1,
                        ),
                        RandomAccess=True,
                        Unit='unit.percent',
                        Instance='brightness',
                        Looped=False,
                    ),
                ),
            ]
        ),
    ]
)
