from alice.megamind.protos.common.iot_pb2 import TIoTUserInfo
from alice.protos.data.device.info_pb2 import EUserDeviceType
from alice.protos.data.location.room_pb2 import TUserRoom

TCapability = TIoTUserInfo.TCapability
TProperty = TIoTUserInfo.TProperty
ECapabilityType = TCapability.ECapabilityType

sensors_humidity = TIoTUserInfo(
    RawUserInfo='{}',
    Scenarios=[],
    Colors=[],
    Rooms=[
        TUserRoom(
            Id='room-test-id-1',
            Name='Кухня',
            HouseholdId='evo-test-household-id-1',
        ),
        TUserRoom(
            Id='room-test-id-2',
            Name='Спальня',
            HouseholdId='evo-test-household-id-1',
        ),
        TUserRoom(
            Id='room-test-id-3',
            Name='Кладовая',
            HouseholdId='evo-test-household-id-1',
        ),
    ],
    Households=[
        TIoTUserInfo.THousehold(
            Id='evo-test-household-id-1',
            Name='Квартира',
        ),
    ],
    CurrentHouseholdId='evo-test-household-id-1',
    Groups=[],
    Devices=[
        TIoTUserInfo.TDevice(
            HouseholdId='evo-test-household-id-1',
            Id='evo-test-property-id-1',
            ExternalId='evo-test-property-id-1',
            Name='Датчик',
            Aliases=[],
            SkillId='QUALITY',
            Status=TIoTUserInfo.TDevice.EDeviceState.OnlineDeviceState,
            Type=EUserDeviceType.SensorDeviceType,
            OriginalType=EUserDeviceType.SensorDeviceType,
            RoomId='room-test-id-1',
            Capabilities=[],
            Properties=[
                TProperty(
                    Type=TProperty.EPropertyType.FloatPropertyType,
                    FloatPropertyParameters=TProperty.TFloatPropertyParameters(
                        Instance='humidity',
                        Unit='unit.percent',
                    ),
                    FloatPropertyState=TProperty.TFloatPropertyState(
                        Instance='humidity',
                        Value=77,
                    ),
                    Retrievable=True,
                ),
                TProperty(
                    Type=TProperty.EPropertyType.FloatPropertyType,
                    FloatPropertyParameters=TProperty.TFloatPropertyParameters(
                        Instance='battery_level',
                        Unit='unit.percent',
                    ),
                    FloatPropertyState=TProperty.TFloatPropertyState(
                        Instance='battery_level',
                        Value=15,
                    ),
                    Retrievable=True,
                ),
            ],
        ),
        TIoTUserInfo.TDevice(
            HouseholdId='evo-test-household-id-1',
            Id='evo-test-property-id-2',
            ExternalId='evo-test-property-id-2',
            Name='Датчик',
            Aliases=[],
            SkillId='QUALITY',
            Status=TIoTUserInfo.TDevice.EDeviceState.OnlineDeviceState,
            Type=EUserDeviceType.SensorDeviceType,
            OriginalType=EUserDeviceType.SensorDeviceType,
            RoomId='room-test-id-2',
            Capabilities=[],
            Properties=[
                TProperty(
                    Type=TProperty.EPropertyType.FloatPropertyType,
                    FloatPropertyParameters=TProperty.TFloatPropertyParameters(
                        Instance='humidity',
                        Unit='unit.percent',
                    ),
                    FloatPropertyState=TProperty.TFloatPropertyState(
                        Instance='humidity',
                        Value=66,
                    ),
                    Retrievable=True,
                ),
                TProperty(
                    Type=TProperty.EPropertyType.FloatPropertyType,
                    FloatPropertyParameters=TProperty.TFloatPropertyParameters(
                        Instance='battery_level',
                        Unit='unit.percent',
                    ),
                    FloatPropertyState=TProperty.TFloatPropertyState(
                        Instance='battery_level',
                        Value=20,
                    ),
                    Retrievable=True,
                ),
            ],
        ),
        TIoTUserInfo.TDevice(
            HouseholdId='evo-test-household-id-1',
            Id='evo-test-property-id-3',
            ExternalId='evo-test-property-id-3',
            Name='Датчик',
            Aliases=[],
            SkillId='QUALITY',
            Status=TIoTUserInfo.TDevice.EDeviceState.OnlineDeviceState,
            Type=EUserDeviceType.SensorDeviceType,
            OriginalType=EUserDeviceType.SensorDeviceType,
            RoomId='room-test-id-3',
            Capabilities=[],
            Properties=[
                TProperty(
                    Type=TProperty.EPropertyType.FloatPropertyType,
                    FloatPropertyParameters=TProperty.TFloatPropertyParameters(
                        Instance='humidity',
                        Unit='unit.percent',
                    ),
                    FloatPropertyState=TProperty.TFloatPropertyState(
                        Instance='humidity',
                        Value=55,
                    ),
                    Retrievable=True,
                ),
                TProperty(
                    Type=TProperty.EPropertyType.FloatPropertyType,
                    FloatPropertyParameters=TProperty.TFloatPropertyParameters(
                        Instance='battery_level',
                        Unit='unit.percent',
                    ),
                    FloatPropertyState=TProperty.TFloatPropertyState(
                        Instance='battery_level',
                        Value=10,
                    ),
                    Retrievable=True,
                ),
            ],
        ),
    ],
)
