Полная [документация](https://wiki.yandex-team.ru/alice/infra/integrationtests/) (в разработке)

В Pull Request используется devexp-robot, которому можно задавать [команды](https://github.yandex-team.ru/devexp/devexp#%D0%BF%D0%BE%D0%B4%D0%B4%D0%B5%D1%80%D0%B6%D0%B8%D0%B2%D0%B0%D0%B5%D0%BC%D1%8B%D0%B5-%D0%BA%D0%BE%D0%BC%D0%B0%D0%BD%D0%B4%D1%8B).
Активируйте telegram-бота ```@codereview_bot``` командой ```/start```, чтобы получать быстрые уведомления.

## Как работают тесты

Тест –– это то, как выглядит Алиса для пользователя (станция, ПП и тп).
В них эмулируется работа разных поверхностей Алисы. Их внутреннее состояние и поведение.

Запросы задаются через Uniproxy. В самих тестах никаких сервисов не поднимается.

При запуске можно переопределить урлы Uniproxy и/или Megamind.
По умолчанию, запросы идут в hamster Uniproxy ```wss://beta.uniproxy.alice.yandex.net/alice-uniproxy-hamster/uni.ws```. Можно переопределить урлы uniproxy и/или megamind, но не рекомендуется обстреливать прод.
В случае использования продовых урлов тесты обязательно запускать с параметром ```--test-param yes-i-want-to-kill-the-production=True```.

При отведении релиза Megamind тесты прогоняются релизной машиной с помощью таски ```AliceEvoIntegrationTestsWrapper```. Также тесты автоматически [запускаются](https://sandbox.yandex-team.ru/scheduler/44252/view) каждый час "против текущего trunk".

## Запуск тестов

Тесты интегрированы в систему сборки ```ya make``` и запускаются с ее помощью.

```
# прогнать все тесты
ya make -A

# отфильтровать тесты по имени
ya make -A -F TEST_NAME

# фильтровать можно по маске, например: -F external_skills.
# -P добавит в вывод имена тестов с путями до логов
ya make -A[P] -F TEST_NAME

# переопределить урл Megamind в тестах
ya make -A --test-param vins-url=MEGAMIND_URL

# переопределить урл Uniproxy в тестах
ya make -A --test-param uniproxy-url=UNIPROXY_URL

# добавить/переопределить эксперименты для всех тестов
ya make -A --test-param exps='disregard_uaas: None, mm_enable_protocol_scenario=Vins, market_disable'

# запустить с полной отладочной информацией о запросах
# имеет смысл запускать для отладки конкретного теста
ya make -A [-F TEST_NAME] --test-param debug=True --test-stderr

# запустить в режиме python-дебага
# останавливается на провалившемся assert
# дает раздебажить (посмотреть стек/переменные и т.д.) как в GDB
ya make -A [-F TEST_NAME] --pdb

# отфильтровать по mark теста (тестовая фича) 
# MARK: testpalm (тесты TestPalm), text (тесты с TextInput), voice (тесты с VoiceInput)
ya make -A --test-param mark=MARK
```

Полная [документация](https://wiki.yandex-team.ru/yatool/test/) по использованию ```ya make```.

#### Медленно работают тест(ы)

Если вы запускаете тесты, которые лежат в одном файле, то можно ускорить их запуск, добавив параметр ```--test-filename```.
Если часто работаете с определенным файлом/файлами, создайте алиас для удобного запуска.

```
# пример запуска
ya make -AF *test_weather_smoke* --test-filename pogoda/get_weather.py
```

Подробнее [тут](https://wiki.yandex-team.ru/alice/infra/fast-integration-tests/).

#### Запуск тестов для тестирования локальных изменений

Если вы хотите протестровать новые изменения с помощью EVO тестов, добавьте флаги для поднятия сооответсвующих сервисов.
Все запросы пойдут через hamster Uniproxy, переопределяя VinsUrl в соответствии с https://docs.yandex-team.ru/alice-scenarios/srcrwr.

EVO поднимает и/или любой из этих сервисов.
Обычно один на все тесты, но иногда происходят аномалии, когда сервисы переподнимаются и из-за этого могут произойти неприятности.

С осторожностью используйте при массовом запуске тестов.

```
# поднять локально Hollywood
# используется шард HOLLYWOOD_ALL
ya make -AF volume. -DHW

# поднять локально Megaming
ya make -AF volume. -DMM

# поднять локально AppHost
ya make -AF volume. -DAP

# поднять локально Hollywood и Megaming
ya make -AF volume. -DHW -DMM

# поднять локально Hollywood, Megaming, AppHost
ya make -AF volume. -DHW -DMM -DAP

# поднять локально всё
ya make -AF volume. -DALL
```

## Хочу написать тест

Основные моменты:
1) Не создавайте файлы с тестами в корневой папке.

Тесты разбиты по папкам, каждая из которых соответствует определённой компоненте из TestPalm.
Такое разбиение позволяет не дублировать тесты с одинаковым поведением, но разными поверхностями.
При добавлении нового теста положите его в правильную папку. Если её еще нет, создайте.

2) Если сейчас технически написать тест невозможно, оставьте заявку в тикете ALICEINFRA-249 с полным описанием проблемы.
3) Все тесты должны быть обернуты в классы. Не используйте свободные функции.
4) У теста обязательно надо задать поверхность. Поверхность по умолчанию не задается.
5) Первый параметр у теста: ```alice```.
6) По умолчанию тест отправляет текстовые запросы.
7) Для создания голосового теста добавьте ```pytest.mark.voice```.
