//
// Autogenerated file
// This file was created from TInterfaces.proto and TInterfaces.jinja2 template
//
// Don't edit it manually!
// Please refer to doc: https://TODO for more information about custom codegeneration
//

struct TSupportedIterfacesBase {
public:
    // True if the app can display the response from Alice (as opposed to
    //  smart speakers, for example).
    //  Relies on data from the app. Please, look for alternatives if possible.
    virtual bool GetHasScreen() const = 0; // This field is an extension or doesnt contains valid definition
    // True if the session started with voice activation (as opposed to typing).
    virtual bool GetVoiceSession() const = 0; // This field is an extension or doesnt contains valid definition
    // True if the app has access to speakers (false for Module, for example).
    //  The flag is not reliable due to wrong default value.
    // (BASS: !no_reliable_speakers) динамики "надежные" (используется для напоминаний и будильников)
    virtual bool GetHasReliableSpeakers() const {
        return SupportedFeatures.contains("no_reliable_speakers");
    }
    // True if the app has access to Bluetooth.
    // not reliable due to wrong default value
    virtual bool GetHasBluetooth() const = 0; // This field is an extension or doesnt contains valid definition
    // True if the app has access to the state of the battery on the device.
    // клиент может имеет доступ к заряду батареи
    virtual bool GetHasAccessToBatteryPowerState() const {
        if (SupportedFeatures.contains("battery_power_state")) {
            return true;
        }
        if (UnsupportedFeatures.contains("battery_power_state")) {
            return false;
        }
        return false;
    }
    // True if the app can turn off a screen connected to the device through
    //  HDMI.
    // клиент может выключать экран через HDMI
    virtual bool GetHasCEC() const {
        if (SupportedFeatures.contains("cec_available")) {
            return true;
        }
        if (UnsupportedFeatures.contains("cec_available")) {
            return false;
        }
        return false;
    }
    // True if the app can change the sound that the device uses for alarms.
    // клиент поддерживает изменение звука будильника
    virtual bool GetCanChangeAlarmSound() const {
        if (SupportedFeatures.contains("change_alarm_sound")) {
            return true;
        }
        if (UnsupportedFeatures.contains("change_alarm_sound")) {
            return false;
        }
        return false;
    }
    // True if the app has access to the microphone on the device.
    // not reliable due to wrong default value
    virtual bool GetHasMicrophone() const = 0; // This field is an extension or doesnt contains valid definition
    // The device firmware supports Music "shots".
    //  TODO: clarify with Music
    // клиент (музыкальный плеер) поддерживает шоты
    virtual bool GetHasMusicPlayerShots() const = 0; // This field is an extension or doesnt contains valid definition
    // True if there's a TV currently plugged into the device.
    virtual bool GetIsTvPlugged() const = 0; // This field is an extension or doesnt contains valid definition
    virtual bool GetCanSetAlarm() const = 0;
    virtual bool GetCanSetTimer() const = 0;
    // client can open link in internal browser
    virtual bool GetCanOpenLink() const = 0;
    // client can open turbo app
    virtual bool GetCanOpenLinkTurboApp() const = 0;
    // client implements pushes without races
    virtual bool GetHasSynchronizedPush() const = 0; // This field is an extension or doesnt contains valid definition
    // client supports video protocol (knows how to handle video directives)
    virtual bool GetSupportsVideoProtocol() const = 0;
    // subset of clients supporting div2 cards
    virtual bool GetCanShowGif() const = 0; // This field is an extension or doesnt contains valid definition
    // client supports led display to show animation
    virtual bool GetHasLedDisplay() const {
        if (SupportedFeatures.contains("led_display")) {
            return true;
        }
        if (UnsupportedFeatures.contains("led_display")) {
            return false;
        }
        return false;
    }
    // client can voice tts (tts_play_placeholder directive) in arbitrary place among directives
    virtual bool GetTtsPlayPlaceholder() const {
        if (SupportedFeatures.contains("tts_play_placeholder")) {
            return true;
        }
        if (UnsupportedFeatures.contains("tts_play_placeholder")) {
            return false;
        }
        return false;
    }
    // True if device has multiroom support
    virtual bool GetMultiroom() const {
        return SupportedFeatures.contains("multiroom");
    }
    // client supports thin audio player
    virtual bool GetHasAudioClient() const {
        if (SupportedFeatures.contains("audio_client")) {
            return true;
        }
        if (UnsupportedFeatures.contains("audio_client")) {
            return false;
        }
        return false;
    }
    // client is publicly available (risky client due to some legal reasons)
    virtual bool GetIsPubliclyAvailable() const {
        if (SupportedFeatures.contains("publicly_available")) {
            return true;
        }
        if (UnsupportedFeatures.contains("publicly_available")) {
            return false;
        }
        return false;
    }
    // client supports push notifications via alice notificator
    virtual bool GetHasNotifications() const {
        if (SupportedFeatures.contains("notifications")) {
            return true;
        }
        if (UnsupportedFeatures.contains("notifications")) {
            return false;
        }
        return false;
    }
    virtual bool GetHasBluetoothPlayer() const {
        if (SupportedFeatures.contains("bluetooth_player")) {
            return true;
        }
        if (UnsupportedFeatures.contains("bluetooth_player")) {
            return false;
        }
        return false;
    }
    virtual bool GetCanChangeAlarmSoundLevel() const {
        if (SupportedFeatures.contains("change_alarm_sound_level")) {
            return true;
        }
        if (UnsupportedFeatures.contains("change_alarm_sound_level")) {
            return false;
        }
        return false;
    }
    // client implements server actions (special alice backend requests)
    virtual bool GetCanServerAction() const = 0;
    // client supports music recognition with music request
    virtual bool GetCanRecognizeMusic() const = 0;
    // client supports mordovia directives
    virtual bool GetHasMordoviaWebView() const = 0;
    // client supports incoming messenger calls
    virtual bool GetIncomingMessengerCalls() const {
        return SupportedFeatures.contains("incoming_messenger_calls");
    }
    // client supports pairing to a remote control unit via bluetooth
    virtual bool GetSupportsBluetoothRCU() const {
        if (SupportedFeatures.contains("bluetooth_rcu")) {
            return true;
        }
        if (UnsupportedFeatures.contains("bluetooth_rcu")) {
            return false;
        }
        return false;
    }
    // True if client supports live-tv scheme urls (publishes own url list based on internal channel db state
    //  to backend and knows how to handle such urls after receiving)
    virtual bool GetLiveTvScheme() const {
        return SupportedFeatures.contains("live_tv_scheme");
    }
    // client can open quasar screen
    virtual bool GetCanOpenQuasarScreen() const = 0;
    // Video codecs
    virtual bool GetVideoCodecAVC() const {
        return SupportedFeatures.contains("video_codec_AVC");
    }
    virtual bool GetVideoCodecHEVC() const {
        return SupportedFeatures.contains("video_codec_HEVC");
    }
    virtual bool GetVideoCodecVP9() const {
        return SupportedFeatures.contains("video_codec_VP9");
    }
    /* [[ deprecated ]] */
    virtual bool GetAudioCodecDD() const = 0; // This field is an extension or doesnt contains valid definition
    /* [[ deprecated ]] */
    virtual bool GetAudioCodecDTS() const = 0; // This field is an extension or doesnt contains valid definition
    virtual bool GetAudioCodecAAC() const {
        return SupportedFeatures.contains("audio_codec_AAC");
    }
    /* [[ deprecated ]] */
    virtual bool GetAudioCodecEC3() const = 0; // This field is an extension or doesnt contains valid definition
    virtual bool GetCurrentHDCPLevelNone() const = 0; // This field is an extension or doesnt contains valid definition
    virtual bool GetCurrentHDCPLevel1X() const = 0; // This field is an extension or doesnt contains valid definition
    virtual bool GetCurrentHDCPLevel2X() const = 0; // This field is an extension or doesnt contains valid definition
    virtual bool GetDynamicRangeSDR() const {
        return SupportedFeatures.contains("dynamic_range_SDR");
    }
    virtual bool GetDynamicRangeHDR10() const {
        return SupportedFeatures.contains("dynamic_range_HDR10");
    }
    virtual bool GetDynamicRangeHDR10Plus() const {
        return SupportedFeatures.contains("dynamic_range_HDR10Plus");
    }
    virtual bool GetDynamicRangeDV() const {
        return SupportedFeatures.contains("dynamic_range_DV");
    }
    virtual bool GetDynamicRangeHLG() const {
        return SupportedFeatures.contains("dynamic_range_HLG");
    }
    virtual bool GetVideoFormatSD() const = 0; // This field is an extension or doesnt contains valid definition
    virtual bool GetVideoFormatHD() const = 0; // This field is an extension or doesnt contains valid definition
    virtual bool GetVideoFormatUHD() const = 0; // This field is an extension or doesnt contains valid definition
    // client can open whocalls onboarding
    virtual bool GetCanOpenWhocalls() const = 0;
    virtual bool GetAudioCodecEAC3() const {
        return SupportedFeatures.contains("audio_codec_EAC3");
    }
    virtual bool GetAudioCodecAC3() const {
        return SupportedFeatures.contains("audio_codec_AC3");
    }
    virtual bool GetAudioCodecVORBIS() const {
        return SupportedFeatures.contains("audio_codec_VORBIS");
    }
    virtual bool GetAudioCodecOPUS() const {
        return SupportedFeatures.contains("audio_codec_OPUS");
    }
    virtual bool GetHasMusicSdkClient() const = 0;
    virtual bool GetCanRecognizeImage() const = 0;
    virtual bool GetCanRenderDivCards() const = 0;
    virtual bool GetCanOpenLinkIntent() const = 0;
    // True if device has multiroom cluster support
    virtual bool GetMultiroomCluster() const {
        return SupportedFeatures.contains("multiroom_cluster");
    }
    // Actually tells that this is PP that can render div2 card from response.layout.card; Consider as Deprecated in Clients other than PP
    virtual bool GetCanRenderDiv2Cards() const = 0;
    // client can open external skills in separate tabs
    virtual bool GetCanOpenDialogsInTabs() const = 0;
    // client can open serp with viewport:// url
    virtual bool GetCanOpenLinkSearchViewport() const = 0;
    // client supports sequential directive execution
    virtual bool GetHasDirectiveSequencer() const {
        if (SupportedFeatures.contains("directive_sequencer")) {
            return true;
        }
        if (UnsupportedFeatures.contains("directive_sequencer")) {
            return false;
        }
        return false;
    }
    // client can open keyboard onboarding/settings
    virtual bool GetCanOpenKeyboard() const {
        if (SupportedFeatures.contains("keyboard")) {
            return true;
        }
        if (UnsupportedFeatures.contains("keyboard")) {
            return false;
        }
        return false;
    }
    // client implements cloud-based pushes
    virtual bool GetHasCloudPush() const = 0; // This field is an extension or doesnt contains valid definition
    // True if device can open "yandex-auth://" links for authorization
    virtual bool GetCanOpenYandexAuth() const = 0;
    // client supports legacy quasar music player
    virtual bool GetHasMusicQuasarClient() const {
        if (SupportedFeatures.contains("music_quasar_client")) {
            return true;
        }
        if (UnsupportedFeatures.contains("music_quasar_client")) {
            return false;
        }
        return false;
    }
    virtual bool GetCanSetAlarmSemanticFrame() const = 0; // This field is an extension or doesnt contains valid definition
    // supports navigator protocol
    virtual bool GetHasNavigator() const = 0;
    // client supports yellowskin js-api
    virtual bool GetCanOpenLinkYellowskin() const = 0;
    // client supports show_view directive
    virtual bool GetSupportsShowView() const {
        if (SupportedFeatures.contains("show_view")) {
            return true;
        }
        if (UnsupportedFeatures.contains("show_view")) {
            return false;
        }
        return false;
    }
    // client supports listening to FM radio
    virtual bool GetSupportsFMRadio() const = 0; // This field is an extension or doesnt contains valid definition
    // client supports outgoing phone calls
    virtual bool GetOutgoingPhoneCalls() const = 0;
    // client can open system browser settings screen with custom push
    virtual bool GetCanOpenIBroSettings() const {
        if (SupportedFeatures.contains("open_ibro_settings")) {
            return true;
        }
        if (UnsupportedFeatures.contains("open_ibro_settings")) {
            return false;
        }
        return false;
    }
    // client supports streaming video data through hdmi
    virtual bool GetSupportsHDMIOutput() const = 0; // This field is an extension or doesnt contains valid definition
    // client's audio player supports middle-level sound bitrate
    virtual bool GetSupportsAudioBitrate192Kbps() const {
        return SupportedFeatures.contains("audio_bitrate192");
    }
    // client's audio player supports the highest sound bitrate
    virtual bool GetSupportsAudioBitrate320Kbps() const {
        return SupportedFeatures.contains("audio_bitrate320");
    }
    // client supports video_play directive
    virtual bool GetSupportsVideoPlayDirective() const = 0;
    // client can open reader app
    virtual bool GetCanOpenReader() const = 0; // This field is an extension or doesnt contains valid definition
    // client supports music directives for unauthorized user
    virtual bool GetSupportsUnauthorizedMusicDirectives() const {
        if (SupportedFeatures.contains("unauthorized_music_directives")) {
            return true;
        }
        if (UnsupportedFeatures.contains("unauthorized_music_directives")) {
            return false;
        }
        return false;
    }
    // client supports tv_open_collection_screen directive
    virtual bool GetSupportsTvOpenCollectionScreenDirective() const {
        if (SupportedFeatures.contains("tv_open_collection_screen_directive")) {
            return true;
        }
        if (UnsupportedFeatures.contains("tv_open_collection_screen_directive")) {
            return false;
        }
        return false;
    }
    // client supports tv_open_details_screen directive
    virtual bool GetSupportsTvOpenDetailsScreenDirective() const {
        if (SupportedFeatures.contains("tv_open_details_screen_directive")) {
            return true;
        }
        if (UnsupportedFeatures.contains("tv_open_details_screen_directive")) {
            return false;
        }
        return false;
    }
    // client supports tv_open_person_screen directive
    virtual bool GetSupportsTvOpenPersonScreenDirective() const {
        if (SupportedFeatures.contains("tv_open_person_screen_directive")) {
            return true;
        }
        if (UnsupportedFeatures.contains("tv_open_person_screen_directive")) {
            return false;
        }
        return false;
    }
    // client supports tv_open_search_screen directive
    virtual bool GetSupportsTvOpenSearchScreenDirective() const {
        if (SupportedFeatures.contains("tv_open_search_screen_directive")) {
            return true;
        }
        if (UnsupportedFeatures.contains("tv_open_search_screen_directive")) {
            return false;
        }
        return false;
    }
    // client supports tv_open_series_screen directive
    virtual bool GetSupportsTvOpenSeriesScreenDirective() const {
        if (SupportedFeatures.contains("tv_open_series_screen_directive")) {
            return true;
        }
        if (UnsupportedFeatures.contains("tv_open_series_screen_directive")) {
            return false;
        }
        return false;
    }
    // client supports Alice-cloud https://st.yandex-team.ru/IBRO-24652
    virtual bool GetSupportsCloudUi() const {
        if (SupportedFeatures.contains("cloud_ui")) {
            return true;
        }
        if (UnsupportedFeatures.contains("cloud_ui")) {
            return false;
        }
        return false;
    }
    // client supports multiroom on audio client
    virtual bool GetMultiroomAudioClient() const {
        return SupportedFeatures.contains("multiroom_audio_client");
    }
    // proxy interface for client support one of div cards (CanRenderDivCards or CanRenderDiv2Cards)
    virtual bool GetSupportsDivCardsRendering() const = 0; // This field is an extension or doesnt contains valid definition
    // can open covid qr code in app
    virtual bool GetCanOpenCovidQrCode() const = 0;
    // client supports hls in thin audio player
    virtual bool GetHasAudioClientHls() const {
        if (SupportedFeatures.contains("audio_client_hls")) {
            return true;
        }
        if (UnsupportedFeatures.contains("audio_client_hls")) {
            return false;
        }
        return false;
    }
    // client can open pedometer app
    virtual bool GetCanOpenPedometer() const {
        return SupportedFeatures.contains("pedometer");
    }
    // client supports vertical screen navigation directives (go_up/go_down)
    virtual bool GetSupportsVerticalScreenNavigation() const = 0;
    // client can open whocalls blocking settings
    virtual bool GetCanOpenWhocallsBlocking() const {
        return SupportedFeatures.contains("whocalls_call_blocking");
    }
    // client can download offline maps https://st.yandex-team.ru/MAPSPRODUCT-1623
    virtual bool GetSupportsMapsDownloadOffline() const {
        if (SupportedFeatures.contains("maps_download_offline")) {
            return true;
        }
        if (UnsupportedFeatures.contains("maps_download_offline")) {
            return false;
        }
        return false;
    }
    // client can open password manager via deeplink
    virtual bool GetCanOpenPasswordManager() const = 0; // This field is an extension or doesnt contains valid definition
    // // client supports go_home directive
    virtual bool GetSupportsGoHomeDirective() const {
        if (SupportedFeatures.contains("go_home")) {
            return true;
        }
        if (UnsupportedFeatures.contains("go_home")) {
            return false;
        }
        return false;
    }
    // client supports smart camera in bonus cards mode
    virtual bool GetCanOpenBonusCardsCamera() const {
        return SupportedFeatures.contains("bonus_cards_camera");
    }
    // client can open bonus cards list
    virtual bool GetCanOpenBonusCardsList() const {
        return SupportedFeatures.contains("bonus_cards_list");
    }
    // client supports timer_show directive
    virtual bool GetCanShowTimer() const = 0;
    // client has internal music player
    virtual bool GetHasMusicPlayer() const = 0; // This field is an extension or doesnt contains valid definition
    // client supports device local reminders
    virtual bool GetSupportsDeviceLocalReminders() const {
        return SupportedFeatures.contains("supports_device_local_reminders");
    }
    // client can open message filtering
    virtual bool GetCanOpenWhocallsMessageFiltering() const {
        return SupportedFeatures.contains("whocalls_message_filtering");
    }
    // client supports 7-segment-led display to show animation (Mini 2)
    virtual bool GetHasScledDisplay() const {
        return SupportedFeatures.contains("scled_display");
    }
    // client can send the address book
    virtual bool GetPhoneAddressBook() const {
        return SupportedFeatures.contains("phone_address_book");
    }
    // client supports sound_set_level directive
    virtual bool GetSupportsAbsoluteVolumeChange() const {
        if (SupportedFeatures.contains("absolute_volume_change")) {
            return true;
        }
        if (UnsupportedFeatures.contains("absolute_volume_change")) {
            return false;
        }
        return true;
    }
    // client supports sound_louder/sound_quiter directive
    virtual bool GetSupportsRelativeVolumeChange() const {
        if (SupportedFeatures.contains("relative_volume_change")) {
            return true;
        }
        if (UnsupportedFeatures.contains("relative_volume_change")) {
            return false;
        }
        return false;
    }
    // client can open videotranslation onboarding
    virtual bool GetCanOpenVideotranslationOnboarding() const = 0; // This field is an extension or doesnt contains valid definition
    // client can open the address book
    virtual bool GetOpenAddressBook() const = 0;
    // client shows clock on its display
    virtual bool GetHasClockDisplay() const {
        if (SupportedFeatures.contains("clock_display")) {
            return true;
        }
        if (UnsupportedFeatures.contains("clock_display")) {
            return false;
        }
        return false;
    }
protected:
    explicit TSupportedIterfaces(const TSpeechKitRequestProto& proto) {
        TClientFeatures clientFeatures{proto.GetApplication(), expFlags};
        for (const auto& feature : proto.GetRequest().GetAdditionalOptions().GetSupportedFeatures()) {
            clientFeatures.AddSupportedFeature(feature);
        }
        for (const auto& feature : proto.GetRequest().GetAdditionalOptions().GetUnsupportedFeatures()) {
            clientFeatures.AddUnsupportedFeature(feature);
        }
    }
    virtual ~TSupportedIterfaces() {
    }
private:
    TSet<TString> SupportedFeatures;
    TSet<TString> UnsupportedFeatures;
};
