# Описание
Сервис будет периодически опрашивать каждый инстанс сервиса и возвращать их консистентность.<br>
Ожидается, что опрашиваемая ручка будет отдавать положительный `int`, плохие значения заменяются на `-1`<br>
Сервис отдает сигналы<br>
`[nanny-service-id_axxx, (0.0 - 1.0)]`,<br>
вычисляя значение по формуле<br>
`1 - (sum(versions)/len(versions)/abs(max(versions)))`<br>
Если значение больше 1, возвращается 1<br>
<br>
`0.0` - Все версии актуальны и равны последней<br>
`1.0` - Сервис требует внимания - скорее всего, большинство инстансов ответили плохо<br>
Промежуточные значения показывают расхождение версий от максимальной. Чем меньше, тем больше старых инстансов<br>
<br>
Если в конфиге указан параметр `beta_for`, будут дополнительно сравниваться версии сервиса с версией сервиса, указанного в этом поле.<br>
Эти данные будут отдаваться в сигнал<br>
`[nanny-service-id-consistent_axxx, {0|1}]`<br>
`0` - версии полностью совпадают<br>
`1` - один из сервисов неконсистентен, или версии не сходятся<br>
<br>
##Настройка:
###Параметры запуска:
`version_alerts [-h] [--wait WAIT] [--config CONFIG] [--host HOST] [--port PORT]`
`--wait` - Задержка между проверками (60 секунд)<br>
`--config` - Путь к файлу с конфигом (`config.json`)<br>
`--host` - Адрес, в котором будет отвечать приложение (`[::]`)<br>
`--port` - Порт, на котором будет отвечать unistat (`82`)<br>
`--dashboard` - ID дашборда, на который нужно разместить графики (Not implemented yet)<br>
`--debug` - Включить debug

###config.json
См. `example.config.json`<br>
```{
  "nannyServiceId": {
    "url": "Урл с данными",
    "token_variable": "Переменная окружения, в которой будет лежать OAuth-токен, если ручка его требует (не обязательно)",
    "beta_for": "Сервис, с которым будут дополнительно сравниваться версии (не обязательно)"
  }
}
```
###Переменные окружения
`NANNY_TOKEN` - токен, с которым сервис будет ходить в Nanny. На данный момент он кажется опциональным.<br>
Переменные, описаные в `token_variable`<br>

##Запросы
`GET /unistat` - получить данные<br>
`GET /health` - хелсчек. Возвращает 500 если сборщик не запущен, или последний запрос данных от него стаймаутился.<br>
`DELETE /stop (from ::1)` - стопхук. Завершает работу, можно использовать для перезапуска. 
