from alice.uniproxy.library.messenger.client_locator import guids_by_requests
import pytest


@pytest.mark.parametrize("guids,expected", [
    (["00c", "01b"], [["00c", "01b"]]),

    (["00c", "02b"], [["00c", "02b"]]),

    (['04000000-0000-0000-0000-000000000000', '06000000-0000-0000-0000-000000000000', '08000000-0000-0000-0000-000000000000',
      '0a000000-0000-0000-0000-000000000000', '0c000000-0000-0000-0000-000000000000', '0e000000-0000-0000-0000-000000000000',
      '10000000-0000-0000-0000-000000000000', '12000000-0000-0000-0000-000000000000', '14000000-0000-0000-0000-000000000000',
      '16000000-0000-0000-0000-000000000000', '18000000-0000-0000-0000-000000000000', '1a000000-0000-0000-0000-000000000000',
      '1c000000-0000-0000-0000-000000000000', '1e000000-0000-0000-0000-000000000000', '20000000-0000-0000-0000-000000000000',
      '22000000-0000-0000-0000-000000000000', '24000000-0000-0000-0000-000000000000', '26000000-0000-0000-0000-000000000000',
      '28000000-0000-0000-0000-000000000000', '2a000000-0000-0000-0000-000000000000', '2c000000-0000-0000-0000-000000000000',
      '2e000000-0000-0000-0000-000000000000', '30000000-0000-0000-0000-000000000000', '32000000-0000-0000-0000-000000000000',
      '34000000-0000-0000-0000-000000000000', '36000000-0000-0000-0000-000000000000', '38000000-0000-0000-0000-000000000000',
      '3a000000-0000-0000-0000-000000000000', '3c000000-0000-0000-0000-000000000000', '3e000000-0000-0000-0000-000000000000',
      '40000000-0000-0000-0000-000000000000', '42000000-0000-0000-0000-000000000000', '44000000-0000-0000-0000-000000000000',
      '46000000-0000-0000-0000-000000000000', '48000000-0000-0000-0000-000000000000', '4a000000-0000-0000-0000-000000000000',
      '4c000000-0000-0000-0000-000000000000', '4e000000-0000-0000-0000-000000000000', '50000000-0000-0000-0000-000000000000',
      '52000000-0000-0000-0000-000000000000', '54000000-0000-0000-0000-000000000000', '56000000-0000-0000-0000-000000000000',
      '58000000-0000-0000-0000-000000000000', '5a000000-0000-0000-0000-000000000000', '5c000000-0000-0000-0000-000000000000',
      '5e000000-0000-0000-0000-000000000000', '60000000-0000-0000-0000-000000000000', '62000000-0000-0000-0000-000000000000',
      ],
     [['04000000-0000-0000-0000-000000000000', '06000000-0000-0000-0000-000000000000', '08000000-0000-0000-0000-000000000000',
       '0a000000-0000-0000-0000-000000000000', '0c000000-0000-0000-0000-000000000000', '0e000000-0000-0000-0000-000000000000',
       '10000000-0000-0000-0000-000000000000', '12000000-0000-0000-0000-000000000000', '14000000-0000-0000-0000-000000000000',
       '16000000-0000-0000-0000-000000000000', '18000000-0000-0000-0000-000000000000', '1a000000-0000-0000-0000-000000000000',
       '1c000000-0000-0000-0000-000000000000', '1e000000-0000-0000-0000-000000000000', '20000000-0000-0000-0000-000000000000',
       '22000000-0000-0000-0000-000000000000',
       ],
      ['24000000-0000-0000-0000-000000000000', '26000000-0000-0000-0000-000000000000', '28000000-0000-0000-0000-000000000000',
       '2a000000-0000-0000-0000-000000000000', '2c000000-0000-0000-0000-000000000000', '2e000000-0000-0000-0000-000000000000',
       '30000000-0000-0000-0000-000000000000', '32000000-0000-0000-0000-000000000000', '34000000-0000-0000-0000-000000000000',
       '36000000-0000-0000-0000-000000000000', '38000000-0000-0000-0000-000000000000', '3a000000-0000-0000-0000-000000000000',
       '3c000000-0000-0000-0000-000000000000', '3e000000-0000-0000-0000-000000000000', '40000000-0000-0000-0000-000000000000',
       '42000000-0000-0000-0000-000000000000',
       ],
      ['44000000-0000-0000-0000-000000000000', '46000000-0000-0000-0000-000000000000', '48000000-0000-0000-0000-000000000000', '4a000000-0000-0000-0000-000000000000',
       '4c000000-0000-0000-0000-000000000000', '4e000000-0000-0000-0000-000000000000', '50000000-0000-0000-0000-000000000000',
       '52000000-0000-0000-0000-000000000000', '54000000-0000-0000-0000-000000000000', '56000000-0000-0000-0000-000000000000',
       '58000000-0000-0000-0000-000000000000', '5a000000-0000-0000-0000-000000000000', '5c000000-0000-0000-0000-000000000000',
       '5e000000-0000-0000-0000-000000000000', '60000000-0000-0000-0000-000000000000', '62000000-0000-0000-0000-000000000000',
       ]
      ]
     ),

    (['04000000-0000-0001-0000-000000000000', '04000000-0000-0001-0001-000000000000', '04000000-0000-0001-0002-000000000000', '04000000-0000-0001-0003-000000000000',
      '04000000-0000-0002-0000-000000000000', '04000000-0000-0002-0001-000000000000', '04000000-0000-0002-0002-000000000000', '04000000-0000-0002-0003-000000000000',
      '04000000-0000-0003-0000-000000000000', '04000000-0000-0003-0001-000000000000', '04000000-0000-0003-0002-000000000000', '04000000-0000-0003-0003-000000000000',
      '04000000-0000-0004-0000-000000000000', '04000000-0000-0004-0001-000000000000', '04000000-0000-0004-0002-000000000000', '04000000-0000-0004-0003-000000000000',
      '04000000-0000-0005-0000-000000000000', '04000000-0000-0005-0001-000000000000', '04000000-0000-0005-0002-000000000000', '04000000-0000-0005-0003-000000000000',
      '04000000-0000-0006-0000-000000000000', '04000000-0000-0006-0001-000000000000', '04000000-0000-0006-0002-000000000000', '04000000-0000-0006-0003-000000000000',
      '04000000-0000-0007-0000-000000000000', '04000000-0000-0007-0001-000000000000', '04000000-0000-0007-0002-000000000000', '04000000-0000-0007-0003-000000000000',
      '04000000-0000-0008-0000-000000000000', '04000000-0000-0008-0001-000000000000', '04000000-0000-0008-0002-000000000000', '04000000-0000-0008-0003-000000000000',
      '04000000-0000-0009-0000-000000000000', '04000000-0000-0009-0001-000000000000', '04000000-0000-0009-0002-000000000000', '04000000-0000-0009-0003-000000000000',
      '04000000-0000-0100-0000-000000000000', '04000000-0000-0100-0001-000000000000', '04000000-0000-0100-0002-000000000000', '04000000-0000-0100-0003-000000000000',
      '04000000-0000-0200-0000-000000000000', '04000000-0000-0200-0001-000000000000', '04000000-0000-0200-0002-000000000000', '04000000-0000-0200-0003-000000000000',
      '04000000-0000-0300-0000-000000000000', '04000000-0000-0300-0001-000000000000', '04000000-0000-0300-0002-000000000000', '04000000-0000-0300-0003-000000000000',
      '04000000-0000-0400-0000-000000000000', '04000000-0000-0400-0001-000000000000', '04000000-0000-0400-0002-000000000000', '04000000-0000-0400-0003-000000000000',
      '04000000-0000-0500-0000-000000000000', '04000000-0000-0500-0001-000000000000', '04000000-0000-0500-0002-000000000000', '04000000-0000-0500-0003-000000000000',
      '04000000-0000-0600-0000-000000000000', '04000000-0000-0600-0001-000000000000', '04000000-0000-0600-0002-000000000000', '04000000-0000-0600-0003-000000000000',
      '04000000-0000-0700-0000-000000000000', '04000000-0000-0700-0001-000000000000', '04000000-0000-0700-0002-000000000000', '04000000-0000-0700-0003-000000000000',
      '04000000-0000-0800-0000-000000000000', '04000000-0000-0800-0001-000000000000', '04000000-0000-0800-0002-000000000000', '04000000-0000-0800-0003-000000000000',
      '04000000-0000-0900-0000-000000000000', '04000000-0000-0900-0001-000000000000', '04000000-0000-0900-0002-000000000000', '04000000-0000-0900-0003-000000000000',
      '04000000-0001-0000-0000-000000000000', '04000000-0001-0000-0001-000000000000', '04000000-0001-0000-0002-000000000000', '04000000-0001-0000-0003-000000000000',
      '04000000-0002-0000-0000-000000000000', '04000000-0002-0000-0001-000000000000', '04000000-0002-0000-0002-000000000000', '04000000-0002-0000-0003-000000000000',
      '04000000-0003-0000-0000-000000000000', '04000000-0003-0000-0001-000000000000', '04000000-0003-0000-0002-000000000000', '04000000-0003-0000-0003-000000000000',
      '04000000-0004-0000-0000-000000000000', '04000000-0004-0000-0001-000000000000', '04000000-0004-0000-0002-000000000000', '04000000-0004-0000-0003-000000000000',
      '04000000-0005-0000-0000-000000000000', '04000000-0005-0000-0001-000000000000', '04000000-0005-0000-0002-000000000000', '04000000-0005-0000-0003-000000000000',
      '04000000-0006-0000-0000-000000000000', '04000000-0006-0000-0001-000000000000', '04000000-0006-0000-0002-000000000000', '04000000-0006-0000-0003-000000000000',
      '04000000-0007-0000-0000-000000000000', '04000000-0007-0000-0001-000000000000', '04000000-0007-0000-0002-000000000000', '04000000-0007-0000-0003-000000000000',
      '04000000-0008-0000-0000-000000000000', '04000000-0008-0000-0001-000000000000', '04000000-0008-0000-0002-000000000000', '04000000-0008-0000-0003-000000000000',
      '04000000-0009-0000-0000-000000000000', '04000000-0009-0000-0001-000000000000', '04000000-0009-0000-0002-000000000000', '04000000-0009-0000-0003-000000000000',
      '04000000-0100-0000-0000-000000000000', '04000000-0100-0000-0001-000000000000', '04000000-0100-0000-0002-000000000000', '04000000-0100-0000-0003-000000000000',
      '04000000-0200-0000-0000-000000000000', '04000000-0200-0000-0001-000000000000', '04000000-0200-0000-0002-000000000000', '04000000-0200-0000-0003-000000000000',
      '04000000-0300-0000-0000-000000000000', '04000000-0300-0000-0001-000000000000', '04000000-0300-0000-0002-000000000000', '04000000-0300-0000-0003-000000000000',
      '04000000-0400-0000-0000-000000000000', '04000000-0400-0000-0001-000000000000', '04000000-0400-0000-0002-000000000000', '04000000-0400-0000-0003-000000000000',
      '04000000-0500-0000-0000-000000000000', '04000000-0500-0000-0001-000000000000', '04000000-0500-0000-0002-000000000000', '04000000-0500-0000-0003-000000000000',
      '04000000-0600-0000-0000-000000000000', '04000000-0600-0000-0001-000000000000', '04000000-0600-0000-0002-000000000000', '04000000-0600-0000-0003-000000000000',
      ],
     [['04000000-0000-0001-0000-000000000000', '04000000-0000-0001-0001-000000000000', '04000000-0000-0001-0002-000000000000', '04000000-0000-0001-0003-000000000000',
       '04000000-0000-0002-0000-000000000000', '04000000-0000-0002-0001-000000000000', '04000000-0000-0002-0002-000000000000', '04000000-0000-0002-0003-000000000000',
       '04000000-0000-0003-0000-000000000000', '04000000-0000-0003-0001-000000000000', '04000000-0000-0003-0002-000000000000', '04000000-0000-0003-0003-000000000000',
       '04000000-0000-0004-0000-000000000000', '04000000-0000-0004-0001-000000000000', '04000000-0000-0004-0002-000000000000', '04000000-0000-0004-0003-000000000000',
       '04000000-0000-0005-0000-000000000000', '04000000-0000-0005-0001-000000000000', '04000000-0000-0005-0002-000000000000', '04000000-0000-0005-0003-000000000000',
       '04000000-0000-0006-0000-000000000000', '04000000-0000-0006-0001-000000000000', '04000000-0000-0006-0002-000000000000', '04000000-0000-0006-0003-000000000000',
       '04000000-0000-0007-0000-000000000000', '04000000-0000-0007-0001-000000000000', '04000000-0000-0007-0002-000000000000', '04000000-0000-0007-0003-000000000000',
       '04000000-0000-0008-0000-000000000000', '04000000-0000-0008-0001-000000000000', '04000000-0000-0008-0002-000000000000', '04000000-0000-0008-0003-000000000000',
       '04000000-0000-0009-0000-000000000000', '04000000-0000-0009-0001-000000000000', '04000000-0000-0009-0002-000000000000', '04000000-0000-0009-0003-000000000000',
       '04000000-0000-0100-0000-000000000000', '04000000-0000-0100-0001-000000000000', '04000000-0000-0100-0002-000000000000', '04000000-0000-0100-0003-000000000000',
       '04000000-0000-0200-0000-000000000000', '04000000-0000-0200-0001-000000000000', '04000000-0000-0200-0002-000000000000', '04000000-0000-0200-0003-000000000000',
       '04000000-0000-0300-0000-000000000000', '04000000-0000-0300-0001-000000000000', '04000000-0000-0300-0002-000000000000', '04000000-0000-0300-0003-000000000000',
       '04000000-0000-0400-0000-000000000000', '04000000-0000-0400-0001-000000000000', '04000000-0000-0400-0002-000000000000', '04000000-0000-0400-0003-000000000000',
       '04000000-0000-0500-0000-000000000000', '04000000-0000-0500-0001-000000000000', '04000000-0000-0500-0002-000000000000', '04000000-0000-0500-0003-000000000000',
       '04000000-0000-0600-0000-000000000000', '04000000-0000-0600-0001-000000000000', '04000000-0000-0600-0002-000000000000', '04000000-0000-0600-0003-000000000000',
       '04000000-0000-0700-0000-000000000000', '04000000-0000-0700-0001-000000000000', '04000000-0000-0700-0002-000000000000', '04000000-0000-0700-0003-000000000000',
       '04000000-0000-0800-0000-000000000000', '04000000-0000-0800-0001-000000000000', '04000000-0000-0800-0002-000000000000', '04000000-0000-0800-0003-000000000000',
       '04000000-0000-0900-0000-000000000000', '04000000-0000-0900-0001-000000000000', '04000000-0000-0900-0002-000000000000', '04000000-0000-0900-0003-000000000000',
       '04000000-0001-0000-0000-000000000000', '04000000-0001-0000-0001-000000000000', '04000000-0001-0000-0002-000000000000', '04000000-0001-0000-0003-000000000000',
       '04000000-0002-0000-0000-000000000000', '04000000-0002-0000-0001-000000000000', '04000000-0002-0000-0002-000000000000', '04000000-0002-0000-0003-000000000000',
       '04000000-0003-0000-0000-000000000000', '04000000-0003-0000-0001-000000000000', '04000000-0003-0000-0002-000000000000', '04000000-0003-0000-0003-000000000000',
       '04000000-0004-0000-0000-000000000000', '04000000-0004-0000-0001-000000000000', '04000000-0004-0000-0002-000000000000', '04000000-0004-0000-0003-000000000000',
       '04000000-0005-0000-0000-000000000000', '04000000-0005-0000-0001-000000000000', '04000000-0005-0000-0002-000000000000', '04000000-0005-0000-0003-000000000000',
       '04000000-0006-0000-0000-000000000000', '04000000-0006-0000-0001-000000000000', '04000000-0006-0000-0002-000000000000', '04000000-0006-0000-0003-000000000000',
       '04000000-0007-0000-0000-000000000000', '04000000-0007-0000-0001-000000000000', '04000000-0007-0000-0002-000000000000', '04000000-0007-0000-0003-000000000000',
       '04000000-0008-0000-0000-000000000000', '04000000-0008-0000-0001-000000000000', '04000000-0008-0000-0002-000000000000', '04000000-0008-0000-0003-000000000000',
       '04000000-0009-0000-0000-000000000000', '04000000-0009-0000-0001-000000000000', '04000000-0009-0000-0002-000000000000', '04000000-0009-0000-0003-000000000000',
       '04000000-0100-0000-0000-000000000000', '04000000-0100-0000-0001-000000000000', '04000000-0100-0000-0002-000000000000', '04000000-0100-0000-0003-000000000000',
       '04000000-0200-0000-0000-000000000000', '04000000-0200-0000-0001-000000000000', '04000000-0200-0000-0002-000000000000', '04000000-0200-0000-0003-000000000000',
       '04000000-0300-0000-0000-000000000000', '04000000-0300-0000-0001-000000000000', '04000000-0300-0000-0002-000000000000', '04000000-0300-0000-0003-000000000000',
       '04000000-0400-0000-0000-000000000000', '04000000-0400-0000-0001-000000000000', '04000000-0400-0000-0002-000000000000', '04000000-0400-0000-0003-000000000000',
       '04000000-0500-0000-0000-000000000000', '04000000-0500-0000-0001-000000000000', '04000000-0500-0000-0002-000000000000', '04000000-0500-0000-0003-000000000000',
       '04000000-0600-0000-0000-000000000000', '04000000-0600-0000-0001-000000000000', '04000000-0600-0000-0002-000000000000', '04000000-0600-0000-0003-000000000000',
       ]],
     ),
])
def test_guids_by_requests(guids, expected):
    ret = guids_by_requests(guids)
    for g, eg in zip(ret, expected):
        assert g == eg
