# coding: utf-8
from __future__ import unicode_literals

COMMANDS_TRANSLATIONS = {
    'ru': {
        'accident': 'ДТП',
        'blockers': 'Перекрытие',
        'bridges': 'Разведение мостов',
        'bug_report': 'Отчет об ошибке принят',
        'feedback': 'Ошибка',
        'camera': 'Камера',
        'cameras': 'камеры',
        'cancel': 'Отменяю действие',
        'confirmation': 'Подтверждение принято',
        'dont_understand': 'Извините, непонятно',
        'from': 'от',
        'go': 'Едем',
        'hide': 'Скрыть',
        'in': 'в',
        'left': 'левый ряд',
        'middle': 'средний ряд',
        'nothing': 'Не знаю что и ответить',
        'other': 'Прочее',
        'report_point': 'Поставить точку',
        'right': 'правый ряд',
        'roadevents': 'Дорожные события',
        'roadworks': 'Дорожные работы',
        'route_reset': 'Маршрут сброшен',
        'search': 'Поиск на карте',
        'show': 'Показать',
        'talks': 'Разговорчики',
        'to': 'до',
        'traffic': 'пробки',
        'parking': 'парковки',
        'via': 'через',
        'with_comment': 'с комментарием',
        'noturn': 'Нет поворота',
        'noparking': 'Нет парковки',
        'noentry': 'Нет проезда',
        'parking_route': 'Поиск парковок',
        'show_me': 'Поиск текущего местоположения',
        'route_view': 'Обзор маршрута',
        'do_nothing': 'Игнорирую действие',
    },
    'en': {
        'accident': 'Accident',
        'blockers': 'Closure',
        'bridges': 'Raised bridge',
        'bug_report': 'Feedback accepted',
        'feedback': 'Bug report',
        'camera': 'Speed camera',
        'cameras': 'cameras',
        'cancel': 'canceled',
        'confirmation': 'confirmed',
        'dont_understand': 'Sorry, do not understand',
        'from': 'from',
        'go': 'Go',
        'hide': 'Hide',
        'in': 'in',
        'left': 'left lane',
        'middle': 'middle lane',
        'nothing': 'Nothing to do',
        'other': 'Other',
        'parking': 'parking',
        'report_point': 'Add point',
        'right': 'right lane',
        'roadevents': 'Road events',
        'roadworks': 'Road works',
        'route_reset': 'Route cleared',
        'search': 'Searching on the map',
        'show': 'Show',
        'talks': 'Speech bubble',
        'to': 'to',
        'traffic': 'traffic jams',
        'via': 'via',
        'with_comment': 'with comment',
        'noturn': 'No turn',
        'noparking': 'No parking',
        'noentry': 'No entry',
        'parking_route': 'Parking search',
        'show_me': 'Current location search',
        'route_view': 'Route review',
        'do_nothing': 'Do nothing',
    },
    'uk': {
        'accident': 'ДТП',
        'blockers': 'Перекриття',
        'bridges': 'Розведення мостів',
        'bug_report': 'Звіт про помилку',
        'feedback': 'Помилка',
        'camera': 'Камера',
        'cameras': 'камери',
        'cancel': 'скасовую',
        'confirmation': 'Підтвердження прийнято',
        'dont_understand': 'Извините, не понятно',
        'from': 'від',
        'go': 'Їдемо',
        'hide': 'Приховати',
        'in': 'в',
        'left': 'лівий ряд',
        'middle': 'середній ряд',
        'nothing': 'Вибачте, не зрозуміло',
        'other': 'Інше',
        'parking': 'парковки',
        'report_point': 'Поставити крапку',
        'right': 'правий ряд',
        'roadevents': 'дорожні події',
        'roadworks': 'Дорожні роботи',
        'route_reset': 'маршрут скинутий',
        'search': 'Пошук на карті',
        'show': 'Показати',
        'talks': 'Балачки',
        'to': 'до',
        'traffic': 'затори',
        'via': 'через',
        'with_comment': 'з коментарем',
        'noturn': 'Отсутствие поворота',
        'noparking': 'Отсутствие парковки',
        'noentry': 'Отсутствие проезда',
        'parking_route': 'Поиск парковок',
        'show_me': 'Поиск текущего местоположения',
        'route_view': 'Обзор маршрута',
        'do_nothing': 'Игнорирую действие',
    },
    'tr': {
        'accident': 'Trafik kazası',
        'blockers': 'Trafiğe kapalı',
        'bridges': 'Açılır köprü',
        'bug_report': 'Hata raporu',
        'feedback': 'Hata raporu',
        'camera': 'Hız kamerası',
        'cameras': 'Kameralar',
        'cancel': 'iptal',
        'confirmation': 'Onay kabul',
        'dont_understand': 'Üzgünüm, anlayamadım',
        'from': 'başlangıç noktasından',
        'go': '',  # empty for proper tr string
        'hide': 'gösterme',
        'in': 'çinde',
        'left': 'sol şerit',
        'middle': 'orta şerit',
        'nothing': 'Ben ne yapacağımı bilmiyorum',
        'other': 'Diğer',
        'parking': 'otopark',
        'report_point': 'Yol uyarısı ekle',
        'right': 'sağ şerit',
        'roadevents': 'yol olaylar',
        'roadworks': 'Yol çalışması',
        'route_reset': 'rota temizlenir',
        'search': 'Haritada bul',
        'show': 'Göster',
        'talks': 'İleti',
        'to': 'noktasına rota hesaplanıyor',
        'traffic': 'Trafik durumunu',
        'via': 'varış noktasına git',
        'with_comment': 'yorum',
        'parking_route': 'Park rotası',
        'show_me': 'Geçerli yer araması',
        'route_view': 'Rota incelemesi',
        'do_nothing': 'Do nothing',
    },
    'fr': {
        'accident': 'Accident',  # accrochage, carambolage, panne
        'blockers': 'Fermeture',  # coupure, obstruction, barrière, interdiction, circulation interdite, blocage
        'bridges': 'Fermeture du pont',  # ouverture du pont (разведение/сведение - зависит от логики человека)
        'bug_report': 'signalement de bogue',  # (или bug) enregistré, rapport d'erreur enregistré
        'camera': 'caméra',  # caméra de surveillance routière, système de contrôle vidéo de la circulation routière
        'cameras': 'caméras',  # caméras de surveillance routière, systèmes de contrôle vidéo de la circulation routière
        'cancel': "J'annule l'action",  # action annulée, action invalidée, action supprimée
        'confirmation': 'confirmer',  # confirmation, action confirmée, action acceptée
        'dont_understand': 'Désolé, je ne vous ai pas compris',  # (désolée + comprise для женского.голоса),
        # Veuillez répéter s'il vous plait.
        'from': 'de',  # depuis, de la, de le, du, depuis la, depuis le.
        'go': 'On y va',  # Allons y, go, en route,
        'hide': 'cacher',  # ne pas montrer, ne pas voir, masquer, couvrir, recouvrir
        'in': 'dans',  # dans la, dans le
        'left': 'la voie de gauche',
        'middle': 'la voie du milieu',  # (la) voie centrale
        'nothing': 'Je ne connais pas la réponse',  # je ne peux vous répondre, pas de réponse, pas de résultat
        'other': ' autre',  # autres
        'report_point': 'Placer un point',  # placer un lieu, mettre un point, mettre un lieu
        'right': 'la voie de droite',
        'roadevents': 'Un incident routier',  # un événement routier (sur la route)
        'roadworks': 'Travaux sur la chaussée',  # (sur la voie, sur la route, sur le chemin...), travaux de maintenance
        'route_reset': "L'itinéraire est annulé",  # Itinéraire annulé, annulation de l'itinéraire,
        # itinéraire supprimé, suppression de l'itinéraire
        'search': 'chercher sur la carte',  # rechercher sur la carte, trouver sur la carte, parcourir la carte
        'show': 'Montrer',  # exposer, afficher
        'talks': 'Discussions',  # chats, échanges
        'to': 'à',  # vers, jusqu'à
        'traffic': 'trafic',  # bouchons, circulation
        'parking': 'parking',  # stationnement, garage
        'via': 'par',  # via,
        'with_comment': 'avec un commentaire',  # avec une suggestion, avec une explication,
        'parking_route': 'Recherche de stationnement',
        'show_me': 'Recherche de localisation actuelle',
        'route_view': 'Examen de la route',
        'do_nothing': 'Do nothing',
        # commenter, suggérer, expliquer
    },
    'he': {
        'accident': 'תאונה',
        'blockers': 'חסימות',
        'bridges': 'גשר מורם',
        'bug_report': 'משוב התקבל',
        'feedback': 'דוח תקלות',
        'camera': 'מצלמת מהירות',
        'cameras': 'מצלמות',
        'cancel': 'ביטול',
        'confirmation': 'אישור',
        'dont_understand': 'סליחה, אני לא מבין ו',
        'from': 'מאת',
        'go': 'צא',
        'hide': 'הסתר',
        'in': 'בעוד',
        'left': 'נתיב שמאלי',
        'middle': 'נתיב אמצעי',
        'nothing': 'אין מה לעשות',
        'other': 'אחר',
        'parking': 'חנייה',
        'report_point': 'הוספת נקודה',
        'right': 'נתיב ימני',
        'roadevents': 'אירועיםבכביש',
        'roadworks': 'עבודותבכביש',
        'route_reset': 'איפוס נתיב',
        'search': 'מחפש על המפה',
        'show': 'הצג',
        'talks': 'בועת מלל',
        'to': 'יעד',
        'traffic': 'עומסי תנועה',
        'via': 'דרך',
        'with_comment': 'עם הערה',
        'noturn': 'איןפנייה',
        'noparking': 'איןחנייה',
        'noentry': 'איןכניסה',
        'parking_route': 'חיפוש חנייה',
        'show_me': 'חיפוש במיקום נוכחי',
        'route_view': 'תצוגת מסלול',
        'do_nothing': 'התעלם',
    }
}

FAV_SYNONYMS = {
    'ru': {
        'дом': {'домой', 'home', 'дома'},
        'работа': {'work', 'работу', 'на работу', 'на работа'},
    },
    'tr': {
        'iş': {'işyeri', 'iş', 'işe'},
        'ev': {'eve'}
    },
    'uk': {
        'дом': {'домой', 'home', 'хата', 'додому', 'будинки'},
        'работа': {'work' 'работу', 'на работу', 'на работа'},
    },
    'en': {
    },
    'fr': {
    }
}

FAV_PLACES = {
    'ru': {
        'home': 'дом',
        'work': 'работа',
    },
    'en': {
        'home': 'home',
        'work': 'work',
    },
    'uk': {
        'home': 'дом',
        'work': 'работа',
    },
    'tr': {
        'home': 'ev',
        'work': 'iş',
    },
    'fr': {
        'home': 'maison',
        'work': 'travail',
    },
}
