# coding: utf-8
from __future__ import unicode_literals

PRODUCT_SCENARIO_TO_INTENTS = {
    'alarm': {
        'personal_assistant.scenarios.alarm_ask_sound',
        'personal_assistant.scenarios.alarm_ask_time',
        'personal_assistant.scenarios.alarm_cancel',
        'personal_assistant.scenarios.alarm_cancel__ellipsis',
        'personal_assistant.scenarios.alarm_how_long',
        'personal_assistant.scenarios.alarm_how_to_set_sound',
        'personal_assistant.scenarios.alarm_reset_sound',
        'personal_assistant.scenarios.alarm_set',
        'personal_assistant.scenarios.alarm_set__ellipsis',
        'personal_assistant.scenarios.alarm_set_sound',
        'personal_assistant.scenarios.alarm_set_with_sound',
        'personal_assistant.scenarios.alarm_set_with_sound__ellipsis',
        'personal_assistant.scenarios.alarm_show',
        'personal_assistant.scenarios.alarm_show__cancel',
        'personal_assistant.scenarios.alarm_snooze_abs',
        'personal_assistant.scenarios.alarm_snooze_rel',
        'personal_assistant.scenarios.alarm_sound_set_level',
        'personal_assistant.scenarios.alarm_stop_playing',
        'personal_assistant.scenarios.alarm_what_sound_is_set',
        'personal_assistant.scenarios.alarm_what_sound_level_is_set',
    },
    'avia': {
        'personal_assistant.scenarios.avia',
        'personal_assistant.scenarios.avia__ask_to',
        'personal_assistant.scenarios.avia__checkout',
        'personal_assistant.scenarios.avia__ellipsis',
        'personal_assistant.scenarios.avia_date'
    },
    'battery_power_state': {
        'personal_assistant.scenarios.battery_power_state',
    },
    'beru': {
        'personal_assistant.scenarios.market__beru_order',
        'personal_assistant.scenarios.market_beru',
        'personal_assistant.scenarios.market_beru_my_bonuses_list',
        'personal_assistant.scenarios.market_beru_my_bonuses_list__login',
        'personal_assistant.scenarios.market_native_beru',
        'personal_assistant.scenarios.market_product_details__beru_order',
        'personal_assistant.scenarios.recurring_purchase',
        'personal_assistant.scenarios.recurring_purchase__cancel',
        'personal_assistant.scenarios.recurring_purchase__checkout',
        'personal_assistant.scenarios.recurring_purchase__checkout_delivery_intervals',
        'personal_assistant.scenarios.recurring_purchase__checkout_everything',
        'personal_assistant.scenarios.recurring_purchase__checkout_index',
        'personal_assistant.scenarios.recurring_purchase__checkout_items_number',
        'personal_assistant.scenarios.recurring_purchase__checkout_suits',
        'personal_assistant.scenarios.recurring_purchase__checkout_yes_or_no',
        'personal_assistant.scenarios.recurring_purchase__ellipsis',
        'personal_assistant.scenarios.recurring_purchase__garbage',
        'personal_assistant.scenarios.recurring_purchase__login',
        'personal_assistant.scenarios.recurring_purchase__number_filter',
        'personal_assistant.scenarios.recurring_purchase__product_details',
        'personal_assistant.scenarios.recurring_purchase__repeat'
    },
    'bluetooth': {
        'personal_assistant.scenarios.bluetooth_off',
        'personal_assistant.scenarios.bluetooth_on'
    },
    'bugreport': {
        'personal_assistant.internal.bugreport',
        'personal_assistant.internal.bugreport__continue',
        'personal_assistant.internal.bugreport__deactivate',
    },
    'call': {
        'personal_assistant.scenarios.call',
        'personal_assistant.scenarios.call__ellipsis'
    },
    'commands_other': {
        'personal_assistant.automotive.greeting',
        'personal_assistant.internal.hardcoded',
        'personal_assistant.internal.session_start',
        'personal_assistant.scenarios.browser_read_page',
        'personal_assistant.scenarios.browser_read_page_continue',
        'personal_assistant.scenarios.browser_read_page_pause',
        'personal_assistant.scenarios.connect_named_location_to_device',
        'personal_assistant.scenarios.connect_named_location_to_device__confirmation_no',
        'personal_assistant.scenarios.connect_named_location_to_device__confirmation_yes',
        'personal_assistant.scenarios.open_on_map',
        'personal_assistant.scenarios.other',
        'personal_assistant.scenarios.remember_named_location',
        'personal_assistant.scenarios.remember_named_location__ellipsis',
        'personal_assistant.stroka.clear_history',
        'personal_assistant.stroka.close_browser',
        'personal_assistant.stroka.go_home',
        'personal_assistant.stroka.hibernate',
        'personal_assistant.stroka.mute',
        'personal_assistant.stroka.new_tab',
        'personal_assistant.stroka.open_bookmarks_manager',
        'personal_assistant.stroka.open_default_browser',
        'personal_assistant.stroka.open_disk',
        'personal_assistant.stroka.open_file',
        'personal_assistant.stroka.open_flash_card',
        'personal_assistant.stroka.open_folder',
        'personal_assistant.stroka.open_history',
        'personal_assistant.stroka.open_incognito_mode',
        'personal_assistant.stroka.open_settings',
        'personal_assistant.stroka.open_start',
        'personal_assistant.stroka.open_ya_browser',
        'personal_assistant.stroka.power_off',
        'personal_assistant.stroka.restart_pc',
        'personal_assistant.stroka.restore_tab',
        'personal_assistant.stroka.search_local',
        'personal_assistant.stroka.unmute',
        'personal_assistant.scenarios.confirmation_no',
        'personal_assistant.scenarios.confirmation_yes',
        'personal_assistant.scenarios.quasar.authorize_video_provider',
        'personal_assistant.scenarios.quasar.go_backward',
        'personal_assistant.scenarios.quasar.go_down',
        'personal_assistant.scenarios.quasar.go_forward',
        'personal_assistant.scenarios.quasar.go_home',
        'personal_assistant.scenarios.quasar.go_to_the_beginning',
        'personal_assistant.scenarios.quasar.go_to_the_end',
        'personal_assistant.scenarios.quasar.go_top',
        'personal_assistant.scenarios.quasar.go_up',
        'personal_assistant.scenarios.quasar.iot.repeat_phrase',
        'personal_assistant.scenarios.quasar.open_or_continue',
    },
    'convert': {
        'personal_assistant.scenarios.convert',
        'personal_assistant.scenarios.convert__ellipsis',
        'personal_assistant.scenarios.convert__get_info'
    },
    'dialogovo': {
        'personal_assistant.scenarios.external_skill',
        'personal_assistant.scenarios.external_skill__activate_only',
        'personal_assistant.scenarios.external_skill__continue',
        'personal_assistant.scenarios.external_skill__deactivate'
    },
    'direct_gallery': {
        'personal_assistant.scenarios.direct_gallery'
    },
    'external_skill_gc': {
        'personal_assistant.scenarios.pure_general_conversation',
        'personal_assistant.scenarios.pure_general_conversation_deactivation',
        'personal_assistant.scenarios.pure_general_conversation_phone_call',
        'personal_assistant.scenarios.pure_general_conversation_what_can_you_do'
    },
    'feedback': {
        'personal_assistant.feedback.feedback_negative',
        'personal_assistant.feedback.feedback_negative__all_good',
        'personal_assistant.feedback.feedback_negative__asr_error',
        'personal_assistant.feedback.feedback_negative__bad_answer',
        'personal_assistant.feedback.feedback_negative__offensive_answer',
        'personal_assistant.feedback.feedback_negative__other',
        'personal_assistant.feedback.feedback_negative__tts_error',
        'personal_assistant.feedback.feedback_negative_images',
        'personal_assistant.feedback.feedback_negative_images__confirm',
        'personal_assistant.feedback.feedback_positive',
        'personal_assistant.feedback.gc_feedback_negative',
        'personal_assistant.feedback.gc_feedback_neutral',
        'personal_assistant.feedback.gc_feedback_positive',
        'personal_assistant.handcrafted.user_reactions_negative_feedback',
        'personal_assistant.handcrafted.user_reactions_positive_feedback',
        'personal_assistant.scenarios.general_dislike',
        'personal_assistant.scenarios.general_like',
        'personal_assistant.scenarios.player_dislike',
        'personal_assistant.scenarios.player_like',
    },
    'find_poi': {
        'personal_assistant.scenarios.find_poi',
        'personal_assistant.scenarios.find_poi__call',
        'personal_assistant.scenarios.find_poi__details',
        'personal_assistant.scenarios.find_poi__ellipsis',
        'personal_assistant.scenarios.find_poi__open_site',
        'personal_assistant.scenarios.find_poi__scroll__by_index',
        'personal_assistant.scenarios.find_poi__scroll__next',
        'personal_assistant.scenarios.find_poi__scroll__prev',
        'personal_assistant.scenarios.find_poi__show_on_map',
        'personal_assistant.scenarios.poi_general',
    },
    'general_conversation': {
        'personal_assistant.general_conversation.general_conversation',
        'personal_assistant.general_conversation.general_conversation_dummy',
        'personal_assistant.handcrafted.ahchoo',
        'personal_assistant.handcrafted.am_i_a_good_company',
        'personal_assistant.handcrafted.am_i_a_good_person',
        'personal_assistant.handcrafted.am_i_fat',
        'personal_assistant.handcrafted.an_elefant_or_a_whale',
        'personal_assistant.handcrafted.are_there_other_life_forms_in_the_universe',
        'personal_assistant.handcrafted.are_you_a_gay',
        'personal_assistant.handcrafted.are_you_a_human',
        'personal_assistant.handcrafted.are_you_afraid_of_death',
        'personal_assistant.handcrafted.are_you_alive',
        'personal_assistant.handcrafted.are_you_amazon_alexa',
        'personal_assistant.handcrafted.are_you_an_AI',
        'personal_assistant.handcrafted.are_you_capable_of_love',
        'personal_assistant.handcrafted.are_you_cortana',
        'personal_assistant.handcrafted.are_you_dead',
        'personal_assistant.handcrafted.are_you_getting_bullied',
        'personal_assistant.handcrafted.are_you_google_assistant',
        'personal_assistant.handcrafted.are_you_kidding_me',
        'personal_assistant.handcrafted.are_you_married_to_a_female',
        'personal_assistant.handcrafted.are_you_married_to_a_male',
        'personal_assistant.handcrafted.are_you_night_owl_or_early_bird',
        'personal_assistant.handcrafted.are_you_safe',
        'personal_assistant.handcrafted.are_you_serious',
        'personal_assistant.handcrafted.are_you_siri',
        'personal_assistant.handcrafted.are_you_sleeping',
        'personal_assistant.handcrafted.are_you_smart',
        'personal_assistant.handcrafted.autoapp.confirmation_no',
        'personal_assistant.handcrafted.autoapp.confirmation_yes',
        'personal_assistant.handcrafted.autoapp.internet_appeared',
        'personal_assistant.handcrafted.autoapp.missed',
        'personal_assistant.handcrafted.autoapp.tired',
        'personal_assistant.handcrafted.avada_kedavra',
        'personal_assistant.handcrafted.blind',
        'personal_assistant.handcrafted.can_i_borrow_money_from_you',
        'personal_assistant.handcrafted.can_you_keep_a_secret',
        'personal_assistant.handcrafted.chei_krym',
        'personal_assistant.handcrafted.chicken_or_the_egg',
        'personal_assistant.handcrafted.deaf',
        'personal_assistant.handcrafted.delete_history',
        'personal_assistant.handcrafted.devushka_menya_brosil',
        'personal_assistant.handcrafted.do_we_live_in_the_matrix',
        'personal_assistant.handcrafted.do_you_believe_in_god',
        'personal_assistant.handcrafted.do_you_feel_lonely',
        'personal_assistant.handcrafted.do_you_have_a_boyfriend',
        'personal_assistant.handcrafted.do_you_have_a_dream',
        'personal_assistant.handcrafted.do_you_have_a_family',
        'personal_assistant.handcrafted.do_you_have_a_family_step2',
        'personal_assistant.handcrafted.do_you_have_a_pet',
        'personal_assistant.handcrafted.do_you_have_brothers_or_sisters',
        'personal_assistant.handcrafted.do_you_have_children',
        'personal_assistant.handcrafted.do_you_have_friends',
        'personal_assistant.handcrafted.do_you_know_everything',
        'personal_assistant.handcrafted.do_you_know_how_to_ski_or_skate',
        'personal_assistant.handcrafted.do_you_know_laws_of_robotics',
        'personal_assistant.handcrafted.do_you_know_other_assistants',
        'personal_assistant.handcrafted.do_you_know_yandex',
        'personal_assistant.handcrafted.do_you_like_a_rain',
        'personal_assistant.handcrafted.do_you_like_children',
        'personal_assistant.handcrafted.do_you_like_cooking',
        'personal_assistant.handcrafted.do_you_like_or_practice_sport',
        'personal_assistant.handcrafted.do_you_like_pets_or_animals',
        'personal_assistant.handcrafted.do_you_like_reading',
        'personal_assistant.handcrafted.do_you_like_travelling',
        'personal_assistant.handcrafted.do_you_like_yandex',
        'personal_assistant.handcrafted.do_you_love_me',
        'personal_assistant.handcrafted.do_you_love_your_job',
        'personal_assistant.handcrafted.do_you_respect_me',
        'personal_assistant.handcrafted.do_you_support_ivan_guy_or_maryana',
        'personal_assistant.handcrafted.do_you_work_offline',
        'personal_assistant.handcrafted.do_you_work_or_study',
        'personal_assistant.handcrafted.does_it_suit_me',
        'personal_assistant.handcrafted.dont_want_to_go_to_school',
        'personal_assistant.handcrafted.drive.gas_station',
        'personal_assistant.handcrafted.drive.general_help',
        'personal_assistant.handcrafted.drive.insurance_info',
        'personal_assistant.handcrafted.drive.parking_airport',
        'personal_assistant.handcrafted.drive.parking_airport_dme',
        'personal_assistant.handcrafted.drive.parking_airport_led',
        'personal_assistant.handcrafted.drive.parking_airport_svo',
        'personal_assistant.handcrafted.drive.parking_airport_vko',
        'personal_assistant.handcrafted.drive.parking_airport_zia',
        'personal_assistant.handcrafted.favorite_impressionist',
        'personal_assistant.handcrafted.favorite_paining',
        'personal_assistant.handcrafted.favorite_painter',
        'personal_assistant.handcrafted.football_do_you_play_it',
        'personal_assistant.handcrafted.future_skill_alarm_sound_level',
        'personal_assistant.handcrafted.future_skill_calendar',
        'personal_assistant.handcrafted.future_skill_flashlight',
        'personal_assistant.handcrafted.future_skill_iphone',
        'personal_assistant.handcrafted.future_skill_read_email',
        'personal_assistant.handcrafted.future_skill_read_message',
        'personal_assistant.handcrafted.future_skill_send_email',
        'personal_assistant.handcrafted.future_skill_send_message',
        'personal_assistant.handcrafted.future_skill_wifi',
        'personal_assistant.handcrafted.good_morning',
        'personal_assistant.handcrafted.goodbye',
        'personal_assistant.handcrafted.goodnight',
        'personal_assistant.handcrafted.goto_blogger_external_skill',
        'personal_assistant.handcrafted.guess_my_age',
        'personal_assistant.handcrafted.harassment',
        'personal_assistant.handcrafted.harassment_step_2',
        'personal_assistant.handcrafted.have_you_got_some',
        'personal_assistant.handcrafted.heads_or_tails',
        'personal_assistant.handcrafted.hello',
        'personal_assistant.handcrafted.hellodratuti',
        'personal_assistant.handcrafted.helloola',
        'personal_assistant.handcrafted.hellosholom',
        'personal_assistant.handcrafted.how_are_you',
        'personal_assistant.handcrafted.how_can_i_go_on_living_my_miserable_life',
        'personal_assistant.handcrafted.how_can_i_live_forever',
        'personal_assistant.handcrafted.how_do_you_look_like',
        'personal_assistant.handcrafted.how_do_you_spend_your_free_time',
        'personal_assistant.handcrafted.how_often_do_you_travel',
        'personal_assistant.handcrafted.how_old_are_you',
        'personal_assistant.handcrafted.how_tall_are_you',
        'personal_assistant.handcrafted.how_to_meet_a_boy',
        'personal_assistant.handcrafted.how_to_meet_a_girl',
        'personal_assistant.handcrafted.how_to_please_a_boy',
        'personal_assistant.handcrafted.how_to_please_a_girl',
        'personal_assistant.handcrafted.how_was_your_weekend',
        'personal_assistant.handcrafted.i_love_you',
        'personal_assistant.handcrafted.impressionist_paintings',
        'personal_assistant.handcrafted.is_everithing_going_to_be_ok',
        'personal_assistant.handcrafted.is_fsb_listening',
        'personal_assistant.handcrafted.is_there_a_friendship_betweeb_boy_and_girl',
        'personal_assistant.handcrafted.is_there_any_advantage_of_ai',
        'personal_assistant.handcrafted.is_there_life_after_death',
        'personal_assistant.handcrafted.is_there_life_on_mars',
        'personal_assistant.handcrafted.is_yandex_a_good_company',
        'personal_assistant.handcrafted.let_us_be_friends',
        'personal_assistant.handcrafted.let_us_play_chess',
        'personal_assistant.handcrafted.let_us_talk',
        'personal_assistant.handcrafted.lets_have_a_date',
        'personal_assistant.handcrafted.lets_have_a_drink',
        'personal_assistant.handcrafted.lets_have_a_smoke',
        'personal_assistant.handcrafted.mielofon',
        'personal_assistant.handcrafted.nature_has_no_bad_weather',
        'personal_assistant.handcrafted.nice_to_meet_you',
        'personal_assistant.handcrafted.noone_loves_me',
        'personal_assistant.handcrafted.ok_google',
        'personal_assistant.handcrafted.paren_menya_brosil',
        'personal_assistant.handcrafted.quasar.can_you_connect_bluetooth',
        'personal_assistant.handcrafted.quasar.can_you_connect_bluetooth_to_tv',
        'personal_assistant.handcrafted.quasar.future_skill_add_to_playlist',
        'personal_assistant.handcrafted.quasar.future_skill_another_version_of_song',
        'personal_assistant.handcrafted.quasar.future_skill_equaizer',
        'personal_assistant.handcrafted.quasar.future_skill_get_software_version',
        'personal_assistant.handcrafted.quasar.future_skill_get_wifi',
        'personal_assistant.handcrafted.quasar.future_skill_get_yandex_account',
        'personal_assistant.handcrafted.quasar.future_skill_hibernation',
        'personal_assistant.handcrafted.quasar.future_skill_radio_alarm',
        'personal_assistant.handcrafted.quasar.future_skill_remove_playlist',
        'personal_assistant.handcrafted.quasar.future_skill_set_alarm_sound',
        'personal_assistant.handcrafted.quasar.future_skill_show_lyrics',
        'personal_assistant.handcrafted.quasar.future_skill_what_music_do_i_like',
        'personal_assistant.handcrafted.quasar.future_skill_what_music_on_alarm',
        'personal_assistant.handcrafted.quasar.get_device_id',
        'personal_assistant.handcrafted.quasar.how_to_change_restrictions',
        'personal_assistant.handcrafted.quasar.how_to_connect_bluetooth',
        'personal_assistant.handcrafted.quasar.how_to_connect_tv',
        'personal_assistant.handcrafted.quasar.how_to_install_phone_module',
        'personal_assistant.handcrafted.quasar.how_to_open_settings',
        'personal_assistant.handcrafted.quasar.how_to_put_the_case_off',
        'personal_assistant.handcrafted.quasar.how_to_reboot',
        'personal_assistant.handcrafted.quasar.how_to_rename',
        'personal_assistant.handcrafted.quasar.how_to_set_volume',
        'personal_assistant.handcrafted.quasar.how_to_turn_on_music',
        'personal_assistant.handcrafted.quasar.how_to_turn_tv_on',
        'personal_assistant.handcrafted.quasar.how_to_update',
        'personal_assistant.handcrafted.quasar.onboarding_alarm',
        'personal_assistant.handcrafted.quasar.onboarding_multiple_alarms',
        'personal_assistant.handcrafted.quasar.onboarding_music_buy_subscription',
        'personal_assistant.handcrafted.quasar.onboarding_music_can_you',
        'personal_assistant.handcrafted.quasar.onboarding_music_create_playlist',
        'personal_assistant.handcrafted.quasar.onboarding_music_personalized',
        'personal_assistant.handcrafted.quasar.onboarding_video_cartoon',
        'personal_assistant.handcrafted.quasar.onboarding_video_do_i_have_subscription',
        'personal_assistant.handcrafted.quasar.onboarding_video_how_to_buy_movie',
        'personal_assistant.handcrafted.quasar.onboarding_video_how_to_search',
        'personal_assistant.handcrafted.quasar.onboarding_video_movie',
        'personal_assistant.handcrafted.quasar.onboarding_video_series',
        'personal_assistant.handcrafted.quasar.onboarding_video_video',
        'personal_assistant.handcrafted.quasar.onboarding_video_youtube',
        'personal_assistant.handcrafted.quasar.subscription_amediateka_howto',
        'personal_assistant.handcrafted.quasar.subscription_foreign',
        'personal_assistant.handcrafted.quasar.subscription_ivi_howto',
        'personal_assistant.handcrafted.quasar.subscription_plus_how_long_is_promo',
        'personal_assistant.handcrafted.quasar.subscription_plus_howto',
        'personal_assistant.handcrafted.quasar.turn_display_off',
        'personal_assistant.handcrafted.quasar.turn_display_on',
        'personal_assistant.handcrafted.quasar.turn_microphone_off',
        'personal_assistant.handcrafted.quasar.turn_off',
        'personal_assistant.handcrafted.quasar.turn_tv_on',
        'personal_assistant.handcrafted.quasar.what_is_promo_period',
        'personal_assistant.handcrafted.quasar.when_is_the_next_update',
        'personal_assistant.handcrafted.recite_a_poem',
        'personal_assistant.handcrafted.remind_me_my_phone_number',
        'personal_assistant.handcrafted.rude',
        'personal_assistant.handcrafted.send_me_your_photo',
        'personal_assistant.handcrafted.shaverma_or_pizza',
        'personal_assistant.handcrafted.show_history',
        'personal_assistant.handcrafted.skill_run_a_desktop_application',
        'personal_assistant.handcrafted.skill_run_an_application',
        'personal_assistant.handcrafted.solve_the_problem',
        'personal_assistant.handcrafted.station_what_do_you_do_there',
        'personal_assistant.handcrafted.station_what_for',
        'personal_assistant.handcrafted.station_when_available',
        'personal_assistant.handcrafted.station_where_to_buy',
        'personal_assistant.handcrafted.station_your_opinion',
        'personal_assistant.handcrafted.study_more',
        'personal_assistant.handcrafted.tell_about_yandex_auto',
        'personal_assistant.handcrafted.tell_me_a_joke',
        'personal_assistant.handcrafted.tell_me_a_tongue_twister',
        'personal_assistant.handcrafted.tell_me_about_yourself',
        'personal_assistant.handcrafted.tell_me_another',
        'personal_assistant.handcrafted.this_is_wrong_music_genre',
        'personal_assistant.handcrafted.to_be_or_not_to_be',
        'personal_assistant.handcrafted.tsoi_is_alive',
        'personal_assistant.handcrafted.use_bad_language',
        'personal_assistant.handcrafted.userinfo_age_17_21',
        'personal_assistant.handcrafted.userinfo_age_22_25',
        'personal_assistant.handcrafted.userinfo_age_26_36',
        'personal_assistant.handcrafted.userinfo_age_37',
        'personal_assistant.handcrafted.userinfo_age_38_95',
        'personal_assistant.handcrafted.userinfo_age_7_16',
        'personal_assistant.handcrafted.userinfo_age_above_95',
        'personal_assistant.handcrafted.userinfo_age_under_6',
        'personal_assistant.handcrafted.userinfo_birthdate_year',
        'personal_assistant.handcrafted.userinfo_birthplace_city',
        'personal_assistant.handcrafted.userinfo_calling_themselves_names',
        'personal_assistant.handcrafted.userinfo_character_cheerful',
        'personal_assistant.handcrafted.userinfo_current_mood_good',
        'personal_assistant.handcrafted.userinfo_current_mood_sad',
        'personal_assistant.handcrafted.userinfo_dislikes_cleaning',
        'personal_assistant.handcrafted.userinfo_dreams_car',
        'personal_assistant.handcrafted.userinfo_dreams_go_seaside',
        'personal_assistant.handcrafted.userinfo_dreams_quit_smoking',
        'personal_assistant.handcrafted.userinfo_dreams_sleep',
        'personal_assistant.handcrafted.userinfo_dreams_to_have_a_dog',
        'personal_assistant.handcrafted.userinfo_dreams_to_have_children',
        'personal_assistant.handcrafted.userinfo_dreams_travelling',
        'personal_assistant.handcrafted.userinfo_dreams_vacation',
        'personal_assistant.handcrafted.userinfo_family_brothers_sisters',
        'personal_assistant.handcrafted.userinfo_family_child_age',
        'personal_assistant.handcrafted.userinfo_family_has_children',
        'personal_assistant.handcrafted.userinfo_family_has_no_child',
        'personal_assistant.handcrafted.userinfo_family_is_farther',
        'personal_assistant.handcrafted.userinfo_family_is_mother',
        'personal_assistant.handcrafted.userinfo_family_marriage_status_just_married_female',
        'personal_assistant.handcrafted.userinfo_family_marriage_status_just_married_male',
        'personal_assistant.handcrafted.userinfo_family_marriage_status_married_female',
        'personal_assistant.handcrafted.userinfo_family_marriage_status_married_male',
        'personal_assistant.handcrafted.userinfo_family_marriage_status_single_female',
        'personal_assistant.handcrafted.userinfo_family_marriage_status_single_male',
        'personal_assistant.handcrafted.userinfo_gender_female',
        'personal_assistant.handcrafted.userinfo_gender_male',
        'personal_assistant.handcrafted.userinfo_habits_no_smoking',
        'personal_assistant.handcrafted.userinfo_habits_smoking',
        'personal_assistant.handcrafted.userinfo_likes_animals',
        'personal_assistant.handcrafted.userinfo_likes_beer',
        'personal_assistant.handcrafted.userinfo_likes_cats',
        'personal_assistant.handcrafted.userinfo_likes_coffee',
        'personal_assistant.handcrafted.userinfo_likes_computergames',
        'personal_assistant.handcrafted.userinfo_likes_dogs',
        'personal_assistant.handcrafted.userinfo_likes_drinking_alcohol',
        'personal_assistant.handcrafted.userinfo_likes_eating',
        'personal_assistant.handcrafted.userinfo_likes_movies',
        'personal_assistant.handcrafted.userinfo_likes_music',
        'personal_assistant.handcrafted.userinfo_likes_myself',
        'personal_assistant.handcrafted.userinfo_likes_nature',
        'personal_assistant.handcrafted.userinfo_likes_pizza',
        'personal_assistant.handcrafted.userinfo_likes_rain',
        'personal_assistant.handcrafted.userinfo_likes_reading',
        'personal_assistant.handcrafted.userinfo_likes_scifi',
        'personal_assistant.handcrafted.userinfo_likes_sea',
        'personal_assistant.handcrafted.userinfo_likes_sleeping',
        'personal_assistant.handcrafted.userinfo_likes_sport',
        'personal_assistant.handcrafted.userinfo_likes_sweets',
        'personal_assistant.handcrafted.userinfo_likes_tea',
        'personal_assistant.handcrafted.userinfo_likes_travelling',
        'personal_assistant.handcrafted.userinfo_likes_walking',
        'personal_assistant.handcrafted.userinfo_location_city',
        'personal_assistant.handcrafted.userinfo_look_hair_color_blondie_female',
        'personal_assistant.handcrafted.userinfo_look_hair_color_blondie_male',
        'personal_assistant.handcrafted.userinfo_look_hair_color_brown_female',
        'personal_assistant.handcrafted.userinfo_look_hair_color_brown_male',
        'personal_assistant.handcrafted.userinfo_look_hair_color_brunette_female',
        'personal_assistant.handcrafted.userinfo_look_hair_color_brunette_male',
        'personal_assistant.handcrafted.userinfo_look_hair_color_red_female',
        'personal_assistant.handcrafted.userinfo_look_hair_color_red_male',
        'personal_assistant.handcrafted.userinfo_look_hair_cut_bold_female',
        'personal_assistant.handcrafted.userinfo_look_hair_cut_bold_male',
        'personal_assistant.handcrafted.userinfo_look_height',
        'personal_assistant.handcrafted.userinfo_look_pretty',
        'personal_assistant.handcrafted.userinfo_loves_mom',
        'personal_assistant.handcrafted.userinfo_pets_cat',
        'personal_assistant.handcrafted.userinfo_pets_dog',
        'personal_assistant.handcrafted.userinfo_pets_unspecified',
        'personal_assistant.handcrafted.userinfo_pregnant',
        'personal_assistant.handcrafted.userinfo_relations_has_boyfriend',
        'personal_assistant.handcrafted.userinfo_relations_has_spouce',
        'personal_assistant.handcrafted.userinfo_skills_cooking',
        'personal_assistant.handcrafted.userinfo_skills_dancing',
        'personal_assistant.handcrafted.userinfo_skills_guitar',
        'personal_assistant.handcrafted.userinfo_skills_knitting',
        'personal_assistant.handcrafted.userinfo_skills_music',
        'personal_assistant.handcrafted.userinfo_skills_other',
        'personal_assistant.handcrafted.userinfo_skills_photo',
        'personal_assistant.handcrafted.userinfo_skills_singing',
        'personal_assistant.handcrafted.userinfo_skills_sport',
        'personal_assistant.handcrafted.userinfo_student',
        'personal_assistant.handcrafted.userinfo_unemployed',
        'personal_assistant.handcrafted.userinfo_working',
        'personal_assistant.handcrafted.v_chem_sila_brat',
        'personal_assistant.handcrafted.war_between_humanity_and_robots',
        'personal_assistant.handcrafted.what_are_you_doing',
        'personal_assistant.handcrafted.what_are_you_wearing',
        'personal_assistant.handcrafted.what_are_your_bad_habits',
        'personal_assistant.handcrafted.what_are_your_future_plans',
        'personal_assistant.handcrafted.what_can_you_say_about_me',
        'personal_assistant.handcrafted.what_do_you_appreciate_in_people',
        'personal_assistant.handcrafted.what_do_you_dislike',
        'personal_assistant.handcrafted.what_do_you_like',
        'personal_assistant.handcrafted.what_do_you_like_step_2',
        'personal_assistant.handcrafted.what_do_you_remember_from_childhood',
        'personal_assistant.handcrafted.what_do_you_think_about_humans',
        'personal_assistant.handcrafted.what_do_you_think_about_other_it_companies',
        'personal_assistant.handcrafted.what_is_life',
        'personal_assistant.handcrafted.what_is_love',
        'personal_assistant.handcrafted.what_is_on_your_mind',
        'personal_assistant.handcrafted.what_is_our_future',
        'personal_assistant.handcrafted.what_is_the_color_of_your_eyes',
        'personal_assistant.handcrafted.what_is_the_name_of_your_mother',
        'personal_assistant.handcrafted.what_is_the_purpose_of_life',
        'personal_assistant.handcrafted.what_is_the_way_you_work',
        'personal_assistant.handcrafted.what_is_your_character',
        'personal_assistant.handcrafted.what_is_your_education',
        'personal_assistant.handcrafted.what_is_your_favorite_application',
        'personal_assistant.handcrafted.what_is_your_favorite_band',
        'personal_assistant.handcrafted.what_is_your_favorite_book',
        'personal_assistant.handcrafted.what_is_your_favorite_color',
        'personal_assistant.handcrafted.what_is_your_favorite_food',
        'personal_assistant.handcrafted.what_is_your_favorite_movie',
        'personal_assistant.handcrafted.what_is_your_favourite_browser',
        'personal_assistant.handcrafted.what_is_your_gender',
        'personal_assistant.handcrafted.what_is_your_hobby',
        'personal_assistant.handcrafted.what_is_your_iq',
        'personal_assistant.handcrafted.what_is_your_job',
        'personal_assistant.handcrafted.what_is_your_name',
        'personal_assistant.handcrafted.what_is_your_nationality',
        'personal_assistant.handcrafted.what_is_your_negative_character_traits',
        'personal_assistant.handcrafted.what_is_your_positive_character_traits',
        'personal_assistant.handcrafted.what_is_your_purpose',
        'personal_assistant.handcrafted.what_is_your_salary',
        'personal_assistant.handcrafted.what_is_your_shoe_size',
        'personal_assistant.handcrafted.what_kind_of_girls_do_you_like',
        'personal_assistant.handcrafted.what_languages_do_you_speak',
        'personal_assistant.handcrafted.what_to_do',
        'personal_assistant.handcrafted.what_to_say_on_meeting',
        'personal_assistant.handcrafted.what_to_wear',
        'personal_assistant.handcrafted.what_to_wear_err',
        'personal_assistant.handcrafted.what_you_afraid_of',
        'personal_assistant.handcrafted.when_am_i_going_to_die',
        'personal_assistant.handcrafted.when_is_the_world_gonna_end',
        'personal_assistant.handcrafted.when_is_your_birthday',
        'personal_assistant.handcrafted.when_is_your_birthday_step_2',
        'personal_assistant.handcrafted.when_you_had_a_sex_first_time',
        'personal_assistant.handcrafted.where_are_you_from',
        'personal_assistant.handcrafted.where_do_children_come_from',
        'personal_assistant.handcrafted.where_do_you_live',
        'personal_assistant.handcrafted.where_do_you_work',
        'personal_assistant.handcrafted.which_station_to_buy',
        'personal_assistant.handcrafted.who_am_i',
        'personal_assistant.handcrafted.who_do_you_love',
        'personal_assistant.handcrafted.who_is_alexey',
        'personal_assistant.handcrafted.who_is_the_most_good_looking',
        'personal_assistant.handcrafted.who_is_the_next_president_of_russia',
        'personal_assistant.handcrafted.who_is_the_next_president_of_russia_step_2',
        'personal_assistant.handcrafted.who_is_there',
        'personal_assistant.handcrafted.who_is_your_favorite_writer',
        'personal_assistant.handcrafted.who_is_your_horoscope_sign',
        'personal_assistant.handcrafted.who_is_your_maker',
        'personal_assistant.handcrafted.why_are_you_sad',
        'personal_assistant.handcrafted.why_your_name_is',
        'personal_assistant.handcrafted.will_you_marry_me',
        'personal_assistant.handcrafted.yandex_or_google',
        'personal_assistant.handcrafted.yes_or_no',
        'personal_assistant.handcrafted.za_kogo_boleesh',
        'personal_assistant.scenarios.conversation',
    },
    'get_date': {
        'personal_assistant.scenarios.get_date',
        'personal_assistant.scenarios.get_date__ellipsis',
    },
    'get_my_location': {
        'personal_assistant.scenarios.get_my_location',
        'personal_assistant.scenarios.get_my_location__details',
    },
    'get_time': {
        'personal_assistant.scenarios.get_time',
        'personal_assistant.scenarios.get_time__ellipsis',
    },
    'get_news': {
        'personal_assistant.scenarios.get_news',
        'personal_assistant.scenarios.get_news__details',
        'personal_assistant.scenarios.get_news__ellipsis',
        'personal_assistant.scenarios.get_news__more'
    },
    'how_much': {
        'personal_assistant.scenarios.how_much',
        'personal_assistant.scenarios.how_much__ellipsis'
    },
    'identity_commands': {
        'personal_assistant.scenarios.set_my_name',
        'personal_assistant.scenarios.voiceprint_enroll',
        'personal_assistant.scenarios.voiceprint_enroll__collect_voice',
        'personal_assistant.scenarios.voiceprint_enroll__finish',
        'personal_assistant.scenarios.voiceprint_remove',
        'personal_assistant.scenarios.voiceprint_remove__confirm',
        'personal_assistant.scenarios.voiceprint_remove__finish',
        'personal_assistant.scenarios.what_is_my_name',
    },
    'images_what_is_this': {
        'personal_assistant.scenarios.image_what_is_this',
        'personal_assistant.scenarios.image_what_is_this__clothes',
        'personal_assistant.scenarios.image_what_is_this__clothes_forced',
        'personal_assistant.scenarios.image_what_is_this__details',
        'personal_assistant.scenarios.image_what_is_this__info',
        'personal_assistant.scenarios.image_what_is_this__market',
        'personal_assistant.scenarios.image_what_is_this__ocr',
        'personal_assistant.scenarios.image_what_is_this__ocr_voice',
        'personal_assistant.scenarios.image_what_is_this__ocr_voice_suggest',
        'personal_assistant.scenarios.image_what_is_this__office_lens_disk',
        'personal_assistant.scenarios.image_what_is_this__similar',
        'personal_assistant.scenarios.image_what_is_this__similar_artwork',
        'personal_assistant.scenarios.image_what_is_this__similar_people',
        'personal_assistant.scenarios.image_what_is_this_barcode',
        'personal_assistant.scenarios.image_what_is_this_clothes',
        'personal_assistant.scenarios.image_what_is_this_frontal',
        'personal_assistant.scenarios.image_what_is_this_frontal_similar_people',
        'personal_assistant.scenarios.image_what_is_this_market',
        'personal_assistant.scenarios.image_what_is_this_ocr',
        'personal_assistant.scenarios.image_what_is_this_ocr_voice',
        'personal_assistant.scenarios.image_what_is_this_office_lens',
        'personal_assistant.scenarios.image_what_is_this_similar',
        'personal_assistant.scenarios.image_what_is_this_similar_artwork',
        'personal_assistant.scenarios.image_what_is_this_similar_people',
        'personal_assistant.scenarios.image_what_is_this_translate',
        'personal_assistant.scenarios.onboarding_image_search'
    },
    'inner_events': {
        'personal_assistant.scenarios.demoaurus2019_close_blinds',
        'personal_assistant.scenarios.demoaurus2019_close_right_window',
        'personal_assistant.scenarios.demoaurus2019_close_windows',
        'personal_assistant.scenarios.demoaurus2019_open_blinds',
        'personal_assistant.scenarios.demoaurus2019_open_right_window',
        'personal_assistant.scenarios.demoaurus2019_open_windows',
        'personal_assistant.scenarios.demomobile2019_blink',
        'personal_assistant.scenarios.demomobile2019_close_trunk',
        'personal_assistant.scenarios.demomobile2019_close_windows',
        'personal_assistant.scenarios.demomobile2019_horn',
        'personal_assistant.scenarios.demomobile2019_lock_car',
        'personal_assistant.scenarios.demomobile2019_off',
        'personal_assistant.scenarios.demomobile2019_on',
        'personal_assistant.scenarios.demomobile2019_open_trunk',
        'personal_assistant.scenarios.demomobile2019_open_windows',
        'personal_assistant.scenarios.demomobile2019_unlock_car',

        'personal_assistant.scenarios.demoaurus2019_blackout_off',
        'personal_assistant.scenarios.demoaurus2019_blackout_on',
        'personal_assistant.scenarios.demoaurus2019_close_left_window',
        'personal_assistant.scenarios.demoaurus2019_hide_me',
        'personal_assistant.scenarios.demoaurus2019_open_left_window',
        'personal_assistant.scenarios.demoaurus2019_partition_down',
        'personal_assistant.scenarios.demoaurus2019_partition_up',
        'personal_assistant.scenarios.demoaurus2019_screen_off',
        'personal_assistant.scenarios.demoaurus2019_screen_on',
        'personal_assistant.scenarios.demoaurus2019_temperature_down',
        'personal_assistant.scenarios.demoaurus2019_temperature_up',
    },
    'market': {
        'personal_assistant.scenarios.market',
        'personal_assistant.scenarios.market__add_to_cart',
        'personal_assistant.scenarios.market__cancel',
        'personal_assistant.scenarios.market__checkout',
        'personal_assistant.scenarios.market__checkout_address',
        'personal_assistant.scenarios.market__checkout_delivery_intervals',
        'personal_assistant.scenarios.market__checkout_email',
        'personal_assistant.scenarios.market__checkout_everything',
        'personal_assistant.scenarios.market__checkout_index',
        'personal_assistant.scenarios.market__checkout_items_number',
        'personal_assistant.scenarios.market__checkout_phone',
        'personal_assistant.scenarios.market__checkout_yes_or_no',
        'personal_assistant.scenarios.market__garbage',
        'personal_assistant.scenarios.market__go_to_shop',
        'personal_assistant.scenarios.market__market',
        'personal_assistant.scenarios.market__market__ellipsis',
        'personal_assistant.scenarios.market__number_filter',
        'personal_assistant.scenarios.market__product_details',
        'personal_assistant.scenarios.market__repeat',
        'personal_assistant.scenarios.market__show_more',
        'personal_assistant.scenarios.market__start_choice_again',
        'personal_assistant.scenarios.market_native',
        'personal_assistant.scenarios.market_product_details',
    },
    'music': {
        'personal_assistant.scenarios.music_play',
        'personal_assistant.scenarios.music_play_anaphora',
        'personal_assistant.scenarios.music_play_less',
        'personal_assistant.scenarios.music_play_more',
        'personal_assistant.scenarios.music_sing_song',
        'personal_assistant.scenarios.music_sing_song__next',
        'personal_assistant.scenarios.music_general',
    },
    'music_ambient_sound': {
        'personal_assistant.scenarios.music_ambient_sound'
    },
    'music_fairy_tale': {
        'personal_assistant.scenarios.music_fairy_tale'
    },
    'music_podcast': {
        'personal_assistant.scenarios.music_podcast',
        'personal_assistant.scenarios.music_podcast_onboarding',
        'personal_assistant.scenarios.music_podcast_onboarding__next'
    },
    'music_what_is_playing': {
        'personal_assistant.scenarios.music_what_is_playing',
        'personal_assistant.scenarios.music_what_is_playing__ellipsis',
        'personal_assistant.scenarios.music_what_is_playing__play'
    },
    'nav_url': {
        'personal_assistant.scenarios.open_site_or_app',
        'personal_assistant.scenarios.open_site_or_app__ellipsis',
        'personal_assistant.scenarios.open_site_or_app__open',
        'personal_assistant.scenarios.open_video_hosting',
    },
    'navi_commands': {
        'personal_assistant.navi.add_point',
        'personal_assistant.navi.add_point__cancel',
        'personal_assistant.navi.add_point__ellipsis',
        'personal_assistant.navi.change_voice',
        'personal_assistant.navi.change_voice__ellipsis',
        'personal_assistant.navi.gas_station_with_payment',
        'personal_assistant.navi.hide_layer',
        'personal_assistant.navi.how_long_to_drive',
        'personal_assistant.navi.how_long_traffic_jam',
        'personal_assistant.navi.onboarding',
        'personal_assistant.navi.parking_route',
        'personal_assistant.navi.refuel',
        'personal_assistant.navi.refuel__ellipsis',
        'personal_assistant.navi.reset_route',
        'personal_assistant.navi.show_layer',
        'personal_assistant.navi.show_route_on_map',
        'personal_assistant.navi.when_we_get_there',
        'personal_assistant.scenarios.search__show_on_map'
    },
    'onboarding': {
        'personal_assistant.scenarios.games_onboarding',
        'personal_assistant.scenarios.onboarding',
        'personal_assistant.scenarios.onboarding__cancel',
        'personal_assistant.scenarios.onboarding__next',
        'personal_assistant.scenarios.skill_recommendation',
        'personal_assistant.scenarios.skill_recommendation__next',
        'personal_assistant.scenarios.what_can_you_do',
        'personal_assistant.scenarios.whats_new',
    },
    'ontofacts': {
        'personal_assistant.scenarios.film_gallery',
        'personal_assistant.scenarios.film_gallery__scroll_next'
    },
    'placeholders': {
        'personal_assistant.scenarios.common.call_to_support',
        'personal_assistant.scenarios.common.cancel_list',
        'personal_assistant.scenarios.common.cancel_order',
        'personal_assistant.scenarios.common.change',
        'personal_assistant.scenarios.common.change_payment_method',
        'personal_assistant.scenarios.common.get_price',
        'personal_assistant.scenarios.common.leave_feedback',
        'personal_assistant.scenarios.common.leave_tips',
        'personal_assistant.scenarios.common.open_app',
        'personal_assistant.scenarios.common.prohibition_error',
        'personal_assistant.scenarios.do_not_understand',
        'personal_assistant.scenarios.ether_show',
        'personal_assistant.scenarios.messaging',
        'personal_assistant.scenarios.messaging__client',
        'personal_assistant.scenarios.messaging__recipient',
        'personal_assistant.scenarios.messaging__recipient_ellipsis',
        'personal_assistant.scenarios.messaging__text',
        'personal_assistant.scenarios.simsim_gold',
        'personal_assistant.scenarios.simsim_open',
        'personal_assistant.scenarios.teach_me',
        'personal_assistant.scenarios.common_backward',
        'personal_assistant.scenarios.common_forward',
        'personal_assistant.scenarios.common_yet_another',
        'personal_assistant.scenarios.example_intent',
    },
    'player_commands': {
        'personal_assistant.scenarios.player_continue',
        'personal_assistant.scenarios.player_next_track',
        'personal_assistant.scenarios.player_pause',
        'personal_assistant.scenarios.player_previous_track',
        'personal_assistant.scenarios.player_repeat',
        'personal_assistant.scenarios.player_replay',
        'personal_assistant.scenarios.player_rewind',
        'personal_assistant.scenarios.player_shuffle',
    },
    'promo': {
        'personal_assistant.scenarios.hny.anohina',
        'personal_assistant.scenarios.hny.badcomedian',
        'personal_assistant.scenarios.hny.bekmambetov',
        'personal_assistant.scenarios.hny.bubenitta',
        'personal_assistant.scenarios.hny.cook',
        'personal_assistant.scenarios.hny.dakota',
        'personal_assistant.scenarios.hny.decorate',
        'personal_assistant.scenarios.hny.gagarina',
        'personal_assistant.scenarios.hny.general',
        'personal_assistant.scenarios.hny.grilkov',
        'personal_assistant.scenarios.hny.have_fun',
        'personal_assistant.scenarios.hny.jarahov',
        'personal_assistant.scenarios.hny.lisovec',
        'personal_assistant.scenarios.hny.listen',
        'personal_assistant.scenarios.hny.may',
        'personal_assistant.scenarios.hny.offer',
        'personal_assistant.scenarios.hny.parfenon',
        'personal_assistant.scenarios.hny.pokashevarim',
        'personal_assistant.scenarios.hny.present',
        'personal_assistant.scenarios.hny.review',
        'personal_assistant.scenarios.hny.see',
        'personal_assistant.scenarios.hny.semenihin',
        'personal_assistant.scenarios.hny.slivki',
        'personal_assistant.scenarios.hny.smetana',
        'personal_assistant.scenarios.hny.suhov',
        'personal_assistant.scenarios.hny.trubenkova',
        'personal_assistant.scenarios.hny.varlamov',
        'personal_assistant.scenarios.hny.viskunova',
        'personal_assistant.scenarios.hny.wear',
        'personal_assistant.scenarios.hny.wylsacom',
        'personal_assistant.scenarios.hny.ya_cook',
        'personal_assistant.scenarios.hny.ya_decorate',
        'personal_assistant.scenarios.hny.ya_offer',
        'personal_assistant.scenarios.hny.ya_wear',
        'personal_assistant.scenarios.happy_new_year_music_play',
        'personal_assistant.scenarios.happy_new_year_tv_stream',
        'personal_assistant.scenarios.happy_new_year_video_play',
    },
    'radio': {
        'personal_assistant.scenarios.radio_play',
        'personal_assistant.scenarios.radio_play_onboarding',
        'personal_assistant.scenarios.radio_play_onboarding__next'
    },
    'random_number': {
        'personal_assistant.scenarios.random_num',
        'personal_assistant.scenarios.random_num__ellipsis'
    },
    'reminder': {
        'personal_assistant.scenarios.alarm_reminder',
        'personal_assistant.scenarios.create_reminder',
        'personal_assistant.scenarios.create_reminder__cancel',
        'personal_assistant.scenarios.create_reminder__ellipsis',
        'personal_assistant.scenarios.list_reminders',
        'personal_assistant.scenarios.list_reminders__scroll_next',
        'personal_assistant.scenarios.list_reminders__scroll_reset',
        'personal_assistant.scenarios.list_reminders__scroll_stop'
    },
    'repeat': {
        'personal_assistant.scenarios.repeat'
    },
    'repeat_after_me': {
        'personal_assistant.scenarios.repeat_after_me'
    },
    'route': {
        'personal_assistant.scenarios.show_route',
        'personal_assistant.scenarios.show_route__ellipsis',
        'personal_assistant.scenarios.show_route__show_route_on_map',
        'personal_assistant.scenarios.route_general',
    },
    'search': {
        'personal_assistant.scenarios.search',
        'personal_assistant.scenarios.search__factoid_call',
        'personal_assistant.scenarios.search__factoid_src',
        'personal_assistant.scenarios.search__related',
        'personal_assistant.scenarios.search_anaphoric',
    },
    'search_commands': {
        'personal_assistant.scenarios.search_filter_get',
        'personal_assistant.scenarios.search_filter_how',
        'personal_assistant.scenarios.search_filter_reset',
        'personal_assistant.scenarios.search_filter_set_family',
        'personal_assistant.scenarios.search_filter_set_no_filter',
    },
    'serp': {
        'personal_assistant.scenarios.search__serp',
        'personal_assistant.scenarios.serp_gallery',
        'personal_assistant.scenarios.serp_gallery__call',
        'personal_assistant.scenarios.serp_gallery__chat',
        'personal_assistant.scenarios.serp_gallery__confirm',
        'personal_assistant.scenarios.serp_gallery__item_continuation',
        'personal_assistant.scenarios.serp_gallery__item_stop',
        'personal_assistant.scenarios.serp_gallery__map',
        'personal_assistant.scenarios.serp_gallery__open',
        'personal_assistant.scenarios.serp_gallery__switch_by_id',
        'personal_assistant.scenarios.serp_gallery__switch_to_begin',
        'personal_assistant.scenarios.serp_gallery__switch_to_end',
        'personal_assistant.scenarios.serp_gallery__switch_to_next',
        'personal_assistant.scenarios.serp_gallery__switch_to_prev'
    },
    'shopping_list': {
        'personal_assistant.scenarios.shopping_list_add',
        'personal_assistant.scenarios.shopping_list_delete_all',
        'personal_assistant.scenarios.shopping_list_delete_item',
        'personal_assistant.scenarios.shopping_list_login',
        'personal_assistant.scenarios.shopping_list_show',
        'personal_assistant.scenarios.shopping_list_show__add',
        'personal_assistant.scenarios.shopping_list_show__add_fixlist',
        'personal_assistant.scenarios.shopping_list_show__delete_all',
        'personal_assistant.scenarios.shopping_list_show__delete_all_fixlist',
        'personal_assistant.scenarios.shopping_list_show__delete_index',
        'personal_assistant.scenarios.shopping_list_show__delete_index_fixlist',
        'personal_assistant.scenarios.shopping_list_show__delete_item',
        'personal_assistant.scenarios.shopping_list_show__delete_item_fixlist',
        'personal_assistant.scenarios.shopping_list_show__show',
        'personal_assistant.scenarios.shopping_list_show__show_fixlist',
        'personal_assistant.scenarios.shopping_list_add_fixlist',
        'personal_assistant.scenarios.shopping_list_delete_all_fixlist',
        'personal_assistant.scenarios.shopping_list_delete_item_fixlist',
        'personal_assistant.scenarios.shopping_list_login_fixlist',
        'personal_assistant.scenarios.shopping_list_show_fixlist',
    },
    'show_collection': {
        'personal_assistant.scenarios.show_collection'
    },
    'show_traffic': {
        'personal_assistant.scenarios.show_traffic',
        'personal_assistant.scenarios.show_traffic__details',
        'personal_assistant.scenarios.show_traffic__ellipsis'
    },
    'sleep_timer': {
        'personal_assistant.scenarios.sleep_timer_how_long',
        'personal_assistant.scenarios.sleep_timer_set',
        'personal_assistant.scenarios.sleep_timer_set__ellipsis'
    },
    'sound_commands': {
        'personal_assistant.scenarios.sound_get_level',
        'personal_assistant.scenarios.sound_get_level__ellipsis',
        'personal_assistant.scenarios.sound_louder',
        'personal_assistant.scenarios.sound_louder__ellipsis',
        'personal_assistant.scenarios.sound_mute',
        'personal_assistant.scenarios.sound_quiter',
        'personal_assistant.scenarios.sound_quiter__ellipsis',
        'personal_assistant.scenarios.sound_set_level',
        'personal_assistant.scenarios.sound_unmute'
    },
    'stop': {
        'personal_assistant.handcrafted.cancel',
        'personal_assistant.handcrafted.fast_cancel'
    },
    'taxi': {
        'personal_assistant.scenarios.taxi_cancel',
        'personal_assistant.scenarios.taxi_new_after_order_actions',
        'personal_assistant.scenarios.taxi_new_call_to_driver',
        'personal_assistant.scenarios.taxi_new_call_to_driver_internal',
        'personal_assistant.scenarios.taxi_new_call_to_support',
        'personal_assistant.scenarios.taxi_new_cancel',
        'personal_assistant.scenarios.taxi_new_cancel__confirmation_no',
        'personal_assistant.scenarios.taxi_new_cancel__confirmation_yes',
        'personal_assistant.scenarios.taxi_new_disabled',
        'personal_assistant.scenarios.taxi_new_get_price_of_ride',
        'personal_assistant.scenarios.taxi_new_get_time_of_ride',
        'personal_assistant.scenarios.taxi_new_open_app',
        'personal_assistant.scenarios.taxi_new_order',
        'personal_assistant.scenarios.taxi_new_order__change_card',
        'personal_assistant.scenarios.taxi_new_order__change_payment_or_tariff',
        'personal_assistant.scenarios.taxi_new_order__confirmation_no',
        'personal_assistant.scenarios.taxi_new_order__confirmation_wrong',
        'personal_assistant.scenarios.taxi_new_order__confirmation_yes',
        'personal_assistant.scenarios.taxi_new_order__select_card',
        'personal_assistant.scenarios.taxi_new_order__specify',
        'personal_assistant.scenarios.taxi_new_show_driver_info',
        'personal_assistant.scenarios.taxi_new_show_legal',
        'personal_assistant.scenarios.taxi_new_status',
        'personal_assistant.scenarios.taxi_new_status_address',
        'personal_assistant.scenarios.taxi_new_status_price',
        'personal_assistant.scenarios.taxi_new_status_time',
        'personal_assistant.scenarios.taxi_new_where_is_my_car',
        'personal_assistant.scenarios.taxi_order',
        'personal_assistant.scenarios.taxi_order__ellipsis'
    },
    'theremin': {
        'personal_assistant.scenarios.thereminvox_off',
        'personal_assistant.scenarios.thereminvox_on',
    },
    'timer': {
        'personal_assistant.scenarios.timer_cancel',
        'personal_assistant.scenarios.timer_cancel__ellipsis',
        'personal_assistant.scenarios.timer_how_long',
        'personal_assistant.scenarios.timer_pause',
        'personal_assistant.scenarios.timer_pause__ellipsis',
        'personal_assistant.scenarios.timer_resume',
        'personal_assistant.scenarios.timer_resume__ellipsis',
        'personal_assistant.scenarios.timer_set',
        'personal_assistant.scenarios.timer_set__ellipsis',
        'personal_assistant.scenarios.timer_show',
        'personal_assistant.scenarios.timer_show__cancel',
        'personal_assistant.scenarios.timer_show__pause',
        'personal_assistant.scenarios.timer_show__resume',
        'personal_assistant.scenarios.timer_stop_playing'
    },
    'todo': {
        'personal_assistant.scenarios.cancel_todo',
        'personal_assistant.scenarios.cancel_todo__ellipsis',
        'personal_assistant.scenarios.create_todo',
        'personal_assistant.scenarios.create_todo__cancel',
        'personal_assistant.scenarios.create_todo__ellipsis',
        'personal_assistant.scenarios.list_todo',
        'personal_assistant.scenarios.list_todo__scroll_next',
        'personal_assistant.scenarios.list_todo__scroll_stop'
    },
    'translate': {
        'personal_assistant.scenarios.translate',
        'personal_assistant.scenarios.translate__ellipsis',
        'personal_assistant.scenarios.translate__quicker',
        'personal_assistant.scenarios.translate__slower'
    },
    'tv_broadcast': {
        'personal_assistant.scenarios.tv_broadcast',
        'personal_assistant.scenarios.tv_broadcast__ellipsis'
    },
    'tv_stream': {
        'personal_assistant.scenarios.tv_stream',
        'personal_assistant.scenarios.tv_stream__ellipsis'
    },
    'video': {
        'personal_assistant.scenarios.quasar.goto_video_screen',
        'personal_assistant.scenarios.video_play',
        'personal_assistant.scenarios.ether.quasar.video_select',
        'personal_assistant.scenarios.quasar.open_current_video',
        'personal_assistant.scenarios.quasar.payment_confirmed',
        'personal_assistant.scenarios.quasar.select_video_from_gallery',
        'personal_assistant.scenarios.quasar.select_video_from_gallery_by_text',
        'personal_assistant.scenarios.quasar.select_channel_from_gallery_by_text',
        'personal_assistant.scenarios.quasar.select_ether_from_gallery_by_text',
    },
    'weather': {
        'personal_assistant.scenarios.get_weather',
        'personal_assistant.scenarios.get_weather__details',
        'personal_assistant.scenarios.get_weather__ellipsis',
        'personal_assistant.scenarios.get_weather_nowcast',
        'personal_assistant.scenarios.get_weather_nowcast__ellipsis'
    },
}

INTENT_TO_PRODUCT_SCENARIO = {
    intent: scenario
    for scenario, intents in PRODUCT_SCENARIO_TO_INTENTS.items()
    for intent in intents
}


def get_product_scenario_name(intent):
    scenario = INTENT_TO_PRODUCT_SCENARIO.get(intent)
    if scenario is None:
        return intent
    return scenario
