#! /usr/bin/env python2
# encoding: utf-8
import sys
sys.path.append('..')
sys.path.append('../..')

from general.normbase import *

replace_dict = {"а": "+а",
                "б": "б+э",
                "в": "в+э",
                "г": "г+э",
                "д": "д+э",
                "е": "й+е",
                "ё": "й+ё",
                "ж": "ж+э",
                "з": "з+э",
                "и": "+и",
                "й": "+и краткое",
                "к": "к+а",
                "л": "+эл",
                "м": "+эм",
                "н": "+эн",
                "о": "+о",
                "п": "п+э",
                "р": "+эр",
                "с": "+эс",
                "т": "т+э",
                "у": "+у",
                "ф": "+эф",
                "х": "х+а",
                "ц": "ц+э",
                "ч": "ч+е",
                "ш": "ш+а",
                "щ": "щ+а",
                "ъ": "твёрдый знак",
                "ы": "+ы",
                "ь": "мягкий знак",
                "э": "+э",
                "ю": "+ю",
                "я": "+я",

                "a": "+а",
                "b": "б+э",
                "c": "ц+э",
                "d": "д+э",
                "e": "й+е",
                "f": "+эф",
                "g": "г+э",
                "h": "+аш",
                "i": "+и",
                "j": "й+от",
                "k": "к+а",
                "l": "+эл",
                "m": "+эм",
                "n": "+эн",
                "o": "+о",
                "p": "п+э",
                "q": "к+у",
                "r": "+эр",
                "s": "+эс",
                "t": "т+э",
                "u": "+у",
                "v": "в+э",
                "w": "дубль в+э",
                "x": "+икс",
                "y": "+игрек",
                "z": "з+эт",

                ".": "точка",
                ",": "запятая",
                ":": "двоеточие",
                "(": "открывающая скобка",
                ")": "закрывающая скобка",
                "\"": "кавычки",
                "\'": "апостроф",
                ";": "точка с запятой",
                "!": "восклицательный знак",
                "?": "вопросительный знак",
                "-": "дефис",

                "/": "слэш",
                "\\": "обратный слэш",
                "±": "плюс минус",
                "€": "евро",
                "™": "торговая марка",
                "§": "пар+аграф",
                "©": "знак авторского права",
                "®": "знак регистрации",
                "$": "знак доллара",
                "%": "процент",
                "‰": "промилле",
                "№": "номер",
                "<": "меньше чем",
                ">": "больше чем",
                "^": "циркумфлекс",
                "|": "вертикальный слэш",
                "~": "тильда",
                "_": "подчёркивание",
                "@": "собака",
                "=": "равн+о",
                "#": "решётка",
                "*": "звёздочка",

                "0": "ноль",
                "1": "один",
                "2": "два",
                "3": "три",
                "4": "четыре",
                "5": "пять",
                "6": "шесть",
                "7": "семь",
                "8": "восемь",
                "9": "девять",
                }

replacer = anyof([insert(" ") + replace(xx, replace_dict[xx]) for xx in replace_dict])

convert_by_character = ((remove("#[character|") +
                         ss(replacer | " ") +
                         remove("]#")))

convert_hex = (replace("0x", "шестнадцатиричное ") +
               (pp(anyof("0123456789abcdef")) >> ss(replacer)))

# To be used in spec_codes.py
handle = convert_by_character | convert_hex
