package ru.yandex.serpbugcatcher.datalayer;

import android.os.Build;
import android.support.annotation.RequiresApi;

import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;

import ru.yandex.serpbugcatcher.kernel.Logger;
import ru.yandex.serpbugcatcher.model.LogEvent;


/**
 * Created by ajkon on 16-11-25.
 */

public class LogSender {

    private final Logger logger;

    public LogSender(Logger logger) {
        this.logger = logger;
    }

    private static int errorCounter =0;

    public static int getErrorCounter() {
        return errorCounter;
    }


    @RequiresApi(api = Build.VERSION_CODES.M)
    public void sendErrors() throws Exception {
        for (LogEvent logEvent = logger.lifeCycleLog.poll(); logEvent != null; logEvent = logger.lifeCycleLog.poll()) {
            if (!logEvent.isNetworkError && !logEvent.isScriptError) continue;
            String error = logEvent.isNetworkError ? "NetworkError" : "ScriptError";
            String meta = logger.isMda0() ? "notMDA" : "MDA";
            String cache = logger.isClearCache() ? "Clear" : "NotClear";
            sendError(logger.getReqid(), error, logger.getUrl(), meta, cache, logEvent.text);
        }
    }

    private void sendError(String reqId, String error, String url, String meta, String cache, String log) {
        try {
            reqId = encode(reqId);
            error = encode(error);
            url = encode(url);
            meta = encode(meta);
            cache = encode(cache);
            log = encode(log);
            String pattern = "https://yandex.ru/clck/click/dtype=stred/pid=1/reqid={0}/cid=73054/path=Tech.SerpMdaTester/vars=-reqid={0},-error={1},-url={2},-meta={3},-cache={4},-log={5}/*";
            String counterUrl = MessageFormat.format(pattern, reqId, error, url, meta, cache, log);
            URL theUrl = new URL(counterUrl);
            HttpURLConnection connection = (HttpURLConnection) theUrl.openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            int code = connection.getResponseCode();
            if (code != 200) {
                throw new RuntimeException(connection.getResponseMessage());
            }
            errorCounter++;
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");

    private static final String encode(String src) throws UnsupportedEncodingException {
        src = URLEncoder.encode(src, "UTF-8");
        src = src.replaceAll("\\+", "%20");
        return src;
    }


}
